/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.deploy.DeployService;
import com.sap.engine.services.deploy.command.DCommandsUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.rmi.RemoteException;

public class ListElementsCommand
implements Command {
    DeployService deploy = null;

    public ListElementsCommand(DeployService deployment) {
        this.deploy = deployment;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintWriter pw = new PrintWriter(os, true);
        String[] servers = null;
        String applicationName = null;
        String containerName = null;
        boolean isServer = false;
        boolean isContainer = false;
        boolean isApplication = false;
        ClassLoader threadLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            if (params.length == 0 || params.length > 0 && (params[0].equals("-?") || params[0].toLowerCase().startsWith("-h"))) {
                pw.println(this.getHelpMessage());
                containerName = null;
                Object var19_13 = null;
                Thread.currentThread().setContextClassLoader(threadLoader);
                return;
            }
            if (params.length > 1) {
                block31: {
                    block30: {
                        int j = 0;
                        String cmd = null;
                        servers = new String[params.length];
                        int i = 0;
                        while (true) {
                            if (i >= params.length) {
                                if (j != 0) break;
                                servers = null;
                                break block30;
                            }
                            cmd = params[i];
                            if (cmd.equals("-s")) {
                                isServer = true;
                                isContainer = false;
                                isApplication = false;
                            } else if (cmd.equals("-c")) {
                                isServer = false;
                                isContainer = true;
                                isApplication = false;
                            } else if (cmd.equals("-a")) {
                                isServer = false;
                                isContainer = false;
                                isApplication = true;
                            } else if (isServer) {
                                servers[j++] = cmd;
                            } else if (isContainer) {
                                containerName = cmd;
                                isContainer = false;
                            } else if (isApplication) {
                                applicationName = cmd;
                                isApplication = false;
                            } else {
                                pw.println("Error in parameters.\n");
                                Object var19_14 = null;
                                Thread.currentThread().setContextClassLoader(threadLoader);
                                return;
                            }
                            ++i;
                        }
                        String[] temp = new String[j];
                        System.arraycopy(servers, 0, temp, 0, j);
                        servers = temp;
                        temp = null;
                    }
                    try {
                        String[] res = this.deploy.listElements(containerName, applicationName, servers);
                        pw.println("");
                        if (res != null && res.length != 0) {
                            if (applicationName != null) {
                                pw.println("Elements for application " + applicationName + " : \n");
                            } else {
                                pw.println("Elements for all applications : \n");
                            }
                            int i = 0;
                            while (i < res.length) {
                                pw.println("\t" + res[i]);
                                ++i;
                            }
                            break block31;
                        }
                        if (applicationName != null) {
                            pw.println("There are no elements for application " + applicationName + " or the application don't exist!");
                        } else {
                            pw.println("No applications are deployed.");
                        }
                    }
                    catch (RemoteException re) {
                        DCommandsUtils.handleProblem(pw, re.toString());
                    }
                    catch (Exception ex) {
                        DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, ex);
                        Object var19_16 = null;
                        Thread.currentThread().setContextClassLoader(threadLoader);
                        return;
                    }
                    catch (ThreadDeath td) {
                        DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, td);
                        throw td;
                    }
                    catch (OutOfMemoryError oome) {
                        DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, oome);
                        throw oome;
                    }
                    catch (Error er) {
                        DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, er);
                    }
                }
                Object var19_17 = null;
                Thread.currentThread().setContextClassLoader(threadLoader);
                return;
            }
            pw.println("Error in parameters.\n");
        }
        catch (Throwable throwable) {
            Object var19_18 = null;
            Thread.currentThread().setContextClassLoader(threadLoader);
            throw throwable;
        }
        Object var19_15 = null;
        Thread.currentThread().setContextClassLoader(threadLoader);
    }

    public String getHelpMessage() {
        return "Lists all components of a deployed application on containers in the cluster.\nUsage: LIST_EL [-s serverName*] [-c containerName] <-a applicationName>\nParameters:\n   [-s serverName*]     - A space-separated list of server names for which\n                          components of a deployed application are listed. If\n                          not specified, application components deployed on\n                          all servers in the cluster are listed.\n   [-c containerName]   - The name of the container for which components of a\n                          deployed application are listed. If not specified,\n                          application components deployed on all registered\n                          containers are listed.\n   <-a applicationName> - The name of the deployed application.\n";
    }

    public String getName() {
        return "LIST_EL";
    }

    public String getGroup() {
        return "DEPLOY";
    }

    public String[] getSupportedShellProviderNames() {
        String[] names = new String[]{"InQMyShell"};
        return names;
    }
}

