/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.deploy.command.DCommandsUtils;
import com.sap.engine.services.deploy.exceptions.ServerDeploymentException;
import com.sap.engine.services.deploy.server.DeployServiceImpl;
import com.sap.engine.services.deploy.server.TransactionStatistics;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class ListApplicationsCommand
implements Command {
    DeployServiceImpl deploy = null;
    Properties status_colour = new Properties();
    private static final String DEFAULT = "DEFAULT";
    private static final String OTHER = "OTHER";
    private boolean isRemote = true;
    static /* synthetic */ Class class$com$sap$engine$services$deploy$command$ListApplicationsCommand;

    public ListApplicationsCommand(DeployServiceImpl deployment) {
        this.deploy = deployment;
        InputStream is = (class$com$sap$engine$services$deploy$command$ListApplicationsCommand == null ? (class$com$sap$engine$services$deploy$command$ListApplicationsCommand = ListApplicationsCommand.class$("com.sap.engine.services.deploy.command.ListApplicationsCommand")) : class$com$sap$engine$services$deploy$command$ListApplicationsCommand).getResourceAsStream("status_colour.properties");
        try {
            this.status_colour.load(is);
        }
        catch (IOException ioe) {
            new ServerDeploymentException("deploy_1006", new String[]{this.getName()}, ioe).log();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        this.isRemote = env.isRemote();
        PrintWriter pw = new PrintWriter(os, true);
        String[] servers = null;
        String containerName = null;
        boolean isServer = false;
        boolean isContainer = false;
        int buffer = 3;
        int MAX_APP_LEN = 49;
        ClassLoader threadLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        if (this.isRemote) {
            pw.print(((Hashtable)this.status_colour).get(DEFAULT));
        }
        try {
            block48: {
                block49: {
                    block47: {
                        if (params.length > 0 && (params[0].equals("-?") || params[0].toLowerCase().startsWith("-h"))) {
                            pw.println(this.getHelpMessage());
                            containerName = null;
                            Object var31_13 = null;
                            Thread.currentThread().setContextClassLoader(threadLoader);
                            return;
                        }
                        if (params.length > 1) {
                            int j = 0;
                            String cmd = null;
                            servers = new String[params.length];
                            int i = 0;
                            while (true) {
                                if (i >= params.length) {
                                    if (j != 0) break;
                                    servers = null;
                                    break block47;
                                }
                                cmd = params[i];
                                if (cmd.equals("-s")) {
                                    isServer = true;
                                    isContainer = false;
                                } else if (cmd.equals("-c")) {
                                    isServer = false;
                                    isContainer = true;
                                } else if (isServer) {
                                    servers[j++] = cmd;
                                } else {
                                    if (!isContainer) break block48;
                                    containerName = cmd;
                                    isContainer = false;
                                }
                                ++i;
                            }
                            String[] temp = new String[j];
                            System.arraycopy(servers, 0, temp, 0, j);
                            servers = temp;
                            temp = null;
                        }
                    }
                    if (servers == null) {
                        servers = this.deploy.getAllServerNames();
                    }
                    try {
                        TransactionStatistics[] stat = this.deploy.listApplicationAndStatusesInCluster(containerName, servers);
                        Hashtable all = this.evaluate(stat);
                        String[] res = this.getKeysAsStringArray(all);
                        pw.println("");
                        if (res != null && res.length != 0) {
                            int i;
                            String status;
                            pw.println("Applications : \n");
                            int appNameLen = -1;
                            int maxStatusLen = "UPGRADING".length();
                            int maxServerLen = 7;
                            int i2 = 0;
                            while (true) {
                                if (i2 >= res.length) break;
                                if (appNameLen < res[i2].length() && res[i2].length() < MAX_APP_LEN) {
                                    appNameLen = res[i2].length();
                                }
                                ++i2;
                            }
                            int i3 = 0;
                            while (true) {
                                if (i3 >= servers.length) {
                                    if (appNameLen == 0) {
                                        appNameLen = 10;
                                    }
                                    break;
                                }
                                if (maxServerLen < servers[i3].length()) {
                                    maxServerLen = servers[i3].length();
                                }
                                ++i3;
                            }
                            pw.print(" NAME");
                            this.printChar(' ', appNameLen - "NAME".length() + buffer - 2, pw);
                            pw.print("STATUS");
                            int k = 0;
                            while (true) {
                                if (k >= maxStatusLen - "STATUS".length() + buffer) {
                                    pw.println("SERVER");
                                    pw.print(" ");
                                    this.printChar('-', appNameLen + buffer - 2 + maxStatusLen + buffer + maxServerLen, pw);
                                    pw.println("");
                                    status = null;
                                    i = 0;
                                    break;
                                }
                                pw.print(" ");
                                ++k;
                            }
                            block17: while (i < res.length) {
                                int k2 = 0;
                                while (true) {
                                    int br;
                                    if (k2 >= servers.length) {
                                        ++i;
                                        continue block17;
                                    }
                                    pw.print(" " + res[i]);
                                    if (res[i].length() >= MAX_APP_LEN) {
                                        pw.println("");
                                        pw.print(" ");
                                        br = appNameLen + buffer - 2;
                                    } else {
                                        br = appNameLen - res[i].length() + buffer - 2;
                                    }
                                    this.printChar(' ', br, pw);
                                    try {
                                        status = (String)((Hashtable)all.get(res[i])).get(new Integer(this.deploy.getClusterIDs(new String[]{servers[k2]})[0]));
                                        if (status == null) {
                                            status = "NOT DEPLOYED";
                                        }
                                    }
                                    catch (Exception ex) {
                                        DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, ex);
                                        Object var31_15 = null;
                                        Thread.currentThread().setContextClassLoader(threadLoader);
                                        return;
                                    }
                                    catch (ThreadDeath td) {
                                        DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, td);
                                        throw td;
                                    }
                                    catch (OutOfMemoryError oome) {
                                        DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, oome);
                                        throw oome;
                                    }
                                    catch (Error er) {
                                        DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, er);
                                    }
                                    if (this.isRemote) {
                                        if (((Hashtable)this.status_colour).get(status) != null) {
                                            pw.print(((Hashtable)this.status_colour).get(status));
                                        } else {
                                            pw.print(((Hashtable)this.status_colour).get(OTHER));
                                        }
                                    }
                                    pw.print(status);
                                    if (status.equalsIgnoreCase("STOPPED")) {
                                        pw.print("!");
                                        br = maxStatusLen - status.length() + 2;
                                    } else {
                                        br = maxStatusLen - status.length() + 3;
                                    }
                                    if (this.isRemote) {
                                        pw.print(((Hashtable)this.status_colour).get(DEFAULT));
                                    }
                                    if (br < 0) {
                                        pw.println("");
                                        br = 1 + appNameLen + buffer - 2 + maxStatusLen + 3;
                                    }
                                    this.printChar(' ', br, pw);
                                    pw.println(servers[k2]);
                                    ++k2;
                                }
                            }
                            break block49;
                        }
                        pw.println("No Applications are currently deployed.");
                    }
                    catch (RemoteException re) {
                        DCommandsUtils.handleProblem(pw, re.toString());
                    }
                    catch (Exception ex) {
                        DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, ex);
                        Object var31_16 = null;
                        Thread.currentThread().setContextClassLoader(threadLoader);
                        return;
                    }
                    catch (ThreadDeath td) {
                        DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, td);
                        throw td;
                    }
                    catch (OutOfMemoryError oome) {
                        DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, oome);
                        throw oome;
                    }
                    catch (Error er) {
                        DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, er);
                    }
                }
                Object var31_17 = null;
                Thread.currentThread().setContextClassLoader(threadLoader);
                return;
            }
            pw.println("Error in parameters.\n");
        }
        catch (Throwable throwable) {
            Object var31_18 = null;
            Thread.currentThread().setContextClassLoader(threadLoader);
            throw throwable;
        }
        Object var31_14 = null;
        Thread.currentThread().setContextClassLoader(threadLoader);
    }

    public String getHelpMessage() {
        return "Lists all applications deployed on containers in the cluster.\nUsage: LIST_APP [-s serverNames*] [-c containerName]\nParameters:\n   [-s serverNames*]  - Server names for which deployed applications are listed.\n                        Server names are separated with spaces. If not\n                        specified, applications deployed on all servers in the\n                        cluster are listed.\n   [-c containerName] - The name of the container for which deployed\n                        applications are listed. If not specified, applications\n                        deployed on all registered containers are listed.\n";
    }

    public String getName() {
        return "LIST_APP";
    }

    public String getGroup() {
        return "DEPLOY";
    }

    public String[] getSupportedShellProviderNames() {
        String[] names = new String[]{"InQMyShell"};
        return names;
    }

    private Hashtable evaluate(TransactionStatistics[] stat) {
        Hashtable<String, Hashtable<Integer, String>> all = null;
        if (stat != null) {
            Hashtable server = null;
            Hashtable<Integer, String> current = null;
            Enumeration enumeration = null;
            String appName = null;
            String status = null;
            int i = 0;
            while (i < stat.length) {
                server = stat[i].getHashAnswer();
                if (server != null) {
                    enumeration = server.keys();
                    while (enumeration.hasMoreElements()) {
                        appName = (String)enumeration.nextElement();
                        if (appName == null || (status = (String)server.get(appName)) == null) continue;
                        if (all == null) {
                            all = new Hashtable<String, Hashtable<Integer, String>>();
                        }
                        if ((current = (Hashtable<Integer, String>)all.get(appName)) == null) {
                            current = new Hashtable<Integer, String>();
                        }
                        current.put(new Integer(stat[i].getClusterID()), status);
                        all.put(appName, current);
                    }
                }
                ++i;
            }
        }
        return all;
    }

    private String[] getKeysAsStringArray(Hashtable hash) {
        Object[] res = null;
        if (hash != null) {
            Enumeration enumeration = hash.keys();
            ArrayList<String> apps = null;
            while (enumeration.hasMoreElements()) {
                if (apps == null) {
                    apps = new ArrayList<String>();
                }
                apps.add(enumeration.nextElement().toString());
            }
            if (apps != null && apps.size() != 0) {
                res = new String[apps.size()];
                apps.toArray(res);
                Arrays.sort(res);
            }
        }
        return res;
    }

    private void printChar(char symbol, int count, PrintWriter pw) {
        while (count > 0) {
            pw.print(symbol);
            --count;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

