/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.deploy.command.DCommandsUtils;
import com.sap.engine.services.deploy.server.DeployServiceImpl;
import com.sap.engine.services.deploy.server.Resource;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.rmi.RemoteException;

public class GetStatusCommand
implements Command {
    DeployServiceImpl deploy = null;

    public GetStatusCommand(DeployServiceImpl deployment) {
        this.deploy = deployment;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintWriter pw = new PrintWriter(os, true);
        String applicationName = null;
        boolean isApplication = false;
        String serverName = null;
        boolean isServer = false;
        ClassLoader threadLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            if (params.length == 0 || params[0].equals("-?") || params[0].toLowerCase().startsWith("-h")) {
                pw.println(this.getHelpMessage());
                Object var17_11 = null;
                Thread.currentThread().setContextClassLoader(threadLoader);
                return;
            }
            if (params.length > 1) {
                block26: {
                    block25: {
                        String cmd = null;
                        int i = 0;
                        while (true) {
                            if (i >= params.length) {
                                if (applicationName != null) break block25;
                                break;
                            }
                            cmd = params[i];
                            if (cmd.equals("-a")) {
                                isApplication = true;
                            } else if (isApplication) {
                                applicationName = cmd;
                                isApplication = false;
                            } else if (cmd.equals("-s")) {
                                isServer = true;
                            } else if (isServer) {
                                serverName = cmd;
                                isServer = false;
                            } else {
                                pw.println("Error in parameters.\n");
                                Object var17_12 = null;
                                Thread.currentThread().setContextClassLoader(threadLoader);
                                return;
                            }
                            ++i;
                        }
                        pw.println("Error in parameters. Missing required data.\n");
                        Object var17_14 = null;
                        Thread.currentThread().setContextClassLoader(threadLoader);
                        return;
                    }
                    if (this.deploy == null) {
                        pw.println("Deploy Service was not started!");
                        Object var17_15 = null;
                        Thread.currentThread().setContextClassLoader(threadLoader);
                        return;
                    }
                    try {
                        String status = "UNKNOWN";
                        if (applicationName == null) break block26;
                        pw.println("");
                        if (serverName == null) {
                            status = this.deploy.getApplicationStatus(applicationName);
                            if (status.equals("IMPLICIT_STOPPED")) {
                                Resource resource = this.deploy.getReasonForImplicitStopped(applicationName);
                                if (resource == null) {
                                    pw.println("Application " + applicationName + " is currently in status : " + status);
                                    break block26;
                                } else {
                                    pw.println("Application " + applicationName + " is currently in status : " + status + ", because it has hard reference to a resource with name " + resource.getName() + " and type " + Resource.getTypeName(resource.getType()) + " and that resource is not active.");
                                }
                                break block26;
                            }
                            pw.println("Application " + applicationName + " is currently in status : " + status);
                            break block26;
                        }
                        status = this.deploy.getApplicationStatus(applicationName, serverName);
                        pw.println("Application " + applicationName + " is currently in status : " + status);
                    }
                    catch (RemoteException re) {
                        DCommandsUtils.handleProblem(pw, re.toString());
                    }
                    catch (Exception ex) {
                        DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, ex);
                        Object var17_16 = null;
                        Thread.currentThread().setContextClassLoader(threadLoader);
                        return;
                    }
                    catch (ThreadDeath td) {
                        DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, td);
                        throw td;
                    }
                    catch (OutOfMemoryError oome) {
                        DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, oome);
                        throw oome;
                    }
                    catch (Error er) {
                        DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, er);
                    }
                }
                Object var17_17 = null;
                Thread.currentThread().setContextClassLoader(threadLoader);
                return;
            }
            pw.println("Error in parameters.\n");
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            Thread.currentThread().setContextClassLoader(threadLoader);
            throw throwable;
        }
        Object var17_13 = null;
        Thread.currentThread().setContextClassLoader(threadLoader);
    }

    public String getHelpMessage() {
        return "Displays the current status of an application.\nUsage: GET_STATUS <-a applicationName> [-s serverName]\nParameters:\n   <-a applicationName> - The name of the application to check.\n   [-s serverName]      - The name of the server, on which application status is\n                          checked. If not specified, it is the server\n                          processing the request.\n";
    }

    public String getName() {
        return "GET_STATUS";
    }

    public String getGroup() {
        return "DEPLOY";
    }

    public String[] getSupportedShellProviderNames() {
        String[] names = new String[]{"InQMyShell"};
        return names;
    }
}

