/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.deploy.DeployService;
import com.sap.engine.services.deploy.command.DCommandsUtils;
import com.sap.engine.services.deploy.container.AdditionalAppInfo;
import com.sap.engine.services.deploy.server.DeployServiceImpl;
import com.sap.engine.services.deploy.server.DeploymentInfo;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;

public class GetStartUpModeCommand
implements Command {
    DeployService deploy = null;

    public GetStartUpModeCommand(DeployService deployment) {
        this.deploy = deployment;
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintWriter pw = new PrintWriter(os, true);
        try {
            if (params.length != 1) {
                pw.println(this.getHelpMessage());
                return;
            }
            DeployServiceImpl dpl = (DeployServiceImpl)this.deploy;
            String appName = params[0];
            DeploymentInfo dinfo = dpl.getDeploymentInfo(appName);
            if (dinfo == null) {
                pw.println("Application " + appName + " doesn't exist. Please fully qualified name.");
                return;
            }
            pw.println("\nCurrent start-up mode is " + AdditionalAppInfo.getStartUpString((int)dinfo.getStartUp()) + "\n");
        }
        catch (Exception ex) {
            DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, ex);
            return;
        }
        catch (ThreadDeath td) {
            DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, td);
            throw td;
        }
        catch (OutOfMemoryError oome) {
            DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, oome);
            throw oome;
        }
        catch (Error er) {
            DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, er);
        }
    }

    public String getHelpMessage() {
        return "Displays start-up mode of an application.\nUsage: CHANGE_STARTUP <applicationName>\nParameters:\n   <applicationName> - The name of the application.\n";
    }

    public String getName() {
        return "GET_STARTUP";
    }

    public String getGroup() {
        return "DEPLOY";
    }

    public String[] getSupportedShellProviderNames() {
        String[] names = new String[]{"InQMyShell"};
        return names;
    }
}

