/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.lib.io.SerializableFile;
import com.sap.engine.services.deploy.DeployService;
import com.sap.engine.services.deploy.command.DCommandsUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.rmi.RemoteException;

public class GetClientJarsCommand
implements Command {
    DeployService deploy = null;

    public GetClientJarsCommand(DeployService deployment) {
        this.deploy = deployment;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintWriter pw = new PrintWriter(os, true);
        String applicationName = null;
        String outputDir = null;
        boolean isApplication = false;
        boolean isDirectory = false;
        ClassLoader threadLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            if (params.length == 0 || params.length > 0 && (params[0].equals("-?") || params[0].toLowerCase().startsWith("-h"))) {
                pw.println(this.getHelpMessage());
                Object var17_11 = null;
                Thread.currentThread().setContextClassLoader(threadLoader);
                return;
            }
            if (params.length > 1) {
                block29: {
                    block28: {
                        String cmd = null;
                        int i = 0;
                        while (true) {
                            if (i >= params.length) {
                                if (outputDir != null) break block28;
                                break;
                            }
                            cmd = params[i];
                            if (cmd.equals("-a")) {
                                isApplication = true;
                                isDirectory = false;
                            } else if (cmd.equals("-d")) {
                                isApplication = false;
                                isDirectory = true;
                            } else if (isDirectory) {
                                outputDir = cmd;
                                isDirectory = false;
                            } else if (isApplication) {
                                applicationName = cmd;
                            } else {
                                pw.println("Error in parameters.\n" + this.getHelpMessage());
                                Object var17_12 = null;
                                Thread.currentThread().setContextClassLoader(threadLoader);
                                return;
                            }
                            ++i;
                        }
                        pw.println("Error in parameters. Please specify right output directory.\n");
                        Object var17_14 = null;
                        Thread.currentThread().setContextClassLoader(threadLoader);
                        return;
                    }
                    if (applicationName == null) {
                        pw.println("Error in parameters. Missing required data.\n");
                        Object var17_15 = null;
                        Thread.currentThread().setContextClassLoader(threadLoader);
                        return;
                    }
                    try {
                        if (this.deploy == null) {
                            pw.println("Could not lookup deploy service.");
                            Object var17_16 = null;
                            Thread.currentThread().setContextClassLoader(threadLoader);
                            return;
                        }
                        SerializableFile res = this.deploy.getClientJar(applicationName);
                        if (res != null) {
                            if (!new File(outputDir).exists()) {
                                new File(outputDir).mkdirs();
                            }
                            FileOutputStream out = null;
                            try {
                                out = new FileOutputStream((outputDir == null ? "." : outputDir) + File.separator + res.getFileName());
                            }
                            catch (FileNotFoundException fnf) {
                                DCommandsUtils.handleProblem(pw, "deploy_1002", new String[]{(outputDir == null ? "." : outputDir) + File.separator + res.getFileName(), fnf.toString()}, fnf);
                                Object var17_17 = null;
                                Thread.currentThread().setContextClassLoader(threadLoader);
                                return;
                            }
                            try {
                                out.write(res.getBytes());
                                out.flush();
                                out.close();
                            }
                            catch (IOException ioe) {
                                DCommandsUtils.handleProblem(pw, "deploy_1004", null, ioe);
                                Object var17_18 = null;
                                Thread.currentThread().setContextClassLoader(threadLoader);
                                return;
                            }
                            pw.println("The client jar was copied in " + (outputDir == null ? "." : outputDir) + " directory.");
                            break block29;
                        }
                        pw.println("No application client jar was found.");
                    }
                    catch (RemoteException re) {
                        DCommandsUtils.handleProblem(pw, re.toString());
                    }
                    catch (Exception ex) {
                        DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, ex);
                        Object var17_19 = null;
                        Thread.currentThread().setContextClassLoader(threadLoader);
                        return;
                    }
                    catch (ThreadDeath td) {
                        DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, td);
                        throw td;
                    }
                    catch (OutOfMemoryError oome) {
                        DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, oome);
                        throw oome;
                    }
                    catch (Error er) {
                        DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, er);
                    }
                }
                Object var17_20 = null;
                Thread.currentThread().setContextClassLoader(threadLoader);
                return;
            }
            pw.println("Error in parameters.\n" + this.getHelpMessage());
        }
        catch (Throwable throwable) {
            Object var17_21 = null;
            Thread.currentThread().setContextClassLoader(threadLoader);
            throw throwable;
        }
        Object var17_13 = null;
        Thread.currentThread().setContextClassLoader(threadLoader);
    }

    public String getHelpMessage() {
        return "Creates an array of jar files, containing the classes a client module needs to work with an application.\nUsage: CLIENT_JARS <-d outputDir> <-a applicationName>\nParameters:\n   <-d outputDir>       - The directory where to store created client jar files.\n   <-a applicationName> - The name of the application for which client jar files\n                          are created.\n";
    }

    public String getName() {
        return "CLIENT_JARS";
    }

    public String getGroup() {
        return "DEPLOY";
    }

    public String[] getSupportedShellProviderNames() {
        String[] names = new String[]{"InQMyShell"};
        return names;
    }
}

