/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.lib.io.FileUtils;
import com.sap.engine.services.deploy.DeployService;
import com.sap.engine.services.deploy.command.DCommandsUtils;
import com.sap.engine.services.deploy.container.WarningException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.rmi.RemoteException;

public class DeployLanguageLibCommand
implements Command {
    DeployService deploy = null;

    public DeployLanguageLibCommand(DeployService deployment) {
        this.deploy = deployment;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        ClassLoader threadLoader;
        block27: {
            block26: {
                block25: {
                    PrintWriter pw = new PrintWriter(os, true);
                    String[] langLibJars = null;
                    String[] temp = null;
                    String appName = null;
                    String destinationDir = "." + File.separator + "temp" + File.separator + "deploy" + File.separator + "work" + File.separator + "deployLanguageLib" + File.separator;
                    if (params.length == 0 || params[0].equals("-?") || params[0].toLowerCase().startsWith("-h")) {
                        pw.println(this.getHelpMessage());
                        return;
                    }
                    threadLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    try {
                        int i;
                        if (params.length > 1) {
                            i = 0;
                            while (i < params.length - 1) {
                                if (params[i].equalsIgnoreCase("-a")) {
                                    appName = params[i + 1];
                                    ++i;
                                } else if (params[i].equalsIgnoreCase("-l")) {
                                    if (!(params[i + 1].toLowerCase().endsWith(".jar") || params[i + 1].toLowerCase().endsWith(".zip") || params[i + 1].toLowerCase().endsWith(".rar"))) {
                                        pw.println("Error in parameters. Wrong name of file.\n");
                                        Object var17_13 = null;
                                        Thread.currentThread().setContextClassLoader(threadLoader);
                                        return;
                                    }
                                    if (!new File(params[i + 1]).exists()) {
                                        pw.println("Error in parameters. File " + params[i + 1] + " dos not exists. \n");
                                        break block25;
                                    }
                                    if (langLibJars == null) {
                                        langLibJars = new String[]{params[i + 1]};
                                    } else {
                                        temp = new String[langLibJars.length + 1];
                                        System.arraycopy(langLibJars, 0, temp, 0, langLibJars.length);
                                        temp[langLibJars.length] = params[i + 1];
                                        langLibJars = temp;
                                    }
                                }
                                ++i;
                            }
                        }
                        if (appName == null || langLibJars == null || langLibJars.length == 0) {
                            pw.println(this.getHelpMessage());
                            break block26;
                        }
                        try {
                            i = 0;
                            while (true) {
                                if (i >= langLibJars.length) {
                                    try {
                                        this.deploy.deployLanguageLib(appName, langLibJars);
                                    }
                                    catch (WarningException wex) {
                                        pw.println("Language library " + appName + " deployed with WARNINGS.");
                                        DCommandsUtils.handleWarnings(pw, wex);
                                    }
                                    break block27;
                                }
                                File f = new File((String)langLibJars[i]);
                                try {
                                    FileUtils.copyFile((File)f, (File)new File(destinationDir + appName + "/" + f.getName()));
                                }
                                catch (IOException ex) {
                                    DCommandsUtils.handleProblem(pw, "deploy_1001", new String[]{langLibJars[i], new File(destinationDir + appName + "/" + f.getName()).getAbsolutePath(), ex.toString()}, ex);
                                    Object var17_16 = null;
                                    Thread.currentThread().setContextClassLoader(threadLoader);
                                    return;
                                }
                                ++i;
                            }
                        }
                        catch (RemoteException re) {
                            DCommandsUtils.handleProblem(pw, re.toString());
                            break block27;
                        }
                        catch (Exception ex) {
                            DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, ex);
                            Object var17_17 = null;
                            Thread.currentThread().setContextClassLoader(threadLoader);
                            return;
                        }
                        catch (ThreadDeath td) {
                            DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, td);
                            throw td;
                        }
                        catch (OutOfMemoryError oome) {
                            DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, oome);
                            throw oome;
                        }
                        catch (Error er) {
                            DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, er);
                            break block27;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var17_19 = null;
                        Thread.currentThread().setContextClassLoader(threadLoader);
                        throw throwable;
                    }
                }
                Object var17_14 = null;
                Thread.currentThread().setContextClassLoader(threadLoader);
                return;
            }
            Object var17_15 = null;
            Thread.currentThread().setContextClassLoader(threadLoader);
            return;
        }
        Object var17_18 = null;
        Thread.currentThread().setContextClassLoader(threadLoader);
    }

    public String getHelpMessage() {
        return "Deploys language libraries for an application to all servers in the cluster.\nUsage: DEPLOY_LANG_LIB <-a applicationName> <-l <languageLibrary>>*\nParameters:\n   <-a applicationName>  - The name of the application for which language\n                           libraries will be deployed.\n   <-l languageLibrary>* - Path to the library archive(s).\n";
    }

    public String getName() {
        return "DEPLOY_LANG_LIB";
    }

    public String getGroup() {
        return "DEPLOY";
    }

    public String[] getSupportedShellProviderNames() {
        String[] names = new String[]{"InQMyShell"};
        return names;
    }
}

