/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.deploy.DeployService;
import com.sap.engine.services.deploy.command.DCommandsUtils;
import com.sap.engine.services.deploy.server.DeployServiceImpl;
import com.sap.engine.services.deploy.server.DeploymentInfo;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.rmi.RemoteException;

public class ChangeStartUpModeCommand
implements Command {
    DeployService deploy = null;

    public ChangeStartUpModeCommand(DeployService deployment) {
        this.deploy = deployment;
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintWriter pw = new PrintWriter(os, true);
        try {
            if (params.length != 2 || !this.isNewStatusValid(params[1])) {
                pw.println(this.getHelpMessage());
                return;
            }
            String appName = params[0];
            String newStatus = params[1];
            DeployServiceImpl dpl = (DeployServiceImpl)this.deploy;
            DeploymentInfo dinfo = dpl.getDeploymentInfo(appName);
            if (dinfo == null) {
                pw.println("Application " + appName + " doesn't exist. Please fully qualified name.");
                return;
            }
            dinfo.setStartUpValue(newStatus);
            dpl.setAdditionalAppInfo(appName, dinfo);
        }
        catch (RemoteException re) {
            DCommandsUtils.handleProblem(pw, re.toString());
        }
        catch (Exception ex) {
            DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, ex);
            return;
        }
        catch (ThreadDeath td) {
            DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, td);
            throw td;
        }
        catch (OutOfMemoryError oome) {
            DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, oome);
            throw oome;
        }
        catch (Error er) {
            DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, er);
        }
    }

    protected boolean isNewStatusValid(String arg) {
        if (arg.compareTo("always") == 0) {
            return true;
        }
        if (arg.compareTo("manual") == 0) {
            return true;
        }
        return arg.compareTo("lazy") == 0;
    }

    public String getHelpMessage() {
        return "Changes start-up mode of an application.\nUsage: CHANGE_STARTUP <applicationName> <new status>\nParameters:\n   <applicationName> - The name of the application.\n   <new status>      - New start-up status. Possible values are always, lazy, \n                       manual.\n";
    }

    public String getName() {
        return "CHANGE_STARTUP";
    }

    public String getGroup() {
        return "DEPLOY";
    }

    public String[] getSupportedShellProviderNames() {
        String[] names = new String[]{"InQMyShell"};
        return names;
    }
}

