/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.deploy.DeployService;
import com.sap.engine.services.deploy.ReferenceObject;
import com.sap.engine.services.deploy.command.DCommandsUtils;
import com.sap.engine.services.deploy.container.WarningException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.util.StringTokenizer;

public class ChangeReference
implements Command {
    DeployService deploy = null;
    ReferenceObject[] references = new ReferenceObject[0];
    PrintWriter pw = null;

    public ChangeReference(DeployService deployment) {
        this.deploy = deployment;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exec(Environment environment, InputStream input, OutputStream output, String[] params) {
        ClassLoader threadLoader;
        block23: {
            block22: {
                block21: {
                    this.pw = new PrintWriter(output, true);
                    this.references = new ReferenceObject[0];
                    if (params.length == 0 || params[0].equals("-?") || params[0].toLowerCase().startsWith("-h")) {
                        this.pw.println(this.getHelpMessage());
                        return;
                    }
                    threadLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    try {
                        if (params.length >= 3) {
                            try {
                                if (params[0].equals("-m")) {
                                    if (!this.parseRestArgs(params, 2)) {
                                        this.pw.println(this.getHelpMessage());
                                        Object var12_6 = null;
                                        Thread.currentThread().setContextClassLoader(threadLoader);
                                        return;
                                    }
                                    try {
                                        this.deploy.makeReferences(params[1], this.references);
                                    }
                                    catch (WarningException wex) {
                                        this.pw.println("References from application " + params[1] + " made with WARNINGS.");
                                        DCommandsUtils.handleWarnings(this.pw, wex);
                                    }
                                    int r = 0;
                                    while (r < this.references.length) {
                                        this.pw.println("The reference between application " + params[1] + " and " + this.references[r] + " was made!");
                                        ++r;
                                    }
                                }
                                if (params[0].equals("-r")) {
                                    if (!this.parseRestArgs(params, 2)) {
                                        this.pw.println(this.getHelpMessage());
                                        break block21;
                                    }
                                    try {
                                        this.deploy.removeReferences(params[1], this.references);
                                    }
                                    catch (WarningException wex) {
                                        this.pw.println("References from application " + params[1] + " removed with WARNINGS.");
                                        DCommandsUtils.handleWarnings(this.pw, wex);
                                    }
                                    int r = 0;
                                    while (r < this.references.length) {
                                        this.pw.println("The reference between application " + params[1] + " and " + this.references[r] + " removed!");
                                        ++r;
                                    }
                                }
                                this.pw.println(this.getHelpMessage());
                                break block22;
                            }
                            catch (RemoteException re) {
                                DCommandsUtils.handleProblem(this.pw, re.toString());
                            }
                            catch (Exception ex) {
                                DCommandsUtils.handleProblem(this.pw, "deploy_1006", new String[]{this.getName()}, ex);
                                Object var12_9 = null;
                                Thread.currentThread().setContextClassLoader(threadLoader);
                                return;
                            }
                            catch (ThreadDeath td) {
                                DCommandsUtils.handleProblem(this.pw, "deploy_1006", new String[]{this.getName()}, td);
                                throw td;
                            }
                            catch (OutOfMemoryError oome) {
                                DCommandsUtils.handleProblem(this.pw, "deploy_1006", new String[]{this.getName()}, oome);
                                throw oome;
                            }
                            catch (Error er) {
                                DCommandsUtils.handleProblem(this.pw, "deploy_1006", new String[]{this.getName()}, er);
                            }
                        } else {
                            this.pw.println(this.getHelpMessage());
                            break block23;
                        }
                        Object var12_11 = null;
                        Thread.currentThread().setContextClassLoader(threadLoader);
                        return;
                    }
                    catch (Throwable throwable) {
                        Object var12_12 = null;
                        Thread.currentThread().setContextClassLoader(threadLoader);
                        throw throwable;
                    }
                }
                Object var12_7 = null;
                Thread.currentThread().setContextClassLoader(threadLoader);
                return;
            }
            Object var12_8 = null;
            Thread.currentThread().setContextClassLoader(threadLoader);
            return;
        }
        Object var12_10 = null;
        Thread.currentThread().setContextClassLoader(threadLoader);
    }

    public String getName() {
        return "CHANGE_REF";
    }

    public String getGroup() {
        return "DEPLOY";
    }

    public String[] getSupportedShellProviderNames() {
        String[] names = new String[]{"InQMyShell"};
        return names;
    }

    public String getHelpMessage() {
        return "Creates or removes references between an application and its resources.\nUsage: CHANGE_REF <mode> <applicationName> [referenceType] [-pr providerName] <[resourceType:]<resourceName>>*\nParameters:\n   <mode>:\n      -m                            - Creates references from an application to\n                                      resource(s).\n      -r                            - Removes references between an application\n                                      and resource(s).\n   <applicationName>                - The name of the application to create to\n                                      or remove references from.\n   [referenceType]                  - Reference type for resources to be created\n                                      references to. Default type is weak.\n                                      Reference type is ignored in case of \n                                      removing references.\n      -weak                         - Creates weak references to resources.\n      -hard                         - Creates hard references to resources.\n   [-pr providerName]               - Provider name for application resources.\n                                      Default values are:\n                                       - for applications: \"sap.com\";\n                                       - for libraries, interfaces and services:\n                                         \"engine.sap.com\".\n   <[resourceType:]<resourceName>>* - A semicolon-separated list of resources.\n      [resourceType]                - Resource type to create to or remove \n                                      references from. Default type is library.\n                                      Possible types are:\n         application                - Referenced resource is an application.\n         library                    - Referenced resource is a library.\n         interface                  - Referenced resource is an interface.\n         service                    - Referenced resource is a service.\n      <resourceName>                - The name of the resource.\n";
    }

    private ReferenceObject[] parseRefs(StringTokenizer st) {
        String ref = null;
        ReferenceObject[] result = new ReferenceObject[st.countTokens()];
        ReferenceObject refObject = null;
        int i = 0;
        while (st.hasMoreTokens()) {
            ref = st.nextToken();
            refObject = new ReferenceObject();
            if (ref.startsWith("application:")) {
                refObject.setReferenceTarget(ref.substring("application:".length()));
                refObject.setReferenceTargetType("application");
            } else if (ref.startsWith("library:")) {
                refObject.setReferenceTarget(ref.substring("library:".length()));
                refObject.setReferenceTargetType("library");
            } else if (ref.startsWith("service:")) {
                refObject.setReferenceTarget(ref.substring("service:".length()));
                refObject.setReferenceTargetType("service");
            } else if (ref.startsWith("interface:")) {
                refObject.setReferenceTarget(ref.substring("interface:".length()));
                refObject.setReferenceTargetType("interface");
            } else {
                refObject.setReferenceTarget(ref);
                refObject.setReferenceTargetType("library");
            }
            result[i++] = refObject;
        }
        return result;
    }

    private boolean parseRestArgs(String[] params, int index) {
        boolean result = true;
        String providerName = null;
        boolean weak = true;
        int i = index;
        while (i < params.length - 1) {
            if (params[i].equalsIgnoreCase("-hard")) {
                weak = false;
            } else if (params[i].equalsIgnoreCase("-weak")) {
                weak = true;
            } else if (params[i].equalsIgnoreCase("-pr")) {
                if (++i == params.length - 1) {
                    return false;
                }
                providerName = params[i];
            }
            ++i;
        }
        StringTokenizer st = new StringTokenizer(params[params.length - 1], ";");
        this.references = this.parseRefs(st);
        if (this.references.length == 0) {
            this.pw.println("No references specified.");
            return false;
        }
        int i2 = 0;
        while (i2 < this.references.length) {
            this.references[i2].setReferenceType(weak ? "weak" : "hard");
            if (providerName != null) {
                this.references[i2].setReferenceProviderName(providerName);
            }
            ++i2;
        }
        return result;
    }
}

