/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.lib.io.FileUtils;
import com.sap.engine.services.deploy.DeployService;
import com.sap.engine.services.deploy.command.DCommandsUtils;
import com.sap.engine.services.deploy.container.WarningException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.rmi.RemoteException;

public class ChangeInterfaces
implements Command {
    DeployService deploy = null;

    public ChangeInterfaces(DeployService deployment) {
        this.deploy = deployment;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exec(Environment environment, InputStream input, OutputStream output, String[] params) {
        ClassLoader threadLoader;
        block21: {
            block23: {
                block22: {
                    block20: {
                        PrintWriter pw = new PrintWriter(output, true);
                        if (params.length == 0 || params[0].equals("-?") || params[0].toLowerCase().startsWith("-h")) {
                            pw.println(this.getHelpMessage());
                            return;
                        }
                        threadLoader = Thread.currentThread().getContextClassLoader();
                        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                        try {
                            if (params.length >= 2) {
                                try {
                                    if (params[0].equals("-d")) {
                                        String jarname = params[1];
                                        if (!(jarname.toLowerCase().endsWith(".jar") || jarname.toLowerCase().endsWith(".zip") || jarname.toLowerCase().endsWith(".rar"))) {
                                            pw.println("The extention of the file " + jarname + " must be jar, rar or zip!.\n");
                                            Object var13_10 = null;
                                            Thread.currentThread().setContextClassLoader(threadLoader);
                                            return;
                                        }
                                        File originalFile = new File(jarname);
                                        if (!originalFile.exists()) {
                                            pw.println("The file " + originalFile.getAbsolutePath() + " was not found!");
                                            break block20;
                                        }
                                        String jar = "." + File.separator + "temp" + File.separator + "deploy" + File.separator + "work" + File.separator + "deploying" + File.separator + originalFile.getName();
                                        File file = new File(jar);
                                        try {
                                            FileUtils.copyFile((File)originalFile, (File)file);
                                        }
                                        catch (IOException ex) {
                                            DCommandsUtils.handleProblem(pw, "deploy_1001", new String[]{jarname, jar, ex.toString()}, ex);
                                            Object var13_12 = null;
                                            Thread.currentThread().setContextClassLoader(threadLoader);
                                            return;
                                        }
                                        try {
                                            this.deploy.deployInterface(jar);
                                        }
                                        catch (WarningException wex) {
                                            pw.println("Interface " + jar + " deployed with WARNINGS.");
                                            DCommandsUtils.handleWarnings(pw, wex);
                                        }
                                        break block21;
                                    }
                                    if (params[0].equals("-r")) {
                                        try {
                                            this.deploy.removeInterface(params[1]);
                                        }
                                        catch (WarningException wex) {
                                            pw.println("Interface " + params[1] + " removed with WARNINGS.");
                                            DCommandsUtils.handleWarnings(pw, wex);
                                        }
                                        break block21;
                                    }
                                    pw.println(this.getHelpMessage());
                                    break block22;
                                }
                                catch (RemoteException re) {
                                    DCommandsUtils.handleProblem(pw, re.toString());
                                    break block21;
                                }
                                catch (Exception ex) {
                                    DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, ex);
                                    Object var13_14 = null;
                                    Thread.currentThread().setContextClassLoader(threadLoader);
                                    return;
                                }
                                catch (ThreadDeath td) {
                                    DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, td);
                                    throw td;
                                }
                                catch (OutOfMemoryError oome) {
                                    DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, oome);
                                    throw oome;
                                }
                                catch (Error er) {
                                    DCommandsUtils.handleProblem(pw, "deploy_1006", new String[]{this.getName()}, er);
                                    break block21;
                                }
                            }
                            pw.println(this.getHelpMessage());
                            break block23;
                        }
                        catch (Throwable throwable) {
                            Object var13_17 = null;
                            Thread.currentThread().setContextClassLoader(threadLoader);
                            throw throwable;
                        }
                    }
                    Object var13_11 = null;
                    Thread.currentThread().setContextClassLoader(threadLoader);
                    return;
                }
                Object var13_13 = null;
                Thread.currentThread().setContextClassLoader(threadLoader);
                return;
            }
            Object var13_15 = null;
            Thread.currentThread().setContextClassLoader(threadLoader);
            return;
        }
        Object var13_16 = null;
        Thread.currentThread().setContextClassLoader(threadLoader);
    }

    public String getName() {
        return "CHANGE_INTERFACE";
    }

    public String getGroup() {
        return "DEPLOY";
    }

    public String[] getSupportedShellProviderNames() {
        String[] names = new String[]{"InQMyShell"};
        return names;
    }

    public String getHelpMessage() {
        return "Deploys or removes an interface from the servers in the cluster.\nUsage: CHANGE_INTERFACE <parameters> \nParameters:\n   <parameters>:\n      -d <jarName>       - Deploys an interface using jar file containing all\n                           the necessary information for the deployable\n                           interface.\n      -r <interfaceName> - Removes the interface with the specified name.\n";
    }
}

