/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class DynamicClassLoader
extends ClassLoader {
    private String classPath;

    public DynamicClassLoader(String classPath) {
        this.classPath = classPath;
    }

    public synchronized Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, true);
    }

    public InputStream getResourceAsStream(String name) {
        try {
            byte[] arr = this.readFileFromClassPath(name, false);
            return new ByteArrayInputStream(arr);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> res = null;
        res = this.findLoadedClass(name);
        if (res == null) {
            byte[] classData = null;
            try {
                classData = this.readFileFromClassPath(name, true);
            }
            catch (Exception ioEx) {
                throw new ClassNotFoundException(name);
            }
            if (classData != null) {
                res = this.defineClass(name, classData, 0, classData.length);
            } else {
                res = this.findSystemClass(name);
            }
        }
        if (resolve) {
            this.resolveClass(res);
        }
        return res;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] readFileFromClassPath(String name, boolean isClass) throws IOException {
        File f;
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        StringTokenizer token = new StringTokenizer(this.classPath, File.pathSeparator);
        while (true) {
            Object var12_12;
            ZipFile zip;
            block13: {
                byte[] byArray;
                if (!token.hasMoreTokens()) {
                    return null;
                }
                f = new File(token.nextToken());
                if (!f.exists()) continue;
                if (f.isDirectory()) break;
                zip = null;
                try {
                    zip = new ZipFile(f);
                    ZipEntry zipEntry = null;
                    zipEntry = isClass ? zip.getEntry(name.replace('.', '/') + ".class") : zip.getEntry(name);
                    if (zipEntry == null) break block13;
                    BufferedInputStream is = new BufferedInputStream(zip.getInputStream(zipEntry));
                    while (true) {
                        void var9_14;
                        int c;
                        if ((c = ((InputStream)is).read()) == -1) {
                            buff.close();
                            ((InputStream)is).close();
                            byArray = buff.toByteArray();
                            var12_12 = null;
                            if (zip == null) return byArray;
                            break;
                        }
                        buff.write((int)var9_14);
                    }
                }
                catch (Throwable throwable) {
                    var12_12 = null;
                    if (zip != null) {
                        zip.close();
                    }
                    throw throwable;
                }
                zip.close();
                return byArray;
            }
            var12_12 = null;
            if (zip == null) continue;
            zip.close();
        }
        BufferedInputStream is = null;
        is = isClass ? new BufferedInputStream(new FileInputStream(new File(f, name.replace('.', File.separatorChar) + ".class"))) : new BufferedInputStream(new FileInputStream(new File(name)));
        while (true) {
            void e;
            int c;
            if ((c = ((InputStream)is).read()) == -1) {
                buff.close();
                ((InputStream)is).close();
                return buff.toByteArray();
            }
            buff.write((int)e);
        }
    }
}

