/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.organizerUI.ui;

import com.sap.cms.organizerUI.internal.TransportViewRepository;
import com.sap.cms.organizerUI.ui.TransportAdaptableSelectionProvider;
import com.sap.cms.util.logging.CmsLogger;
import com.sap.ide.eclipse.cbs.activation.internal.ActivationRuntimeDataStorage;
import com.sap.ide.login.LoginListener;
import com.sap.ide.login.UserValidator;
import com.sap.tc.complib.DevelopmentConfiguration;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.internal.IIDELoginListener;
import com.tssap.dtr.client.eclipse.internal.RepositoryViewLegendManager;
import com.tssap.dtr.client.eclipse.ui.LegendDialog;
import com.tssap.dtr.client.eclipse.ui.MultipleSelectionMessageDialog;
import com.tssap.dtr.client.eclipse.ui.SearchFolderItemInViewerDialog;
import com.tssap.dtr.client.eclipse.ui.actions.AddFavoriteAction;
import com.tssap.dtr.client.eclipse.ui.actions.CheckoutAndDeleteAction;
import com.tssap.dtr.client.eclipse.ui.actions.DeleteActivityAction;
import com.tssap.dtr.client.eclipse.ui.actions.DeleteSubtreeAction;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.IRepositoryViewLegendManager;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.OfflineModeTreeInput;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.PluggableProvider;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.RepositoryTreeViewer;
import com.tssap.dtr.client.eclipse.ui.util.ConcreteCompositeImageDescriptor;
import com.tssap.dtr.client.eclipse.ui.util.ImageDescriptorSingletone;
import com.tssap.dtr.client.eclipse.ui.util.RefreshLogic;
import com.tssap.dtr.client.eclipse.ui.util.RepositoryBrowseFavorite;
import com.tssap.dtr.client.eclipse.util.Util;
import com.tssap.dtr.client.eclipse.vfs.VfsManagerProvider;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.util.Platform;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityListener;
import com.tssap.dtr.client.lib.vfs.IVfsContext;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsFolder;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsManagerListener;
import com.tssap.dtr.client.lib.vfs.IVfsRepository;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VersionedFileSystemFactory;
import com.tssap.dtr.client.lib.vfs.VfsActivityState;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsExceptionCategory;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.config.Configuration;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import com.tssap.dtr.client.lib.vfs.config.IConfiguration;
import com.tssap.dtr.client.lib.vfs.config.IConfigurationListener;
import java.security.KeyStore;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;

public class TransportView
extends ViewPart
implements IShowInTarget,
IVfsManagerListener,
IConfigurationListener,
IIDELoginListener,
IContentProvider,
IVfsActivityListener {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$cms$organizerUI$ui$TransportView == null ? (class$com$sap$cms$organizerUI$ui$TransportView = TransportView.class$("com.sap.cms.organizerUI.ui.TransportView")) : class$com$sap$cms$organizerUI$ui$TransportView));
    public static final String PRESTORE_KEYPART_SORT_CHANGE_REQUEST_ASCENDING = "_sortChangeRequestAscending";
    public static final String PRESTORE_KEYPART_SORT_CHANGE_REQUEST_BY_NAME = "_sortChangeRequestByName";
    public static final String PRESTORE_KEYPART_PENDING_WORKSPACE_DECORATORS = "_pendingWorkspaceDecorators";
    private static final CmsLogger log = CmsLogger.getLogger((String)(class$com$sap$cms$organizerUI$ui$TransportView == null ? (class$com$sap$cms$organizerUI$ui$TransportView = TransportView.class$("com.sap.cms.organizerUI.ui.TransportView")) : class$com$sap$cms$organizerUI$ui$TransportView).getName());
    private WebUIAction action_gotoWebUI = null;
    private static final String REFRESH_ACTION_ICON_ATTRIBUTE = "refreshButtonIcon";
    private static final String REFRESH_ACTION_TOOLTIP_ATTRIBUTE = "refreshButtonTooltip";
    private static final String REFRESH_ACTION_TOOLTIP_DEFAULT = "Refresh";
    private static final String REFRESH_ACTION_ICON_DEFAULT = "refresh.gif";
    private static final String VIEW_ID_KEY = "id";
    private static final String VIEW_TITLE_SEPARATOR_CLIENT = " - ";
    private static final String VIEW_TITLE_SEPARATOR_USER_BEGIN = " [";
    private static final String VIEW_TITLE_SEPARATOR_USER_END = "]";
    private static final String VIEW_TITLE_PART_ALL_USERS = "All Users";
    private static final String MENU_LABEL_ADD_FAVORITE = "Add Favorite...";
    private static final String MENU_LABEL_GOTO_FAVORITE = "Go to Favorite";
    private static final String MENU_LABEL_DELETE_FAVORITE = "Delete Favorite";
    private static final String MENU_LABEL_FIND_BY_PATH = "Navigate by Path...";
    private static final String MENU_LABEL_VIEW_FOR_ANOTHER_USER = "Another User...";
    private static final String MENU_LABEL_SET_WORKSPACE_FILTER = "Workspace Filter...";
    private static final String MENU_LABEL_SORT_ASCENDING = "Ascending";
    private static final String MENU_LABEL_SORT_DESCENDING = "Descending";
    private static final String MENU_LABEL_SHOW_LEGEND = "Display Legend";
    private static final String IMAGE_NAME_FAVORITE = "favorite.gif";
    private static final String IMAGE_NAME_SEARCH = "search.gif";
    private static final String IMAGE_NAME_WSFILTER = "ws_filters.gif";
    private static final String IMAGE_NAME_LEGEND = "showlegend.gif";
    private static final String DIALOG_TITLE_WORKSPACE_FILTER = "Workspace Filter";
    private static final String DIALOG_MESSAGE_WORKSPACE_FILTER = "Select the workspaces to view";
    private static final ImageDescriptorSingletone DECORATOR_ALL_USERS = new ImageDescriptorSingletone("allusers.gif");
    private static final ImageDescriptorSingletone DECORATOR_OTHER_USER = new ImageDescriptorSingletone("otheruser.gif");
    private static final ImageDescriptorSingletone DECORATOR_DATE_RANGE = new ImageDescriptorSingletone("daterange.gif");
    private String m_viewId;
    private String m_viewType;
    private RepositoryTreeViewer m_repositoryViewer;
    private Composite m_parent;
    private Image m_defaultViewTitleImage;
    private IAction m_refreshAction;
    private Boolean m_favoritesMenuVisible = null;
    private Boolean m_userMenuVisible = null;
    private Boolean m_dateMenuVisible = null;
    private Boolean m_sortMenuVisible = null;
    private Boolean m_wsFilterMenuVisible = null;
    private Boolean m_legendMenuVisible = null;
    private RepositoryViewLegendManager m_legendManager;
    private String m_clientName_gettingVfsManagerFailedBecauseOfThreadingProblem;
    static /* synthetic */ Class class$com$sap$cms$organizerUI$ui$TransportView;

    public TransportView() {
        IPreferenceStore preferenceStore = BluebirdPlugin.getDefault().getPreferenceStore();
        if (preferenceStore != null) {
            preferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if ("showProjectDecorator".equals(event.getProperty())) {
                        TransportView.this.getRepositoryTreeViewer().refresh();
                    }
                }
            });
        }
    }

    public void createPartControl(Composite parent) {
        this.m_parent = parent;
        Composite composite = this.createNewPanel(parent);
        this.m_repositoryViewer.createControl(composite);
        this.m_repositoryViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    TransportView.this.clearStatusLine();
                    Object element = ((IStructuredSelection)selection).getFirstElement();
                    if (element instanceof IVfsFolderItem) {
                        IVfsFile file = ((IVfsFolderItem)element).asFile();
                        IVfsFolder folder = ((IVfsFolderItem)element).asFolder();
                        if (file != null) {
                            if (file.hasLocalRemoteNameClash()) {
                                if (file.getActivityState() != VfsFolderItemActivityState.NOT_CHECKED_OUT) {
                                    TransportView.this.showErrorMessage("\"" + file.getName() + "\" has a name clash between local existing file and resource in repository! Revert file and rename or delete local file.");
                                } else {
                                    TransportView.this.showErrorMessage("\"" + file.getName() + "\" has a name clash between local existing file and resource in repository! Rename or delete local file.");
                                }
                                return;
                            }
                            if (file.wasManuallySetWritable()) {
                                TransportView.this.showErrorMessage("\"" + file.getName() + "\" has been manually set to writable. Save changed content, reset file to read-only, remove it and sync again.");
                                return;
                            }
                            if (file.isInconsistent()) {
                                TransportView.this.showErrorMessage("\"" + file.getName() + "\" No MountPoint for checked-out file. Please create a MountPoint for the remote resource.");
                                return;
                            }
                        }
                        if (folder != null && folder.isInconsistent()) {
                            TransportView.this.showErrorMessage("\"" + folder.getName() + "\" No MountPoint for checked-out folder. Please create a MountPoint for the remote resource.");
                            return;
                        }
                        String msg = ((IVfsFolderItem)element).getCategory().toString();
                        msg = msg.concat(TransportView.VIEW_TITLE_SEPARATOR_CLIENT).concat(((IVfsFolderItem)element).getName());
                        if (element instanceof IVfsFile) {
                            try {
                                long length = ((IVfsFile)element).getLength();
                                String byteStr = length > 1L ? "bytes" : "byte";
                                msg = msg + " (" + length + " " + byteStr + ")";
                            }
                            catch (VfsException x) {
                                TransportView.this.showErrorMessage(x.getMessage());
                                LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
                            }
                        }
                        TransportView.this.getViewSite().getActionBars().getStatusLineManager().setMessage(msg);
                    }
                }
            }
        });
        this.addKeyListener();
        this.getSite().registerContextMenu(this.m_repositoryViewer.getMenuManager(), (ISelectionProvider)this.m_repositoryViewer.getTreeViewer());
        this.getSite().setSelectionProvider((ISelectionProvider)new TransportAdaptableSelectionProvider((ISelectionProvider)this.getRepositoryTreeViewer().getTreeViewer()));
        this.createToolbar();
        this.createMenu();
        this.setDefaultViewTitleImage(this.getTitleImage());
        this.updateViewTitle();
        this.updateViewTitleImage();
        this.registerListeners();
    }

    private void createMenu() {
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        if (this.m_viewType != null) {
            WebUIAction action_gotoWebUI = new WebUIAction();
            UserValidator.addLoginListener((LoginListener)action_gotoWebUI);
            menuManager.add((IAction)action_gotoWebUI);
            menuManager.add((IContributionItem)new Separator());
        }
        if (this.m_viewType != null && this.m_viewType.equals("FOLDER_ITEM") && this.isFavoriteMenuVisible()) {
            this.createFavoriteMenus(menuManager);
        }
        if (this.m_viewType != null && this.m_viewType.equals("ACTIVITY_CLOSED")) {
            if (this.isUserMenuVisible()) {
                this.createUserMenu(menuManager);
            }
            if (this.isDateRangeMenuVisible()) {
                this.createDateRangeMenu(menuManager);
            }
            if (this.isFilterWorkspaceMenuVisible()) {
                this.createFilterWorkspaceMenu(menuManager);
            }
        }
        if (this.m_viewType != null && (this.m_viewType.equals("ACTIVITY_OPEN") || this.m_viewType.equals("ACTIVITY_CLOSED")) && this.isSortMenuVisible()) {
            if (menuManager.getItems() != null && menuManager.getItems().length > 0) {
                menuManager.add((IContributionItem)new Separator());
            }
            this.createSortMenus(menuManager);
        }
        if (this.m_viewType != null && this.m_viewType.equals("VERSION")) {
            if (this.isUserMenuVisible()) {
                this.createUserMenuForCollisionView(menuManager);
            }
            if (this.isFilterWorkspaceMenuVisible()) {
                this.createFilterWorkspaceMenu(menuManager);
            }
        }
        this.createCustomizeMenu(menuManager);
        if (this.isShowLegendMenuVisible()) {
            this.createShowLegendMenu(menuManager);
        }
    }

    public void dispose() {
        UserValidator.removeLoginListener((LoginListener)this.action_gotoWebUI);
        Configuration.getConfiguration().removeConfigurationListener((IConfigurationListener)this);
        VersionedFileSystemFactory.removeVfsManagerListener((IVfsManagerListener)this);
        if (VfsManagerProvider.getInstance().isSapIDELoginAvailable()) {
            VfsManagerProvider.getInstance().removeIDELoginListener((IIDELoginListener)this);
        }
        if (this.getRepositoryTreeViewer() != null && "ACTIVITY_CLOSED".equals(this.m_viewType) && "com.sap.ide.eclipse.cbs.activation.ui.views.InactiveActivityView".equals(this.m_viewId)) {
            this.getRepositoryTreeViewer().removeInputChangelistener((IContentProvider)this);
        }
        super.dispose();
    }

    private boolean isChangeRequestSortedByName() {
        return this.getPreferenceStore().getBoolean(this.getViewID() + PRESTORE_KEYPART_SORT_CHANGE_REQUEST_BY_NAME);
    }

    private boolean isChangeRequestSortedAscending() {
        return this.getPreferenceStore().getBoolean(this.getViewID() + PRESTORE_KEYPART_SORT_CHANGE_REQUEST_ASCENDING);
    }

    private void createDateRangeMenu(IMenuManager mainMenuManager) {
        MenuManager dateRangeMenu = new MenuManager("Date Filter");
        mainMenuManager.add((IContributionItem)dateRangeMenu);
        Action actLastMonth = new Action("Last 2 Weeks"){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                TransportView.this.getPreferenceStore().setValue(TransportView.this.getViewID() + "_dateRange", "");
                TransportView.this.updateRepositoryTree(false);
                TransportView.this.updateViewTitleImage();
            }
        };
        Action actUnlimited = new Action("Unlimited"){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                TransportView.this.getPreferenceStore().setValue(TransportView.this.getViewID() + "_dateRange", "*");
                TransportView.this.updateRepositoryTree(false);
                TransportView.this.updateViewTitleImage();
            }
        };
        String dateRange = this.getDateRangeFromPreferenceStrore();
        boolean unlimitedDateRange = dateRange.equals("*");
        actLastMonth.setChecked(!unlimitedDateRange);
        actUnlimited.setChecked(unlimitedDateRange);
        dateRangeMenu.add((IAction)actLastMonth);
        dateRangeMenu.add((IAction)actUnlimited);
        dateRangeMenu.addMenuListener(new IMenuListener((IAction)actLastMonth, (IAction)actUnlimited){
            private final /* synthetic */ IAction val$actLastMonth;
            private final /* synthetic */ IAction val$actUnlimited;
            {
                this.val$actLastMonth = val$actLastMonth;
                this.val$actUnlimited = val$actUnlimited;
            }

            public void menuAboutToShow(IMenuManager manager) {
                String dateRange = TransportView.this.getDateRangeFromPreferenceStrore();
                boolean unlimitedDateRange = dateRange.equals("*");
                this.val$actLastMonth.setChecked(!unlimitedDateRange);
                this.val$actUnlimited.setChecked(unlimitedDateRange);
            }
        });
    }

    private void createSortMenus(IMenuManager mainMenuManager) {
        MenuManager sortChangeRequestMenu = new MenuManager("Sort Change Requests");
        mainMenuManager.add((IContributionItem)sortChangeRequestMenu);
        String sortByCreationDateLabel = "by Creation Date";
        Action actSortChangeRequestByDate = new Action(sortByCreationDateLabel){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                TransportView.this.getPreferenceStore().setValue(TransportView.this.getViewID() + TransportView.PRESTORE_KEYPART_SORT_CHANGE_REQUEST_BY_NAME, !this.isChecked());
                TransportView.this.updateRepositoryTree(false);
            }
        };
        actSortChangeRequestByDate.setChecked(false);
        Action actSortChangeRequestByName = new Action("by Name"){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                TransportView.this.getPreferenceStore().setValue(TransportView.this.getViewID() + TransportView.PRESTORE_KEYPART_SORT_CHANGE_REQUEST_BY_NAME, this.isChecked());
                TransportView.this.updateRepositoryTree(false);
            }
        };
        actSortChangeRequestByName.setChecked(false);
        Action actSortChangeRequestAscending = new Action(MENU_LABEL_SORT_ASCENDING){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                TransportView.this.getPreferenceStore().setValue(TransportView.this.getViewID() + TransportView.PRESTORE_KEYPART_SORT_CHANGE_REQUEST_ASCENDING, this.isChecked());
                TransportView.this.updateRepositoryTree(false);
            }
        };
        actSortChangeRequestAscending.setChecked(false);
        Action actSortChangeRequestDescending = new Action(MENU_LABEL_SORT_DESCENDING){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                TransportView.this.getPreferenceStore().setValue(TransportView.this.getViewID() + TransportView.PRESTORE_KEYPART_SORT_CHANGE_REQUEST_ASCENDING, !this.isChecked());
                TransportView.this.updateRepositoryTree(false);
            }
        };
        actSortChangeRequestDescending.setChecked(false);
        sortChangeRequestMenu.add((IAction)actSortChangeRequestByDate);
        sortChangeRequestMenu.add((IAction)actSortChangeRequestByName);
        sortChangeRequestMenu.add((IContributionItem)new Separator());
        sortChangeRequestMenu.add((IAction)actSortChangeRequestAscending);
        sortChangeRequestMenu.add((IAction)actSortChangeRequestDescending);
        sortChangeRequestMenu.addMenuListener(new IMenuListener((IAction)actSortChangeRequestByDate, (IAction)actSortChangeRequestByName, (IAction)actSortChangeRequestAscending, (IAction)actSortChangeRequestDescending){
            private final /* synthetic */ IAction val$actSortChangeRequestByDate;
            private final /* synthetic */ IAction val$actSortChangeRequestByName;
            private final /* synthetic */ IAction val$actSortChangeRequestAscending;
            private final /* synthetic */ IAction val$actSortChangeRequestDescending;
            {
                this.val$actSortChangeRequestByDate = val$actSortChangeRequestByDate;
                this.val$actSortChangeRequestByName = val$actSortChangeRequestByName;
                this.val$actSortChangeRequestAscending = val$actSortChangeRequestAscending;
                this.val$actSortChangeRequestDescending = val$actSortChangeRequestDescending;
            }

            public void menuAboutToShow(IMenuManager manager) {
                boolean sortByName = TransportView.this.isChangeRequestSortedByName();
                boolean sortAscending = TransportView.this.isChangeRequestSortedAscending();
                this.val$actSortChangeRequestByDate.setChecked(!sortByName);
                this.val$actSortChangeRequestByName.setChecked(sortByName);
                this.val$actSortChangeRequestAscending.setChecked(sortAscending);
                this.val$actSortChangeRequestDescending.setChecked(!sortAscending);
            }
        });
        MenuManager sortActivityMenu = new MenuManager("Sort Activities");
        mainMenuManager.add((IContributionItem)sortActivityMenu);
        String sortByDateLabel = this.m_viewType.equals("ACTIVITY_OPEN") ? "by Creation Date" : "by Checkin Date";
        Action actSortActivityByDate = new Action(sortByDateLabel){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                TransportView.this.getPreferenceStore().setValue(TransportView.this.getViewID() + "_sortActivityByName", !this.isChecked());
                TransportView.this.updateRepositoryTree(false);
            }
        };
        actSortActivityByDate.setChecked(false);
        Action actSortActivityByName = new Action("by Name"){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                TransportView.this.getPreferenceStore().setValue(TransportView.this.getViewID() + "_sortActivityByName", this.isChecked());
                TransportView.this.updateRepositoryTree(false);
            }
        };
        actSortActivityByName.setChecked(false);
        Action actSortActivityAscending = new Action(MENU_LABEL_SORT_ASCENDING){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                TransportView.this.getPreferenceStore().setValue(TransportView.this.getViewID() + "_sortActivityAscending", this.isChecked());
                TransportView.this.updateRepositoryTree(false);
            }
        };
        actSortActivityAscending.setChecked(false);
        Action actSortActivityDescending = new Action(MENU_LABEL_SORT_DESCENDING){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                TransportView.this.getPreferenceStore().setValue(TransportView.this.getViewID() + "_sortActivityAscending", !this.isChecked());
                TransportView.this.updateRepositoryTree(false);
            }
        };
        actSortActivityDescending.setChecked(false);
        sortActivityMenu.add((IAction)actSortActivityByDate);
        sortActivityMenu.add((IAction)actSortActivityByName);
        sortActivityMenu.add((IContributionItem)new Separator());
        sortActivityMenu.add((IAction)actSortActivityAscending);
        sortActivityMenu.add((IAction)actSortActivityDescending);
        sortActivityMenu.addMenuListener(new IMenuListener((IAction)actSortActivityByDate, (IAction)actSortActivityByName, (IAction)actSortActivityAscending, (IAction)actSortActivityDescending){
            private final /* synthetic */ IAction val$actSortActivityByDate;
            private final /* synthetic */ IAction val$actSortActivityByName;
            private final /* synthetic */ IAction val$actSortActivityAscending;
            private final /* synthetic */ IAction val$actSortActivityDescending;
            {
                this.val$actSortActivityByDate = val$actSortActivityByDate;
                this.val$actSortActivityByName = val$actSortActivityByName;
                this.val$actSortActivityAscending = val$actSortActivityAscending;
                this.val$actSortActivityDescending = val$actSortActivityDescending;
            }

            public void menuAboutToShow(IMenuManager manager) {
                boolean sortByName = TransportView.this.isActivitySortedByName();
                boolean sortAscending = TransportView.this.isActivityAscendingSorted();
                this.val$actSortActivityByDate.setChecked(!sortByName);
                this.val$actSortActivityByName.setChecked(sortByName);
                this.val$actSortActivityAscending.setChecked(sortAscending);
                this.val$actSortActivityDescending.setChecked(!sortAscending);
            }
        });
        MenuManager sortElementMenu = new MenuManager("Sort Activity Elements");
        mainMenuManager.add((IContributionItem)sortElementMenu);
        Action actSortElementByPath = new Action("by Path"){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                TransportView.this.getPreferenceStore().setValue(TransportView.this.getViewID() + "_sortElementByName", !this.isChecked());
                TransportView.this.updateRepositoryTree(true);
            }
        };
        actSortElementByPath.setChecked(false);
        Action actSortElementByName = new Action("by Name"){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                TransportView.this.getPreferenceStore().setValue(TransportView.this.getViewID() + "_sortElementByName", this.isChecked());
                TransportView.this.updateRepositoryTree(true);
            }
        };
        actSortElementByName.setChecked(false);
        Action actSortElementAscending = new Action(MENU_LABEL_SORT_ASCENDING){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                TransportView.this.getPreferenceStore().setValue(TransportView.this.getViewID() + "_sortElementDescending", !this.isChecked());
                TransportView.this.updateRepositoryTree(false);
            }
        };
        actSortElementAscending.setChecked(false);
        Action actSortElementDescending = new Action(MENU_LABEL_SORT_DESCENDING){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                TransportView.this.getPreferenceStore().setValue(TransportView.this.getViewID() + "_sortElementDescending", this.isChecked());
                TransportView.this.updateRepositoryTree(false);
            }
        };
        actSortElementDescending.setChecked(false);
        sortElementMenu.add((IAction)actSortElementByPath);
        sortElementMenu.add((IAction)actSortElementByName);
        sortElementMenu.add((IContributionItem)new Separator());
        sortElementMenu.add((IAction)actSortElementAscending);
        sortElementMenu.add((IAction)actSortElementDescending);
        sortElementMenu.addMenuListener(new IMenuListener((IAction)actSortElementByPath, (IAction)actSortElementByName, (IAction)actSortElementAscending, (IAction)actSortElementDescending){
            private final /* synthetic */ IAction val$actSortElementByPath;
            private final /* synthetic */ IAction val$actSortElementByName;
            private final /* synthetic */ IAction val$actSortElementAscending;
            private final /* synthetic */ IAction val$actSortElementDescending;
            {
                this.val$actSortElementByPath = val$actSortElementByPath;
                this.val$actSortElementByName = val$actSortElementByName;
                this.val$actSortElementAscending = val$actSortElementAscending;
                this.val$actSortElementDescending = val$actSortElementDescending;
            }

            public void menuAboutToShow(IMenuManager manager) {
                boolean sortByName = TransportView.this.isElementSortedByName();
                boolean sortDescending = TransportView.this.isElementDescendingSorted();
                this.val$actSortElementByPath.setChecked(!sortByName);
                this.val$actSortElementByName.setChecked(sortByName);
                this.val$actSortElementAscending.setChecked(!sortDescending);
                this.val$actSortElementDescending.setChecked(sortDescending);
            }
        });
    }

    private void createCustomizeMenu(IMenuManager mainMenuManager) {
        IContributionItem[] items = mainMenuManager.getItems();
        if (items != null && items.length > 0) {
            mainMenuManager.add((IContributionItem)new Separator());
        }
        MenuManager customizeMenu = new MenuManager("Customize View");
        mainMenuManager.add((IContributionItem)customizeMenu);
        Action actionWorkspaceDecorator = new Action("Enable Pending Workspace Decorators"){

            public void run() {
                TransportView.this.getPreferenceStore().setValue(TransportView.this.getViewID() + TransportView.PRESTORE_KEYPART_PENDING_WORKSPACE_DECORATORS, this.isChecked());
                TransportView.this.updateRepositoryTree(true);
            }
        };
        boolean isEnabled = this.getPreferenceStore().getBoolean(this.getViewID() + PRESTORE_KEYPART_PENDING_WORKSPACE_DECORATORS);
        actionWorkspaceDecorator.setChecked(isEnabled);
        customizeMenu.add((IAction)actionWorkspaceDecorator);
    }

    private void createUserMenu(IMenuManager mainMenuManager) {
        MenuManager userMenu = new MenuManager("User Filter");
        mainMenuManager.add((IContributionItem)userMenu);
        Action actViewMy = new Action("Current User"){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                TransportView.this.getPreferenceStore().setValue(TransportView.this.getViewID() + "_viewForUser", "");
                TransportView.this.updateRepositoryTree(true);
                TransportView.this.updateViewHeaderForUserFilterChanged("");
            }
        };
        actViewMy.setChecked(false);
        String user = this.getUserFromPreferenceStrore();
        String actLabelViewAnother = !user.equals("") && !user.equals("*") ? user : MENU_LABEL_VIEW_FOR_ANOTHER_USER;
        Action actViewAnother = new Action(actLabelViewAnother){

            public void run() {
                InputDialog dialog = new InputDialog(TransportView.this.getSite().getShell(), "View for User...", "Enter a user name:", "< Name >", new IInputValidator(this){
                    private final /* synthetic */ 23 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public String isValid(String newText) {
                        if ("".equals(newText)) {
                            return "User name must not be empty.";
                        }
                        return null;
                    }
                });
                if (dialog.open() == 0 && !TransportView.this.getUserFromPreferenceStrore().equals(dialog.getValue())) {
                    TransportView.this.getPreferenceStore().setValue(TransportView.this.getViewID() + "_viewForUser", dialog.getValue());
                    TransportView.this.updateRepositoryTree(true);
                    TransportView.this.updateViewHeaderForUserFilterChanged(dialog.getValue());
                }
            }
        };
        actViewAnother.setChecked(false);
        Action actViewAll = new Action(VIEW_TITLE_PART_ALL_USERS){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                MessageDialog warnDialog = new MessageDialog(TransportView.this.getSite().getShell(), "Show for all Users", null, "This setting will result in a long delay while retrieving data.\n\nAre you sure you want to select this option?", 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
                if (warnDialog.open() == 0) {
                    TransportView.this.getPreferenceStore().setValue(TransportView.this.getViewID() + "_viewForUser", "*");
                    TransportView.this.updateRepositoryTree(true);
                    TransportView.this.updateViewHeaderForUserFilterChanged("*");
                }
            }
        };
        actViewAll.setChecked(false);
        userMenu.add((IAction)actViewMy);
        userMenu.add((IAction)actViewAnother);
        userMenu.add((IAction)actViewAll);
        userMenu.addMenuListener(new IMenuListener((IAction)actViewAnother, (IAction)actViewMy, (IAction)actViewAll){
            private final /* synthetic */ IAction val$actViewAnother;
            private final /* synthetic */ IAction val$actViewMy;
            private final /* synthetic */ IAction val$actViewAll;
            {
                this.val$actViewAnother = val$actViewAnother;
                this.val$actViewMy = val$actViewMy;
                this.val$actViewAll = val$actViewAll;
            }

            public void menuAboutToShow(IMenuManager manager) {
                String user = TransportView.this.getUserFromPreferenceStrore();
                if (!user.equals("") && !user.equals("*")) {
                    this.val$actViewAnother.setText(user);
                } else {
                    this.val$actViewAnother.setText(TransportView.MENU_LABEL_VIEW_FOR_ANOTHER_USER);
                }
                this.val$actViewMy.setChecked(user.equals(""));
                this.val$actViewAnother.setChecked(!user.equals("") && !user.equals("*"));
                this.val$actViewAll.setChecked(user.equals("*"));
            }
        });
    }

    private void addKeyListener() {
        this.getRepositoryTreeViewer().getTreeViewer().getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000E && e.stateMask == 0 && TransportView.this.m_refreshAction != null) {
                    TransportView.this.m_refreshAction.run();
                } else if (e.character == '\u007f' && e.stateMask == 0) {
                    ISelection selection = TransportView.this.getRepositoryTreeViewer().getTreeViewer().getSelection();
                    if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
                        return;
                    }
                    Object firstItem = ((IStructuredSelection)selection).getFirstElement();
                    if (firstItem instanceof IVfsFile || firstItem instanceof IVfsFolder || firstItem instanceof IVfsActivity) {
                        Class<?> objectType = firstItem.getClass();
                        Iterator iter = ((IStructuredSelection)selection).iterator();
                        while (iter.hasNext()) {
                            if (iter.next().getClass().equals(objectType)) continue;
                            return;
                        }
                        Action fakeAction = new Action(this){
                            private final /* synthetic */ 27 this$1;
                            {
                                this.this$1 = this$1;
                            }
                        };
                        if (firstItem instanceof IVfsFile) {
                            CheckoutAndDeleteAction deleteFileAction = new CheckoutAndDeleteAction();
                            deleteFileAction.setActivePart((IAction)fakeAction, (IWorkbenchPart)TransportView.this);
                            deleteFileAction.selectionChanged((IAction)fakeAction, selection);
                            if (fakeAction.isEnabled()) {
                                deleteFileAction.run((IAction)fakeAction);
                            }
                        } else if (firstItem instanceof IVfsFolder) {
                            IVfsFolderItem[] folderItems = null;
                            try {
                                folderItems = ((IVfsFolder)firstItem).getFolderItems();
                            }
                            catch (VfsException x) {
                                TransportView.this.showErrorMessage(x.getMessage());
                                LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
                            }
                            if (folderItems == null) {
                                return;
                            }
                            if (((IStructuredSelection)selection).size() > 1 || folderItems.length == 0) {
                                CheckoutAndDeleteAction deleteFolderAction = new CheckoutAndDeleteAction();
                                deleteFolderAction.setActivePart((IAction)fakeAction, (IWorkbenchPart)TransportView.this);
                                deleteFolderAction.selectionChanged((IAction)fakeAction, selection);
                                if (fakeAction.isEnabled()) {
                                    deleteFolderAction.run((IAction)fakeAction);
                                }
                            } else {
                                DeleteSubtreeAction deleteSubtreeAction = new DeleteSubtreeAction();
                                deleteSubtreeAction.setActivePart((IAction)fakeAction, (IWorkbenchPart)TransportView.this);
                                deleteSubtreeAction.selectionChanged((IAction)fakeAction, selection);
                                if (fakeAction.isEnabled()) {
                                    deleteSubtreeAction.run((IAction)fakeAction);
                                }
                            }
                        } else if (firstItem instanceof IVfsActivity) {
                            DeleteActivityAction deleteActivityAction = new DeleteActivityAction();
                            deleteActivityAction.setActivePart((IAction)fakeAction, (IWorkbenchPart)TransportView.this);
                            deleteActivityAction.selectionChanged((IAction)fakeAction, selection);
                            if (fakeAction.isEnabled()) {
                                deleteActivityAction.run((IAction)fakeAction);
                            }
                        }
                    }
                }
            }
        });
    }

    private void createFavoriteMenus(IMenuManager mainMenuManager) {
        Action addFavoriteAction = new Action(MENU_LABEL_ADD_FAVORITE){

            public ImageDescriptor getImageDescriptor() {
                return BluebirdPlugin.getDefault().createImageDescriptor(TransportView.IMAGE_NAME_FAVORITE);
            }

            public void run() {
                TransportView.this.clearStatusLine();
                AddFavoriteAction action = new AddFavoriteAction();
                action.setActivePart((IAction)this, (IWorkbenchPart)TransportView.this);
                action.selectionChanged((IAction)this, TransportView.this.getRepositoryTreeViewer().getTreeViewer().getSelection());
                action.run((IAction)this);
                super.run();
            }
        };
        mainMenuManager.add((IAction)addFavoriteAction);
        MenuManager gotoMenu = new MenuManager(MENU_LABEL_GOTO_FAVORITE);
        MenuManager deleteMenu = new MenuManager(MENU_LABEL_DELETE_FAVORITE);
        mainMenuManager.add((IContributionItem)gotoMenu);
        mainMenuManager.add((IContributionItem)deleteMenu);
        mainMenuManager.add((IContributionItem)new Separator());
        Action findAction = new Action(MENU_LABEL_FIND_BY_PATH){

            public ImageDescriptor getImageDescriptor() {
                return BluebirdPlugin.getDefault().createImageDescriptor(TransportView.IMAGE_NAME_SEARCH);
            }

            public void run() {
                TransportView.this.clearStatusLine();
                new SearchFolderItemInViewerDialog(TransportView.this.m_parent.getShell(), (StructuredViewer)TransportView.this.getRepositoryTreeViewer().getTreeViewer(), TransportView.this.getCurrentVfsManager().getCurrentContext()).open();
            }
        };
        mainMenuManager.add((IAction)findAction);
        mainMenuManager.addMenuListener(new IMenuListener((IAction)addFavoriteAction, (IMenuManager)gotoMenu, (IMenuManager)deleteMenu, (IAction)findAction){
            private final /* synthetic */ IAction val$addFavoriteAction;
            private final /* synthetic */ IMenuManager val$gotoMenu;
            private final /* synthetic */ IMenuManager val$deleteMenu;
            private final /* synthetic */ IAction val$findAction;
            {
                this.val$addFavoriteAction = val$addFavoriteAction;
                this.val$gotoMenu = val$gotoMenu;
                this.val$deleteMenu = val$deleteMenu;
                this.val$findAction = val$findAction;
            }

            public void menuAboutToShow(IMenuManager menuManager) {
                if (TransportView.this.getCurrentVfsManager() != null) {
                    boolean oneItemSelected = false;
                    ISelection selection = TransportView.this.getRepositoryTreeViewer().getTreeViewer().getSelection();
                    if (selection instanceof IStructuredSelection) {
                        oneItemSelected = ((IStructuredSelection)selection).size() == 1;
                    }
                    this.val$addFavoriteAction.setEnabled(oneItemSelected);
                    this.val$gotoMenu.removeAll();
                    this.val$deleteMenu.removeAll();
                    TreeMap favorites = RepositoryBrowseFavorite.getFavoritesForClientdef((String)TransportView.this.getActiveClientName());
                    if (favorites.size() > 0) {
                        TransportView.this.createGotoDeleteFavoritesMenus(this.val$gotoMenu, this.val$deleteMenu, favorites);
                    }
                    this.val$findAction.setEnabled(true);
                } else {
                    this.val$addFavoriteAction.setEnabled(false);
                    this.val$findAction.setEnabled(false);
                }
            }
        });
    }

    private void createToolbar() {
        String imagePath;
        String refreshTooltip;
        IToolBarManager toolbarManager = this.getViewSite().getActionBars().getToolBarManager();
        PluggableProvider[] providers = this.m_repositoryViewer.getPluggableProviders();
        int i = 0;
        while (i < providers.length) {
            final PluggableProvider provider = providers[i];
            Action nextAction = new Action(){
                private ImageDescriptor myImageDescriptor = null;
                private String myTooltip = null;

                public void setChecked(boolean value) {
                    super.setChecked(value);
                    provider.plugProvider(this.isChecked());
                    TransportView.this.m_repositoryViewer.refresh();
                }

                public ImageDescriptor getImageDescriptor() {
                    if (this.myImageDescriptor == null) {
                        this.myImageDescriptor = provider.getImageDescriptor();
                        if (this.myImageDescriptor == null) {
                            this.myImageDescriptor = super.getImageDescriptor();
                        }
                    }
                    return this.myImageDescriptor;
                }

                public String getToolTipText() {
                    if (this.myTooltip == null) {
                        this.myTooltip = provider.getToolTip();
                    }
                    return this.myTooltip;
                }
            };
            nextAction.setChecked(true);
            toolbarManager.add((IAction)nextAction);
            ++i;
        }
        IConfigurationElement config = BluebirdPlugin.getViewConfigurationRegistry().getViewConfiguration(this.m_viewId);
        String string = refreshTooltip = config != null ? config.getAttribute(REFRESH_ACTION_TOOLTIP_ATTRIBUTE) : "";
        if (refreshTooltip == null || "".equals(refreshTooltip)) {
            refreshTooltip = REFRESH_ACTION_TOOLTIP_DEFAULT;
        }
        String string2 = imagePath = config != null ? config.getAttribute(REFRESH_ACTION_ICON_ATTRIBUTE) : REFRESH_ACTION_ICON_DEFAULT;
        if (imagePath == null || "".equals(imagePath)) {
            imagePath = REFRESH_ACTION_ICON_DEFAULT;
        }
        final ImageDescriptor refreshImage = BluebirdPlugin.getDefault().createImageDescriptor(imagePath);
        final String processedTooltip = refreshTooltip + "   [F5]";
        this.m_refreshAction = new Action(){

            public void run() {
                TransportView.this.clearStatusLine();
                BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(this){
                    private final /* synthetic */ 33 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        Object isInput = TransportView.access$1900(33.access$2000(this.this$1)).getTreeViewer().getInput();
                        IClient activeClient = Configuration.getConfiguration().getActiveClient();
                        IVersionedFileSystemManager shouldInput = TransportView.access$2100(33.access$2000(this.this$1), activeClient);
                        if (shouldInput == null) {
                            TransportView.access$1900(33.access$2000(this.this$1)).getTreeViewer().setInput((Object)new OfflineModeTreeInput());
                            return;
                        }
                        TransportViewRepository.getInstance().refresh();
                        if (isInput != null && isInput.equals(shouldInput)) {
                            if (TransportView.access$2200(33.access$2000(this.this$1)).equals("com.tssap.dtr.client.eclipse.ui.treeBrowser.OpenActivityView")) {
                                try {
                                    IVfsRepository[] repositories = TransportView.access$1600(33.access$2000(this.this$1)).getRepositories();
                                    int i = 0;
                                    while (i < repositories.length) {
                                        repositories[i].refreshOpenActivitiesFromRepository();
                                        ++i;
                                    }
                                }
                                catch (VfsException x) {
                                    TransportView.access$100(33.access$2000(this.this$1), x.getMessage());
                                    LogUtil.logCaughtException((Location)TransportView.access$200(), (Throwable)x);
                                }
                            }
                            RefreshLogic.setRefresh((boolean)true);
                            TransportView.access$1900(33.access$2000(this.this$1)).refresh();
                            RefreshLogic.setRefresh((boolean)false);
                        } else {
                            TransportView.access$1900(33.access$2000(this.this$1)).setInput(shouldInput);
                        }
                    }
                });
            }

            public ImageDescriptor getImageDescriptor() {
                return refreshImage;
            }

            public String getToolTipText() {
                return processedTooltip;
            }

            static /* synthetic */ TransportView access$2000(33 x0) {
                return x0.TransportView.this;
            }
        };
        toolbarManager.add(this.m_refreshAction);
    }

    private void registerListeners() {
        Configuration.getConfiguration().addConfigurationListener((IConfigurationListener)this);
        VersionedFileSystemFactory.addVfsManagerListener((IVfsManagerListener)this);
        if (VfsManagerProvider.getInstance().isSapIDELoginAvailable()) {
            VfsManagerProvider.getInstance().addIDELoginListener((IIDELoginListener)this);
        }
    }

    public void setFocus() {
        this.getRepositoryTreeViewer().getTreeViewer().getTree().setFocus();
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        super.setInitializationData(cfig, propertyName, data);
        if ("ACTIVITY_CLOSED".equals(this.m_viewType) && "com.sap.ide.eclipse.cbs.activation.ui.views.InactiveActivityView".equals(this.m_viewId)) {
            this.getRepositoryTreeViewer().addInputChangelistener((IContentProvider)this);
        }
        this.m_viewType = cfig.getAttribute("type").trim().toUpperCase();
        this.m_viewId = cfig.getAttribute(VIEW_ID_KEY);
        if (this.m_viewId == null || this.m_viewId.equals("")) {
            throw new RuntimeException("No \"id\" attribute specified in view configuration.");
        }
        this.m_repositoryViewer = new RepositoryTreeViewer(this.m_viewId, this.getConfigurationElement());
    }

    public RepositoryTreeViewer getRepositoryTreeViewer() {
        return this.m_repositoryViewer;
    }

    private boolean isFavoriteMenuVisible() {
        if (this.m_favoritesMenuVisible == null) {
            IConfigurationElement viewConfiguration = this.getViewConfiguration();
            this.m_favoritesMenuVisible = viewConfiguration == null ? Boolean.FALSE : new Boolean(Boolean.TRUE.toString().equalsIgnoreCase(viewConfiguration.getAttribute("showFavoriteMenu")));
        }
        return this.m_favoritesMenuVisible;
    }

    private boolean isUserMenuVisible() {
        if (this.m_userMenuVisible == null) {
            IConfigurationElement viewConfiguration = this.getViewConfiguration();
            this.m_userMenuVisible = viewConfiguration == null ? Boolean.FALSE : new Boolean(Boolean.TRUE.toString().equalsIgnoreCase(viewConfiguration.getAttribute("showSwitchUserMenu")));
        }
        return this.m_userMenuVisible;
    }

    private boolean isDateRangeMenuVisible() {
        if (this.m_dateMenuVisible == null) {
            IConfigurationElement viewConfiguration = this.getViewConfiguration();
            this.m_dateMenuVisible = viewConfiguration == null ? Boolean.FALSE : new Boolean(Boolean.TRUE.toString().equalsIgnoreCase(viewConfiguration.getAttribute("showSetDateRangeMenu")));
        }
        return this.m_dateMenuVisible;
    }

    private boolean isFilterWorkspaceMenuVisible() {
        if (this.m_wsFilterMenuVisible == null) {
            IConfigurationElement viewConfiguration = this.getViewConfiguration();
            this.m_wsFilterMenuVisible = viewConfiguration == null ? Boolean.FALSE : new Boolean(Boolean.TRUE.toString().equalsIgnoreCase(viewConfiguration.getAttribute("showWorkspaceFilterMenu")));
        }
        return this.m_wsFilterMenuVisible;
    }

    private boolean isSortMenuVisible() {
        if (this.m_sortMenuVisible == null) {
            IConfigurationElement viewConfiguration = this.getViewConfiguration();
            this.m_sortMenuVisible = viewConfiguration == null ? Boolean.FALSE : new Boolean(Boolean.TRUE.toString().equalsIgnoreCase(viewConfiguration.getAttribute("showSortMenu")));
        }
        return this.m_sortMenuVisible;
    }

    private boolean isShowLegendMenuVisible() {
        if (this.m_legendMenuVisible == null) {
            IConfigurationElement viewConfiguration = this.getViewConfiguration();
            if (viewConfiguration == null) {
                this.m_legendMenuVisible = Boolean.FALSE;
            } else {
                this.m_legendMenuVisible = new Boolean(Boolean.TRUE.toString().equalsIgnoreCase(viewConfiguration.getAttribute("showLegendMenu")));
                if (this.m_legendMenuVisible.booleanValue() && this.getLegendManager() == null) {
                    this.m_legendMenuVisible = new Boolean(false);
                }
            }
        }
        return this.m_legendMenuVisible;
    }

    private RepositoryViewLegendManager getLegendManager() {
        if (this.m_legendManager == null) {
            try {
                Object legendManager;
                IConfigurationElement viewConfiguration = this.getViewConfiguration();
                if (viewConfiguration != null && (legendManager = viewConfiguration.createExecutableExtension("legendManager")) instanceof RepositoryViewLegendManager) {
                    this.m_legendManager = (RepositoryViewLegendManager)legendManager;
                }
            }
            catch (CoreException x) {
                LogUtil.logException((Location)LOCATION, (Throwable)x);
            }
        }
        return this.m_legendManager;
    }

    private IConfigurationElement getViewConfiguration() {
        return BluebirdPlugin.getViewConfigurationRegistry().getViewConfiguration(this.m_viewId);
    }

    private void createUserMenuForCollisionView(IMenuManager mainMenuManager) {
        MenuManager userMenu = new MenuManager("User Filter");
        mainMenuManager.add((IContributionItem)userMenu);
        Action actViewMy = new Action("Current User"){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                TransportView.this.getPreferenceStore().setValue(TransportView.this.getViewID() + "_viewForUser", "");
                TransportView.this.updateRepositoryTree(false);
                TransportView.this.updateViewHeaderForUserFilterChanged("");
            }
        };
        actViewMy.setChecked(false);
        Action actViewAll = new Action(VIEW_TITLE_PART_ALL_USERS){

            public void run() {
                if (!this.isChecked()) {
                    return;
                }
                TransportView.this.getPreferenceStore().setValue(TransportView.this.getViewID() + "_viewForUser", "*");
                TransportView.this.updateRepositoryTree(false);
                TransportView.this.updateViewHeaderForUserFilterChanged("*");
            }
        };
        actViewAll.setChecked(false);
        userMenu.add((IAction)actViewMy);
        userMenu.add((IAction)actViewAll);
        userMenu.addMenuListener(new IMenuListener((IAction)actViewMy, (IAction)actViewAll){
            private final /* synthetic */ IAction val$actViewMy;
            private final /* synthetic */ IAction val$actViewAll;
            {
                this.val$actViewMy = val$actViewMy;
                this.val$actViewAll = val$actViewAll;
            }

            public void menuAboutToShow(IMenuManager manager) {
                String user = TransportView.this.getUserFromPreferenceStrore();
                this.val$actViewMy.setChecked(user.equals(""));
                this.val$actViewAll.setChecked(user.equals("*"));
            }
        });
    }

    private void createGotoDeleteFavoritesMenus(IMenuManager gotoMenu, IMenuManager deleteMenu, Map favorites) {
        Iterator iterator = favorites.keySet().iterator();
        final String clientdefName = this.getActiveClientName();
        while (iterator.hasNext()) {
            String favorite = (String)iterator.next();
            String actionLabel = (String)favorites.get(favorite);
            final String path = favorite.substring(clientdefName.length() + 1);
            Action action = new Action(actionLabel){

                public void run() {
                    BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(this){
                        private final /* synthetic */ 38 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            TransportView.access$000(38.access$2400(this.this$1));
                            try {
                                if (TransportView.access$1600(38.access$2400(this.this$1)) != null && !RepositoryBrowseFavorite.gotoFavorite((TreeViewer)38.access$2400(this.this$1).getRepositoryTreeViewer().getTreeViewer(), (IVfsFolderItem)TransportView.access$1600(38.access$2400(this.this$1)).getFolderItemByBrowsePath(38.access$2500(this.this$1)))) {
                                    TransportView.access$100(38.access$2400(this.this$1), "Could not find \"" + 38.access$2500(this.this$1) + "\".");
                                    MessageDialog errorDialog = new MessageDialog(TransportView.access$1500(38.access$2400(this.this$1)).getShell(), "Resource not found", null, "The corresponding resource \"" + 38.access$2500(this.this$1) + "\" is not longer available." + "\n\n" + "Would you like to delete this favorite?", 1, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
                                    if (errorDialog.open() == 0) {
                                        RepositoryBrowseFavorite.deleteFavorite((String)38.access$2600(this.this$1), (String)38.access$2500(this.this$1));
                                    }
                                }
                            }
                            catch (VfsException x) {
                                TransportView.access$100(38.access$2400(this.this$1), x.getMessage());
                                LogUtil.logCaughtException((Location)TransportView.access$200(), (Throwable)x);
                            }
                        }
                    });
                }

                static /* synthetic */ TransportView access$2400(38 x0) {
                    return x0.TransportView.this;
                }

                static /* synthetic */ String access$2500(38 x0) {
                    return x0.path;
                }

                static /* synthetic */ String access$2600(38 x0) {
                    return x0.clientdefName;
                }
            };
            gotoMenu.add((IAction)action);
            action = new Action(actionLabel){

                public void run() {
                    TransportView.this.clearStatusLine();
                    RepositoryBrowseFavorite.deleteFavorite((String)clientdefName, (String)path);
                }
            };
            deleteMenu.add((IAction)action);
        }
    }

    private void createFilterWorkspaceMenu(IMenuManager mainMenuManager) {
        Action setWsFilterAction = new Action(MENU_LABEL_SET_WORKSPACE_FILTER){
            static /* synthetic */ Class class$com$tssap$dtr$client$lib$vfs$IVfsWorkspace;

            public ImageDescriptor getImageDescriptor() {
                return BluebirdPlugin.getDefault().createImageDescriptor(TransportView.IMAGE_NAME_WSFILTER);
            }

            public void run() {
                if (TransportView.this.getCurrentVfsManager() != null) {
                    MultipleSelectionMessageDialog dialog;
                    IVfsWorkspace[] allWorkspaces = TransportView.this.getCurrentVfsManager().getWorkspaces();
                    IVfsWorkspace[] lastWorkspaceFilter = new IVfsWorkspace[]{};
                    List ws = Util.restoreWorkspaceFilter((IVersionedFileSystemManager)TransportView.this.getCurrentVfsManager(), (String)(TransportView.this.getViewID() + "_selectedWorkspaces-" + TransportView.this.getActiveClientName()));
                    if (ws != null) {
                        lastWorkspaceFilter = ws.toArray(new IVfsWorkspace[ws.size()]);
                    }
                    if ((dialog = new MultipleSelectionMessageDialog(TransportView.this.getSite().getShell(), TransportView.DIALOG_TITLE_WORKSPACE_FILTER, TransportView.DIALOG_MESSAGE_WORKSPACE_FILTER, 2, (IVfsFolderItem[])allWorkspaces, (IVfsFolderItem[])(lastWorkspaceFilter.length > 0 ? lastWorkspaceFilter : allWorkspaces))).open() == 0) {
                        IStructuredSelection selection = dialog.getReturnedSelection();
                        IVfsWorkspace[] newWorkspaceFilter = (IVfsWorkspace[])Util.getArrayFromIterator((Iterator)selection.iterator(), (Class)(class$com$tssap$dtr$client$lib$vfs$IVfsWorkspace == null ? (class$com$tssap$dtr$client$lib$vfs$IVfsWorkspace = 41.class$("com.tssap.dtr.client.lib.vfs.IVfsWorkspace")) : class$com$tssap$dtr$client$lib$vfs$IVfsWorkspace));
                        if (newWorkspaceFilter.length != allWorkspaces.length) {
                            TransportView.this.storeWorkspaceFilter(newWorkspaceFilter);
                            TransportView.this.updateRepositoryTree(false);
                        } else if (lastWorkspaceFilter.length > 0) {
                            TransportView.this.getPreferenceStore().setValue(TransportView.this.getViewID() + "_selectedWorkspaces-" + TransportView.this.getActiveClientName(), "");
                            TransportView.this.updateRepositoryTree(false);
                        }
                    }
                }
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        };
        mainMenuManager.add((IAction)setWsFilterAction);
        mainMenuManager.addMenuListener(new IMenuListener((IAction)setWsFilterAction){
            private final /* synthetic */ IAction val$setWsFilterAction;
            {
                this.val$setWsFilterAction = val$setWsFilterAction;
            }

            public void menuAboutToShow(IMenuManager manager) {
                this.val$setWsFilterAction.setEnabled(TransportView.this.getCurrentVfsManager() != null);
            }
        });
    }

    private void storeWorkspaceFilter(IVfsWorkspace[] workspaces) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < workspaces.length) {
            try {
                String pattern = workspaces[i].getUrl();
                buf.append(pattern);
                buf.append("\n");
            }
            catch (VfsException x) {
                this.showErrorMessage(x.getMessage());
                LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
            }
            ++i;
        }
        this.getPreferenceStore().setValue(this.getViewID() + "_selectedWorkspaces-" + this.getActiveClientName(), buf.toString());
    }

    private void createShowLegendMenu(IMenuManager mainMenuManager) {
        IContributionItem[] items = mainMenuManager.getItems();
        if (items != null && items.length > 0) {
            mainMenuManager.add((IContributionItem)new Separator());
        }
        Action actShowLegend = new Action(MENU_LABEL_SHOW_LEGEND){

            public ImageDescriptor getImageDescriptor() {
                return BluebirdPlugin.getDefault().createImageDescriptor(TransportView.IMAGE_NAME_LEGEND);
            }

            public void run() {
                new LegendDialog(TransportView.this.getSite().getShell(), (IRepositoryViewLegendManager)TransportView.this.getLegendManager(), this.getImageDescriptor().createImage(true)).open();
            }
        };
        mainMenuManager.add((IAction)actShowLegend);
    }

    private String getUserFromPreferenceStrore() {
        return this.getPreferenceStore().getString(this.getViewID() + "_viewForUser");
    }

    protected String getDateRangeFromPreferenceStrore() {
        return this.getPreferenceStore().getString(this.getViewID() + "_dateRange");
    }

    protected String getToDateFromPreferenceStrore() {
        return this.getPreferenceStore().getString(this.getViewID() + "_toDate");
    }

    private boolean isActivitySortedByName() {
        return this.getPreferenceStore().getBoolean(this.getViewID() + "_sortActivityByName");
    }

    private boolean isActivityAscendingSorted() {
        return this.getPreferenceStore().getBoolean(this.getViewID() + "_sortActivityAscending");
    }

    private boolean isElementSortedByName() {
        return this.getPreferenceStore().getBoolean(this.getViewID() + "_sortElementByName");
    }

    private boolean isElementDescendingSorted() {
        return this.getPreferenceStore().getBoolean(this.getViewID() + "_sortElementDescending");
    }

    private void updateRepositoryTree(final boolean updateLabel) {
        this.clearStatusLine();
        BusyIndicator.showWhile((Display)this.getSite().getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                TransportView.this.getRepositoryTreeViewer().getTreeViewer().refresh(updateLabel);
            }
        });
    }

    private void clearStatusLine() {
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(null);
        this.getViewSite().getActionBars().getStatusLineManager().setErrorMessage(null);
    }

    private String getActiveClientName() {
        IClient activeClient = Configuration.getConfiguration().getActiveClient();
        if (activeClient != null) {
            return activeClient.getName();
        }
        return null;
    }

    private IVersionedFileSystemManager getCurrentVfsManager() {
        Object currentInput = this.getRepositoryTreeViewer().getTreeViewer().getInput();
        if (!(currentInput instanceof IVersionedFileSystemManager)) {
            return null;
        }
        return (IVersionedFileSystemManager)currentInput;
    }

    private IVersionedFileSystemManager getVfsManager(IClient client) {
        if (client == null) {
            return null;
        }
        try {
            return VfsManagerProvider.getInstance().getVersionedFileSystemManager(client.getContext());
        }
        catch (VfsException x) {
            this.showErrorMessage(x.getMessage());
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
            return null;
        }
    }

    public void onActiveClientChanged(final IClient newClient, IClient oldClient) {
        if (newClient == null) {
            this.getRepositoryTreeViewer().getTreeViewer().setInput((Object)new OfflineModeTreeInput());
            this.updateViewTitle();
            return;
        }
        if (!newClient.equals(oldClient)) {
            this.clearStatusLine();
            BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                public void run() {
                    if (TransportView.this.getVfsManager(newClient) != null) {
                        TransportView.this.getRepositoryTreeViewer().setInput(TransportView.this.getVfsManager(newClient));
                    } else {
                        TransportView.this.getRepositoryTreeViewer().getTreeViewer().setInput((Object)new OfflineModeTreeInput());
                    }
                    TransportView.this.updateViewTitle();
                }
            });
        }
    }

    public void onConfigurationChanged(IConfiguration configuration) {
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                if (TransportView.this.getCurrentVfsManager() != null) {
                    VersionedFileSystemFactory.releaseVersionedFileSystemManager((IVersionedFileSystemManager)TransportView.this.getCurrentVfsManager());
                } else {
                    IClient client = Configuration.getConfiguration().getActiveClient();
                    if (client != null) {
                        try {
                            IVersionedFileSystemManager newManager = VersionedFileSystemFactory.getVersionedFileSystemManager((IVfsContext)client.getContext());
                            TransportView.this.m_repositoryViewer.setInput(newManager);
                        }
                        catch (VfsException e) {
                            TransportView.this.showErrorMessage(e.getMessage());
                            LogUtil.logCaughtException((Location)LOCATION, (Throwable)e);
                        }
                    }
                    LOCATION.pathT("RepositoryView reacted to configuration-changed event.");
                }
            }
        });
    }

    public void released(final IVersionedFileSystemManager vfsManager) {
        ActivationRuntimeDataStorage.getStorage().released(vfsManager);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(this){
                    private final /* synthetic */ 47 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        block4: {
                            if (47.access$3000(this.this$1) == null || !47.access$3000(this.this$1).equals(47.access$3100(this.this$1).getRepositoryTreeViewer().getTreeViewer().getInput())) {
                                return;
                            }
                            TransportView.access$200().pathT("RepositoryView reacted to VFS-manager-released event.");
                            IClient client = Configuration.getConfiguration().getActiveClient();
                            if (client != null) {
                                try {
                                    IVersionedFileSystemManager newManager = VersionedFileSystemFactory.getVersionedFileSystemManager((IVfsContext)client.getContext());
                                    TransportView.access$1900(47.access$3100(this.this$1)).setInput(newManager);
                                    return;
                                }
                                catch (VfsException x) {
                                    TransportView.access$100(47.access$3100(this.this$1), x.getMessage());
                                    LogUtil.logCaughtException((Location)TransportView.access$200(), (Throwable)x);
                                    if (!x.getCategory().equals(VfsExceptionCategory.PARALLEL_THREAD_ACCESS_DURING_INITIALIZATION_OF_VFS_MANAGER)) break block4;
                                    TransportView.access$3202(47.access$3100(this.this$1), client.getName());
                                }
                            }
                        }
                        TransportView.access$1900(47.access$3100(this.this$1)).getTreeViewer().setInput((Object)new OfflineModeTreeInput());
                    }
                });
            }

            static /* synthetic */ IVersionedFileSystemManager access$3000(47 x0) {
                return x0.vfsManager;
            }

            static /* synthetic */ TransportView access$3100(47 x0) {
                return x0.TransportView.this;
            }
        });
    }

    public void created(final IVersionedFileSystemManager vfsManager) {
        if (this.m_clientName_gettingVfsManagerFailedBecauseOfThreadingProblem != null && this.m_clientName_gettingVfsManagerFailedBecauseOfThreadingProblem.equals(vfsManager.getClientName())) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(this){
                        private final /* synthetic */ 49 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            TransportView.access$1900(49.access$3400(this.this$1)).setInput(49.access$3300(this.this$1));
                        }
                    });
                }

                static /* synthetic */ IVersionedFileSystemManager access$3300(49 x0) {
                    return x0.vfsManager;
                }

                static /* synthetic */ TransportView access$3400(49 x0) {
                    return x0.TransportView.this;
                }
            });
            this.m_clientName_gettingVfsManagerFailedBecauseOfThreadingProblem = null;
        }
    }

    private Composite createNewPanel(Composite parent) {
        Composite out = new Composite(parent, 0);
        out.setLayout((Layout)new FillLayout());
        return out;
    }

    public String getViewID() {
        return this.m_viewId;
    }

    private void showErrorMessage(String message) {
        this.clearStatusLine();
        this.getViewSite().getActionBars().getStatusLineManager().setErrorMessage(Dialog.getImage((String)"dialog_message_error_image"), message);
    }

    private void updateViewTitle() {
        String userName = "";
        String currentUserFilter = this.getUserFromPreferenceStrore();
        if (currentUserFilter.equals("*")) {
            userName = VIEW_TITLE_PART_ALL_USERS;
        } else if (!currentUserFilter.equals("")) {
            userName = currentUserFilter;
        }
        String title = this.getTitle();
        if (title.indexOf(VIEW_TITLE_SEPARATOR_USER_BEGIN) != -1) {
            title = title.substring(0, title.indexOf(VIEW_TITLE_SEPARATOR_USER_BEGIN));
        } else if (title.indexOf(VIEW_TITLE_SEPARATOR_CLIENT) != -1) {
            title = title.substring(0, title.indexOf(VIEW_TITLE_SEPARATOR_CLIENT));
        }
        if (!userName.equals("")) {
            title = title + VIEW_TITLE_SEPARATOR_USER_BEGIN + userName + VIEW_TITLE_SEPARATOR_USER_END;
        }
        if (this.getActiveClientName() != null) {
            title = title + VIEW_TITLE_SEPARATOR_CLIENT + this.getActiveClientName();
        }
        this.setTitle(title);
    }

    private void updateViewTitleImage() {
        ConcreteCompositeImageDescriptor decoratedImageDescriptor;
        String dateRange;
        if (this.getDefaultViewTitleImage() == null) {
            return;
        }
        Image titleImage = this.getDefaultViewTitleImage();
        boolean changed = false;
        if (this.isDateRangeMenuVisible() && !(dateRange = this.getDateRangeFromPreferenceStrore()).equals("*")) {
            decoratedImageDescriptor = new ConcreteCompositeImageDescriptor(titleImage, 5, DECORATOR_DATE_RANGE.getImageDescriptor(), 10);
            titleImage = decoratedImageDescriptor.createImage();
            changed = true;
        }
        if (this.isUserMenuVisible()) {
            String user = this.getUserFromPreferenceStrore();
            if (user.equals("*")) {
                decoratedImageDescriptor = new ConcreteCompositeImageDescriptor(titleImage, changed ? 0 : 5, DECORATOR_ALL_USERS.getImageDescriptor(), 0);
                titleImage = decoratedImageDescriptor.createImage();
            } else if (!user.equals("")) {
                decoratedImageDescriptor = new ConcreteCompositeImageDescriptor(titleImage, changed ? 0 : 5, DECORATOR_OTHER_USER.getImageDescriptor(), 0);
                titleImage = decoratedImageDescriptor.createImage();
            }
        }
        this.setTitleImage(titleImage);
    }

    private void updateViewHeaderForUserFilterChanged(String newUser) {
        if (newUser == null) {
            return;
        }
        this.updateViewTitle();
        this.updateViewTitleImage();
    }

    public void onUserLoggedIn(String[] userAndPassword, KeyStore[] serverAndClientCerts) {
        this.clearStatusLine();
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                IClient activeClient = Configuration.getConfiguration().getActiveClient();
                IVersionedFileSystemManager shouldInput = TransportView.this.getVfsManager(activeClient);
                if (shouldInput == null) {
                    TransportView.this.m_repositoryViewer.getTreeViewer().setInput((Object)new OfflineModeTreeInput());
                } else {
                    TransportView.this.m_repositoryViewer.setInput(shouldInput);
                }
            }
        });
        this.updateViewTitle();
    }

    public void onUserLoggedOut() {
        this.getRepositoryTreeViewer().getTreeViewer().setInput((Object)new OfflineModeTreeInput());
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "[" + this.m_viewId + VIEW_TITLE_SEPARATOR_USER_END;
    }

    private IPreferenceStore getPreferenceStore() {
        return BluebirdPlugin.getDefault().getPreferenceStore();
    }

    private Image getDefaultViewTitleImage() {
        return this.m_defaultViewTitleImage;
    }

    private void setDefaultViewTitleImage(Image image) {
        this.m_defaultViewTitleImage = image;
    }

    public boolean show(ShowInContext context) {
        return false;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (oldInput instanceof IVersionedFileSystemManager) {
            ((IVersionedFileSystemManager)oldInput).removeActivityListener((IVfsActivityListener)this);
        }
        if (newInput instanceof IVersionedFileSystemManager) {
            ((IVersionedFileSystemManager)newInput).addActivityListener((IVfsActivityListener)this);
        }
    }

    public void stateChanged(IVfsActivity activity, VfsActivityState oldState) {
        try {
            if (activity.getState() != VfsActivityState.CLOSED) {
                return;
            }
            if (this.getRepositoryTreeViewer().getTreeViewer().getInput() == activity.getVersionedFileSystemManager()) {
                this.getRepositoryTreeViewer().getTreeViewer().refresh();
            }
        }
        catch (VfsException x) {
            this.getViewSite().getActionBars().getStatusLineManager().setErrorMessage(x.getMessage());
            LogUtil.logCaughtException((Location)LOCATION, (Throwable)x);
        }
    }

    public void beforeCheckin(IVfsActivity activity) {
    }

    public void created(IVfsActivity activity) {
    }

    public void deleted(IVfsActivity activity, VfsActivityState oldState) {
    }

    public void itemsAddedOrRemoved(IVfsActivity activity) {
    }

    public void nameOrDescriptionChanged(IVfsActivity activity) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ String access$2200(TransportView x0) {
        return x0.m_viewId;
    }

    static /* synthetic */ String access$3202(TransportView x0, String x1) {
        x0.m_clientName_gettingVfsManagerFailedBecauseOfThreadingProblem = x1;
        return x0.m_clientName_gettingVfsManagerFailedBecauseOfThreadingProblem;
    }

    class WebUIAction
    extends Action
    implements LoginListener {
        public WebUIAction() {
            super("Go to CMS WebUI");
            UserValidator.Data data = UserValidator.getDefaultServerData();
            if (data == null) {
                this.setEnabled(false);
            } else {
                this.setEnabled(data.isOnline());
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            log.entering("$WebUIAction.run");
            try {
                try {
                    IDevelopmentConfiguration devConf = ActivationRuntimeDataStorage.getStorage().getActiveDevelopmentConfiguration();
                    DevelopmentConfiguration data = devConf.getConfigurationData();
                    String cmsServer = data.getCMS();
                    String url = cmsServer + "/webdynpro/dispatcher/sap.com/tc~SL~CMS~WebUI/Cms";
                    if (cmsServer != null && !cmsServer.equals("")) {
                        Platform.getPlatform().openWithDefaultApplication(url);
                    }
                    log.error("CMS server URL is null");
                    MessageDialog.openError((Shell)new Shell(), (String)"Go to CMS WebUI", (String)"Unable to determine CMS URL");
                }
                catch (Exception ex) {
                    log.error("Error during execution of WebUIAction", (Throwable)ex);
                    MessageDialog.openError((Shell)new Shell(), (String)"Go to CMS WebUI", (String)("Error:" + ex.getMessage()));
                    Object var6_7 = null;
                    log.exiting("$WebUIAction.run");
                    return;
                }
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                log.exiting("$WebUIAction.run");
                throw throwable;
            }
            log.exiting("$WebUIAction.run");
        }

        public void loginPerformed(UserValidator.Data data) {
            log.entering("$WebUIAction.loginPerformed");
            this.setEnabled(data.isOnline());
            log.exiting("$WebUIAction.loginPerformed");
        }
    }
}

