/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.organizerUI.ui;

import com.sap.cms.organizerUI.CMSOrganizerPlugin;
import com.sap.cms.organizerUI.exception.CalculatePredecessorException;
import com.sap.cms.organizerUI.exception.ReleaseActivityException;
import com.sap.cms.organizerUI.exception.ReleaseActivityTimeoutException;
import com.sap.cms.organizerUI.internal.ActivityReleaser;
import com.sap.cms.organizerUI.internal.PropagationPredecessorProvider;
import com.sap.cms.util.exception.CMSUnexpectedException;
import com.sap.cms.util.logging.CmsLogger;
import com.sap.ide.eclipse.cbs.activation.ActivationPlugin;
import com.sap.ide.eclipse.cbs.activation.ui.ExplanationDialog;
import com.sap.ide.eclipse.cbs.activation.ui.util.MessageViewerInput;
import com.tssap.dtr.client.eclipse.ui.AscendingElementLabelSorter;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.labelProviders.VfsActivityLabelProvider;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.labelProviders.VfsVersionLabelProvider;
import com.tssap.dtr.client.eclipse.util.Util;
import com.tssap.dtr.client.eclipse.vfs.ClosedActivityWrapper;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ReleasePredecessorDialog
extends Dialog {
    private static final CmsLogger log = CmsLogger.getLogger((String)(class$com$sap$cms$organizerUI$ui$ReleasePredecessorDialog == null ? (class$com$sap$cms$organizerUI$ui$ReleasePredecessorDialog = ReleasePredecessorDialog.class$("com.sap.cms.organizerUI.ui.ReleasePredecessorDialog")) : class$com$sap$cms$organizerUI$ui$ReleasePredecessorDialog).getName());
    private static final String BUTTON_LABEL_RELEASE = "Release";
    private static final String BUTTON_LABEL_RELEASE_ALL = "Release with all predecessors";
    private static final int PROGRESS_START = 25;
    private static final int TOTAL_PROGRESS = 100;
    private static final int PROGRESS_FINISH = 10;
    private static final String MESSAGE_DIALOG_TITLE_RELEASE = "Release for transport";
    private List activityList = null;
    private ClosedActivityWrapper[] activities = null;
    private ClosedActivityWrapper[] predecessorActivities = null;
    private PropagationPredecessorProvider ppp = null;
    private MessageViewerInput treeNodeSelected = null;
    private MessageViewerInput treeNodePredecessors = null;
    private KeyListener keyListener = null;
    private boolean hasForeignActivity = false;
    private String user = null;
    private IVfsWorkspace workspace = null;
    private boolean predecessorCalculationFailed = false;
    private final ActivityReleaser activityReleaser = new ActivityReleaser();
    private Label labelMessageImage;
    private Label labelMessageText;
    private TreeViewer treeViewerPredecessor;
    private Text textActivityDescription;
    private Text textActivityLastModified;
    private Text textChangeRequestCaption;
    private TableViewer TableViewerActivityProperties;
    private ProgressMonitorPart progressBar;
    private String predecessorErrorMessage = null;
    private boolean isEmptyCaptionErrorDisplayed = false;
    private String captionHead = "";
    static /* synthetic */ Class class$com$sap$cms$organizerUI$ui$ReleasePredecessorDialog;

    public ReleasePredecessorDialog(Shell parent, List activityList) {
        super(parent);
        log.entering("Constructor");
        if (activityList == null || activityList.size() < 1) {
            throw new CMSUnexpectedException("Could not initialize ReleasePredecessorDialog because argument is null.");
        }
        this.activityList = activityList;
        this.activities = activityList.toArray(new ClosedActivityWrapper[activityList.size()]);
        this.workspace = this.activities[0].workspace;
        this.user = CMSOrganizerPlugin.getDefault().getUser();
        if (this.user == null) {
            log.error("User is null!");
        }
        log.debug("Check activities on foreign authors (user = " + this.user + ") ...");
        try {
            StringBuffer buf = new StringBuffer("");
            int i = 0;
            while (i < this.activities.length) {
                log.debug("activity[" + i + "]: author:" + this.activities[i].activity.getAuthor());
                buf.append(this.activities[i].activity.getDisplayName() + ", ");
                if (this.user != null && !this.user.equalsIgnoreCase(this.activities[i].activity.getAuthor())) {
                    this.hasForeignActivity = true;
                    log.debug("Foreign activity found: " + this.activities[i].activity.getDisplayName());
                }
                ++i;
            }
            this.captionHead = buf.toString();
        }
        catch (VfsException ex) {
            log.error((Throwable)ex);
        }
        log.debug("Result: hasForeignActivity = " + this.hasForeignActivity);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.ppp = new PropagationPredecessorProvider(this.workspace);
        this.treeNodeSelected = new MessageViewerInput(activityList.size() > 1 ? "Selected activities" : "Selected activity", ActivationPlugin.getDefault().getAtomicImage("selection.gif"));
        log.exiting("Constructor");
    }

    public int open() {
        log.entering("open");
        if (this.getShell() == null) {
            this.create();
        }
        this.constrainShellSize();
        this.getShell().open();
        this.performPredecessorCheck();
        this.textChangeRequestCaption.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!ReleasePredecessorDialog.this.predecessorCalculationFailed) {
                    if (ReleasePredecessorDialog.this.textChangeRequestCaption.getText() == null || ReleasePredecessorDialog.this.textChangeRequestCaption.getText().trim().length() == 0) {
                        ReleasePredecessorDialog.this.setErrorMessage("Please enter a change request caption");
                        ReleasePredecessorDialog.this.isEmptyCaptionErrorDisplayed = true;
                        ReleasePredecessorDialog.super.getButton(0).setEnabled(false);
                    } else {
                        if (ReleasePredecessorDialog.this.isEmptyCaptionErrorDisplayed) {
                            ReleasePredecessorDialog.this.clearMessageArea();
                        }
                        ReleasePredecessorDialog.super.getButton(0).setEnabled(true);
                    }
                }
            }
        });
        this.getButton(1).setFocus();
        this.setBlockOnOpen(true);
        int open = super.open();
        log.exiting("open");
        return open;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Release for Transport");
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(768));
        Composite monitorComposite = new Composite(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 7;
        monitorComposite.setLayout((Layout)gridLayout);
        monitorComposite.setLayoutData((Object)new GridData(776));
        Composite buttonBar = (Composite)super.createButtonBar(composite);
        buttonBar.setLayoutData((Object)new GridData(136));
        Layout layout = buttonBar.getLayout();
        if (layout instanceof GridLayout) {
            ((GridLayout)layout).makeColumnsEqualWidth = false;
        }
        this.progressBar = new ProgressMonitorPart(monitorComposite, (Layout)new GridLayout());
        this.progressBar.setLayoutData((Object)new GridData(768));
        return buttonBar;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, BUTTON_LABEL_RELEASE_ALL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.createButton(parent, 17, IDialogConstants.HELP_LABEL, false);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.getButton(0).setText(BUTTON_LABEL_RELEASE);
        this.addDialogKeyListener((Composite)this.getShell());
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite baseArea = (Composite)super.createDialogArea(parent);
        int defaultMessageWidth = this.getMinimumMessageWidth();
        Composite messageArea = new Composite(baseArea, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        messageArea.setLayout((Layout)gridLayout);
        messageArea.setLayoutData((Object)new GridData(768));
        this.labelMessageImage = new Label(messageArea, 0);
        this.labelMessageImage.setImage(Dialog.getImage((String)"dialog_messasge_info_image"));
        this.labelMessageImage.setLayoutData((Object)new GridData(2));
        this.labelMessageText = new Label(messageArea, 64);
        GridData gridData = new GridData(768);
        gridData.widthHint = defaultMessageWidth * 4 / 3;
        this.labelMessageText.setLayoutData((Object)gridData);
        this.labelMessageText.setText("");
        Composite captionArea = new Composite(baseArea, 0);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 10;
        captionArea.setLayout((Layout)gridLayout);
        captionArea.setLayoutData((Object)new GridData(768));
        Label labelChangeRequestCaption = new Label(captionArea, 0);
        labelChangeRequestCaption.setText("Change request caption:");
        labelChangeRequestCaption.setLayoutData((Object)new GridData(1));
        labelChangeRequestCaption.setToolTipText("Descriptive text of the change request");
        this.textChangeRequestCaption = new Text(captionArea, 133124);
        this.textChangeRequestCaption.setLayoutData((Object)new GridData(768));
        this.textChangeRequestCaption.setToolTipText("Descriptive text of the change request");
        Composite selectionArea = new Composite(baseArea, 0);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 2;
        selectionArea.setLayout((Layout)gridLayout);
        selectionArea.setLayoutData((Object)new GridData(1809));
        Label lbPredecessor = new Label(selectionArea, 0);
        lbPredecessor.setText("Predecessors check:");
        lbPredecessor.setLayoutData((Object)new GridData());
        this.treeViewerPredecessor = new TreeViewer(selectionArea, 2816);
        PredecessorTreeContentProvider contentProvider = new PredecessorTreeContentProvider();
        this.treeViewerPredecessor.setContentProvider((IContentProvider)contentProvider);
        this.treeViewerPredecessor.setLabelProvider((IBaseLabelProvider)new PredecessorTreeLabelProvider());
        this.treeViewerPredecessor.setSorter((ViewerSorter)new PredecessorTreeSorter());
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.heightHint = defaultMessageWidth / 3;
        this.treeViewerPredecessor.getTree().setLayoutData((Object)gridData);
        Group infoGroup = new Group(baseArea, 0);
        infoGroup.setText("Activity Details");
        infoGroup.setLayout((Layout)new GridLayout(2, false));
        infoGroup.setLayoutData((Object)new GridData(1809));
        Label label = new Label((Composite)infoGroup, 0);
        label.setText("Description:");
        label.setLayoutData((Object)new GridData(2));
        this.textActivityDescription = new Text((Composite)infoGroup, 2632);
        gridData = new GridData(1792);
        gridData.heightHint = defaultMessageWidth / 6;
        this.textActivityDescription.setLayoutData((Object)gridData);
        label = new Label((Composite)infoGroup, 0);
        label.setText("Elements:");
        label.setLayoutData((Object)new GridData(2));
        this.TableViewerActivityProperties = new TableViewer((Composite)infoGroup, 2818);
        this.TableViewerActivityProperties.setContentProvider((IContentProvider)new ActivityElementsContentProvider());
        this.TableViewerActivityProperties.setLabelProvider((IBaseLabelProvider)new VfsVersionLabelProvider());
        this.TableViewerActivityProperties.setSorter((ViewerSorter)new AscendingElementLabelSorter());
        gridData = new GridData(1808);
        gridData.heightHint = defaultMessageWidth / 4;
        this.TableViewerActivityProperties.getTable().setLayoutData((Object)gridData);
        this.TableViewerActivityProperties.getTable().setBackground(this.getShell().getDisplay().getSystemColor(22));
        label = new Label((Composite)infoGroup, 0);
        label.setText("Last modified:");
        label.setLayoutData((Object)new GridData());
        this.textActivityLastModified = new Text((Composite)infoGroup, 2060);
        this.textActivityLastModified.setLayoutData((Object)new GridData(768));
        gridData = new GridData(768);
        new Label(baseArea, 0).setLayoutData((Object)gridData);
        this.treeViewerPredecessor.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!(event.getSelection() instanceof IStructuredSelection)) {
                    return;
                }
                BusyIndicator.showWhile((Display)ReleasePredecessorDialog.this.getShell().getDisplay(), (Runnable)new Runnable(this, event){
                    private final /* synthetic */ SelectionChangedEvent val$event;
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$event = val$event;
                    }

                    public void run() {
                        Object selected = ((IStructuredSelection)this.val$event.getSelection()).getFirstElement();
                        if (selected != null) {
                            ReleasePredecessorDialog.access$1200(2.access$1100(this.this$1), selected);
                        }
                    }
                });
            }

            static /* synthetic */ ReleasePredecessorDialog access$1100(2 x0) {
                return x0.ReleasePredecessorDialog.this;
            }
        });
        this.treeViewerPredecessor.setInput((Object)this.activities);
        this.treeViewerPredecessor.expandToLevel(2);
        return baseArea;
    }

    protected void buttonPressed(int buttonId) {
        log.entering("buttonPressed");
        this.setReturnCode(buttonId);
        switch (buttonId) {
            case 0: {
                this.performRelease();
                break;
            }
            case 1: {
                ProgressMonitorPart progressMonitorPart = this.progressBar;
                synchronized (progressMonitorPart) {
                    if (this.progressBar.getVisible()) {
                        this.progressBar.setCanceled(true);
                    }
                }
                this.close();
                break;
            }
            case 17: {
                this.explainPredecessorOption();
                break;
            }
            default: {
                log.warning("ButtonID " + buttonId + " not evaluated!");
            }
        }
        log.exiting("buttonPressed");
    }

    private int getMinimumMessageWidth() {
        return this.convertHorizontalDLUsToPixels(300);
    }

    private KeyListener getDialogKeyListener() {
        if (this.keyListener == null) {
            this.keyListener = new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 0x100000A && e.stateMask == 0) {
                        ReleasePredecessorDialog.this.explainPredecessorOption();
                    }
                    if (e.keyCode == 27 && e.stateMask == 0) {
                        ReleasePredecessorDialog.this.buttonPressed(1);
                    }
                }
            };
        }
        return this.keyListener;
    }

    private void addDialogKeyListener(Composite parent) {
        parent.addKeyListener(this.getDialogKeyListener());
        Control[] childrens = parent.getChildren();
        int i = 0;
        while (i < childrens.length) {
            if (childrens[i] instanceof Composite) {
                this.addDialogKeyListener((Composite)childrens[i]);
            } else {
                childrens[i].addKeyListener(this.getDialogKeyListener());
            }
            ++i;
        }
    }

    private void explainPredecessorOption() {
        String text = "Predecessor activities are activities that have been activated before the selected activities but that are not released yet.\n\nNote: Predecessors may also be from other users.\n\nIf the \"Release\" or \"Release with all predecessors\" button is pressed, all displayed activities will be released in one change request. After activation, either all displayed activities are released or (if the release fails) none of them.";
        new ExplanationDialog(this.getShell(), "Help on predecessor activities", text).open();
    }

    private void switchActivateButtons(boolean enableActivateWithAll) {
        log.entering("switchActivateButtons");
        this.getButton(0).setText(enableActivateWithAll ? BUTTON_LABEL_RELEASE_ALL : BUTTON_LABEL_RELEASE);
        if (enableActivateWithAll) {
            this.getButton(1).setFocus();
        }
        log.exiting("switchActivateButtons");
    }

    private void updateInfoGroup(Object selected) {
        if (selected instanceof ClosedActivityWrapper) {
            IVfsActivity activity = ((ClosedActivityWrapper)selected).activity;
            try {
                String description = activity.getDescription() == null ? "" : activity.getDescription();
                this.textActivityDescription.setText(description);
                this.TableViewerActivityProperties.setInput((Object)activity);
                this.textActivityLastModified.setText(Util.getGMTString((Date)activity.getCheckedInDate()) + " by " + activity.getAuthor());
            }
            catch (VfsException ex) {
                this.setErrorMessage(ex.getMessage());
                log.error((Throwable)ex);
            }
        } else {
            this.textActivityDescription.setText("");
            this.textActivityLastModified.setText("");
            this.TableViewerActivityProperties.setInput(null);
        }
    }

    private void setMessage(String message, int messageType) {
        this.labelMessageText.setText(message);
        switch (messageType) {
            case 3: {
                this.labelMessageImage.setImage(Dialog.getImage((String)"dialog_message_error_image"));
                this.labelMessageText.setForeground(this.getShell().getDisplay().getSystemColor(3));
                this.labelMessageText.setBackground(this.getShell().getDisplay().getSystemColor(22));
                break;
            }
            case 1: {
                this.labelMessageImage.setImage(Dialog.getImage((String)"dialog_messasge_info_image"));
                this.labelMessageText.setForeground(this.getShell().getDisplay().getSystemColor(28));
                this.labelMessageText.setBackground(this.getShell().getDisplay().getSystemColor(29));
                break;
            }
            case 2: {
                this.labelMessageImage.setImage(Dialog.getImage((String)"dialog_messasge_warning_image"));
                this.labelMessageText.setForeground(this.getShell().getDisplay().getSystemColor(28));
                this.labelMessageText.setBackground(this.getShell().getDisplay().getSystemColor(20));
                break;
            }
            default: {
                this.labelMessageImage.setText("");
                this.labelMessageText.setForeground(this.getShell().getDisplay().getSystemColor(28));
                this.labelMessageText.setBackground(this.getShell().getDisplay().getSystemColor(22));
            }
        }
        this.labelMessageText.getParent().pack();
        this.isEmptyCaptionErrorDisplayed = false;
    }

    private void setErrorMessage(String message) {
        this.setMessage(message, 3);
    }

    private void clearMessageArea() {
        this.setMessage("", 0);
    }

    private void updatePredecessorTree(ClosedActivityWrapper[] predecessors) {
        if (predecessors == null || predecessors.length == 0) {
            ((PredecessorTreeContentProvider)this.treeViewerPredecessor.getContentProvider()).setAllPredecessors(null);
            this.setMessage("No predecessor activity detected.", 1);
            this.switchActivateButtons(false);
            return;
        }
        int count = predecessors.length;
        this.treeNodePredecessors = new MessageViewerInput(count > 1 ? "Predecessor Activities" : "Predecessor Activity", Dialog.getImage((String)"dialog_messasge_warning_image"));
        ((PredecessorTreeContentProvider)this.treeViewerPredecessor.getContentProvider()).setAllPredecessors(predecessors);
        String predActMessage = count > 1 ? "predecessor activities" : "predecessor activity";
        predActMessage = predActMessage + " based on overlapping files";
        this.setMessage("" + count + " " + predActMessage + " detected.", 2);
        this.treeViewerPredecessor.refresh();
        this.treeViewerPredecessor.setSelection((ISelection)new StructuredSelection((Object)this.treeNodePredecessors), true);
        this.treeViewerPredecessor.expandToLevel((Object)this.treeNodePredecessors, 1);
        this.switchActivateButtons(true);
    }

    private void performRelease() {
        final String caption = this.textChangeRequestCaption.getText();
        if (caption == null || caption.trim().length() == 0) {
            this.textChangeRequestCaption.setText("");
            this.textChangeRequestCaption.setFocus();
            return;
        }
        if (this.hasForeignActivity) {
            log.debug("Displaying foreign activity warning");
            MessageDialog warnDialog = new MessageDialog(this.getShell(), "Foreign Activity(ies)", null, "The current set of activities contains activity(ies) from other user(s).\n\nContinue release?", 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 1);
            if (warnDialog.open() == 1) {
                return;
            }
        }
        this.clearMessageArea();
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                log.entering("run");
                try {
                    try {
                        ReleasePredecessorDialog.this.activityReleaser.releaseActivities(ReleasePredecessorDialog.this.activityList, ReleasePredecessorDialog.this.predecessorActivities, ReleasePredecessorDialog.this.workspace, caption.trim());
                        ReleasePredecessorDialog.this.close();
                    }
                    catch (ReleaseActivityTimeoutException ex) {
                        String message = "The release process was not finished after 1 minute.\nIt will be continued asynchronously on the server.\nPlease refresh your transport view periodically to check whether the release has finished.";
                        MessageDialog.openInformation((Shell)ReleasePredecessorDialog.this.getShell(), (String)ReleasePredecessorDialog.MESSAGE_DIALOG_TITLE_RELEASE, (String)message);
                        ReleasePredecessorDialog.this.close();
                        Object var5_2 = null;
                        log.exiting("run");
                        return;
                    }
                    catch (ReleaseActivityException ex) {
                        log.error((Throwable)((Object)ex));
                        MessageDialog.openError((Shell)ReleasePredecessorDialog.this.getShell(), (String)ReleasePredecessorDialog.MESSAGE_DIALOG_TITLE_RELEASE, (String)ex.getMessage());
                        ReleasePredecessorDialog.this.setErrorMessage("Release of activities failed: " + ((Object)((Object)ex)).getClass().getName());
                        Object var5_3 = null;
                        log.exiting("run");
                        return;
                    }
                    catch (Exception ex) {
                        log.error((Throwable)ex);
                        MessageDialog.openError((Shell)ReleasePredecessorDialog.this.getShell(), (String)ReleasePredecessorDialog.MESSAGE_DIALOG_TITLE_RELEASE, (String)("Internal error: " + ex.getMessage()));
                        ReleasePredecessorDialog.this.setErrorMessage("Release of activities failed: " + ex.getClass().getName());
                        Object var5_4 = null;
                        log.exiting("run");
                        return;
                    }
                    Object var5_1 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    log.exiting("run");
                    throw throwable;
                }
                log.exiting("run");
            }
        });
    }

    private void performPredecessorCheck() {
        boolean isAllowed;
        Color prevColor = this.treeViewerPredecessor.getControl().getBackground();
        this.treeViewerPredecessor.getControl().setBackground(this.getShell().getDisplay().getSystemColor(22));
        this.getDialogArea().setEnabled(false);
        this.getButton(0).setEnabled(false);
        String predecessorKind = "predecessors based on overlapping files";
        this.setMessage("Calculating " + predecessorKind + " for activation...", 1);
        this.progressBar.setVisible(true);
        this.progressBar.beginTask("Calculating predecessors...", 100);
        this.progressBar.worked(25);
        try {
            ModalContext.run((IRunnableWithProgress)new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    ReleasePredecessorDialog.this.findAllPredecessors(ReleasePredecessorDialog.this.activities, monitor);
                }
            }, (boolean)true, (IProgressMonitor)this.progressBar, (Display)this.getShell().getDisplay());
        }
        catch (InvocationTargetException ex) {
            log.error(ex.getTargetException().getMessage(), (Throwable)ex);
        }
        catch (InterruptedException ex) {
            log.error((Throwable)ex);
        }
        if (!this.progressBar.isCanceled()) {
            if (this.predecessorErrorMessage == null) {
                this.updatePredecessorTree(this.predecessorActivities);
                this.getButton(0).setEnabled(true);
                this.predecessorCalculationFailed = false;
            } else {
                this.setErrorMessage(this.predecessorErrorMessage);
                this.predecessorErrorMessage = null;
                this.predecessorCalculationFailed = true;
            }
        } else {
            this.predecessorCalculationFailed = true;
        }
        if (!(this.predecessorCalculationFailed || this.textChangeRequestCaption.getText() != null && this.textChangeRequestCaption.getText().length() != 0)) {
            StringBuffer defaultCaption = new StringBuffer(this.captionHead);
            try {
                if (this.predecessorActivities != null) {
                    int i = 0;
                    while (i < this.predecessorActivities.length) {
                        defaultCaption.append(this.predecessorActivities[i].activity.getDisplayName() + ", ");
                        ++i;
                    }
                }
            }
            catch (VfsException ex) {
                log.error("Problems reading activity display name", (Throwable)ex);
            }
            log.debug("Set default change request caption to '" + defaultCaption.substring(0, defaultCaption.length() - 2) + "'");
            this.textChangeRequestCaption.setText(defaultCaption.substring(0, defaultCaption.length() - 2));
        }
        if (!this.progressBar.isDisposed()) {
            this.progressBar.done();
            this.progressBar.setVisible(false);
        }
        if (this.hasForeignActivity && !(isAllowed = this.activityReleaser.hasPermissionToReleaseForeignActivities(this.workspace))) {
            this.getButton(0).setEnabled(false);
            MessageDialog.openWarning((Shell)new Shell(), (String)"Permission denied", (String)"Your change request contains foreign activities.\nYou don't have the permission to release foreign activities.");
        }
        this.getDialogArea().setEnabled(true);
        this.treeViewerPredecessor.getControl().setBackground(prevColor);
    }

    private void excludeMarkedActivitiesFromPredecessors() {
        if (this.predecessorActivities == null) {
            return;
        }
        int count = this.predecessorActivities.length;
        String w = null;
        try {
            int i = 0;
            while (i < this.predecessorActivities.length) {
                w = this.predecessorActivities[i].activity.getObjectID();
                int j = 0;
                while (j < this.activities.length) {
                    if (w == this.activities[j].activity.getObjectID()) {
                        --count;
                        this.predecessorActivities[i] = null;
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (VfsException ex) {
            log.error((Throwable)ex);
            return;
        }
        if (count == this.predecessorActivities.length) {
            return;
        }
        ClosedActivityWrapper[] dummy = new ClosedActivityWrapper[count];
        count = 0;
        int i = 0;
        while (i < this.predecessorActivities.length) {
            if (this.predecessorActivities[i] != null) {
                dummy[count++] = this.predecessorActivities[i];
            }
            ++i;
        }
        this.predecessorActivities = dummy;
    }

    private ClosedActivityWrapper[] getPredecessorActivities(ClosedActivityWrapper[] activities, IVfsWorkspace workspace) throws CalculatePredecessorException {
        return this.ppp.findPredecessorActivities(activities, workspace);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void findAllPredecessors(ClosedActivityWrapper[] wrappers, IProgressMonitor monitor) {
        log.entering("findAllPredecessors");
        try {
            try {
                int progress = 65;
                ProgressMonitorPart progressMonitorPart = this.progressBar;
                synchronized (progressMonitorPart) {
                    if (!this.progressBar.isDisposed()) {
                        monitor.setTaskName("Checking predecessors ...");
                    }
                }
                this.predecessorActivities = this.getPredecessorActivities(wrappers, this.workspace);
                ProgressMonitorPart progressMonitorPart2 = this.progressBar;
                synchronized (progressMonitorPart2) {
                    if (!this.progressBar.isDisposed()) {
                        monitor.worked(progress);
                        monitor.setTaskName("Exclude selected activities ...");
                    }
                }
                this.excludeMarkedActivitiesFromPredecessors();
                if (!this.hasForeignActivity && this.predecessorActivities != null) {
                    log.debug("Check predecessor activities on foreign authors (user = " + this.user + ") ...");
                    try {
                        int i = 0;
                        while (i < this.predecessorActivities.length) {
                            log.debug("predecessorActivity[" + i + "]: author:" + this.predecessorActivities[i].activity.getAuthor());
                            if (this.user != null && !this.user.equalsIgnoreCase(this.predecessorActivities[i].activity.getAuthor())) {
                                this.hasForeignActivity = true;
                                log.debug("Foreign activity found: " + this.predecessorActivities[i].activity.getDisplayName());
                            }
                            ++i;
                        }
                    }
                    catch (VfsException ex) {
                        log.error((Throwable)ex);
                    }
                    log.debug("Result: hasForeignActivity = " + this.hasForeignActivity);
                }
                ProgressMonitorPart progressMonitorPart3 = this.progressBar;
                synchronized (progressMonitorPart3) {
                    if (!this.progressBar.isDisposed()) {
                        monitor.worked(10);
                    }
                }
            }
            catch (Exception ex) {
                log.error((Throwable)ex);
                this.predecessorErrorMessage = ex.getMessage();
                Object var9_11 = null;
                log.exiting("findAllPredecessors");
                return;
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            log.exiting("findAllPredecessors");
            throw throwable;
        }
        log.exiting("findAllPredecessors");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ void access$1200(ReleasePredecessorDialog x0, Object x1) {
        x0.updateInfoGroup(x1);
    }

    private class ActivityElementsContentProvider
    implements IStructuredContentProvider {
        private ActivityElementsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            try {
                if (inputElement instanceof IVfsActivity) {
                    return ((IVfsActivity)inputElement).getElementsFromClosedActivity();
                }
            }
            catch (VfsException ex) {
                ReleasePredecessorDialog.this.setErrorMessage(ex.getMessage());
                log.error("Exception during display of activity content", (Throwable)ex);
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class PredecessorTreeSorter
    extends AscendingElementLabelSorter {
        private PredecessorTreeSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof MessageViewerInput && e2 instanceof MessageViewerInput) {
                if (e1.equals(ReleasePredecessorDialog.this.treeNodeSelected) && e2.equals(ReleasePredecessorDialog.this.treeNodePredecessors)) {
                    return -1;
                }
                if (e2.equals(ReleasePredecessorDialog.this.treeNodeSelected) && e1.equals(ReleasePredecessorDialog.this.treeNodePredecessors)) {
                    return 1;
                }
                return 0;
            }
            return super.compare(viewer, e1, e2);
        }
    }

    private class PredecessorTreeLabelProvider
    extends VfsActivityLabelProvider {
        private PredecessorTreeLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof ClosedActivityWrapper) {
                try {
                    if (ReleasePredecessorDialog.this.user != null && !ReleasePredecessorDialog.this.user.equalsIgnoreCase(((ClosedActivityWrapper)element).activity.getAuthor())) {
                        return ActivationPlugin.getDefault().getCompositeImage("ACTIVITY_INACTIVE.gif", new String[]{"FOREIGN_CO.gif"});
                    }
                    return ActivationPlugin.getDefault().getAtomicImage("ACTIVITY_INACTIVE.gif");
                }
                catch (VfsException x) {
                    log.error((Throwable)x);
                    return super.getImage(element);
                }
            }
            if (element instanceof MessageViewerInput) {
                return ((MessageViewerInput)element).getImage();
            }
            return null;
        }

        protected boolean stretchImage() {
            return false;
        }

        public String getText(Object element) {
            if (element instanceof MessageViewerInput) {
                return ((MessageViewerInput)element).getLabel();
            }
            if (element instanceof ClosedActivityWrapper) {
                try {
                    String author = ((ClosedActivityWrapper)element).activity.getAuthor();
                    if (ReleasePredecessorDialog.this.user != null && !ReleasePredecessorDialog.this.user.equalsIgnoreCase(author)) {
                        return super.getText(element) + " (" + author + ")";
                    }
                }
                catch (VfsException x) {
                    log.error((Throwable)x);
                }
            }
            return super.getText(element);
        }
    }

    private class PredecessorTreeContentProvider
    implements ITreeContentProvider {
        private ClosedActivityWrapper[] allPredecessors = null;

        private PredecessorTreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement.equals(ReleasePredecessorDialog.this.treeNodeSelected)) {
                return ReleasePredecessorDialog.this.activities;
            }
            if (parentElement.equals(ReleasePredecessorDialog.this.treeNodePredecessors)) {
                if (this.allPredecessors != null) {
                    return this.allPredecessors;
                }
            } else if (parentElement instanceof ClosedActivityWrapper) {
                Object[] activityPredecessors = null;
                try {
                    activityPredecessors = ReleasePredecessorDialog.this.ppp.findPredecessorActivities((ClosedActivityWrapper)parentElement, ((ClosedActivityWrapper)parentElement).workspace);
                    if (activityPredecessors != null) {
                        return activityPredecessors;
                    }
                }
                catch (CalculatePredecessorException ex) {
                    log.error((Throwable)((Object)ex));
                    MessageDialog.openError((Shell)new Shell(), (String)"Calculate predecessors", (String)ex.getMessage());
                    ReleasePredecessorDialog.this.setErrorMessage("Error retrieving predecessor information!");
                }
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element.equals(ReleasePredecessorDialog.this.treeNodeSelected) || element.equals(ReleasePredecessorDialog.this.treeNodePredecessors)) {
                return true;
            }
            return element instanceof ClosedActivityWrapper;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ClosedActivityWrapper[]) {
                if (this.allPredecessors != null) {
                    return new MessageViewerInput[]{ReleasePredecessorDialog.this.treeNodeSelected, ReleasePredecessorDialog.this.treeNodePredecessors};
                }
                return new MessageViewerInput[]{ReleasePredecessorDialog.this.treeNodeSelected};
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        protected void setAllPredecessors(ClosedActivityWrapper[] allPredecessors) {
            this.allPredecessors = allPredecessors;
        }
    }
}

