/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.organizerUI.providers;

import com.sap.cms.organizerUI.providers.CMSTransportBaseContentProvider;
import com.sap.cms.util.logging.CmsLogger;
import com.sap.ide.eclipse.cbs.activation.internal.ActivationRuntimeDataStorage;
import com.sap.ide.eclipse.component.devconf.DevConfManager;
import com.sap.tc.complib.Compartment;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.devconf.RepositoryAccessException;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.contentProviders.EmptyTreeContentProvider;
import com.tssap.dtr.client.lib.vfs.IVfsRootFolder;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.config.Configuration;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class WorkspaceNodeContentProvider
extends CMSTransportBaseContentProvider {
    private static final CmsLogger log = CmsLogger.getLogger((String)(class$com$sap$cms$organizerUI$providers$WorkspaceNodeContentProvider == null ? (class$com$sap$cms$organizerUI$providers$WorkspaceNodeContentProvider = WorkspaceNodeContentProvider.class$("com.sap.cms.organizerUI.providers.WorkspaceNodeContentProvider")) : class$com$sap$cms$organizerUI$providers$WorkspaceNodeContentProvider).getName());
    private String actualRoot = null;
    static /* synthetic */ Class class$com$sap$cms$organizerUI$providers$WorkspaceNodeContentProvider;

    protected synchronized Object[] getMyChildren(Object element) {
        log.entering("getMyChildren(" + element + ")");
        if (element instanceof IVfsRootFolder) {
            log.debug("get development configuration...");
            IDevelopmentConfiguration actDevConfig = null;
            String clientName = ((IVfsRootFolder)element).getVersionedFileSystemManager().getClientName();
            IClient client = Configuration.getConfiguration().getClient(clientName);
            String localRoot = client.getAbsoluteLocalRoot();
            log.debug("client.getAbsoluteLocalRoot = " + localRoot);
            Iterator devConfigs = DevConfManager.getInstalledDevConfs().iterator();
            while (devConfigs.hasNext()) {
                IDevelopmentConfiguration devConfig = (IDevelopmentConfiguration)devConfigs.next();
                String devConfigRoot = devConfig.getConfigurationRootFolder();
                log.debug("devConfig.getConfigurationRootFolder = " + devConfigRoot);
                if (!localRoot.equals(devConfigRoot)) continue;
                actDevConfig = devConfig;
                log.debug("active development configuration = " + actDevConfig);
                break;
            }
            if (actDevConfig == null) {
                log.error("development configuration = null");
                log.exiting("getMyChildren: null");
                return EmptyTreeContentProvider.getEmptyChildren();
            }
            log.debug("get SCs/workspaces...");
            ArrayList<IVfsWorkspace> wsList = new ArrayList<IVfsWorkspace>();
            List compartments = actDevConfig.getCompartments();
            Iterator iter = compartments.iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                Compartment compartment = ActivationRuntimeDataStorage.getStorage().getCompartment(actDevConfig, name);
                if (compartment == null || (!compartment.hasSourceState() || compartment.getSourceState().getType() != 0) && (!compartment.hasSourceState() || compartment.getSourceState().getType() != 2)) continue;
                IVfsWorkspace workspace = null;
                try {
                    workspace = actDevConfig.getWorkspaceOfCompartment(name, true);
                }
                catch (RepositoryAccessException e) {
                    log.error("get workspace from compartment failed", (Throwable)e);
                }
                catch (DevConfigException e) {
                    log.error("get workspace from compartment failed", (Throwable)e);
                }
                if (workspace == null) continue;
                try {
                    log.debug("workspace " + workspace.getAbsoluteRemotePath() + " (" + workspace.getDisplayName() + ") added...");
                }
                catch (VfsException e) {
                    log.error("get workspace attributes failed", (Throwable)e);
                }
                wsList.add(workspace);
            }
            if (this.actualRoot == null || !this.actualRoot.equals(localRoot)) {
                this.actualRoot = localRoot;
                if (wsList.size() > 0) {
                    this.tvr.dtcChanged((IVfsWorkspace)wsList.get(0));
                } else {
                    this.tvr.dtcChanged();
                }
            }
            log.exiting("getMyChildren");
            return wsList.toArray(new IVfsWorkspace[wsList.size()]);
        }
        log.exiting("getMyChildren: null");
        return EmptyTreeContentProvider.getEmptyChildren();
    }

    protected boolean isChildrenApplicable(Object element) {
        log.entering("isChildrenApplicable");
        log.exiting("isChildrenApplicable: " + (element instanceof IVfsRootFolder));
        return element instanceof IVfsRootFolder;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

