/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.organizerUI.providers;

import com.sap.cms.client.types.CMSChangeRequest;
import com.sap.cms.organizerUI.CMSChangeRequestNode;
import com.sap.cms.organizerUI.CMSTransportNode;
import com.sap.cms.organizerUI.providers.CMSTransportBaseContentProvider;
import com.sap.cms.util.exception.CMSUnexpectedException;
import com.sap.cms.util.exception.client.CMSClientChangeRequestNotFoundException;
import com.sap.cms.util.exception.client.CMSClientCreateAPIException;
import com.sap.cms.util.logging.CmsLogger;
import com.tssap.dtr.client.eclipse.ui.treeBrowser.contentProviders.EmptyTreeContentProvider;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class ChangeRequestNodeContentProvider
extends CMSTransportBaseContentProvider {
    private static final CmsLogger log = CmsLogger.getLogger((String)(class$com$sap$cms$organizerUI$providers$ChangeRequestNodeContentProvider == null ? (class$com$sap$cms$organizerUI$providers$ChangeRequestNodeContentProvider = ChangeRequestNodeContentProvider.class$("com.sap.cms.organizerUI.providers.ChangeRequestNodeContentProvider")) : class$com$sap$cms$organizerUI$providers$ChangeRequestNodeContentProvider).getName());
    static /* synthetic */ Class class$com$sap$cms$organizerUI$providers$ChangeRequestNodeContentProvider;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object[] getMyChildren(Object element) {
        log.entering("getMyChildren(" + element + ")");
        Object[] returnValues = null;
        try {
            block16: {
                try {
                    if (element instanceof CMSTransportNode) {
                        CMSTransportNode node = (CMSTransportNode)element;
                        this.tvr.setFilterUser(this.getFilterUser());
                        CMSChangeRequest[] requests = null;
                        switch (node.getType()) {
                            case 0: {
                                CMSChangeRequestNode defaultNode = new CMSChangeRequestNode();
                                defaultNode.setTransportNode(node);
                                returnValues = new Object[]{defaultNode};
                                break;
                            }
                            case 1: {
                                this.tvr.setFilterUser(this.getFilterUser());
                                requests = this.tvr.getFailedChangeRequests(node.getWorkspace());
                                returnValues = this.makeNodes(requests, node);
                                break;
                            }
                            case 2: {
                                this.tvr.setFilterUser(this.getFilterUser());
                                requests = this.tvr.getReleasedChangeRequests(node.getWorkspace(), this.getDateFilter().getTime());
                                returnValues = this.makeNodes(requests, node);
                                break;
                            }
                            default: {
                                log.error("Unknown transport node type");
                            }
                        }
                        if (this.m_withSortPossiblity && this.m_viewId != null) {
                            boolean sortByName = this.getPreferenceStore().getBoolean(this.m_viewId + "_sortChangeRequestByName");
                            boolean sortAscending = this.getPreferenceStore().getBoolean(this.m_viewId + "_sortChangeRequestAscending");
                            if (sortByName) {
                                log.debug("sort change requests by caption (sortAscending = " + sortAscending + ")");
                                returnValues = this.sortElementsByCaption(returnValues, sortAscending);
                                break block16;
                            } else {
                                log.debug("sort change requests by creation date (sortAscending = " + sortAscending + ")");
                                returnValues = this.sortElementsByCreationDate(returnValues, sortAscending);
                            }
                        }
                        break block16;
                    }
                    returnValues = EmptyTreeContentProvider.getEmptyChildren();
                }
                catch (VfsException ex) {
                    log.error((Throwable)ex);
                    Shell shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Read change requests", (String)("Read of change request information from DTR failed:\n" + ex.getMessage()));
                    shell.dispose();
                    returnValues = EmptyTreeContentProvider.getEmptyChildren();
                    Object var9_17 = null;
                    log.exiting("getMyChildren: " + returnValues);
                    return returnValues;
                }
                catch (CMSClientCreateAPIException ex) {
                    log.error((Throwable)ex);
                    Shell shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Read change requests", (String)("Read of change request information from CMS failed:\n" + ex.getMessage()));
                    shell.dispose();
                    returnValues = EmptyTreeContentProvider.getEmptyChildren();
                    Object var9_18 = null;
                    log.exiting("getMyChildren: " + returnValues);
                    return returnValues;
                }
                catch (CMSClientChangeRequestNotFoundException ex) {
                    log.error((Throwable)ex);
                    Shell shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Read change requests", (String)ex.getMessage());
                    shell.dispose();
                    returnValues = EmptyTreeContentProvider.getEmptyChildren();
                    Object var9_19 = null;
                    log.exiting("getMyChildren: " + returnValues);
                    return returnValues;
                }
                catch (CMSUnexpectedException ex) {
                    log.error((Throwable)ex);
                    Shell shell = new Shell();
                    MessageDialog.openError((Shell)shell, (String)"Generate transport view tree", (String)("Unexpected error: " + ex.getMessage()));
                    shell.dispose();
                    returnValues = EmptyTreeContentProvider.getEmptyChildren();
                    Object var9_20 = null;
                    log.exiting("getMyChildren: " + returnValues);
                    return returnValues;
                }
            }
            Object var9_16 = null;
            log.exiting("getMyChildren: " + returnValues);
            return returnValues;
        }
        catch (Throwable throwable) {
            Object var9_21 = null;
            log.exiting("getMyChildren: " + returnValues);
            throw throwable;
        }
    }

    protected boolean isChildrenApplicable(Object element) {
        log.entering("isChildrenApplicable(" + element + ")");
        boolean returnValue = false;
        returnValue = this.tvr.isChangeRequestViewEnabled() && element instanceof CMSTransportNode;
        log.exiting("isChildrenApplicable: " + returnValue);
        return returnValue;
    }

    private Object[] makeNodes(CMSChangeRequest[] requests, CMSTransportNode parentNode) {
        if (requests == null) {
            return EmptyTreeContentProvider.getEmptyChildren();
        }
        Object[] nodes = new CMSChangeRequestNode[requests.length];
        int i = 0;
        while (i < requests.length) {
            nodes[i] = new CMSChangeRequestNode();
            ((CMSChangeRequestNode)nodes[i]).setRequest(requests[i]);
            ((CMSChangeRequestNode)nodes[i]).setTransportNode(parentNode);
            ++i;
        }
        return nodes;
    }

    private Object[] sortElementsByCaption(Object[] elements, final boolean ascending) {
        if (elements == null) {
            return elements;
        }
        Arrays.sort(elements, new Comparator(){

            public int compare(Object elm1, Object elm2) {
                if (elm1 == null || elm2 == null) {
                    throw new IllegalStateException("Can't compare <null> arguments.");
                }
                String name1 = ((CMSChangeRequestNode)elm1).getCaption();
                String name2 = ((CMSChangeRequestNode)elm2).getCaption();
                if (name1 == null || name2 == null) {
                    throw new IllegalStateException("Can't compare <null> captions.");
                }
                return ascending ? name1.compareToIgnoreCase(name2) : -name1.compareToIgnoreCase(name2);
            }
        });
        return elements;
    }

    private Object[] sortElementsByCreationDate(Object[] elements, final boolean ascending) {
        if (elements == null) {
            return elements;
        }
        Arrays.sort(elements, new Comparator(){

            public int compare(Object elm1, Object elm2) {
                long date2;
                if (elm1 == null || elm2 == null) {
                    throw new IllegalStateException("Can't compare <null> arguments.");
                }
                CMSChangeRequest request1 = ((CMSChangeRequestNode)elm1).getRequest();
                CMSChangeRequest request2 = ((CMSChangeRequestNode)elm1).getRequest();
                if (request1 == null || request2 == null) {
                    return 0;
                }
                long date1 = request1.getCreationDate();
                return date1 > (date2 = request2.getCreationDate()) ^ ascending ? -1 : 1;
            }
        });
        return elements;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

