/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.organizerUI.internal;

import com.sap.cms.client.release.ReleaseAPI;
import com.sap.cms.client.types.CMSChangeList;
import com.sap.cms.client.types.CMSChangeRequest;
import com.sap.cms.client.types.RequestID;
import com.sap.cms.organizerUI.CMSOrganizerPlugin;
import com.sap.cms.organizerUI.internal.CMSAPIFactory;
import com.sap.cms.util.exception.CMSUnexpectedException;
import com.sap.cms.util.exception.client.CMSClientChangeRequestNotFoundException;
import com.sap.cms.util.exception.client.CMSClientCreateAPIException;
import com.sap.cms.util.exception.client.CMSClientVersionConflictException;
import com.sap.cms.util.exception.misc.CMSPermissionDeniedException;
import com.sap.cms.util.logging.CmsLogger;
import com.sap.cms.util.request.CmsRequestTool;
import com.sap.ide.eclipse.cbs.activation.internal.ActivationRuntimeDataStorage;
import com.sap.tc.complib.Compartment;
import com.sap.tc.devconf.DevConfigException;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.devconf.RepositoryAccessException;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsProperty;
import com.tssap.dtr.client.lib.vfs.IVfsVersionSet;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.net.MalformedURLException;
import java.security.KeyStoreException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class TransportViewRepository {
    private static final CmsLogger log = CmsLogger.getLogger((String)(class$com$sap$cms$organizerUI$internal$TransportViewRepository == null ? (class$com$sap$cms$organizerUI$internal$TransportViewRepository = TransportViewRepository.class$("com.sap.cms.organizerUI.internal.TransportViewRepository")) : class$com$sap$cms$organizerUI$internal$TransportViewRepository).getName());
    private static TransportViewRepository instance = null;
    private HashMap unfinishedChangeRequests = new HashMap();
    private HashMap finishedChangeRequests = new HashMap();
    private HashMap changeListsByChangeRequest = new HashMap();
    private HashMap waitingActivities = new HashMap();
    private HashSet unfinishedChangeLists = new HashSet();
    private HashMap userMapFailed = new HashMap();
    private HashMap userMapWaiting = new HashMap();
    private HashMap userMapReleased = new HashMap();
    private HashMap requestIDByWorkspace = new HashMap();
    private boolean changeRequestViewEnabled = true;
    private String filterUser = "*";
    private ReleaseAPI releaseAPI = null;
    private long dateFilter = 0L;
    private String cmsServer = null;
    static /* synthetic */ Class class$com$sap$cms$organizerUI$internal$TransportViewRepository;

    TransportViewRepository() {
    }

    public void dtcChanged() {
        log.entering("dtcChanged");
        this.releaseAPI = null;
        this.clearCache();
        log.exiting("dtcChanged");
    }

    public void dtcChanged(IVfsWorkspace workspace) {
        log.entering("dtcChanged", new Object[]{workspace});
        this.dtcChanged();
        try {
            this.getReleaseAPI(workspace);
        }
        catch (CMSClientCreateAPIException e) {
            log.error("Failed to contact CMS server", (Throwable)e);
        }
        log.exiting("dtcChanged");
    }

    public void refresh() {
        log.entering("refresh");
        this.clearCache();
        log.exiting("refresh");
    }

    private void clearCache() {
        log.entering("clearCache");
        this.unfinishedChangeRequests.clear();
        this.finishedChangeRequests.clear();
        this.changeListsByChangeRequest.clear();
        this.waitingActivities.clear();
        this.unfinishedChangeLists.clear();
        this.userMapFailed.clear();
        this.userMapReleased.clear();
        this.userMapWaiting.clear();
        log.exiting("clearCache");
    }

    public void setFilterUser(String filterUser) {
        log.entering("setFilterUser", new Object[]{filterUser});
        if (!filterUser.equalsIgnoreCase(this.filterUser)) {
            log.debug("Filter user changed from " + this.filterUser + " to " + filterUser);
            this.filterUser = filterUser;
            this.finishedChangeRequests.clear();
            this.waitingActivities.clear();
        }
        log.exiting("setFilterUser");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ReleaseAPI getReleaseAPI(IVfsWorkspace workspace) throws CMSClientCreateAPIException {
        log.entering("getReleaseAPI", new Object[]{workspace});
        try {
            block11: {
                try {
                    String currentCmsServer = CMSOrganizerPlugin.getDefault().getCMSServerURL(workspace);
                    if (this.releaseAPI != null && this.cmsServer != null && this.cmsServer.equals(currentCmsServer)) break block11;
                    this.cmsServer = currentCmsServer;
                    this.releaseAPI = CMSAPIFactory.getInstance().createReleaseAPI(this.cmsServer, 600000);
                    String cmsWorkspaceId = workspace.getProperty("XCM:cms-workspace-name").getValue();
                    this.requestIDByWorkspace.put(cmsWorkspaceId, this.releaseAPI.getRequestIDForWorkspace(cmsWorkspaceId));
                    this.changeRequestViewEnabled = true;
                }
                catch (CMSClientVersionConflictException e) {
                    log.warning("This server does not support methods for change request evaluation. For a change request based view please update your server to at least NW04 SP10");
                    this.changeRequestViewEnabled = false;
                    Object var11_7 = null;
                    log.exiting("getReleaseAPI", (Object)this.releaseAPI);
                    return this.releaseAPI;
                }
                catch (MalformedURLException e) {
                    throw new CMSUnexpectedException((Throwable)e);
                }
                catch (KeyStoreException e) {
                    throw new CMSUnexpectedException((Throwable)e);
                }
                catch (VfsException e) {
                    throw new CMSClientCreateAPIException((Throwable)e);
                }
                catch (CMSPermissionDeniedException e) {
                    throw new CMSClientCreateAPIException((Throwable)e);
                }
                catch (CMSClientCreateAPIException e) {
                    throw e;
                }
                catch (CMSUnexpectedException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new CMSUnexpectedException((Throwable)e);
                }
            }
            Object var11_6 = null;
            log.exiting("getReleaseAPI", (Object)this.releaseAPI);
            return this.releaseAPI;
        }
        catch (Throwable throwable) {
            Object var11_8 = null;
            log.exiting("getReleaseAPI", (Object)this.releaseAPI);
            throw throwable;
        }
    }

    public static TransportViewRepository getInstance() {
        log.entering("getInstance");
        if (instance == null) {
            instance = new TransportViewRepository();
        }
        log.exiting("getInstance", (Object)instance);
        return instance;
    }

    private CMSChangeList[] loadChangeListsOfChangeRequest(IVfsWorkspace workspace, CMSChangeRequest request) throws CMSClientChangeRequestNotFoundException, CMSClientCreateAPIException {
        log.entering("loadChangeListsOfChangeRequest", new Object[]{workspace, request});
        CMSChangeList[] changelists = null;
        try {
            ReleaseAPI myReleaseAPI = this.getReleaseAPI(workspace);
            changelists = myReleaseAPI.getChangeListsOfChangeRequest(request.getComponent(), request.getVersion());
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            log.exiting("loadChangeListsOfChangeRequest", changelists);
            throw throwable;
        }
        log.exiting("loadChangeListsOfChangeRequest", (Object)changelists);
        return changelists;
    }

    public CMSChangeRequest[] loadUnfinishedChangeRequests(IVfsWorkspace workspace) throws VfsException, CMSClientChangeRequestNotFoundException, CMSClientCreateAPIException {
        log.entering("loadUnfinishedChangeRequests", new Object[]{workspace});
        CMSChangeRequest[] requests = null;
        try {
            ReleaseAPI myReleaseAPI = this.getReleaseAPI(workspace);
            String cmsWorkspaceId = workspace.getProperty("XCM:cms-workspace-name").getValue();
            RequestID requestID = (RequestID)this.requestIDByWorkspace.get(cmsWorkspaceId);
            if (requestID == null) {
                requestID = this.releaseAPI.getRequestIDForWorkspace(cmsWorkspaceId);
                this.requestIDByWorkspace.put(cmsWorkspaceId, requestID);
            }
            requests = myReleaseAPI.getUnfinishedChangeRequests(requestID, null);
            log.debug("Unfinished change requests for workspace " + workspace + " loaded");
            if (requests == null) {
                log.debug("No requests found (null)");
                requests = new CMSChangeRequest[]{};
            } else {
                int i = 0;
                while (i < requests.length) {
                    log.debug("Loaded unfinished change request[" + i + "]:" + requests[i]);
                    ++i;
                }
            }
            this.unfinishedChangeRequests.put(workspace, requests);
            int i = 0;
            while (i < requests.length) {
                CMSChangeRequest tmpReq = requests[i];
                if (tmpReq.getState() == 0) {
                    CMSChangeList[] cl = myReleaseAPI.getChangeListsOfChangeRequest(tmpReq.getComponent(), tmpReq.getVersion());
                    String rId = CmsRequestTool.requestKeyToId((String)tmpReq.getComponent().getName(), (String)tmpReq.getComponent().getVendor(), (String)tmpReq.getVersion().getLocation(), (long)tmpReq.getVersion().getCounter());
                    this.changeListsByChangeRequest.put(rId, cl);
                    int j = 0;
                    while (j < cl.length) {
                        this.unfinishedChangeLists.add(cl[j].getName());
                        ++j;
                    }
                }
                ++i;
            }
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            log.exiting("loadUnfinishedChangeRequests", requests);
            throw throwable;
        }
        log.exiting("loadUnfinishedChangeRequests", (Object)requests);
        return requests;
    }

    public CMSChangeRequest[] loadFinishedChangeRequests(IVfsWorkspace workspace, long dateFilter) throws VfsException, CMSClientCreateAPIException {
        log.entering("loadFinishedChangeRequests", new Object[]{workspace});
        CMSChangeRequest[] requests = null;
        try {
            ReleaseAPI myReleaseAPI = this.getReleaseAPI(workspace);
            String cmsWorkspaceId = workspace.getProperty("XCM:cms-workspace-name").getValue();
            RequestID requestID = (RequestID)this.requestIDByWorkspace.get(cmsWorkspaceId);
            if (requestID == null) {
                requestID = this.releaseAPI.getRequestIDForWorkspace(cmsWorkspaceId);
                this.requestIDByWorkspace.put(cmsWorkspaceId, requestID);
            }
            requests = myReleaseAPI.getFinishedChangeRequests(requestID, this.getExternalFilterUser(), dateFilter);
            log.debug("Finished change requests for workspace " + workspace + " loaded");
            if (requests == null) {
                log.debug("No requests found (null)");
                requests = new CMSChangeRequest[]{};
            } else {
                int i = 0;
                while (i < requests.length) {
                    log.debug("Loaded finished change request[" + i + "]:" + requests[i]);
                    ++i;
                }
            }
            this.finishedChangeRequests.put(workspace, requests);
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            log.exiting("loadFinishedChangeRequests", requests);
            throw throwable;
        }
        log.exiting("loadFinishedChangeRequests", (Object)requests);
        return requests;
    }

    public void loadWaitingActivities(IVfsWorkspace workspace) throws VfsException, CMSClientChangeRequestNotFoundException, CMSClientCreateAPIException {
        log.entering("loadWaitingActivities", new Object[]{workspace});
        try {
            IVfsVersionSet[] versionSets = null;
            String[] additionalProperties = new String[]{"XCM:propagation-request-id"};
            versionSets = this.filterUser.equals("*") ? workspace.deprecated_specialGetVersionSetsBy(null, false, additionalProperties, true) : workspace.deprecated_specialGetVersionSetsBy(this.filterUser, false, additionalProperties, true);
            ArrayList<IVfsActivity> waiting = new ArrayList<IVfsActivity>();
            String value = null;
            IVfsProperty property = null;
            String inactiveWorkspacePath = this.getInactiveWorkspacePath(workspace);
            if (inactiveWorkspacePath == null) {
                throw new VfsException("Could not determine inactive workspace path");
            }
            if (!this.unfinishedChangeRequests.containsKey(workspace)) {
                this.loadUnfinishedChangeRequests(workspace);
            }
            IVfsActivity act = null;
            int i = 0;
            while (i < versionSets.length) {
                act = versionSets[i].getAsClosedActivity();
                if (!inactiveWorkspacePath.equalsIgnoreCase(act.getCreationWorkspaceAbsoluteRemotePath())) {
                    log.debug("Creation workspace path: " + act.getCreationWorkspaceAbsoluteRemotePath());
                    log.debug("Hiding activity from foreign workspace: " + act);
                } else {
                    property = act.getProperty("XCM:propagation-request-id");
                    if ((property == null || (value = property.getValue()) == null || value.equals("")) && !this.unfinishedChangeLists.contains(act.getObjectID())) {
                        waiting.add(act);
                    }
                }
                ++i;
            }
            log.debug("Waiting activities for workspace " + workspace + " loaded");
            Iterator iter = ((AbstractList)waiting).iterator();
            while (iter.hasNext()) {
                log.debug("Activity " + iter.next());
            }
            this.waitingActivities.put(workspace, waiting);
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            log.exiting("loadWaitingActivities");
            throw throwable;
        }
        log.exiting("loadWaitingActivities");
    }

    private IVfsActivity[] loadActivities(IVfsWorkspace workspace, String[] activities) throws VfsException {
        log.entering("loadActivities", new Object[]{workspace, activities});
        IVfsActivity[] fullActivities = null;
        try {
            fullActivities = workspace.getRepository().getActivitiesById(activities);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            log.exiting("loadActivities", (Object)fullActivities);
            throw throwable;
        }
        log.exiting("loadActivities", (Object)fullActivities);
        return fullActivities;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasWaitingActivities(IVfsWorkspace workspace) {
        log.entering("hasWaitingActivities");
        boolean returnValue = false;
        try {
            block6: {
                try {
                    IVfsActivity[] acts = this.getActivitiesOfChangeRequest(workspace, null);
                    if (acts == null) break block6;
                    returnValue = acts.length > 0;
                }
                catch (VfsException ex) {
                    log.error((Throwable)ex);
                    Object var7_6 = null;
                    log.exiting("hasWaitingActivities", (Object)new Boolean(returnValue));
                    return returnValue;
                }
                catch (CMSClientCreateAPIException ex) {
                    log.error((Throwable)ex);
                    Object var7_7 = null;
                    log.exiting("hasWaitingActivities", (Object)new Boolean(returnValue));
                    return returnValue;
                }
                catch (CMSClientChangeRequestNotFoundException ex) {
                    log.error((Throwable)ex);
                    Object var7_8 = null;
                    log.exiting("hasWaitingActivities", (Object)new Boolean(returnValue));
                    return returnValue;
                }
            }
            Object var7_5 = null;
            log.exiting("hasWaitingActivities", (Object)new Boolean(returnValue));
            return returnValue;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            log.exiting("hasWaitingActivities", (Object)new Boolean(returnValue));
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasFailedChangeRequests(IVfsWorkspace workspace) {
        log.entering("hasFailedChangeRequests", new Object[]{workspace});
        boolean returnValue = false;
        try {
            block6: {
                try {
                    CMSChangeRequest[] unfinished = this.getFailedChangeRequests(workspace);
                    if (unfinished == null) break block6;
                    returnValue = unfinished.length > 0;
                }
                catch (VfsException ex) {
                    log.error((Throwable)ex);
                    Object var7_6 = null;
                    log.exiting("hasFailedChangeRequests", (Object)new Boolean(returnValue));
                    return returnValue;
                }
                catch (CMSClientCreateAPIException ex) {
                    log.error((Throwable)ex);
                    Object var7_7 = null;
                    log.exiting("hasFailedChangeRequests", (Object)new Boolean(returnValue));
                    return returnValue;
                }
                catch (CMSClientChangeRequestNotFoundException ex) {
                    log.error((Throwable)ex);
                    Object var7_8 = null;
                    log.exiting("hasFailedChangeRequests", (Object)new Boolean(returnValue));
                    return returnValue;
                }
            }
            Object var7_5 = null;
            log.exiting("hasFailedChangeRequests", (Object)new Boolean(returnValue));
            return returnValue;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            log.exiting("hasFailedChangeRequests", (Object)new Boolean(returnValue));
            throw throwable;
        }
    }

    public CMSChangeRequest[] getFailedChangeRequests(IVfsWorkspace workspace) throws VfsException, CMSClientChangeRequestNotFoundException, CMSClientCreateAPIException {
        log.entering("getFailedChangeRequests", new Object[]{workspace});
        CMSChangeRequest[] returnValues = null;
        try {
            returnValues = (CMSChangeRequest[])this.unfinishedChangeRequests.get(workspace);
            if (returnValues == null) {
                returnValues = this.loadUnfinishedChangeRequests(workspace);
            }
            if (this.getExternalFilterUser() != null) {
                HashMap<IVfsWorkspace, CMSChangeRequest[]> wsMap = (HashMap<IVfsWorkspace, CMSChangeRequest[]>)this.userMapFailed.get(this.filterUser);
                CMSChangeRequest[] cached = null;
                if (wsMap != null) {
                    cached = (CMSChangeRequest[])wsMap.get(workspace);
                } else {
                    wsMap = new HashMap<IVfsWorkspace, CMSChangeRequest[]>();
                    this.userMapFailed.put(this.filterUser, wsMap);
                }
                if (cached == null) {
                    cached = this.filterChangeRequestsByUser(workspace, returnValues);
                    wsMap.put(workspace, cached);
                }
                returnValues = cached;
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            log.exiting("getFailedChangeRequests", (Object)returnValues);
            throw throwable;
        }
        log.exiting("getFailedChangeRequests", (Object)returnValues);
        return returnValues;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasReleasedChangeRequests(IVfsWorkspace workspace, long dateFilter) {
        log.entering("hasReleasedChangeRequests", new Object[]{workspace});
        boolean returnValue = false;
        try {
            block6: {
                try {
                    CMSChangeRequest[] released = this.getReleasedChangeRequests(workspace, dateFilter);
                    if (released == null) break block6;
                    returnValue = released.length > 0;
                }
                catch (VfsException ex) {
                    log.error((Throwable)ex);
                    Object var9_7 = null;
                    log.exiting("hasReleasedChangeRequests", (Object)new Boolean(returnValue));
                    return returnValue;
                }
                catch (CMSClientCreateAPIException ex) {
                    log.error((Throwable)ex);
                    Object var9_8 = null;
                    log.exiting("hasReleasedChangeRequests", (Object)new Boolean(returnValue));
                    return returnValue;
                }
                catch (CMSClientChangeRequestNotFoundException ex) {
                    log.error((Throwable)ex);
                    Object var9_9 = null;
                    log.exiting("hasReleasedChangeRequests", (Object)new Boolean(returnValue));
                    return returnValue;
                }
            }
            Object var9_6 = null;
            log.exiting("hasReleasedChangeRequests", (Object)new Boolean(returnValue));
            return returnValue;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            log.exiting("hasReleasedChangeRequests", (Object)new Boolean(returnValue));
            throw throwable;
        }
    }

    public CMSChangeRequest[] getReleasedChangeRequests(IVfsWorkspace workspace, long dateFilter) throws VfsException, CMSClientCreateAPIException, CMSClientChangeRequestNotFoundException {
        log.entering("getReleasedChangeRequests", new Object[]{workspace});
        CMSChangeRequest[] returnValues = null;
        try {
            returnValues = (CMSChangeRequest[])this.finishedChangeRequests.get(workspace);
            if (returnValues == null || Math.abs(this.dateFilter - dateFilter) > 600000L) {
                this.dateFilter = dateFilter;
                returnValues = this.loadFinishedChangeRequests(workspace, dateFilter);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            log.exiting("getReleasedChangeRequests", (Object)returnValues);
            throw throwable;
        }
        log.exiting("getReleasedChangeRequests", (Object)returnValues);
        return returnValues;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IVfsActivity[] getActivitiesOfChangeRequest(IVfsWorkspace workspace, CMSChangeRequest request) throws VfsException, CMSClientChangeRequestNotFoundException, CMSClientCreateAPIException {
        IVfsActivity[] iVfsActivityArray;
        block19: {
            block18: {
                IVfsActivity[] wsMap2;
                block17: {
                    IVfsActivity[] iVfsActivityArray2;
                    block16: {
                        log.entering("getActivitiesOfChangeRequest", new Object[]{workspace, request});
                        try {
                            if (request == null) {
                                ArrayList cls = (ArrayList)this.waitingActivities.get(workspace);
                                if (cls == null) {
                                    this.loadWaitingActivities(workspace);
                                    cls = (ArrayList)this.waitingActivities.get(workspace);
                                }
                                if (cls == null) {
                                    iVfsActivityArray2 = new IVfsActivity[]{};
                                    Object var10_9 = null;
                                    break block16;
                                }
                                if (this.getExternalFilterUser() != null) {
                                    Object al;
                                    HashMap<IVfsWorkspace, IVfsActivity[]> wsMap2 = (HashMap<IVfsWorkspace, IVfsActivity[]>)this.userMapWaiting.get(this.filterUser);
                                    IVfsActivity[] cached = null;
                                    if (wsMap2 != null) {
                                        cached = (IVfsActivity[])wsMap2.get(workspace);
                                    } else {
                                        wsMap2 = new HashMap<IVfsWorkspace, IVfsActivity[]>();
                                        this.userMapWaiting.put(this.filterUser, wsMap2);
                                    }
                                    if (cached == null) {
                                        al = (ArrayList)cls.clone();
                                        Iterator iter = ((AbstractList)al).iterator();
                                        while (true) {
                                            if (!iter.hasNext()) {
                                                cached = ((ArrayList)al).toArray(new IVfsActivity[((ArrayList)al).size()]);
                                                wsMap2.put(workspace, cached);
                                                break;
                                            }
                                            IVfsActivity act = (IVfsActivity)iter.next();
                                            if (this.filterUser.equalsIgnoreCase(act.getAuthor())) continue;
                                            iter.remove();
                                        }
                                    }
                                    al = cached;
                                    Object var10_10 = null;
                                    log.exiting("getActivitiesOfChangeRequest");
                                    return al;
                                }
                                wsMap2 = cls.toArray(new IVfsActivity[cls.size()]);
                                break block17;
                            }
                            String reqID = CmsRequestTool.requestKeyToId((String)request.getComponent().getName(), (String)request.getComponent().getVendor(), (String)request.getVersion().getLocation(), (long)request.getVersion().getCounter());
                            Object cls = this.changeListsByChangeRequest.get(reqID);
                            if (cls == null) {
                                cls = this.loadChangeListsOfChangeRequest(workspace, request);
                                this.changeListsByChangeRequest.put(reqID, cls);
                            }
                            if (cls instanceof CMSChangeList[]) {
                                CMSChangeList[] changelists = (CMSChangeList[])cls;
                                String[] actIDs = new String[changelists.length];
                                int i = 0;
                                while (true) {
                                    if (i >= changelists.length) {
                                        cls = this.loadActivities(workspace, actIDs);
                                        this.changeListsByChangeRequest.put(reqID, cls);
                                        break;
                                    }
                                    actIDs[i] = changelists[i].getName();
                                    ++i;
                                }
                            }
                            if (cls == null) {
                                iVfsActivityArray = new IVfsActivity[]{};
                                break block18;
                            }
                            iVfsActivityArray = (IVfsActivity[])cls;
                            break block19;
                        }
                        catch (Throwable throwable) {
                            Object var10_14 = null;
                            log.exiting("getActivitiesOfChangeRequest");
                            throw throwable;
                        }
                    }
                    log.exiting("getActivitiesOfChangeRequest");
                    return iVfsActivityArray2;
                }
                Object var10_11 = null;
                log.exiting("getActivitiesOfChangeRequest");
                return wsMap2;
            }
            Object var10_12 = null;
            log.exiting("getActivitiesOfChangeRequest");
            return iVfsActivityArray;
        }
        Object var10_13 = null;
        log.exiting("getActivitiesOfChangeRequest");
        return iVfsActivityArray;
    }

    private String getExternalFilterUser() {
        if (this.filterUser.equalsIgnoreCase("*")) {
            return null;
        }
        return this.filterUser;
    }

    private String getInactiveWorkspacePath(IVfsWorkspace activeWorkspace) {
        try {
            String inactiveWsPath = null;
            IDevelopmentConfiguration devConfig = ActivationRuntimeDataStorage.getStorage().getActiveDevelopmentConfiguration();
            List compartments = devConfig.getCompartments();
            Object properties = null;
            Iterator iter = compartments.iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                Compartment compartment = ActivationRuntimeDataStorage.getStorage().getCompartment(devConfig, name);
                String activeWsPath = null;
                if (!compartment.hasSourceState()) continue;
                activeWsPath = devConfig.getWorkspaceOfCompartment(name, true).getAbsoluteRemotePath();
                inactiveWsPath = devConfig.getWorkspaceOfCompartment(name, false).getAbsoluteRemotePath();
                log.debug("active path ......: " + activeWsPath);
                log.debug("inactive path ....: " + inactiveWsPath);
                if (!activeWsPath.equalsIgnoreCase(activeWorkspace.getAbsoluteRemotePath())) continue;
                return inactiveWsPath;
            }
        }
        catch (RepositoryAccessException e) {
            log.error("get inactive workspace failed", (Throwable)e);
        }
        catch (DevConfigException e) {
            log.error("get inactive workspace failed", (Throwable)e);
        }
        return null;
    }

    private CMSChangeRequest[] filterChangeRequestsByUser(IVfsWorkspace workspace, CMSChangeRequest[] requests) throws VfsException, CMSClientChangeRequestNotFoundException, CMSClientCreateAPIException {
        CMSChangeRequest[] cMSChangeRequestArray;
        log.entering("filterChangeRequestsByUser", new Object[]{workspace, requests});
        ArrayList<CMSChangeRequest> list = new ArrayList<CMSChangeRequest>();
        CMSChangeRequest[] returnValues = null;
        try {
            int i = 0;
            while (i < requests.length) {
                boolean ok = false;
                CMSChangeRequest tmpReq = requests[i];
                if (this.filterUser.equalsIgnoreCase(tmpReq.getOwner())) {
                    ok = true;
                } else {
                    String rID = CmsRequestTool.requestKeyToId((String)tmpReq.getComponent().getName(), (String)tmpReq.getComponent().getVendor(), (String)tmpReq.getVersion().getLocation(), (long)tmpReq.getVersion().getCounter());
                    IVfsActivity[] cls = this.getActivitiesOfChangeRequest(workspace, tmpReq);
                    int j = 0;
                    while (j < cls.length) {
                        if (this.filterUser.equalsIgnoreCase(cls[j].getAuthor())) {
                            ok = true;
                            break;
                        }
                        ++j;
                    }
                }
                if (ok) {
                    list.add(tmpReq);
                }
                ++i;
            }
            cMSChangeRequestArray = returnValues = list.toArray(new CMSChangeRequest[list.size()]);
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            log.exiting("filterChangeRequestsByUser", returnValues);
            throw throwable;
        }
        log.exiting("filterChangeRequestsByUser", (Object)returnValues);
        return cMSChangeRequestArray;
    }

    public boolean isChangeRequestViewEnabled() {
        return this.changeRequestViewEnabled;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

