/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.organizerUI.internal;

import com.sap.cms.organizerUI.exception.CalculatePredecessorException;
import com.sap.cms.util.exception.CMSUnexpectedException;
import com.sap.cms.util.logging.CmsLogger;
import com.sap.ide.login.UserValidator;
import com.tssap.dtr.client.eclipse.vfs.ClosedActivityWrapper;
import com.tssap.dtr.client.lib.propagation.PropagationManager;
import com.tssap.dtr.client.lib.propagation.clientapi.IPropagator;
import com.tssap.dtr.client.lib.propagation.clientapi.PropagationException;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import com.tssap.dtr.client.lib.protocol.ISessionContext;
import com.tssap.dtr.client.lib.protocol.session.SessionContext;
import com.tssap.dtr.client.lib.protocol.ssl.IAIKSecureSocketProvider;
import com.tssap.dtr.client.lib.protocol.ssl.ISecureSocketProvider;
import com.tssap.dtr.client.lib.protocol.templates.ConnectionTemplate;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.net.MalformedURLException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

public class PropagationPredecessorProvider {
    private static final CmsLogger log = CmsLogger.getLogger((String)(class$com$sap$cms$organizerUI$internal$PropagationPredecessorProvider == null ? (class$com$sap$cms$organizerUI$internal$PropagationPredecessorProvider = PropagationPredecessorProvider.class$("com.sap.cms.organizerUI.internal.PropagationPredecessorProvider")) : class$com$sap$cms$organizerUI$internal$PropagationPredecessorProvider).getName());
    private IPropagator propagationManager = null;
    private Map cache = null;
    static /* synthetic */ Class class$com$sap$cms$organizerUI$internal$PropagationPredecessorProvider;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PropagationPredecessorProvider(IVfsWorkspace workspace) {
        log.entering("Constructor(" + workspace + ")");
        try {
            try {
                String url = workspace.getRepository().getUrl();
                log.debug("DTR server URL: " + url);
                String user = UserValidator.getDefaultServerData().getUser();
                String password = UserValidator.getDefaultServerData().getPassword();
                KeyStore truststore = UserValidator.getKeyStore();
                ConnectionTemplate template = new ConnectionTemplate();
                template.setUrl(url);
                SessionContext context = new SessionContext();
                context.setUser(user);
                context.setPassword(password);
                context.setAuthenticator("BASIC");
                template.setSessionContext((ISessionContext)context);
                IAIKSecureSocketProvider socketProvider = new IAIKSecureSocketProvider(truststore);
                template.setSecureSocketProvider((ISecureSocketProvider)socketProvider);
                this.propagationManager = new PropagationManager((IConnectionTemplate)template);
            }
            catch (MalformedURLException ex) {
                log.error("PropagationManager could not be initialized", (Throwable)ex);
                Object var10_12 = null;
                log.exiting("Constructor");
                return;
            }
            catch (NoSuchAlgorithmException ex) {
                log.error("PropagationManager could not be initialized", (Throwable)ex);
                Object var10_13 = null;
                log.exiting("Constructor");
                return;
            }
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            log.exiting("Constructor");
            throw throwable;
        }
        log.exiting("Constructor");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ClosedActivityWrapper[] findPredecessorActivities(ClosedActivityWrapper[] activities, IVfsWorkspace workspace) throws CalculatePredecessorException {
        ClosedActivityWrapper[] closedActivityWrapperArray;
        block14: {
            ClosedActivityWrapper[] closedActivityWrapperArray2;
            block13: {
                log.entering("findPredecessorActivities(activities, workspace)");
                if (activities == null) {
                    throw new CMSUnexpectedException("activities is null");
                }
                if (workspace == null) {
                    throw new CMSUnexpectedException("workspace is null");
                }
                if (this.propagationManager == null) {
                    log.error("propagationManager is null");
                    throw new CalculatePredecessorException("CalculatePredecessorException_NoPropagationManager", null);
                }
                try {
                    try {
                        String[] predecessors;
                        log.debug("Workspace: " + workspace.getAbsoluteRemotePath());
                        String[] urls = new String[activities.length];
                        int i = 0;
                        while (true) {
                            if (i >= activities.length) {
                                predecessors = this.propagationManager.getPropagationPredecessors(workspace.getAbsoluteRemotePath(), urls, -1);
                                if (predecessors != null && predecessors.length != 0) break;
                                log.debug("No predecessors found!");
                                closedActivityWrapperArray2 = null;
                                Object var11_10 = null;
                                break block13;
                            }
                            urls[i] = activities[i].getUrl();
                            log.debug("Activity[" + i + "]: " + urls[i]);
                            ++i;
                        }
                        ClosedActivityWrapper[] predecessorActivities = new ClosedActivityWrapper[predecessors.length];
                        IVfsActivity activity = null;
                        int i2 = 0;
                        while (true) {
                            if (i2 >= predecessors.length) {
                                closedActivityWrapperArray = predecessorActivities;
                                break block14;
                            }
                            log.info("Predecessor[" + i2 + "](URL)=" + predecessors[i2]);
                            activity = workspace.getRepository().getActivityByName(this.getNameFromURL(predecessors[i2]));
                            if (activity == null) {
                                log.error("Activity[" + i2 + "] is null!");
                                throw new CalculatePredecessorException("CalculatePredecessorException_NullPredecessorActivity", null);
                            }
                            log.info("Predecessor[" + i2 + "](Name)=" + activity.getDisplayName());
                            predecessorActivities[i2] = new ClosedActivityWrapper(activity, workspace);
                            ++i2;
                        }
                    }
                    catch (PropagationException ex) {
                        log.error("Predecessors could not be determined!", (Throwable)ex);
                        throw new CalculatePredecessorException(ex);
                    }
                    catch (VfsException ex) {
                        log.error("Activity not found!", (Throwable)ex);
                        throw new CalculatePredecessorException(ex);
                    }
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    log.exiting("findPredecessorActivities(activities, workspace)");
                    throw throwable;
                }
            }
            log.exiting("findPredecessorActivities(activities, workspace)");
            return closedActivityWrapperArray2;
        }
        Object var11_11 = null;
        log.exiting("findPredecessorActivities(activities, workspace)");
        return closedActivityWrapperArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ClosedActivityWrapper[] findPredecessorActivities(ClosedActivityWrapper activity, IVfsWorkspace workspace) throws CalculatePredecessorException {
        ClosedActivityWrapper[] closedActivityWrapperArray;
        block7: {
            ClosedActivityWrapper[] closedActivityWrapperArray2;
            block6: {
                log.entering("findPredecessorActivities(activity, workspace)");
                if (this.cache == null) {
                    this.cache = new HashMap();
                }
                try {
                    try {
                        String objectID = activity.activity.getObjectID();
                        if (this.cache.containsKey(objectID)) {
                            closedActivityWrapperArray2 = (ClosedActivityWrapper[])this.cache.get(objectID);
                            Object var8_7 = null;
                            break block6;
                        }
                        ClosedActivityWrapper[] activityArray = new ClosedActivityWrapper[]{activity};
                        ClosedActivityWrapper[] returnValue = this.findPredecessorActivities(activityArray, workspace);
                        this.cache.put(objectID, returnValue);
                        closedActivityWrapperArray = returnValue;
                        break block7;
                    }
                    catch (VfsException ex) {
                        log.error("Retrieving of object ID from activity failed", (Throwable)ex);
                        throw new CalculatePredecessorException(ex);
                    }
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    log.exiting("findPredecessorActivities()");
                    throw throwable;
                }
            }
            log.exiting("findPredecessorActivities()");
            return closedActivityWrapperArray2;
        }
        Object var8_8 = null;
        log.exiting("findPredecessorActivities()");
        return closedActivityWrapperArray;
    }

    public void emptyCache() {
        log.entering("emptyCache()");
        this.cache.clear();
        this.cache = null;
        log.exiting("emptyCache");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getNameFromURL(String url) {
        log.entering("getNameFromURL(" + url + ")");
        String returnValue = null;
        try {
            try {
                int separator1 = 47;
                int separator2 = 92;
                int index1 = url.lastIndexOf(separator1);
                int index2 = url.lastIndexOf(separator2);
                returnValue = url.substring(Math.max(index1, index2) + 1);
            }
            catch (Exception ex) {
                log.error("Get name from URL failed", (Throwable)ex);
                Object var8_9 = null;
                log.exiting("getNameFromURL: " + returnValue);
                return returnValue;
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            log.exiting("getNameFromURL: " + returnValue);
            throw throwable;
        }
        log.exiting("getNameFromURL: " + returnValue);
        return returnValue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

