/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.organizerUI.internal;

import com.sap.cms.client.connection.CMSConnectionFactory;
import com.sap.cms.client.connection.ICMSConnectionIdentifier;
import com.sap.cms.client.connection.ICMSConnectionPool;
import com.sap.cms.client.connection.ICMSConnectionPrincipal;
import com.sap.cms.client.connector.CMSConnectorException;
import com.sap.cms.client.organizerAPI.CMSTransportOrganizerAPI;
import com.sap.cms.client.organizerAPI.CMSTransportOrganizerIF;
import com.sap.cms.client.release.ReleaseAPI;
import com.sap.cms.client.release.ReleaseAPIFactory;
import com.sap.cms.organizerUI.exception.CMSAPICreateException;
import com.sap.cms.util.exception.client.CMSClientCreateAPIException;
import com.sap.cms.util.logging.CmsLogger;
import com.sap.ide.login.UserValidator;
import com.tssap.dtr.client.lib.protocol.IAuthenticator;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import com.tssap.dtr.client.lib.protocol.ISessionContext;
import com.tssap.dtr.client.lib.protocol.URL;
import com.tssap.dtr.client.lib.protocol.session.BasicAuthenticator;
import com.tssap.dtr.client.lib.protocol.session.SessionContext;
import com.tssap.dtr.client.lib.protocol.templates.ConnectionTemplate;
import java.net.MalformedURLException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.HashMap;
import java.util.Map;

public class CMSAPIFactory {
    private static final CmsLogger log = CmsLogger.getLogger((String)(class$com$sap$cms$organizerUI$internal$CMSAPIFactory == null ? (class$com$sap$cms$organizerUI$internal$CMSAPIFactory = CMSAPIFactory.class$("com.sap.cms.organizerUI.internal.CMSAPIFactory")) : class$com$sap$cms$organizerUI$internal$CMSAPIFactory).getName());
    private static CMSAPIFactory instance = null;
    private final ICMSConnectionPool pool;
    private final Map connectionTemplates;
    static /* synthetic */ Class class$com$sap$cms$organizerUI$internal$CMSAPIFactory;

    protected CMSAPIFactory() {
        log.entering("Constructor");
        this.pool = CMSConnectionFactory.createConnectionPool((String)"organizerPool");
        this.connectionTemplates = new HashMap();
        log.exiting("Constructor");
    }

    public static synchronized CMSAPIFactory getInstance() {
        log.entering("getInstance");
        if (instance == null) {
            instance = new CMSAPIFactory();
        }
        log.exiting("getInstance");
        return instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CMSTransportOrganizerIF createCMSAPI(String cmsServer) throws CMSAPICreateException {
        CMSTransportOrganizerAPI cMSTransportOrganizerAPI;
        log.entering("createCMSAPI", new Object[]{cmsServer});
        CMSTransportOrganizerAPI api = null;
        try {
            try {
                String user = UserValidator.getDefaultServerData().getUser();
                String password = UserValidator.getDefaultServerData().getPassword();
                KeyStore truststore = UserValidator.getKeyStore();
                ConnectionTemplate connectionTemplate = new ConnectionTemplate();
                connectionTemplate.setUrl(cmsServer);
                SessionContext ctx = new SessionContext(user, password);
                BasicAuthenticator auth = new BasicAuthenticator((ISessionContext)ctx);
                ctx.setAuthenticator((IAuthenticator)auth);
                if (truststore != null) {
                    ctx.certificates().setAuthenticateThem(true);
                    ctx.certificates().setServerCertificates(truststore);
                }
                connectionTemplate.setSessionContext((ISessionContext)ctx);
                connectionTemplate.setSocketReadTimeout(60000);
                cMSTransportOrganizerAPI = api = new CMSTransportOrganizerAPI((IConnectionTemplate)connectionTemplate);
                Object var11_13 = null;
            }
            catch (CMSConnectorException e) {
                log.error((Throwable)e);
                throw new CMSAPICreateException(e);
            }
            catch (KeyStoreException e) {
                log.error((Throwable)e);
                throw new CMSAPICreateException(e);
            }
            catch (MalformedURLException e1) {
                log.error((Throwable)e1);
                throw new CMSAPICreateException("CMSAPICreateException_MalformedURL", cmsServer);
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            log.exiting("createCMSAPI", api);
            throw throwable;
        }
        log.exiting("createCMSAPI", (Object)api);
        return cMSTransportOrganizerAPI;
    }

    public ReleaseAPI createReleaseAPI(String cmsServer, int readTimeout) throws CMSClientCreateAPIException, MalformedURLException, KeyStoreException {
        ReleaseAPI releaseAPI;
        log.entering("createReleaseAPI", new Object[]{cmsServer, new Integer(readTimeout)});
        ReleaseAPI releaseAPI2 = null;
        try {
            int id;
            KeyStore truststore = UserValidator.getKeyStore();
            TemplateKey templateKey = new TemplateKey(cmsServer, readTimeout, truststore);
            String user = UserValidator.getDefaultServerData().getUser();
            String password = UserValidator.getDefaultServerData().getPassword();
            if (this.connectionTemplates.containsKey(templateKey)) {
                id = (Integer)this.connectionTemplates.get(templateKey);
            } else {
                URL url = new URL(cmsServer);
                ConnectionTemplate template = new ConnectionTemplate(cmsServer);
                ISessionContext ctx = template.getSessionContext();
                if ("https".equalsIgnoreCase(url.getProtocol()) && truststore != null) {
                    ctx.certificates().setAuthenticateThem(true);
                    ctx.certificates().setServerCertificates(truststore);
                }
                template.setSocketReadTimeout(readTimeout);
                id = this.pool.addConnectionTemplate((IConnectionTemplate)template);
                this.connectionTemplates.put(templateKey, new Integer(id));
            }
            ICMSConnectionPrincipal principal = CMSConnectionFactory.createConnectionPrincipal((String)user, (String)password);
            ICMSConnectionIdentifier connectionID = CMSConnectionFactory.createConnectionIdentifier((int)id, (ICMSConnectionPool)this.pool, (ICMSConnectionPrincipal)principal);
            releaseAPI = releaseAPI2 = ReleaseAPIFactory.getInstance().createReleaseAPI(connectionID);
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            log.exiting("createReleaseAPI", releaseAPI2);
            throw throwable;
        }
        log.exiting("createReleaseAPI", (Object)releaseAPI2);
        return releaseAPI;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TemplateKey {
        private final String url;
        private final int readTimeout;
        private final KeyStore keyStore;

        public TemplateKey(String url, int readTimeout, KeyStore keyStore) {
            this.url = url;
            this.readTimeout = readTimeout;
            this.keyStore = keyStore;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof TemplateKey)) {
                return false;
            }
            TemplateKey tk = (TemplateKey)obj;
            return this.readTimeout == tk.readTimeout && (this.url == null && tk.url == null || this.url != null && this.url.equalsIgnoreCase(tk.url)) && (this.keyStore == null && tk.keyStore == null || this.keyStore != null && this.keyStore.equals(tk.keyStore));
        }

        public int hashCode() {
            if (this.url == null) {
                if (this.keyStore == null) {
                    return this.readTimeout;
                }
                return this.readTimeout ^ this.keyStore.hashCode();
            }
            if (this.keyStore == null) {
                return this.readTimeout ^ this.url.hashCode();
            }
            return this.readTimeout ^ this.keyStore.hashCode() ^ this.url.hashCode();
        }
    }
}

