/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.organizerUI.internal;

import com.sap.cms.client.connector.CMSConnectorException;
import com.sap.cms.client.release.ReleaseAPI;
import com.sap.cms.client.types.CMSChangeList;
import com.sap.cms.client.types.RequestID;
import com.sap.cms.organizerUI.CMSOrganizerPlugin;
import com.sap.cms.organizerUI.exception.ReleaseActivityException;
import com.sap.cms.organizerUI.exception.ReleaseActivityTimeoutException;
import com.sap.cms.organizerUI.internal.CMSAPIFactory;
import com.sap.cms.util.exception.CMSUEBaseException;
import com.sap.cms.util.exception.CMSUnexpectedException;
import com.sap.cms.util.exception.client.CMSClientVersionConflictException;
import com.sap.cms.util.exception.misc.CMSPermissionDeniedException;
import com.sap.cms.util.exception.misc.PCSTransactionException;
import com.sap.cms.util.exception.organizer.CMSOFileAccessException;
import com.sap.cms.util.exception.organizer.CMSOInvalidParameterException;
import com.sap.cms.util.exception.request.CmsChangelistCreateException;
import com.sap.cms.util.exception.request.CmsChangelistUpdateException;
import com.sap.cms.util.exception.request.CmsRequestCreateException;
import com.sap.cms.util.exception.request.CmsRequestUpdateException;
import com.sap.cms.util.logging.CmsLogger;
import com.sap.ide.login.UserValidator;
import com.tssap.dtr.client.eclipse.vfs.ClosedActivityWrapper;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.io.InterruptedIOException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class ActivityReleaser {
    private static final CmsLogger log = CmsLogger.getLogger((String)(class$com$sap$cms$organizerUI$internal$ActivityReleaser == null ? (class$com$sap$cms$organizerUI$internal$ActivityReleaser = ActivityReleaser.class$("com.sap.cms.organizerUI.internal.ActivityReleaser")) : class$com$sap$cms$organizerUI$internal$ActivityReleaser).getName());
    static /* synthetic */ Class class$com$sap$cms$organizerUI$internal$ActivityReleaser;

    public void releaseActivities(List activities, ClosedActivityWrapper[] predecessorActivities, IVfsWorkspace workspace, String caption) throws ReleaseActivityException {
        log.entering("releaseActivities");
        try {
            try {
                if (activities == null || activities.isEmpty()) {
                    log.error("List of activities is empty");
                    throw new CMSUnexpectedException("No activities to release!");
                }
                if (workspace == null) {
                    log.error("Workspace is null");
                    throw new CMSUnexpectedException("Workspace is null!");
                }
                String cmsWorkspaceId = workspace.getProperty("XCM:cms-workspace-name").getValue();
                String cmsServer = null;
                try {
                    cmsServer = CMSOrganizerPlugin.getDefault().getCMSServerURL(workspace);
                }
                catch (Exception ex) {
                    log.error("Getting of CMS server URL failed", (Throwable)ex);
                    throw new CMSUnexpectedException("Getting of CMS Server URL failed");
                }
                log.debug("CMS Server = " + cmsServer);
                ClosedActivityWrapper activity = null;
                Vector<CMSChangeList> changelist = new Vector<CMSChangeList>();
                Object obj = null;
                Iterator it = activities.iterator();
                while (it.hasNext()) {
                    obj = it.next();
                    if (!(obj instanceof ClosedActivityWrapper)) {
                        throw new CMSUnexpectedException("Element is no activity but " + obj.getClass().getName());
                    }
                    activity = (ClosedActivityWrapper)obj;
                    changelist.add(new CMSChangeList(activity.activity.getObjectID(), activity.activity.getDisplayName(), null, activity.activity.getAuthor()));
                }
                if (predecessorActivities != null) {
                    IVfsActivity act = null;
                    int i = 0;
                    while (i < predecessorActivities.length) {
                        act = predecessorActivities[i].activity;
                        changelist.add(new CMSChangeList(act.getObjectID(), act.getDisplayName(), null, act.getAuthor()));
                        ++i;
                    }
                }
                String user = UserValidator.getDefaultServerData().getUser();
                log.info("Release: CMS workspaceId...: " + cmsWorkspaceId);
                log.info("Release: Request owner.....: " + user);
                log.info("Release: Request caption...: " + caption);
                CMSChangeList cl = null;
                int i = 0;
                while (i < changelist.size()) {
                    cl = (CMSChangeList)changelist.get(i);
                    log.info("Release: activity[" + i + "] : " + cl.getName() + "(" + cl.getCaption() + ")");
                    ++i;
                }
                ReleaseAPI releaseAPI = CMSAPIFactory.getInstance().createReleaseAPI(cmsServer, 60000);
                RequestID requestId = releaseAPI.releaseNewChangeRequest(caption, cmsWorkspaceId, null, changelist.toArray(new CMSChangeList[changelist.size()]));
                log.info("Change request '" + caption + "' released for transport with request id " + requestId.toLogString());
            }
            catch (VfsException e) {
                throw new ReleaseActivityException(e);
            }
            catch (CMSOFileAccessException e) {
                throw new ReleaseActivityException(e);
            }
            catch (PCSTransactionException e) {
                throw new ReleaseActivityException(e);
            }
            catch (CMSOInvalidParameterException e) {
                throw new ReleaseActivityException(e);
            }
            catch (CmsRequestUpdateException e) {
                throw new ReleaseActivityException(e);
            }
            catch (CmsRequestCreateException e) {
                throw new ReleaseActivityException(e);
            }
            catch (CmsChangelistUpdateException e) {
                throw new ReleaseActivityException(e);
            }
            catch (CmsChangelistCreateException e) {
                throw new ReleaseActivityException(e);
            }
            catch (CMSPermissionDeniedException e) {
                throw new ReleaseActivityException("ReleaseActivityException_PermissionDenied", null, e);
            }
            catch (CMSConnectorException e) {
                Throwable cause = e.getCause();
                if (cause instanceof InterruptedIOException) {
                    log.warning("Interrupted IO exception", cause);
                    throw new ReleaseActivityTimeoutException(cause);
                }
                throw new ReleaseActivityException(e);
            }
            catch (CMSUEBaseException e) {
                log.error("CMSUEBaseException: ", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                throw new ReleaseActivityException(e);
            }
            Object var18_30 = null;
        }
        catch (Throwable throwable) {
            Object var18_31 = null;
            log.exiting("releaseActivities");
            throw throwable;
        }
        log.exiting("releaseActivities");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasPermissionToReleaseForeignActivities(IVfsWorkspace workspace) {
        log.entering("hasPermissionToReleaseForeignActivities", new Object[]{workspace});
        boolean isAllowed = true;
        try {
            try {
                if (workspace == null) {
                    log.error("Workspace is null");
                    throw new CMSUnexpectedException("Workspace is null!");
                }
                String cmsWorkspaceId = workspace.getProperty("XCM:cms-workspace-name").getValue();
                String cmsServer = CMSOrganizerPlugin.getDefault().getCMSServerURL(workspace);
                log.debug("CMS Server = " + cmsServer);
                ReleaseAPI releaseAPI = CMSAPIFactory.getInstance().createReleaseAPI(cmsServer, 30000);
                isAllowed = releaseAPI.isForeignReleaseAllowed(cmsWorkspaceId);
            }
            catch (CMSClientVersionConflictException e) {
                log.warning("Server too old - method isForeignReleaseAllowed does not exist", (Throwable)e);
                Object var7_9 = null;
                log.exiting("hasPermissionToReleaseForeignActivities", (Object)new Boolean(isAllowed));
                return isAllowed;
            }
            catch (Exception e) {
                log.warning("Exception during determination of permissions", (Throwable)e);
                Object var7_10 = null;
                log.exiting("hasPermissionToReleaseForeignActivities", (Object)new Boolean(isAllowed));
                return isAllowed;
            }
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            log.exiting("hasPermissionToReleaseForeignActivities", (Object)new Boolean(isAllowed));
            throw throwable;
        }
        log.exiting("hasPermissionToReleaseForeignActivities", (Object)new Boolean(isAllowed));
        return isAllowed;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

