/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.organizerUI.actions;

import com.sap.cms.client.connector.CMSConnectorException;
import com.sap.cms.client.organizerAPI.CMSTransportOrganizerIF;
import com.sap.cms.client.types.CMSChangeRequest;
import com.sap.cms.organizerUI.CMSChangeRequestNode;
import com.sap.cms.organizerUI.CMSOrganizerPlugin;
import com.sap.cms.organizerUI.CMSTransportNode;
import com.sap.cms.organizerUI.actions.TransportViewAction;
import com.sap.cms.organizerUI.exception.CMSAPICreateException;
import com.sap.cms.organizerUI.internal.CMSAPIFactory;
import com.sap.cms.organizerUI.internal.TransportViewRepository;
import com.sap.cms.util.TextUtils;
import com.sap.cms.util.exception.CMSUEBaseException;
import com.sap.cms.util.exception.CMSUnexpectedException;
import com.sap.cms.util.exception.misc.CMSPermissionDeniedException;
import com.sap.cms.util.exception.misc.PCSTransactionException;
import com.sap.cms.util.exception.organizer.CMSOGetRequestCounterException;
import com.sap.cms.util.exception.organizer.CMSOGetResultException;
import com.sap.cms.util.exception.request.CmsRequestNotFoundException;
import com.sap.cms.util.logging.CmsLogger;
import com.sap.cms.util.request.CmsRequestTool;
import com.tssap.dtr.client.eclipse.vfs.ClosedActivityWrapper;
import com.tssap.dtr.client.lib.util.Platform;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class ViewExportLogAction
extends TransportViewAction
implements IViewActionDelegate {
    private static final CmsLogger log = CmsLogger.getLogger((String)(class$com$sap$cms$organizerUI$actions$ViewExportLogAction == null ? (class$com$sap$cms$organizerUI$actions$ViewExportLogAction = ViewExportLogAction.class$("com.sap.cms.organizerUI.actions.ViewExportLogAction")) : class$com$sap$cms$organizerUI$actions$ViewExportLogAction).getName());
    private static final String DIALOG_TITLE = "Display export log";
    static /* synthetic */ Class class$com$sap$cms$organizerUI$actions$ViewExportLogAction;

    public ViewExportLogAction() {
        log.entering("Constructor()");
        log.exiting("Constructor");
    }

    protected boolean runWithinWorkerThread() {
        log.entering("runWithinWorkerThread()");
        log.exiting("runWithinWorkerThread: false");
        return false;
    }

    protected boolean allowedMultipleSelection() {
        log.entering("allowedMultipleSelection()");
        log.exiting("allowedMultipleSelection: false");
        return false;
    }

    public void init(IViewPart arg0) {
        log.entering("init(" + arg0 + ")");
        this.m_targetPart = arg0;
        log.exiting("init");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isEnabled(IStructuredSelection selection) {
        boolean bl;
        boolean enable;
        block15: {
            boolean bl2;
            block14: {
                boolean bl3;
                block13: {
                    boolean bl4;
                    block12: {
                        boolean bl5;
                        block11: {
                            boolean bl6;
                            block10: {
                                boolean bl7;
                                block9: {
                                    log.entering("isEnabled(" + selection + ")");
                                    enable = false;
                                    try {
                                        if (!TransportViewRepository.getInstance().isChangeRequestViewEnabled()) {
                                            bl7 = enable = this.isEnabledOld(selection);
                                            Object var7_7 = null;
                                            break block9;
                                        }
                                        if (selection == null || selection.isEmpty()) {
                                            log.debug("Selection is null or empty");
                                            bl6 = enable;
                                            break block10;
                                        }
                                        if (selection.size() > 1) {
                                            log.debug("View log action not allowed for more than one selected change request.");
                                            bl5 = enable;
                                            break block11;
                                        }
                                        Object selected = selection.getFirstElement();
                                        if (!(selected instanceof CMSChangeRequestNode)) {
                                            log.debug("Selected item is no change request: " + selected);
                                            bl4 = enable;
                                            break block12;
                                        }
                                        Object[] parents = this.getParentObjectForTreeSelection(selected, 1);
                                        if (parents != null && parents.length > 0 && parents[0] instanceof CMSTransportNode) {
                                            if (((CMSTransportNode)parents[0]).getType() != 2) {
                                                log.debug("Change request " + selection + " is not failed");
                                                bl3 = enable;
                                                break block13;
                                            }
                                        } else {
                                            log.debug("CR parent node is null or no transport node");
                                            bl2 = enable;
                                            break block14;
                                        }
                                        bl = enable = true;
                                        break block15;
                                    }
                                    catch (Throwable throwable) {
                                        Object var7_14 = null;
                                        log.exiting("isEnabled: " + enable);
                                        throw throwable;
                                    }
                                }
                                log.exiting("isEnabled: " + enable);
                                return bl7;
                            }
                            Object var7_8 = null;
                            log.exiting("isEnabled: " + enable);
                            return bl6;
                        }
                        Object var7_9 = null;
                        log.exiting("isEnabled: " + enable);
                        return bl5;
                    }
                    Object var7_10 = null;
                    log.exiting("isEnabled: " + enable);
                    return bl4;
                }
                Object var7_11 = null;
                log.exiting("isEnabled: " + enable);
                return bl3;
            }
            Object var7_12 = null;
            log.exiting("isEnabled: " + enable);
            return bl2;
        }
        Object var7_13 = null;
        log.exiting("isEnabled: " + enable);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isEnabledOld(IStructuredSelection selection) {
        boolean bl;
        boolean enable;
        block13: {
            boolean bl2;
            block12: {
                boolean bl3;
                block11: {
                    boolean bl4;
                    block10: {
                        boolean bl5;
                        block9: {
                            boolean bl6;
                            block8: {
                                log.entering("isEnabledOld(" + selection + ")");
                                enable = false;
                                try {
                                    if (selection == null || selection.isEmpty()) {
                                        log.debug("Selection is null or empty");
                                        bl6 = enable;
                                        Object var7_6 = null;
                                        break block8;
                                    }
                                    if (selection.size() > 1) {
                                        log.debug("View log activity not allowed for more than one selected activity.");
                                        bl5 = enable;
                                        break block9;
                                    }
                                    Object activity = selection.getFirstElement();
                                    if (!(activity instanceof ClosedActivityWrapper)) {
                                        log.debug("Selected item is not an activity");
                                        bl4 = enable;
                                        break block10;
                                    }
                                    Object[] parents = this.getParentObjectForTreeSelection(activity, 1);
                                    if (parents != null && parents.length > 0 && parents[0] instanceof CMSTransportNode) {
                                        if (!((CMSTransportNode)parents[0]).isTransported()) {
                                            log.debug("Activity not transported yet");
                                            bl3 = enable;
                                            break block11;
                                        }
                                    } else {
                                        log.debug("Activity parent node is null or no transport node");
                                        bl2 = enable;
                                        break block12;
                                    }
                                    bl = enable = true;
                                    break block13;
                                }
                                catch (Throwable throwable) {
                                    Object var7_12 = null;
                                    log.exiting("isEnabledOld: " + enable);
                                    throw throwable;
                                }
                            }
                            log.exiting("isEnabledOld: " + enable);
                            return bl6;
                        }
                        Object var7_7 = null;
                        log.exiting("isEnabledOld: " + enable);
                        return bl5;
                    }
                    Object var7_8 = null;
                    log.exiting("isEnabledOld: " + enable);
                    return bl4;
                }
                Object var7_9 = null;
                log.exiting("isEnabledOld: " + enable);
                return bl3;
            }
            Object var7_10 = null;
            log.exiting("isEnabledOld: " + enable);
            return bl2;
        }
        Object var7_11 = null;
        log.exiting("isEnabledOld: " + enable);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execute(IStructuredSelection selection, IAction action, IVfsProgressMonitor moni) {
        log.entering("execute(" + selection + ", " + action + ", " + moni + ")");
        if (!TransportViewRepository.getInstance().isChangeRequestViewEnabled()) {
            this.executeOld(selection, action, moni);
            return;
        }
        try {
            try {
                if (action == null || !action.getId().equalsIgnoreCase("com.sap.cms.organizerUI.actions.ShowExportLogAction")) {
                    log.error("wrong action " + action);
                    throw new CMSUnexpectedException("Wrong action: " + action);
                }
                if (selection == null || selection.isEmpty()) {
                    log.error("Selection is null or empty");
                    throw new CMSUnexpectedException("No activity selected");
                }
                if (selection.size() > 1) {
                    log.error("View log not allowed for more than one selected change request.");
                    throw new CMSUnexpectedException("More than one change request selected");
                }
                Object selected = selection.getFirstElement();
                if (selected == null) {
                    log.error("Selected element is null");
                    throw new CMSUnexpectedException("Selected element is null");
                }
                if (!(selected instanceof CMSChangeRequestNode)) {
                    log.error("Selection is no change request:" + selected);
                    throw new CMSUnexpectedException("Selection is no change request node");
                }
                CMSChangeRequestNode changeRequestNode = (CMSChangeRequestNode)selected;
                IVfsWorkspace workspace = changeRequestNode.getTransportNode().getWorkspace();
                CMSChangeRequest changeRequest = changeRequestNode.getRequest();
                String changeRequestCaption = changeRequest.getCaption();
                String changeRequestID = CmsRequestTool.requestKeyToId((String)changeRequest.getComponent().getName(), (String)changeRequest.getComponent().getVendor(), (String)changeRequest.getVersion().getLocation(), (long)changeRequest.getVersion().getCounter());
                String cmsWorkspaceId = workspace.getProperty("XCM:cms-workspace-name").getValue();
                log.debug("workspace = " + cmsWorkspaceId + ", change request = " + changeRequestCaption);
                String cmsServer = null;
                try {
                    cmsServer = CMSOrganizerPlugin.getDefault().getCMSServerURL(workspace);
                    log.debug("CMS Server = " + cmsServer);
                }
                catch (Exception e) {
                    log.error("get CMS Server URL failed" + e);
                    throw new CMSUnexpectedException("Getting of CMS Server URL failed");
                }
                CMSTransportOrganizerIF cmsTransportOrganizer = null;
                cmsTransportOrganizer = CMSAPIFactory.getInstance().createCMSAPI(cmsServer);
                this.displayExportLog(cmsTransportOrganizer, cmsWorkspaceId, changeRequestID, changeRequestCaption, cmsServer);
            }
            catch (VfsException e) {
                log.error("get activity/workspace properties failed", (Throwable)e);
                MessageDialog.openError((Shell)new Shell(), (String)DIALOG_TITLE, (String)("Error while getting change request information from DTR:\n" + e.getMessage()));
                Object var14_18 = null;
                log.exiting("execute");
                return;
            }
            catch (CMSAPICreateException ex) {
                log.error((Throwable)((Object)ex));
                MessageDialog.openError((Shell)new Shell(), (String)DIALOG_TITLE, (String)ex.getMessage());
                Object var14_19 = null;
                log.exiting("execute");
                return;
            }
            catch (Exception e) {
                log.error("Unexpected exception", (Throwable)e);
                MessageDialog.openError((Shell)new Shell(), (String)DIALOG_TITLE, (String)e.getMessage());
                Object var14_20 = null;
                log.exiting("execute");
                return;
            }
            Object var14_17 = null;
        }
        catch (Throwable throwable) {
            Object var14_21 = null;
            log.exiting("execute");
            throw throwable;
        }
        log.exiting("execute");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void executeOld(IStructuredSelection selection, IAction action, IVfsProgressMonitor moni) {
        block16: {
            block15: {
                log.entering("executeOld(" + selection + ", " + action + ", " + moni + ")");
                try {
                    try {
                        if (action == null || !action.getId().equalsIgnoreCase("com.sap.cms.organizerUI.actions.ShowExportLogAction")) {
                            log.error("wrong action " + action);
                            throw new CMSUnexpectedException("Wrong action: " + action);
                        }
                        if (selection == null || selection.isEmpty()) {
                            log.error("Selection is null or empty");
                            throw new CMSUnexpectedException("No activity selected");
                        }
                        if (selection.size() > 1) {
                            log.error("View log activity not allowed for more than one selected activity.");
                            throw new CMSUnexpectedException("More than one activity selected");
                        }
                        Object selected = selection.getFirstElement();
                        if (selected == null) {
                            log.error("Selected element is null");
                            throw new CMSUnexpectedException("Selected element is null");
                        }
                        if (!(selected instanceof ClosedActivityWrapper)) {
                            log.error("Selection is no activity:" + selected);
                            throw new CMSUnexpectedException("Selection is no activity");
                        }
                        ClosedActivityWrapper closedActivityWrapper = (ClosedActivityWrapper)selected;
                        IVfsActivity activity = closedActivityWrapper.activity;
                        IVfsWorkspace workspace = closedActivityWrapper.workspace;
                        String displayName = activity.getDisplayName();
                        String changeRequest = activity.getProperty("XCM:propagation-request-id").getValue();
                        String cmsWorkspaceId = workspace.getProperty("XCM:cms-workspace-name").getValue();
                        log.debug("workspace = " + cmsWorkspaceId + ", displayName = " + displayName + ", propagation request = " + changeRequest);
                        if (changeRequest == null || changeRequest.equals("")) {
                            log.warning("activity '" + displayName + "' is not yet released - display logs not possible");
                            MessageDialog.openWarning((Shell)new Shell(), (String)DIALOG_TITLE, (String)("Activity '" + displayName + "' is not released yet, no export log available"));
                            Object var14_14 = null;
                            break block15;
                        }
                        String cmsServer = null;
                        try {
                            cmsServer = CMSOrganizerPlugin.getDefault().getCMSServerURL(workspace);
                            log.debug("CMS Server = " + cmsServer);
                        }
                        catch (Exception e) {
                            log.error("get CMS Server URL failed" + e);
                            throw new CMSUnexpectedException("Getting of CMS Server URL failed");
                        }
                        CMSTransportOrganizerIF cmsTransportOrganizer = null;
                        cmsTransportOrganizer = CMSAPIFactory.getInstance().createCMSAPI(cmsServer);
                        this.displayExportLog(cmsTransportOrganizer, cmsWorkspaceId, changeRequest, displayName, cmsServer);
                        break block16;
                    }
                    catch (VfsException e) {
                        log.error("get activity/workspace properties failed", (Throwable)e);
                        MessageDialog.openError((Shell)new Shell(), (String)DIALOG_TITLE, (String)("Error while getting change request information from DTR:\n" + e.getMessage()));
                        Object var14_16 = null;
                        log.exiting("executeOld");
                        return;
                    }
                    catch (CMSAPICreateException ex) {
                        log.error((Throwable)((Object)ex));
                        MessageDialog.openError((Shell)new Shell(), (String)DIALOG_TITLE, (String)ex.getMessage());
                        Object var14_17 = null;
                        log.exiting("executeOld");
                        return;
                    }
                    catch (Exception e) {
                        log.error("Unexpected exception", (Throwable)e);
                        MessageDialog.openError((Shell)new Shell(), (String)DIALOG_TITLE, (String)e.getMessage());
                        Object var14_18 = null;
                        log.exiting("executeOld");
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var14_19 = null;
                    log.exiting("executeOld");
                    throw throwable;
                }
            }
            log.exiting("executeOld");
            return;
        }
        Object var14_15 = null;
        log.exiting("executeOld");
    }

    private void displayExportLog(final CMSTransportOrganizerIF cmsTransportOrganizer, final String cmsWorkspaceId, final String requestID, final String requestCaption, final String cmsServer) {
        log.entering("displayExportLog");
        log.debug("CMS server.........: " + cmsServer);
        log.debug("CMS workspaceId....: " + cmsWorkspaceId);
        log.debug("Change request id..: " + requestID);
        log.debug("Change request name: " + requestCaption);
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                block17: {
                    block16: {
                        log.entering("run");
                        try {
                            try {
                                String logFile = cmsTransportOrganizer.getExportLog002(requestID, cmsWorkspaceId, null);
                                log.debug("export log file of change request '" + requestCaption + "' = " + logFile);
                                if (logFile == null) {
                                    log.error("Log file is null");
                                    MessageDialog.openError((Shell)new Shell(), (String)ViewExportLogAction.DIALOG_TITLE, (String)"There is no log file for this change request.");
                                    Object var10_3 = null;
                                    break block16;
                                }
                                String logViewerURL = cmsServer + "/CMS/LogViewer" + "?LogName=" + TextUtils.hexEncodeForURI((String)logFile) + "&Req=" + TextUtils.hexEncodeForURI((String)requestCaption) + "&Step=" + "Export";
                                log.debug("CMS log viewer URL = " + logViewerURL);
                                while (true) {
                                    void var3_16;
                                    int index;
                                    if ((index = logViewerURL.indexOf(32)) == -1) {
                                        int returnCode = Platform.getPlatform().openWithDefaultApplication(logViewerURL);
                                        if (returnCode == -3) {
                                            log.error("openWithDefaultApplication returned error code -3");
                                            MessageDialog.openError((Shell)new Shell(), (String)ViewExportLogAction.DIALOG_TITLE, (String)"The external browser call failed.");
                                        }
                                        break block17;
                                    }
                                    logViewerURL = logViewerURL.substring(0, (int)var3_16) + "%20" + logViewerURL.substring((int)(var3_16 + true));
                                }
                            }
                            catch (CMSOGetResultException e) {
                                log.error("Propagation result could not be read", (Throwable)e);
                                MessageDialog.openError((Shell)new Shell(), (String)ViewExportLogAction.DIALOG_TITLE, (String)("The result of propagation request " + requestCaption + " could not be located."));
                                Object var10_5 = null;
                                log.exiting("run");
                                return;
                            }
                            catch (CMSOGetRequestCounterException e) {
                                log.error("Propagation request counter could not be calculated", (Throwable)e);
                                MessageDialog.openError((Shell)new Shell(), (String)ViewExportLogAction.DIALOG_TITLE, (String)("The counter of propagation request " + requestCaption + " could not be calculated."));
                                Object var10_6 = null;
                                log.exiting("run");
                                return;
                            }
                            catch (CmsRequestNotFoundException e) {
                                log.error("Propagation request could not be found", (Throwable)e);
                                MessageDialog.openError((Shell)new Shell(), (String)ViewExportLogAction.DIALOG_TITLE, (String)("The propagation request " + requestCaption + " could not be found."));
                                Object var10_7 = null;
                                log.exiting("run");
                                return;
                            }
                            catch (CMSPermissionDeniedException e) {
                                log.error("Permission denied", (Throwable)e);
                                MessageDialog.openError((Shell)new Shell(), (String)ViewExportLogAction.DIALOG_TITLE, (String)"You do not have sufficient access rights to view the export log.");
                                Object var10_8 = null;
                                log.exiting("run");
                                return;
                            }
                            catch (CMSConnectorException e) {
                                log.error("CMSConnectorException: ", (Throwable)e);
                                MessageDialog.openError((Shell)new Shell(), (String)ViewExportLogAction.DIALOG_TITLE, (String)e.getMessage());
                                Object var10_9 = null;
                                log.exiting("run");
                                return;
                            }
                            catch (PCSTransactionException e) {
                                log.error("PCSTransactionException: ", (Throwable)e);
                                MessageDialog.openError((Shell)new Shell(), (String)ViewExportLogAction.DIALOG_TITLE, (String)e.getMessage());
                                Object var10_10 = null;
                                log.exiting("run");
                                return;
                            }
                            catch (CMSUEBaseException e) {
                                log.error("CMSUEBaseException: ", (Throwable)e);
                                MessageDialog.openError((Shell)new Shell(), (String)ViewExportLogAction.DIALOG_TITLE, (String)("Internal error: " + ((Object)((Object)e)).getClass().getName() + "\n" + e.getMessage()));
                                Object var10_11 = null;
                                log.exiting("run");
                                return;
                            }
                            catch (Exception e) {
                                log.error("Exception", (Throwable)e);
                                MessageDialog.openError((Shell)new Shell(), (String)ViewExportLogAction.DIALOG_TITLE, (String)("Internal error: " + e.getClass().getName() + "\n" + e.getMessage()));
                                Object var10_12 = null;
                                log.exiting("run");
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var10_13 = null;
                            log.exiting("run");
                            throw throwable;
                        }
                    }
                    log.exiting("run");
                    return;
                }
                Object var10_4 = null;
                log.exiting("run");
            }
        });
        log.exiting("displayExportLog");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

