/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.organizerUI.actions;

import com.sap.cms.client.connector.CMSConnectorException;
import com.sap.cms.client.organizerAPI.CMSTransportOrganizerIF;
import com.sap.cms.client.types.CMSChangeList;
import com.sap.cms.client.types.CMSChangeRequest;
import com.sap.cms.client.types.RequestID;
import com.sap.cms.organizerUI.CMSChangeRequestNode;
import com.sap.cms.organizerUI.CMSOrganizerPlugin;
import com.sap.cms.organizerUI.CMSTransportNode;
import com.sap.cms.organizerUI.actions.TransportViewAction;
import com.sap.cms.organizerUI.exception.CMSAPICreateException;
import com.sap.cms.organizerUI.internal.CMSAPIFactory;
import com.sap.cms.organizerUI.internal.TransportViewRepository;
import com.sap.cms.organizerUI.ui.TransportView;
import com.sap.cms.util.exception.CMSUEBaseException;
import com.sap.cms.util.exception.CMSUnexpectedException;
import com.sap.cms.util.exception.PropMgr.CmsPropagationInvalidConfException;
import com.sap.cms.util.exception.PropMgr.CmsPropagationQueueItemExistsException;
import com.sap.cms.util.exception.client.CMSClientChangeRequestNotFoundException;
import com.sap.cms.util.exception.client.CMSClientCreateAPIException;
import com.sap.cms.util.exception.misc.CMSPermissionDeniedException;
import com.sap.cms.util.exception.misc.PCSTransactionException;
import com.sap.cms.util.exception.organizer.CMSOFileAccessException;
import com.sap.cms.util.exception.organizer.CMSOInvalidParameterException;
import com.sap.cms.util.exception.request.CmsChangelistUpdateException;
import com.sap.cms.util.exception.request.CmsRequestNotFoundException;
import com.sap.cms.util.exception.request.CmsRequestUpdateException;
import com.sap.cms.util.logging.CmsLogger;
import com.sap.cms.util.request.CmsRequestTool;
import com.tssap.dtr.client.eclipse.vfs.ClosedActivityWrapper;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class RestartExportActivityAction
extends TransportViewAction
implements IViewActionDelegate {
    private static final CmsLogger log = CmsLogger.getLogger((String)(class$com$sap$cms$organizerUI$actions$RestartExportActivityAction == null ? (class$com$sap$cms$organizerUI$actions$RestartExportActivityAction = RestartExportActivityAction.class$("com.sap.cms.organizerUI.actions.RestartExportActivityAction")) : class$com$sap$cms$organizerUI$actions$RestartExportActivityAction).getName());
    private static final String DIALOG_TITLE = "Restart export";
    static /* synthetic */ Class class$com$sap$cms$organizerUI$actions$RestartExportActivityAction;

    public RestartExportActivityAction() {
        log.entering("Constructor()");
        log.exiting("Constructor");
    }

    protected boolean runWithinWorkerThread() {
        log.entering("runWithinWorkerThread()");
        log.exiting("runWithinWorkerThread: false");
        return false;
    }

    protected boolean allowedMultipleSelection() {
        log.entering("allowedMultipleSelection()");
        log.exiting("allowedMultipleSelection: false");
        return false;
    }

    public void init(IViewPart arg0) {
        log.entering("init(" + arg0 + ")");
        this.m_targetPart = arg0;
        log.exiting("init");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isEnabled(IStructuredSelection selection) {
        boolean bl;
        boolean enable;
        block15: {
            boolean bl2;
            block14: {
                boolean bl3;
                block13: {
                    boolean bl4;
                    block12: {
                        boolean bl5;
                        block11: {
                            boolean bl6;
                            block10: {
                                boolean bl7;
                                block9: {
                                    log.entering("isEnabled(" + selection + ")");
                                    enable = false;
                                    try {
                                        if (!TransportViewRepository.getInstance().isChangeRequestViewEnabled()) {
                                            bl7 = enable = this.isEnabledOld(selection);
                                            Object var8_7 = null;
                                            break block9;
                                        }
                                        if (selection == null || selection.isEmpty()) {
                                            log.debug("Selection is null or empty");
                                            bl6 = enable;
                                            break block10;
                                        }
                                        if (selection.size() > 1 || selection.size() == 0) {
                                            log.debug("Only exactly one element may be selected");
                                            bl5 = enable;
                                            break block11;
                                        }
                                        Object workspace = null;
                                        Object selected = selection.getFirstElement();
                                        if (!(selected instanceof CMSChangeRequestNode)) {
                                            log.debug("Selected item is no change request: " + selected);
                                            bl4 = enable;
                                            break block12;
                                        }
                                        Object[] parents = this.getParentObjectForTreeSelection(selected, 1);
                                        if (parents != null && parents.length > 0 && parents[0] instanceof CMSTransportNode) {
                                            if (((CMSTransportNode)parents[0]).getType() != 1) {
                                                log.debug("Change request " + selection + " is not failed");
                                                bl3 = enable;
                                                break block13;
                                            }
                                        } else {
                                            log.debug("CR parent node is null or no transport node");
                                            bl2 = enable;
                                            break block14;
                                        }
                                        bl = enable = true;
                                        break block15;
                                    }
                                    catch (Throwable throwable) {
                                        Object var8_14 = null;
                                        log.exiting("isEnabled: " + enable);
                                        throw throwable;
                                    }
                                }
                                log.exiting("isEnabled: " + enable);
                                return bl7;
                            }
                            Object var8_8 = null;
                            log.exiting("isEnabled: " + enable);
                            return bl6;
                        }
                        Object var8_9 = null;
                        log.exiting("isEnabled: " + enable);
                        return bl5;
                    }
                    Object var8_10 = null;
                    log.exiting("isEnabled: " + enable);
                    return bl4;
                }
                Object var8_11 = null;
                log.exiting("isEnabled: " + enable);
                return bl3;
            }
            Object var8_12 = null;
            log.exiting("isEnabled: " + enable);
            return bl2;
        }
        Object var8_13 = null;
        log.exiting("isEnabled: " + enable);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isEnabledOld(IStructuredSelection selection) {
        log.entering("isEnabledOld(" + selection + ")");
        boolean enable = false;
        try {
            if (selection == null || selection.isEmpty()) {
                log.debug("Selection is null or empty");
                boolean bl = enable;
                Object var10_5 = null;
                log.exiting("isEnabledOld: " + enable);
                return bl;
            }
            Iterator iter = selection.iterator();
            if (iter == null) {
                log.error("Selection iterator is null");
                boolean bl = enable;
                Object var10_6 = null;
                log.exiting("isEnabledOld: " + enable);
                return bl;
            }
            String workspace = null;
            while (iter.hasNext()) {
                Object activity = iter.next();
                if (!(activity instanceof ClosedActivityWrapper)) {
                    log.debug("Selected item is no activity: " + activity);
                    boolean bl = enable;
                    Object var10_7 = null;
                    log.exiting("isEnabledOld: " + enable);
                    return bl;
                }
                Object[] parents = this.getParentObjectForTreeSelection(activity, 1);
                if (parents != null && parents.length > 0 && parents[0] instanceof CMSTransportNode) {
                    if (!((CMSTransportNode)parents[0]).isTransported()) {
                        log.debug("Activity " + activity + " not transported yet");
                        boolean bl = enable;
                        Object var10_8 = null;
                        log.exiting("isEnabledOld: " + enable);
                        return bl;
                    }
                } else {
                    log.debug("Activity parent node is null or no transport node");
                    boolean bl = enable;
                    Object var10_9 = null;
                    log.exiting("isEnabledOld: " + enable);
                    return bl;
                }
                try {
                    if (workspace == null) {
                        workspace = ((ClosedActivityWrapper)activity).workspace.getObjectID();
                        continue;
                    }
                    if (((ClosedActivityWrapper)activity).workspace.getObjectID().equals(workspace)) continue;
                    log.debug("The selected activities do not have the same workspace");
                    boolean bl = enable;
                    Object var10_10 = null;
                    log.exiting("isEnabledOld: " + enable);
                    return bl;
                }
                catch (VfsException ex) {
                    log.error((Throwable)ex);
                    boolean bl = enable;
                    Object var10_11 = null;
                    log.exiting("isEnabledOld: " + enable);
                    return bl;
                }
            }
            boolean bl = enable = true;
            Object var10_12 = null;
            log.exiting("isEnabledOld: " + enable);
            return bl;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            log.exiting("isEnabledOld: " + enable);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execute(IStructuredSelection selection, IAction action, IVfsProgressMonitor moni) {
        block19: {
            block18: {
                log.entering("execute(" + selection + ", " + action + ", " + moni + ")");
                if (!TransportViewRepository.getInstance().isChangeRequestViewEnabled()) {
                    this.executeOld(selection, action, moni);
                    return;
                }
                try {
                    try {
                        if (action == null || !action.getId().equalsIgnoreCase("com.sap.cms.organizerUI.actions.RestartExportAction")) {
                            log.error("wrong action " + action);
                            throw new CMSUnexpectedException("Wrong action: " + action);
                        }
                        if (selection == null || selection.isEmpty()) {
                            log.error("Selection is null or empty");
                            throw new CMSUnexpectedException("No activity selected");
                        }
                        if (selection.size() > 1) {
                            log.error("More than one element selected");
                            throw new CMSUnexpectedException("More than one element selected");
                        }
                        Object selected = selection.getFirstElement();
                        if (!(selected instanceof CMSChangeRequestNode)) {
                            log.debug("Selected item is no change request: " + selected);
                            throw new CMSUnexpectedException("Selected item is no change request: " + selected);
                        }
                        CMSChangeRequestNode node = (CMSChangeRequestNode)selected;
                        CMSChangeRequest request = node.getRequest();
                        String requestID = CmsRequestTool.requestKeyToId((String)request.getComponent().getName(), (String)request.getComponent().getVendor(), (String)request.getVersion().getLocation(), (long)request.getVersion().getCounter());
                        String cmsServer = null;
                        try {
                            cmsServer = CMSOrganizerPlugin.getDefault().getCMSServerURL(node.getTransportNode().getWorkspace());
                            log.debug("CMS Server = " + cmsServer);
                        }
                        catch (Exception e) {
                            log.error("get CMS Server URL failed", (Throwable)e);
                            throw new CMSUnexpectedException("Getting of CMS Server URL failed");
                        }
                        boolean confirm = MessageDialog.openConfirm((Shell)new Shell(), (String)DIALOG_TITLE, (String)("Restart export of change request '" + request.getCaption() + "'"));
                        if (!confirm) {
                            log.debug("restart export cancelled");
                            Object var13_15 = null;
                            break block18;
                        }
                        log.debug("CMS Server = " + cmsServer);
                        CMSTransportOrganizerIF cmsTransportOrganizer = CMSAPIFactory.getInstance().createCMSAPI(cmsServer);
                        String cmsWorkspaceId = node.getTransportNode().getWorkspace().getProperty("XCM:cms-workspace-name").getValue();
                        if (request.getState() == 0) {
                            log.debug("Rerelease of changelist " + request.getCaption() + "(" + requestID + ")");
                            this.rerelease(cmsTransportOrganizer, node.getTransportNode().getWorkspace(), request);
                            break block19;
                        } else {
                            log.debug("Restart export of changelist " + request.getCaption() + "(" + requestID + ")");
                            this.restartExport(cmsTransportOrganizer, cmsWorkspaceId, requestID);
                        }
                        break block19;
                    }
                    catch (VfsException e) {
                        log.error("get activity/workspace properties failed", (Throwable)e);
                        MessageDialog.openError((Shell)new Shell(), (String)DIALOG_TITLE, (String)("Error while getting activity properties:\n" + e.getMessage()));
                        Object var13_17 = null;
                        log.exiting("execute");
                        return;
                    }
                    catch (CMSAPICreateException ex) {
                        log.error((Throwable)((Object)ex));
                        MessageDialog.openError((Shell)new Shell(), (String)DIALOG_TITLE, (String)"The connection to the CMS server could not be established");
                        Object var13_18 = null;
                        log.exiting("execute");
                        return;
                    }
                    catch (CMSClientCreateAPIException ex) {
                        log.error((Throwable)ex);
                        MessageDialog.openError((Shell)new Shell(), (String)DIALOG_TITLE, (String)"The connection to the CMS server could not be established");
                        Object var13_19 = null;
                        log.exiting("execute");
                        return;
                    }
                    catch (Exception e) {
                        log.error("Unexpected exception: ", (Throwable)e);
                        MessageDialog.openError((Shell)new Shell(), (String)DIALOG_TITLE, (String)("Unexpected exception:\n" + e.getMessage()));
                        Object var13_20 = null;
                        log.exiting("execute");
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var13_21 = null;
                    log.exiting("execute");
                    throw throwable;
                }
            }
            log.exiting("execute");
            return;
        }
        Object var13_16 = null;
        log.exiting("execute");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeOld(IStructuredSelection selection, IAction action, IVfsProgressMonitor moni) {
        log.entering("execute(" + selection + ", " + action + ", " + moni + ")");
        try {
            try {
                if (action == null || !action.getId().equalsIgnoreCase("com.sap.cms.organizerUI.actions.RestartExportAction")) {
                    log.error("wrong action " + action);
                    throw new CMSUnexpectedException("Wrong action: " + action);
                }
                if (selection == null || selection.isEmpty()) {
                    log.error("Selection is null or empty");
                    throw new CMSUnexpectedException("No activity selected");
                }
                Iterator it = selection.iterator();
                if (it == null) {
                    log.error("Selection iterator is null");
                    throw new CMSUnexpectedException("Selection iterator is null");
                }
                Object selected = null;
                ClosedActivityWrapper closedActivityWrapper = null;
                String displayName = null;
                String changeRequest = null;
                StringBuffer reqCaption = new StringBuffer();
                HashSet<String> requests = new HashSet<String>();
                String cmsWorkspaceId = null;
                String cmsWorkspaceIdNew = null;
                while (it.hasNext()) {
                    selected = it.next();
                    if (!(selected instanceof ClosedActivityWrapper)) {
                        log.error("Selected element no activity: " + selected);
                        throw new CMSUnexpectedException("Selected element no activity");
                    }
                    closedActivityWrapper = selected;
                    cmsWorkspaceIdNew = closedActivityWrapper.workspace.getProperty("XCM:cms-workspace-name").getValue();
                    if (cmsWorkspaceId != null && !cmsWorkspaceId.equals(cmsWorkspaceIdNew)) {
                        log.warning("Activities from different workspaces selected");
                        MessageDialog.openWarning((Shell)new Shell(), (String)DIALOG_TITLE, (String)"You have selected activities from multiple workspaces.\nRestart export on multiple workspaces in one transaction is not possible.\nPlease select only activities from one workspace.");
                        Object var17_16 = null;
                        log.exiting("execute");
                        return;
                    }
                    cmsWorkspaceId = cmsWorkspaceIdNew;
                    displayName = closedActivityWrapper.activity.getDisplayName();
                    changeRequest = closedActivityWrapper.activity.getProperty("XCM:propagation-request-id").getValue();
                    log.debug("displayName = " + displayName + "; propagation request = " + changeRequest);
                    if (changeRequest == null || changeRequest.equals("")) {
                        log.warning("activity '" + displayName + "' is not yet released - display logs not possible");
                        MessageDialog.openWarning((Shell)new Shell(), (String)DIALOG_TITLE, (String)("Activity '" + displayName + "' is not released yet, no export log available"));
                        Object var17_17 = null;
                        log.exiting("execute");
                        return;
                    }
                    reqCaption.append(displayName);
                    if (it.hasNext()) {
                        reqCaption.append(", ");
                    }
                    requests.add(changeRequest);
                    log.debug("change request " + changeRequest + " added to restart export list");
                }
                String cmsServer = null;
                try {
                    cmsServer = CMSOrganizerPlugin.getDefault().getCMSServerURL(closedActivityWrapper.workspace);
                    log.debug("CMS Server = " + cmsServer);
                }
                catch (Exception e) {
                    log.error("get CMS Server URL failed", (Throwable)e);
                    throw new CMSUnexpectedException("Getting of CMS Server URL failed");
                }
                boolean confirm = false;
                confirm = selection.size() > 1 ? MessageDialog.openConfirm((Shell)new Shell(), (String)DIALOG_TITLE, (String)("Restart export of " + requests.size() + " activities (" + reqCaption + ")")) : MessageDialog.openConfirm((Shell)new Shell(), (String)DIALOG_TITLE, (String)("Restart export of activity '" + reqCaption + "'"));
                if (!confirm) {
                    log.debug("restart export cancelled");
                    Object var17_18 = null;
                    log.exiting("execute");
                    return;
                }
                log.debug("CMS Server = " + cmsServer);
                CMSTransportOrganizerIF cmsTransportOrganizer = CMSAPIFactory.getInstance().createCMSAPI(cmsServer);
                it = requests.iterator();
                while (it.hasNext()) {
                    changeRequest = (String)it.next();
                    log.debug("Restart export of changelist " + changeRequest);
                    this.restartExport(cmsTransportOrganizer, cmsWorkspaceId, changeRequest);
                }
            }
            catch (VfsException e) {
                log.error("get activity/workspace properties failed", (Throwable)e);
                MessageDialog.openError((Shell)new Shell(), (String)DIALOG_TITLE, (String)("Error while getting activity properties:\n" + e.getMessage()));
                Object var17_20 = null;
                log.exiting("execute");
                return;
            }
            catch (CMSAPICreateException ex) {
                log.error((Throwable)((Object)ex));
                MessageDialog.openError((Shell)new Shell(), (String)DIALOG_TITLE, (String)ex.getMessage());
                Object var17_21 = null;
                log.exiting("execute");
                return;
            }
            catch (Exception e) {
                log.error("Unexpected exception: ", (Throwable)e);
                MessageDialog.openError((Shell)new Shell(), (String)DIALOG_TITLE, (String)("Unexpected exception:\n" + e.getMessage()));
                Object var17_22 = null;
                log.exiting("execute");
                return;
            }
            Object var17_19 = null;
            log.exiting("execute");
            return;
        }
        catch (Throwable throwable) {
            Object var17_23 = null;
            log.exiting("execute");
            throw throwable;
        }
    }

    private void restartExport(final CMSTransportOrganizerIF cmsTransportOrganizer, final String cmsWorkspaceId, final String request) {
        log.entering("restartExport");
        log.debug("CMS workspaceId...: " + cmsWorkspaceId);
        log.debug("request...........: " + request);
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                log.entering("run");
                try {
                    try {
                        cmsTransportOrganizer.restartExport002(request, cmsWorkspaceId, null);
                        log.info("export of change request '" + request + "' restarted");
                        TransportViewRepository.getInstance().refresh();
                        ((TransportView)RestartExportActivityAction.this.m_targetPart).getRepositoryTreeViewer().refresh();
                    }
                    catch (CmsPropagationQueueItemExistsException e) {
                        log.error((Throwable)e);
                        MessageDialog.openError((Shell)new Shell(), (String)RestartExportActivityAction.DIALOG_TITLE, (String)("Change request " + request + "\n" + e.getMessage()));
                        Object var14_2 = null;
                        log.exiting("run");
                        return;
                    }
                    catch (CmsPropagationInvalidConfException e) {
                        log.error((Throwable)e);
                        MessageDialog.openError((Shell)new Shell(), (String)RestartExportActivityAction.DIALOG_TITLE, (String)("Change request " + request + "\n" + e.getMessage()));
                        Object var14_3 = null;
                        log.exiting("run");
                        return;
                    }
                    catch (CMSOFileAccessException e) {
                        log.error((Throwable)e);
                        MessageDialog.openError((Shell)new Shell(), (String)RestartExportActivityAction.DIALOG_TITLE, (String)("Change request " + request + "\n" + e.getMessage()));
                        Object var14_4 = null;
                        log.exiting("run");
                        return;
                    }
                    catch (PCSTransactionException e) {
                        log.error((Throwable)e);
                        MessageDialog.openError((Shell)new Shell(), (String)RestartExportActivityAction.DIALOG_TITLE, (String)("Change request " + request + "\n" + e.getMessage()));
                        Object var14_5 = null;
                        log.exiting("run");
                        return;
                    }
                    catch (CMSOInvalidParameterException e) {
                        log.error((Throwable)e);
                        MessageDialog.openError((Shell)new Shell(), (String)RestartExportActivityAction.DIALOG_TITLE, (String)("Change request " + request + "\n" + e.getMessage()));
                        Object var14_6 = null;
                        log.exiting("run");
                        return;
                    }
                    catch (CmsRequestNotFoundException e) {
                        log.error("Propagation request could not be found", (Throwable)e);
                        MessageDialog.openError((Shell)new Shell(), (String)RestartExportActivityAction.DIALOG_TITLE, (String)("The propagation request " + request + " could not be found."));
                        Object var14_7 = null;
                        log.exiting("run");
                        return;
                    }
                    catch (CmsRequestUpdateException e) {
                        log.error((Throwable)e);
                        MessageDialog.openError((Shell)new Shell(), (String)RestartExportActivityAction.DIALOG_TITLE, (String)("Change request " + request + "\n" + e.getMessage()));
                        Object var14_8 = null;
                        log.exiting("run");
                        return;
                    }
                    catch (CmsChangelistUpdateException e) {
                        log.error((Throwable)e);
                        MessageDialog.openError((Shell)new Shell(), (String)RestartExportActivityAction.DIALOG_TITLE, (String)("Change request " + request + "\n" + e.getMessage()));
                        Object var14_9 = null;
                        log.exiting("run");
                        return;
                    }
                    catch (CMSPermissionDeniedException e) {
                        log.error("Permission denied", (Throwable)e);
                        MessageDialog.openError((Shell)new Shell(), (String)RestartExportActivityAction.DIALOG_TITLE, (String)("Change request " + request + "\n" + "You do not have sufficient access rights to restart the export."));
                        Object var14_10 = null;
                        log.exiting("run");
                        return;
                    }
                    catch (CMSConnectorException e) {
                        log.error("CMSConnectorException", (Throwable)e);
                        MessageDialog.openError((Shell)new Shell(), (String)RestartExportActivityAction.DIALOG_TITLE, (String)("Change request " + request + "\n" + e.getMessage()));
                        Object var14_11 = null;
                        log.exiting("run");
                        return;
                    }
                    catch (CMSUEBaseException e) {
                        log.error("CMSUEBaseException: ", (Throwable)e);
                        MessageDialog.openError((Shell)new Shell(), (String)RestartExportActivityAction.DIALOG_TITLE, (String)("Internal error: " + ((Object)((Object)e)).getClass().getName() + "\n" + e.getMessage()));
                        Object var14_12 = null;
                        log.exiting("run");
                        return;
                    }
                    catch (Exception e) {
                        log.error("Exception", (Throwable)e);
                        MessageDialog.openError((Shell)new Shell(), (String)RestartExportActivityAction.DIALOG_TITLE, (String)("Internal error: " + e.getClass().getName() + "\n" + e.getMessage()));
                        Object var14_13 = null;
                        log.exiting("run");
                        return;
                    }
                    Object var14_1 = null;
                }
                catch (Throwable throwable) {
                    Object var14_14 = null;
                    log.exiting("run");
                    throw throwable;
                }
                log.exiting("run");
            }
        });
        log.exiting("restartExport");
    }

    private void rerelease(final CMSTransportOrganizerIF cmsTransportOrganizer, IVfsWorkspace workspace, CMSChangeRequest request) throws VfsException, CMSClientChangeRequestNotFoundException, CMSClientCreateAPIException {
        final String user = request.getOwner();
        final Vector<CMSChangeList> changelist = new Vector<CMSChangeList>();
        final String caption = request.getCaption();
        final String cmsWorkspaceId = workspace.getProperty("XCM:cms-workspace-name").getValue();
        IVfsActivity[] activities = TransportViewRepository.getInstance().getActivitiesOfChangeRequest(workspace, request);
        if (activities == null) {
            log.error("No activities found for request " + request);
            throw new CMSUnexpectedException("No activities found for request " + request);
        }
        int i = 0;
        while (i < activities.length) {
            changelist.add(new CMSChangeList(activities[i].getObjectID(), activities[i].getDisplayName(), null, activities[i].getAuthor()));
            ++i;
        }
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    try {
                        RequestID requestId = cmsTransportOrganizer.releaseChangelists002(user, caption, changelist, cmsWorkspaceId, null);
                        log.info("export of change request '" + requestId + "' restarted");
                        TransportViewRepository.getInstance().refresh();
                        ((TransportView)RestartExportActivityAction.this.m_targetPart).getRepositoryTreeViewer().refresh();
                    }
                    catch (CMSPermissionDeniedException e) {
                        log.error("Permission denied", (Throwable)e);
                        MessageDialog.openError((Shell)new Shell(), (String)RestartExportActivityAction.DIALOG_TITLE, (String)("Change request " + caption + "\n" + "You do not have sufficient access rights to restart the export."));
                        Object var4_4 = null;
                        log.exiting("releaseActivities");
                        return;
                    }
                    catch (Exception e) {
                        log.error("Exception", (Throwable)e);
                        MessageDialog.openError((Shell)new Shell(), (String)RestartExportActivityAction.DIALOG_TITLE, (String)("Internal error: " + e.getClass().getName() + "\n" + e.getMessage()));
                        Object var4_5 = null;
                        log.exiting("releaseActivities");
                        return;
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    log.exiting("releaseActivities");
                    throw throwable;
                }
                log.exiting("releaseActivities");
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

