/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.organizerUI.actions;

import com.sap.cms.organizerUI.CMSChangeRequestNode;
import com.sap.cms.organizerUI.CMSTransportNode;
import com.sap.cms.organizerUI.actions.TransportViewAction;
import com.sap.cms.organizerUI.internal.TransportViewRepository;
import com.sap.cms.organizerUI.ui.ReleasePredecessorDialog;
import com.sap.cms.organizerUI.ui.TransportView;
import com.sap.cms.util.exception.CMSUnexpectedException;
import com.sap.cms.util.logging.CmsLogger;
import com.tssap.dtr.client.eclipse.vfs.ClosedActivityWrapper;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.actions.IVfsProgressMonitor;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class ReleaseActivityAction
extends TransportViewAction
implements IViewActionDelegate {
    private static final CmsLogger log = CmsLogger.getLogger((String)(class$com$sap$cms$organizerUI$actions$ReleaseActivityAction == null ? (class$com$sap$cms$organizerUI$actions$ReleaseActivityAction = ReleaseActivityAction.class$("com.sap.cms.organizerUI.actions.ReleaseActivityAction")) : class$com$sap$cms$organizerUI$actions$ReleaseActivityAction).getName());
    private static final String DIALOG_TITLE = "Release for transport";
    static /* synthetic */ Class class$com$sap$cms$organizerUI$actions$ReleaseActivityAction;

    public ReleaseActivityAction() {
        log.entering("Constructor()");
        log.exiting("Constructor");
    }

    protected boolean runWithinWorkerThread() {
        log.entering("runWithinWorkerThread()");
        log.exiting("runWithinWorkerThread: false");
        return false;
    }

    protected boolean allowedMultipleSelection() {
        log.entering("allowedMultipleSelection()");
        log.exiting("allowedMultipleSelection: true");
        return true;
    }

    public void init(IViewPart arg0) {
        log.entering("init(" + arg0 + ")");
        this.m_targetPart = arg0;
        log.exiting("init");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isEnabled(IStructuredSelection selection) {
        log.entering("isEnabled(" + selection + ")");
        boolean enable = false;
        try {
            if (selection == null || selection.isEmpty()) {
                log.debug("Selection is null or empty");
                boolean bl = enable;
                Object var10_5 = null;
                log.exiting("isEnabled: " + enable);
                return bl;
            }
            Iterator iter = selection.iterator();
            if (iter == null) {
                log.error("Selection iterator is null");
                boolean bl = enable;
                Object var10_6 = null;
                log.exiting("isEnabled: " + enable);
                return bl;
            }
            String workspace = null;
            while (iter.hasNext()) {
                Object activity;
                block16: {
                    activity = iter.next();
                    if (!(activity instanceof ClosedActivityWrapper)) {
                        log.debug("Selected item is no activity: " + activity);
                        boolean bl = enable;
                        Object var10_7 = null;
                        log.exiting("isEnabled: " + enable);
                        return bl;
                    }
                    Object[] parents = this.getParentObjectForTreeSelection(activity, 1);
                    if (TransportViewRepository.getInstance().isChangeRequestViewEnabled()) {
                        if (parents != null && parents.length > 0 && parents[0] instanceof CMSChangeRequestNode) {
                            if (((CMSChangeRequestNode)parents[0]).getRequest() != null) {
                                log.debug("Activity " + activity + " is already part of a change request");
                                boolean bl = enable;
                                Object var10_8 = null;
                                log.exiting("isEnabled: " + enable);
                                return bl;
                            }
                            break block16;
                        } else {
                            log.debug("Activity parent node is null or no change request");
                            boolean bl = enable;
                            Object var10_9 = null;
                            log.exiting("isEnabled: " + enable);
                            return bl;
                        }
                    }
                    if (parents != null && parents.length > 0 && parents[0] instanceof CMSTransportNode) {
                        if (((CMSTransportNode)parents[0]).isTransported()) {
                            log.debug("Activity " + activity + " is already transported");
                            boolean bl = enable;
                            Object var10_10 = null;
                            log.exiting("isEnabled: " + enable);
                            return bl;
                        }
                    } else {
                        log.debug("Activity parent node is null or no transport node");
                        boolean bl = enable;
                        Object var10_11 = null;
                        log.exiting("isEnabled: " + enable);
                        return bl;
                    }
                }
                try {
                    if (workspace == null) {
                        workspace = ((ClosedActivityWrapper)activity).workspace.getObjectID();
                        continue;
                    }
                    if (((ClosedActivityWrapper)activity).workspace.getObjectID().equals(workspace)) continue;
                    log.debug("The selected activities do not have the same workspace");
                    boolean bl = enable;
                    Object var10_12 = null;
                    log.exiting("isEnabled: " + enable);
                    return bl;
                }
                catch (VfsException ex) {
                    log.error((Throwable)ex);
                    boolean bl = enable;
                    Object var10_13 = null;
                    log.exiting("isEnabled: " + enable);
                    return bl;
                }
            }
            boolean bl = enable = true;
            Object var10_14 = null;
            log.exiting("isEnabled: " + enable);
            return bl;
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            log.exiting("isEnabled: " + enable);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execute(IStructuredSelection selection, IAction action, IVfsProgressMonitor moni) {
        block14: {
            block16: {
                log.entering("execute(" + selection + ", " + action + ", " + moni + ")");
                try {
                    try {
                        if (action == null || !action.getId().equalsIgnoreCase("com.sap.cms.organizerUI.actions.ReleaseActivityAction")) {
                            log.error("wrong action " + action);
                            throw new CMSUnexpectedException("Wrong action: " + action);
                        }
                        if (selection == null || selection.isEmpty()) {
                            log.error("Selection is null or empty");
                            throw new CMSUnexpectedException("No activity selected");
                        }
                        final ArrayList<ClosedActivityWrapper> wrappers = new ArrayList<ClosedActivityWrapper>(selection.size());
                        Iterator it = selection.iterator();
                        if (it == null) {
                            log.error("Selection iterator is null");
                            throw new CMSUnexpectedException("Selection iterator is null");
                        }
                        Object selected = null;
                        ClosedActivityWrapper closedActivityWrapper = null;
                        String displayName = null;
                        String changeRequest = null;
                        String cmsWorkspaceId = null;
                        String cmsWorkspaceIdNew = null;
                        while (true) {
                            if (!it.hasNext()) {
                                BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                                    public void run() {
                                        int returnCode = new ReleasePredecessorDialog(ReleaseActivityAction.super.getShell(), wrappers).open();
                                        TransportViewRepository.getInstance().refresh();
                                        ((TransportView)ReleaseActivityAction.this.m_targetPart).getRepositoryTreeViewer().refresh();
                                    }
                                });
                                break block14;
                            }
                            selected = it.next();
                            if (!(selected instanceof ClosedActivityWrapper)) {
                                log.error("Selected element no activity: " + selected);
                                throw new CMSUnexpectedException("Selected element no activity");
                            }
                            closedActivityWrapper = selected;
                            cmsWorkspaceIdNew = closedActivityWrapper.workspace.getProperty("XCM:cms-workspace-name").getValue();
                            if (cmsWorkspaceId != null && !cmsWorkspaceId.equals(cmsWorkspaceIdNew)) {
                                log.warning("Activities from different workspaces selected");
                                MessageDialog.openWarning((Shell)new Shell(), (String)DIALOG_TITLE, (String)"You have selected activities from multiple workspaces.\nRelease on multiple workspaces in one transaction is not possible.\nPlease select only activities from one workspace.");
                                Object var13_14 = null;
                                break;
                            }
                            cmsWorkspaceId = cmsWorkspaceIdNew;
                            displayName = closedActivityWrapper.activity.getDisplayName();
                            changeRequest = closedActivityWrapper.activity.getProperty("XCM:propagation-request-id").getValue();
                            log.debug("object id = " + closedActivityWrapper.activity.getObjectID() + "; displayName = " + displayName);
                            if (changeRequest != null && !changeRequest.equals("")) {
                                log.warning("activity '" + displayName + "' already released with request '" + changeRequest + "'");
                                MessageDialog.openWarning((Shell)new Shell(), (String)DIALOG_TITLE, (String)("Activity '" + displayName + "' already released with request '" + changeRequest + "'"));
                                break block16;
                            }
                            wrappers.add(closedActivityWrapper);
                        }
                    }
                    catch (VfsException e) {
                        log.error("get activity/workspace properties failed", (Throwable)e);
                        MessageDialog.openError((Shell)new Shell(), (String)DIALOG_TITLE, (String)("Error while getting activity properties:\n" + e.getMessage()));
                        Object var13_17 = null;
                        log.exiting("execute");
                        return;
                    }
                    catch (Exception e) {
                        log.error("Unexpected exception", (Throwable)e);
                        MessageDialog.openError((Shell)new Shell(), (String)DIALOG_TITLE, (String)("Internal error:" + e.getClass().getName() + "\n" + e.getMessage()));
                        Object var13_18 = null;
                        log.exiting("execute");
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var13_19 = null;
                    log.exiting("execute");
                    throw throwable;
                }
                log.exiting("execute");
                return;
            }
            Object var13_15 = null;
            log.exiting("execute");
            return;
        }
        Object var13_16 = null;
        log.exiting("execute");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

