/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.organizerUI;

import com.sap.cms.util.exception.CMSUnexpectedException;
import com.sap.cms.util.logging.CmsLogger;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;

public class CMSTransportNode {
    public static final int TYPE_WAITING = 0;
    public static final int TYPE_FAILED = 1;
    public static final int TYPE_RELEASED = 2;
    public static final int MIN_TYPE = 0;
    public static final int MAX_TYPE = 2;
    private static final CmsLogger log = CmsLogger.getLogger((String)(class$com$sap$cms$organizerUI$CMSTransportNode == null ? (class$com$sap$cms$organizerUI$CMSTransportNode = CMSTransportNode.class$("com.sap.cms.organizerUI.CMSTransportNode")) : class$com$sap$cms$organizerUI$CMSTransportNode).getName());
    private boolean transported;
    private int type = 0;
    private IVfsWorkspace workspace;
    static /* synthetic */ Class class$com$sap$cms$organizerUI$CMSTransportNode;

    public CMSTransportNode(IVfsWorkspace workspace, boolean transported) {
        log.entering("Constructor", new Object[]{workspace, new Boolean(transported)});
        this.workspace = workspace;
        this.setTransported(transported);
        log.exiting("Constructor");
    }

    public CMSTransportNode(IVfsWorkspace workspace, int type) {
        log.entering("Constructor", new Object[]{workspace, new Integer(type)});
        this.workspace = workspace;
        this.setType(type);
        log.exiting("Constructor");
    }

    public boolean isTransported() {
        log.entering("isTransported");
        log.exiting("isTransported", (Object)new Boolean(this.transported));
        return this.transported;
    }

    public IVfsWorkspace getWorkspace() {
        log.entering("getWorkspace");
        log.exiting("getWorkspace", (Object)this.workspace);
        return this.workspace;
    }

    public void setTransported(boolean transported) {
        log.entering("setTransported", new Object[]{new Boolean(transported)});
        this.transported = transported;
        this.type = transported ? 2 : 0;
        log.exiting("setTransported");
    }

    public void setWorkspace(IVfsWorkspace workspace) {
        log.entering("setWorkspace", new Object[]{workspace});
        this.workspace = workspace;
        log.exiting("setWorkspace");
    }

    public int getType() {
        log.entering("getType");
        log.exiting("getType", (Object)new Integer(this.type));
        return this.type;
    }

    public void setType(int type) {
        log.entering("setType", new Object[]{new Integer(type)});
        try {
            if (type < 0 || type > 2) {
                log.error("Invalid type: " + type);
                throw new CMSUnexpectedException("Invalid type: '" + type + "'");
            }
            this.type = type;
            this.transported = type != 0;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            log.exiting("setType");
            throw throwable;
        }
        log.exiting("setType");
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CMSTransportNode)) {
            return false;
        }
        CMSTransportNode node = (CMSTransportNode)obj;
        if (node.getType() != this.getType()) {
            return false;
        }
        try {
            return node.getWorkspace().getObjectID().equalsIgnoreCase(this.getWorkspace().getObjectID());
        }
        catch (VfsException ex) {
            log.error((Throwable)ex);
            return false;
        }
    }

    public int hashCode() {
        try {
            return (this.getType() + this.getWorkspace().getObjectID()).hashCode();
        }
        catch (VfsException e) {
            log.error((Throwable)e);
            return 0;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

