/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.organizerUI;

import com.sap.cms.util.exception.CMSUnexpectedException;
import com.sap.cms.util.logging.CmsLogger;
import com.sap.ide.eclipse.component.devconf.DevConfManager;
import com.sap.ide.login.LoginListener;
import com.sap.ide.login.UserValidator;
import com.sap.tc.complib.ConfigurationFactory;
import com.sap.tc.complib.provider.ConfigurationInputProvider;
import com.sap.tc.complib.provider.ProviderException;
import com.sap.tc.complib.provider.SimpleFileConfigInputProvider;
import com.sap.tc.complib.validate.ValidationException;
import com.sap.tc.complib.xml.XMLException;
import com.sap.tc.devconf.impl.DevelopmentConfiguration;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.config.Configuration;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CMSOrganizerPlugin
extends AbstractUIPlugin
implements LoginListener {
    private static final CmsLogger log = CmsLogger.getLogger((String)(class$com$sap$cms$organizerUI$CMSOrganizerPlugin == null ? (class$com$sap$cms$organizerUI$CMSOrganizerPlugin = CMSOrganizerPlugin.class$("com.sap.cms.organizerUI.CMSOrganizerPlugin")) : class$com$sap$cms$organizerUI$CMSOrganizerPlugin).getName());
    private static final String m_imageDirectory = "icons/";
    private static CMSOrganizerPlugin cmsOrganizerPlugin;
    private ImageRegistry m_imageRegistry;
    private String user = null;
    private String password = null;
    static /* synthetic */ Class class$com$sap$cms$organizerUI$CMSOrganizerPlugin;

    public CMSOrganizerPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        log.entering("Constructor", new Object[]{descriptor});
        cmsOrganizerPlugin = this;
        UserValidator.addLoginListener((LoginListener)this);
        if (UserValidator.getDefaultServerData() != null && UserValidator.getDefaultServerData().isOnline()) {
            this.user = UserValidator.getDefaultServerData().getUser();
            this.password = UserValidator.getDefaultServerData().getPassword();
        }
        log.exiting("Constructor");
    }

    public static CMSOrganizerPlugin getDefault() {
        return cmsOrganizerPlugin;
    }

    public Image getAtomicImage(String filename) {
        log.entering("getAtomicImage", new Object[]{filename});
        if (this.m_imageRegistry == null) {
            this.m_imageRegistry = this.getImageRegistry();
        }
        if (this.m_imageRegistry.get(filename) == null) {
            this.m_imageRegistry.put(filename, this.createImageDescriptor(filename));
        }
        log.exiting("getAtomicImage");
        return this.m_imageRegistry.get(filename);
    }

    public String getCMSServer(IVfsWorkspace workspace) throws IOException, XMLException, ProviderException, ValidationException {
        String string;
        log.entering("getCMSServer(" + workspace + ")");
        try {
            if (workspace == null) {
                log.error("workspace = null");
                throw new CMSUnexpectedException("workspace is null");
            }
            String clientName = workspace.getVersionedFileSystemManager().getCurrentContext().getClientName();
            IClient vfsClient = Configuration.getConfiguration().getClient(clientName);
            String vfsRootFolder = vfsClient.getAbsoluteLocalRoot();
            String configFile = vfsRootFolder + File.separator + ".confdef";
            log.debug("development configuration file = " + configFile);
            SimpleFileConfigInputProvider provider = new SimpleFileConfigInputProvider(new File(configFile));
            com.sap.tc.complib.DevelopmentConfiguration config = ConfigurationFactory.initializeDevelopmentConfiguration((ConfigurationInputProvider)provider);
            String cmsServer = config.getCMS();
            try {
                log.debug("CMS Server of workspace " + workspace.getDisplayName() + " = " + cmsServer);
            }
            catch (VfsException ex) {
                log.warning("Unable to get workspace display name", (Throwable)ex);
            }
            string = cmsServer;
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            log.exiting("getCMSServer");
            throw throwable;
        }
        log.exiting("getCMSServer");
        return string;
    }

    public String getCMSServerURL(IVfsWorkspace workspace) {
        String string;
        log.entering("getCMSServerURL", new Object[]{workspace});
        String cmsServer = null;
        try {
            if (workspace == null) {
                log.error("workspace = null");
                throw new CMSUnexpectedException("workspace is null");
            }
            String clientName = workspace.getVersionedFileSystemManager().getCurrentContext().getClientName();
            IClient vfsClient = Configuration.getConfiguration().getClient(clientName);
            String vfsRootFolder = vfsClient.getAbsoluteLocalRoot();
            List list = DevConfManager.getInstalledDevConfs();
            DevelopmentConfiguration dev = null;
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                dev = (DevelopmentConfiguration)iter.next();
                if (vfsRootFolder.equalsIgnoreCase(dev.getConfigurationRootFolder())) break;
            }
            if (dev == null) {
                log.error("DevConfig not found");
                throw new CMSUnexpectedException("development configuration not found");
            }
            string = cmsServer = dev.getCMS();
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            log.exiting("getCMSServerURL", cmsServer);
            throw throwable;
        }
        log.exiting("getCMSServerURL", cmsServer);
        return string;
    }

    public void loginPerformed(UserValidator.Data loginData) {
        log.entering("loginPerformed", new Object[]{loginData});
        this.user = loginData.getUser();
        this.password = loginData.getPassword();
        log.exiting("loginPerformed");
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ImageDescriptor createImageDescriptor(String filename) {
        ImageDescriptor imageDescriptor;
        log.entering("createImageDescriptor", new Object[]{filename});
        URL installURL = this.getDescriptor().getInstallURL();
        try {
            try {
                URL imageURL = new URL(installURL, m_imageDirectory + filename);
                imageDescriptor = ImageDescriptor.createFromURL((URL)imageURL);
                Object var6_7 = null;
            }
            catch (MalformedURLException e) {
                log.error("get image descriptor failed", (Throwable)e);
                ImageDescriptor imageDescriptor2 = null;
                Object var6_8 = null;
                log.exiting("createImageDescriptor");
                return imageDescriptor2;
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            log.exiting("createImageDescriptor");
            throw throwable;
        }
        log.exiting("createImageDescriptor");
        return imageDescriptor;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

