/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http.auth;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import org.w3c.tools.codec.Base64Encoder;
import org.w3c.www.http.HttpChallenge;
import org.w3c.www.http.HttpCredential;
import org.w3c.www.http.HttpFactory;
import org.w3c.www.http.HttpReplyMessage;
import org.w3c.www.protocol.http.HttpException;
import org.w3c.www.protocol.http.HttpManager;
import org.w3c.www.protocol.http.PropRequestFilter;
import org.w3c.www.protocol.http.Reply;
import org.w3c.www.protocol.http.Request;
import org.w3c.www.protocol.http.auth.LocalAuthFilter;
import org.w3c.www.protocol.http.auth.b;
import org.w3c.www.protocol.http.auth.d;

public class AuthFilter
implements PropRequestFilter {
    protected HttpManager manager = null;
    protected static Hashtable realms = new Hashtable(13);

    public void sync() {
    }

    protected static void registerRealm(Request request, Reply reply, HttpCredential httpCredential) {
        if (AuthFilter.lookupRealm(request, reply) != null) {
            return;
        }
        String string = request.getManager().getServerKey(request);
        String string2 = (request.hasProxy() ? reply.getProxyAuthenticate() : reply.getWWWAuthenticate()).getAuthParameter("realm");
        d[] dArray = (d[])realms.get(string);
        if (dArray == null) {
            dArray = new d[]{new d(string2, httpCredential)};
        } else {
            d[] dArray2 = new d[dArray.length + 1];
            System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
            dArray2[dArray.length] = new d(string2, httpCredential);
            dArray = dArray2;
        }
        realms.put(string, dArray);
    }

    public Reply outgoingFilter(Request request, Reply reply) throws HttpException {
        Object object;
        Object object2;
        if (reply.getStatus() != 401 && reply.getStatus() != 407) {
            return null;
        }
        HttpCredential httpCredential = null;
        httpCredential = AuthFilter.lookupRealm(request, reply);
        if (httpCredential == null) {
            if (!request.getAllowUserInteraction()) {
                return null;
            }
            object2 = new b(request, reply);
            if (!((b)object2).prompt()) {
                return null;
            }
            object = ((b)object2).getUser();
            String string = ((b)object2).getPassword();
            httpCredential = HttpFactory.makeCredential("Basic");
            Base64Encoder base64Encoder = new Base64Encoder(String.valueOf(object) + ":" + string);
            httpCredential.setAuthParameter("cookie", base64Encoder.processString());
        }
        if (request.hasProxy()) {
            request.setProxyAuthorization(httpCredential);
        } else {
            request.setAuthorization(httpCredential);
        }
        object2 = request.getManager().runRequest(request);
        if (((HttpReplyMessage)object2).getStatus() / 100 != 4) {
            AuthFilter.registerRealm(request, reply, httpCredential);
            if (request.hasProxy()) {
                LocalAuthFilter.installProxyAuth(this.manager, httpCredential);
            } else {
                LocalAuthFilter.installLocalAuth(this.manager, request.getURL(), httpCredential);
            }
            try {
                object = reply.getInputStream();
                if (object != null) {
                    ((InputStream)object).close();
                }
            }
            catch (IOException iOException) {}
            return object2;
        }
        return null;
    }

    protected static HttpCredential lookupRealm(Request request, Reply reply) {
        String string = request.getManager().getServerKey(request);
        d[] dArray = (d[])realms.get(string);
        if (dArray == null) {
            return null;
        }
        HttpChallenge httpChallenge = request.hasProxy() ? reply.getProxyAuthenticate() : reply.getWWWAuthenticate();
        String string2 = httpChallenge.getAuthParameter("realm");
        int n = 0;
        while (n < dArray.length) {
            if (dArray[n].realm.equalsIgnoreCase(string2)) {
                return dArray[n].credentials;
            }
            ++n;
        }
        return null;
    }

    public void initialize(HttpManager httpManager) {
        this.manager = httpManager;
        httpManager.setFilter(this);
        httpManager.setAllowUserInteraction(true);
    }

    public Reply ingoingFilter(Request request) {
        return null;
    }

    public boolean exceptionFilter(Request request, HttpException httpException) {
        return false;
    }
}

