/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.test;

import com.togethersoft.sca.ast.AstCompilationUnit;
import com.togethersoft.sca.ast.AstCompoundStatement;
import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstDeclarationStatement;
import com.togethersoft.sca.ast.AstField;
import com.togethersoft.sca.ast.AstInitializer;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstPackage;
import com.togethersoft.sca.ast.AstStatement;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.ast.AstTypeReference;
import com.togethersoft.sca.ast.AstVariable;
import com.togethersoft.sca.internal.jparser.test.JParserTestCase;
import junit.framework.Assert;
import junit.framework.TestSuite;

public class ModelTest
extends JParserTestCase {
    static /* synthetic */ Class class$com$togethersoft$sca$internal$jparser$test$ModelTest;

    public ModelTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.getModel("../../../../../../../test/data/Model.java");
    }

    public static TestSuite suite() {
        return new TestSuite(class$com$togethersoft$sca$internal$jparser$test$ModelTest == null ? (class$com$togethersoft$sca$internal$jparser$test$ModelTest = ModelTest.class$("com.togethersoft.sca.internal.jparser.test.ModelTest")) : class$com$togethersoft$sca$internal$jparser$test$ModelTest);
    }

    public void testModel() {
        AstPackage[] packages = this.model.getPackages();
        Assert.assertTrue((packages.length == 2 ? 1 : 0) != 0);
        AstPackage pkg = this.model.getDefaultPackage();
        Assert.assertTrue((pkg == packages[0] || pkg == packages[1] ? 1 : 0) != 0);
        Assert.assertTrue((pkg.getParent() == null ? 1 : 0) != 0);
        Assert.assertTrue((pkg.getPackage() == null ? 1 : 0) != 0);
        Assert.assertTrue((pkg.getDeclaringType() == null ? 1 : 0) != 0);
        AstCompilationUnit[] cunits = pkg.getCompilationUnits();
        Assert.assertTrue((cunits.length == 1 ? 1 : 0) != 0);
        AstCompilationUnit cu = cunits[0];
        Assert.assertTrue((cu.getParent() == pkg ? 1 : 0) != 0);
        Assert.assertTrue((cu.getPackage() == pkg ? 1 : 0) != 0);
        Assert.assertTrue((cu.getDeclaringType() == null ? 1 : 0) != 0);
        AstType[] classes = cu.getTypes();
        Assert.assertTrue((classes.length == 1 ? 1 : 0) != 0);
        AstType cls = classes[0];
        Assert.assertEquals((String)cls.getQualifiedName(), (String)"C");
        Assert.assertTrue((cls.getParent() == cu ? 1 : 0) != 0);
        Assert.assertTrue((cls.getPackage() == pkg ? 1 : 0) != 0);
        Assert.assertTrue((cls.getCompilationUnit() == cu ? 1 : 0) != 0);
        Assert.assertTrue((cls.getDeclaringType() == null ? 1 : 0) != 0);
        AstType[] innerTypes = cls.getTypes();
        Assert.assertTrue((innerTypes.length == 1 ? 1 : 0) != 0);
        AstType inner = innerTypes[0];
        Assert.assertEquals((String)inner.getQualifiedName(), (String)"C/Inner");
        Assert.assertTrue((inner.getParent() == cls ? 1 : 0) != 0);
        Assert.assertTrue((inner.getPackage() == pkg ? 1 : 0) != 0);
        Assert.assertTrue((inner.getCompilationUnit() == cu ? 1 : 0) != 0);
        Assert.assertTrue((inner.getDeclaringType() == cls ? 1 : 0) != 0);
        Assert.assertTrue((inner.getConstructors().length == 1 ? 1 : 0) != 0);
        AstMethod ctor = inner.getConstructors()[0];
        Assert.assertEquals((String)ctor.getQualifiedName(), (String)"C/Inner/Inner");
        Assert.assertTrue((boolean)ctor.isConstructor());
        Assert.assertTrue((boolean)ctor.getElementName().equals("Inner"));
        AstField[] fields = inner.getFields();
        Assert.assertTrue((fields.length == 1 ? 1 : 0) != 0);
        AstField i = fields[0];
        Assert.assertEquals((String)i.getQualifiedName(), (String)"C/Inner/i");
        Assert.assertTrue((i.getParent() == inner ? 1 : 0) != 0);
        Assert.assertTrue((i.getType().getKind() == 5 ? 1 : 0) != 0);
        Assert.assertTrue((i.getType().numDimensions() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((i.getType().getBaseType() == null ? 1 : 0) != 0);
        AstMethod[] methods = inner.getMethods();
        Assert.assertTrue((methods.length == 1 ? 1 : 0) != 0);
        AstMethod method = methods[0];
        Assert.assertEquals((String)method.getQualifiedName(), (String)"C/Inner/f");
        Assert.assertTrue((method.getParent() == inner ? 1 : 0) != 0);
        Assert.assertTrue((!method.isConstructor() ? 1 : 0) != 0);
        AstTypeReference ref = method.getReturnType();
        Assert.assertTrue((ref.getKind() == 11 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)ref.getTypeName().equals("java/lang/String[][]"));
        Assert.assertTrue((ref.numDimensions() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)ref.getBaseType().getQualifiedName().equals("java/lang/String"));
        Assert.assertTrue((boolean)ref.getSignature().equals("[[Ljava/lang/String;"));
        AstVariable[] params = method.getParameters();
        Assert.assertTrue((params.length == 1 ? 1 : 0) != 0);
        AstVariable param = params[0];
        Assert.assertTrue((param.getParent() == method ? 1 : 0) != 0);
        Assert.assertTrue((param.getType().getKind() == 5 ? 1 : 0) != 0);
        Assert.assertTrue((param.getType().numDimensions() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((param.getType().getBaseType() == null ? 1 : 0) != 0);
        AstCompoundStatement body = method.getBody();
        AstStatement[] stmts = body.getStatements();
        Assert.assertTrue((stmts.length == 1 ? 1 : 0) != 0);
        AstDeclarationStatement decl = (AstDeclarationStatement)stmts[0];
        Assert.assertTrue((decl.getParent() == body ? 1 : 0) != 0);
        AstDeclaration[] decls = decl.getDeclarations();
        Assert.assertTrue((decls.length == 2 ? 1 : 0) != 0);
        AstVariable b1 = (AstVariable)decls[0];
        AstVariable b2 = (AstVariable)decls[1];
        Assert.assertTrue((b1.getParent() == decl ? 1 : 0) != 0);
        Assert.assertTrue((b1.getPackage() == pkg ? 1 : 0) != 0);
        Assert.assertTrue((b1.getDeclaringType() == inner ? 1 : 0) != 0);
        Assert.assertTrue((b1.getDeclaringType().getCompilationUnit() == cu ? 1 : 0) != 0);
        Assert.assertTrue((b1.getType().getKind() == 9 ? 1 : 0) != 0);
        Assert.assertTrue((b2.getParent() == decl ? 1 : 0) != 0);
        Assert.assertTrue((b2.getType().getKind() == 9 ? 1 : 0) != 0);
        AstInitializer[] inits = cls.getInitializers();
        Assert.assertTrue((inits.length == 1 ? 1 : 0) != 0);
        AstInitializer init = inits[0];
        Assert.assertTrue((init.getParent() == cls ? 1 : 0) != 0);
        AstPackage javaLang = this.model.findPackage("java/lang");
        Assert.assertTrue((javaLang != null ? 1 : 0) != 0);
        AstType string1 = this.model.findType("java/lang/String");
        Assert.assertTrue((string1 != null ? 1 : 0) != 0);
        AstType string2 = javaLang.findType("String");
        Assert.assertTrue((string2 != null ? 1 : 0) != 0);
        AstMethod cmp1 = string1.findMethod("compareTo", "(Ljava/lang/Object;)I", false);
        Assert.assertTrue((cmp1 != null ? 1 : 0) != 0);
        Assert.assertTrue((!cmp1.isConstructor() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)cmp1.getQualifiedName().equals("java/lang/String/compareTo"));
        Assert.assertTrue((cmp1.getParameters().length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)cmp1.getParameters()[0].getType().getTypeName().equals("java/lang/Object"));
        ctor = string1.getConstructors()[0];
        Assert.assertTrue((boolean)ctor.isConstructor());
        Assert.assertTrue((boolean)ctor.getElementName().equals("String"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

