/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.test;

import com.togethersoft.sca.ast.AstAssignmentExpression;
import com.togethersoft.sca.ast.AstCompilationUnit;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstExpressionStatement;
import com.togethersoft.sca.ast.AstModel;
import com.togethersoft.sca.ast.AstStatement;
import com.togethersoft.sca.core.Factory;
import com.togethersoft.sca.internal.core.ClientSourceBase;
import com.togethersoft.sca.internal.core.Project;
import com.togethersoft.sca.internal.jparser.Control;
import junit.framework.TestCase;

abstract class JParserTestCase
extends TestCase {
    protected AstModel model;

    public JParserTestCase(String name) {
        super(name);
    }

    protected void getModel(String filename1, String filename2) {
        try {
            Project project = new Project(null, 8);
            ClientSourceBase base = Factory.createLocalSourceBase();
            project.addSourceBase(base);
            base.addFile(filename1);
            if (filename2 != null) {
                base.addFile(filename2);
            }
            Control control = new Control(project);
            control.update(false, null);
            this.model = control.getModel();
        }
        catch (Exception e) {
            this.model = null;
        }
    }

    protected void getModel(String filename) {
        this.getModel(filename, null);
    }

    protected AstCompilationUnit getCUnit(String pkg, int i) {
        return this.model.findPackage(pkg).getCompilationUnits()[i];
    }

    protected AstExpression getExpr(AstStatement[] stmts, int i) {
        return ((AstExpressionStatement)stmts[i]).getExpression();
    }

    protected AstExpression getAssignRight(AstStatement[] stmts, int i) {
        return ((AstAssignmentExpression)this.getExpr(stmts, i)).getRightOperand();
    }
}

