/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.symbol;

import com.togethersoft.sca.internal.jparser.symbol.CArrayType;
import com.togethersoft.sca.internal.jparser.symbol.CClassType;
import com.togethersoft.sca.internal.jparser.symbol.CCompilationUnit;
import com.togethersoft.sca.internal.jparser.symbol.CDefinition;
import com.togethersoft.sca.internal.jparser.symbol.CMethod;
import com.togethersoft.sca.internal.jparser.symbol.CVariable;
import com.togethersoft.sca.internal.jparser.symbol.CVisitorAdapter;
import java.io.ObjectOutputStream;

public class SymbolWriter
extends CVisitorAdapter {
    private ObjectOutputStream s;
    private static final String MSG_FAIL = "Failed to write model to disk";

    public SymbolWriter(ObjectOutputStream s) {
        this.s = s;
    }

    public void traverse(CDefinition table) {
        table.action(this);
    }

    public void visitCompilationUnit(CCompilationUnit file) {
        try {
            this.s.writeObject(file.importedTypes);
            this.s.writeObject(file.importedPackages);
        }
        catch (Exception e) {
            throw new RuntimeException(MSG_FAIL);
        }
        this.visitSymbol(file);
    }

    public void visitClassType(CClassType cls) {
        try {
            this.s.writeObject(cls.getSuperClass());
            this.s.writeObject(cls.superIfaces);
            this.s.writeObject(cls.subclasses);
            this.s.writeObject(cls.dependents);
            this.s.writeObject(cls.dependsOn);
        }
        catch (Exception e) {
            throw new RuntimeException(MSG_FAIL);
        }
        this.visitSymbol(cls);
    }

    public void visitArrayType(CArrayType array) {
        try {
            this.s.writeObject(array.getSuperClass());
            this.s.writeObject(array.superIfaces);
        }
        catch (Exception e) {
            throw new RuntimeException(MSG_FAIL);
        }
        this.visitSymbol(array);
    }

    public void visitMethod(CMethod method) {
        try {
            this.s.writeObject(method.type);
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
        this.visitSymbol(method);
    }

    public void visitVariable(CVariable var) {
        try {
            this.s.writeObject(var.type);
        }
        catch (Exception e) {
            throw new RuntimeException(MSG_FAIL);
        }
        this.visitSymbol(var);
    }

    public void visitSymbol(CDefinition symbol) {
        try {
            this.s.writeObject(symbol.astNode);
        }
        catch (Exception e) {
            throw new RuntimeException(MSG_FAIL);
        }
    }
}

