/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.symbol;

import com.togethersoft.sca.internal.jparser.ast.Declaration;
import com.togethersoft.sca.internal.jparser.symbol.CArrayType;
import com.togethersoft.sca.internal.jparser.symbol.CClassType;
import com.togethersoft.sca.internal.jparser.symbol.CCompilationUnit;
import com.togethersoft.sca.internal.jparser.symbol.CDefinition;
import com.togethersoft.sca.internal.jparser.symbol.CMethod;
import com.togethersoft.sca.internal.jparser.symbol.CType;
import com.togethersoft.sca.internal.jparser.symbol.CVariable;
import com.togethersoft.sca.internal.jparser.symbol.CVisitorAdapter;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashSet;

public class SymbolReader
extends CVisitorAdapter {
    private ObjectInputStream s;
    private static final String MSG_FAIL = "Failed to load model from disk";

    public SymbolReader(ObjectInputStream s) {
        this.s = s;
    }

    public void traverse(CDefinition table) {
        table.action(this);
    }

    public void visitCompilationUnit(CCompilationUnit file) {
        try {
            file.importedTypes = (ArrayList)this.s.readObject();
            file.importedPackages = (ArrayList)this.s.readObject();
        }
        catch (Exception e) {
            throw new RuntimeException(MSG_FAIL);
        }
        this.visitSymbol(file);
    }

    public void visitClassType(CClassType cls) {
        try {
            cls.setSuperClass((CClassType)this.s.readObject());
            cls.superIfaces = (ArrayList)this.s.readObject();
            cls.subclasses = (ArrayList)this.s.readObject();
            cls.dependents = (HashSet)this.s.readObject();
            cls.dependsOn = (HashSet)this.s.readObject();
        }
        catch (Exception e) {
            throw new RuntimeException(MSG_FAIL);
        }
        this.visitSymbol(cls);
    }

    public void visitArrayType(CArrayType array) {
        try {
            array.setSuperClass((CClassType)this.s.readObject());
            array.superIfaces = (ArrayList)this.s.readObject();
        }
        catch (Exception e) {
            throw new RuntimeException(MSG_FAIL);
        }
        this.visitSymbol(array);
    }

    public void visitMethod(CMethod method) {
        try {
            method.type = (CType)this.s.readObject();
        }
        catch (Exception e) {
            throw new RuntimeException(MSG_FAIL);
        }
        this.visitSymbol(method);
    }

    public void visitVariable(CVariable var) {
        try {
            var.type = (CType)this.s.readObject();
        }
        catch (Exception e) {
            throw new RuntimeException(MSG_FAIL);
        }
        this.visitSymbol(var);
    }

    public void visitSymbol(CDefinition symbol) {
        try {
            symbol.astNode = (Declaration)this.s.readObject();
        }
        catch (Exception e) {
            throw new RuntimeException(MSG_FAIL);
        }
    }
}

