/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.symbol;

import com.togethersoft.sca.internal.jparser.ast.ArrayAccess;
import com.togethersoft.sca.internal.jparser.ast.ArrayCreationExpr;
import com.togethersoft.sca.internal.jparser.ast.ArrayInitializer;
import com.togethersoft.sca.internal.jparser.ast.AssertStmt;
import com.togethersoft.sca.internal.jparser.ast.AssignExpr;
import com.togethersoft.sca.internal.jparser.ast.Ast;
import com.togethersoft.sca.internal.jparser.ast.AstVector;
import com.togethersoft.sca.internal.jparser.ast.BinaryExpr;
import com.togethersoft.sca.internal.jparser.ast.BinaryNotExpr;
import com.togethersoft.sca.internal.jparser.ast.Block;
import com.togethersoft.sca.internal.jparser.ast.Brackets;
import com.togethersoft.sca.internal.jparser.ast.BreakStmt;
import com.togethersoft.sca.internal.jparser.ast.CaseLabel;
import com.togethersoft.sca.internal.jparser.ast.CastExpr;
import com.togethersoft.sca.internal.jparser.ast.CatchClause;
import com.togethersoft.sca.internal.jparser.ast.ClassInitializer;
import com.togethersoft.sca.internal.jparser.ast.CompilationUnit;
import com.togethersoft.sca.internal.jparser.ast.ConditionalExpr;
import com.togethersoft.sca.internal.jparser.ast.ContinueStmt;
import com.togethersoft.sca.internal.jparser.ast.DbcResultExpr;
import com.togethersoft.sca.internal.jparser.ast.Declaration;
import com.togethersoft.sca.internal.jparser.ast.DeclarationStmt;
import com.togethersoft.sca.internal.jparser.ast.DefaultLabel;
import com.togethersoft.sca.internal.jparser.ast.DoStmt;
import com.togethersoft.sca.internal.jparser.ast.EmptyStmt;
import com.togethersoft.sca.internal.jparser.ast.Expr;
import com.togethersoft.sca.internal.jparser.ast.ExprStmt;
import com.togethersoft.sca.internal.jparser.ast.FieldAccess;
import com.togethersoft.sca.internal.jparser.ast.FinallyClause;
import com.togethersoft.sca.internal.jparser.ast.ForStmt;
import com.togethersoft.sca.internal.jparser.ast.FormalParameter;
import com.togethersoft.sca.internal.jparser.ast.IfStmt;
import com.togethersoft.sca.internal.jparser.ast.ImportDeclaration;
import com.togethersoft.sca.internal.jparser.ast.IncDecExpr;
import com.togethersoft.sca.internal.jparser.ast.Inheritance;
import com.togethersoft.sca.internal.jparser.ast.Literal;
import com.togethersoft.sca.internal.jparser.ast.LogicalNotExpr;
import com.togethersoft.sca.internal.jparser.ast.MethodCall;
import com.togethersoft.sca.internal.jparser.ast.MethodDeclaration;
import com.togethersoft.sca.internal.jparser.ast.Model;
import com.togethersoft.sca.internal.jparser.ast.Modifiers;
import com.togethersoft.sca.internal.jparser.ast.Name;
import com.togethersoft.sca.internal.jparser.ast.NewExpr;
import com.togethersoft.sca.internal.jparser.ast.ParExpr;
import com.togethersoft.sca.internal.jparser.ast.ReturnStmt;
import com.togethersoft.sca.internal.jparser.ast.SimpleName;
import com.togethersoft.sca.internal.jparser.ast.Stmt;
import com.togethersoft.sca.internal.jparser.ast.SuperCall;
import com.togethersoft.sca.internal.jparser.ast.SuperExpr;
import com.togethersoft.sca.internal.jparser.ast.SwitchGroup;
import com.togethersoft.sca.internal.jparser.ast.SwitchStmt;
import com.togethersoft.sca.internal.jparser.ast.SynchronizedStmt;
import com.togethersoft.sca.internal.jparser.ast.ThisCall;
import com.togethersoft.sca.internal.jparser.ast.ThisExpr;
import com.togethersoft.sca.internal.jparser.ast.ThrowSpecifier;
import com.togethersoft.sca.internal.jparser.ast.ThrowStmt;
import com.togethersoft.sca.internal.jparser.ast.TryStmt;
import com.togethersoft.sca.internal.jparser.ast.TypeDeclaration;
import com.togethersoft.sca.internal.jparser.ast.TypeExpr;
import com.togethersoft.sca.internal.jparser.ast.UnaryPlusMinusExpr;
import com.togethersoft.sca.internal.jparser.ast.VariableDeclaration;
import com.togethersoft.sca.internal.jparser.ast.VariableDeclarator;
import com.togethersoft.sca.internal.jparser.ast.WhileStmt;
import com.togethersoft.sca.internal.jparser.classfile.ClassPath;
import com.togethersoft.sca.internal.jparser.symbol.CArrayType;
import com.togethersoft.sca.internal.jparser.symbol.CBlock;
import com.togethersoft.sca.internal.jparser.symbol.CClassType;
import com.togethersoft.sca.internal.jparser.symbol.CCompilationUnit;
import com.togethersoft.sca.internal.jparser.symbol.CDefinition;
import com.togethersoft.sca.internal.jparser.symbol.CMethod;
import com.togethersoft.sca.internal.jparser.symbol.CPackage;
import com.togethersoft.sca.internal.jparser.symbol.CPrimitiveType;
import com.togethersoft.sca.internal.jparser.symbol.CScope;
import com.togethersoft.sca.internal.jparser.symbol.CTopLevel;
import com.togethersoft.sca.internal.jparser.symbol.CType;
import com.togethersoft.sca.internal.jparser.symbol.CVariable;
import com.togethersoft.sca.internal.jparser.symbol.Constants;
import com.togethersoft.sca.internal.jparser.symbol.ContextStack;
import com.togethersoft.sca.internal.jparser.symbol.ErrorMgr;
import com.togethersoft.sca.internal.jparser.symbol.IndentingPrintWriter;
import com.togethersoft.sca.internal.jparser.symbol.MethodSet;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class Semantic
implements Constants {
    public CTopLevel topContext;
    CCompilationUnit currentFile;
    private ContextStack currentContext = new ContextStack();
    private Model model;
    ClassPath classpath;

    public Semantic(Model model, boolean createSymbolTable) {
        this.model = model;
        this.classpath = new ClassPath(model.getCompiler().getProject().getClasspath());
        if (createSymbolTable) {
            this.topContext = new CTopLevel(this);
            this.topContext.model = model;
        }
    }

    public void setSymbolTable(CTopLevel symbolTable) {
        this.topContext = symbolTable;
        this.topContext.model = this.model;
        this.topContext.sem = this;
    }

    public void report(OutputStream out, boolean showBinaryTypes) {
        IndentingPrintWriter ipw = new IndentingPrintWriter(out, true, showBinaryTypes);
        this.topContext.report(ipw);
    }

    public ContextStack getContext() {
        return this.currentContext;
    }

    public void processTypes(CompilationUnit astCu, CPackage ownerPackage) {
        this.currentFile = new CCompilationUnit(ownerPackage, astCu.getElementName(), astCu);
        this.currentFile.addImportedPackage(this.topContext.getJavaLangPackage());
        ownerPackage.addCUnit(this.currentFile);
        astCu.symbol = this.currentFile;
        int j = 0;
        while (j < astCu.numTypeDeclarations()) {
            this.processTypes(ownerPackage, null, null, this.currentFile, astCu.getTypeDeclaration(j));
            ++j;
        }
    }

    private void processTypes(CPackage ownerPackage, CClassType outermostType, CClassType ownerType, CScope parent, TypeDeclaration astType) {
        if (parent == ownerPackage && ownerPackage.lookupType(astType.getElementName()) != null) {
            ErrorMgr.report(33, ownerPackage.getQualifiedName() + "/" + astType.getElementName());
        }
        CClassType ctype = new CClassType(ownerPackage, outermostType, ownerType, parent, astType.getElementName(), null, 0, astType);
        ctype.setSourceFile();
        if (outermostType == null) {
            outermostType = ctype;
        }
        ctype.setOutermostType(outermostType);
        if (ownerType == null) {
            if (astType.isInterface()) {
                ctype.getAccess().processInterfaceModifiers(astType.modifiers);
            } else {
                ctype.getAccess().processClassModifiers(astType.modifiers);
            }
        } else if (ownerType.isInterface()) {
            if (astType.isInterface()) {
                ctype.getAccess().processStaticInterfaceModifiers(astType.modifiers);
            } else {
                ctype.getAccess().processStaticNestedClassModifiers(astType.modifiers);
            }
        } else if (astType.isInterface()) {
            ctype.getAccess().processNestedInterfaceModifiers(astType.modifiers);
        } else {
            ctype.getAccess().processNestedClassModifiers(astType.modifiers);
        }
        parent.addType(ctype);
        astType.symbol = ctype;
        astType.sourceFile = this.currentFile;
        int i = 0;
        while (i < astType.numNestedTypes()) {
            this.processTypes(ownerPackage, outermostType, ctype, ctype, astType.getNestedType(i));
            ++i;
        }
    }

    public void processImports(CompilationUnit ast) {
        this.currentFile = ast.symbol;
        int i = 0;
        while (i < ast.numImportDeclarations()) {
            ImportDeclaration im = ast.getImportDeclaration(i);
            CScope type = this.topContext.lookupImportedType((CPackage)this.currentFile.getParent(), im.type);
            if (type == null) {
                ErrorMgr.report(0, im.leftToken(), im.rightToken(), im.type.getFullName());
            } else if (im.importPackage) {
                im.setSymbol(type);
                this.currentFile.addImportedPackage(type);
            } else if (type instanceof CPackage) {
                ErrorMgr.report(0, im.leftToken(), im.rightToken(), im.type.getFullName());
            } else {
                im.setSymbol(type);
                this.currentFile.addImportedType((CClassType)type);
            }
            ++i;
        }
    }

    public void processSuperTypes(CompilationUnit ast) {
        int i = 0;
        while (i < ast.numTypeDeclarations()) {
            this.processSuperTypes(ast.getTypeDeclaration(i), true);
            ++i;
        }
    }

    private boolean processSuperTypes(TypeDeclaration astType, boolean processNested) {
        CClassType type = astType.symbol;
        if (type.isSuperComplete()) {
            return true;
        }
        if (type.isSuperProcessing()) {
            return false;
        }
        type.markSuperProcessing();
        if (!type.isNestedPending()) {
            if (!type.isSuperResolved()) {
                Inheritance superType;
                CCompilationUnit savedCurrentFile = this.currentFile;
                if (astType.sourceFile != null) {
                    this.currentFile = astType.sourceFile;
                }
                if ((superType = astType.getSuperType()) != null) {
                    CClassType sc = (CClassType)this.topContext.lookupType((CScope)type, superType.getType());
                    if (sc == null) {
                        ErrorMgr.report(0, superType.leftToken(), superType.rightToken(), superType.getType().getFullName());
                    } else if (this.processSuperTypes((TypeDeclaration)sc.astNode, false)) {
                        type.setSuperClass(sc);
                        superType.setSymbol(sc, type);
                    } else {
                        ErrorMgr.report(1, superType.leftToken(), superType.rightToken(), superType.getType().getFullName());
                    }
                } else if (type.isInterface() || type.isClass() && type != this.topContext.objectType) {
                    type.setSuperClass(this.topContext.objectType);
                    this.topContext.objectType.addSubclass(type);
                }
                int i = 0;
                while (i < astType.numInterfaces()) {
                    Inheritance superIface = astType.getInterface(i);
                    CClassType ifc = (CClassType)this.topContext.lookupType((CScope)type, superIface.getType());
                    if (ifc == null) {
                        ErrorMgr.report(0, superIface.leftToken(), superIface.rightToken(), superIface.getType().getFullName());
                    } else if (this.processSuperTypes((TypeDeclaration)ifc.astNode, false)) {
                        type.addInterface(ifc);
                        superIface.setSymbol(ifc, type);
                    } else {
                        ErrorMgr.report(1, superIface.leftToken(), superIface.rightToken(), superIface.getType().getFullName());
                    }
                    ++i;
                }
                this.currentFile = savedCurrentFile;
            } else {
                if (type.getSuperClass() != null) {
                    CClassType sc = type.getSuperClass();
                    if (!this.processSuperTypes((TypeDeclaration)sc.astNode, false)) {
                        ErrorMgr.report(1, "in super class " + sc.getQualifiedName() + " of " + type.getQualifiedName());
                        type.setSuperClass(null);
                    } else {
                        sc.addSubclass(type);
                    }
                }
                if (type.superIfaces != null) {
                    Iterator iter = ((AbstractList)type.superIfaces).iterator();
                    while (iter.hasNext()) {
                        CClassType ifc = (CClassType)iter.next();
                        if (!this.processSuperTypes((TypeDeclaration)ifc.astNode, false)) {
                            ErrorMgr.report(1, "in super interface " + ifc.getQualifiedName() + " of " + type.getQualifiedName());
                            iter.remove();
                            continue;
                        }
                        ifc.addSubclass(type);
                    }
                }
            }
        }
        type.unmarkSuperProcessing();
        if (processNested) {
            type.markSuperComplete();
            int i = 0;
            while (i < astType.numNestedTypes()) {
                this.processSuperTypes(astType.getNestedType(i), true);
                ++i;
            }
        } else {
            type.markNestedPending();
        }
        return true;
    }

    public void processMembers(CompilationUnit ast) {
        this.currentFile = ast.symbol;
        int i = 0;
        while (i < ast.numTypeDeclarations()) {
            this.processMembers(ast.getTypeDeclaration(i));
            ++i;
        }
    }

    private void processMembers(TypeDeclaration astType) {
        this.currentContext.push(astType.symbol);
        this.processFields(astType);
        this.processMethods(astType);
        int i = 0;
        while (i < astType.numNestedTypes()) {
            this.processMembers(astType.getNestedType(i));
            ++i;
        }
        this.currentContext.pop();
    }

    private void processMethods(TypeDeclaration astType) {
        CClassType ownerType = astType.symbol;
        int i = 0;
        while (i < astType.numClassInitializers()) {
            ClassInitializer init = astType.getClassInitializer(i);
            int mods = init.isStatic() ? 8 : 0;
            CMethod method = new CMethod(ownerType, "<clinit>", this.topContext.voidType, mods, init);
            ownerType.addMethod(method);
            init.symbol = method;
            ++i;
        }
        if (astType.numConstructors() > 0) {
            int i2 = 0;
            while (i2 < astType.numConstructors()) {
                MethodDeclaration m = astType.getConstructor(i2);
                CMethod ctor = new CMethod(ownerType, ownerType.getName(), this.topContext.voidType, 0, m);
                ctor.getAccess().processConstructorModifiers(m.modifiers);
                ownerType.addConstructor(ctor);
                m.symbol = ctor;
                this.processThrowsClause(m);
                this.currentContext.push(ctor);
                int j = 0;
                while (j < m.numFormalParameters()) {
                    this.processParameterDeclaration(m.getFormalParameter(j));
                    ++j;
                }
                this.currentContext.pop();
                ++i2;
            }
        } else {
            CMethod ctor;
            MethodDeclaration ctorAst = new MethodDeclaration(new Modifiers(astType.getModifiers()), null, ownerType.getName(), null, null, null, null, null, null, null, null, true, false);
            ctorAst.setParent(astType);
            ctorAst.symbol = ctor = new CMethod(ownerType, ownerType.getName(), this.topContext.voidType, astType.getModifiers(), ctorAst);
            ownerType.addConstructor(ctor);
        }
        this.createDefaultInitializers(astType, ownerType);
        int i3 = 0;
        while (i3 < astType.numMethods()) {
            MethodDeclaration m = astType.getMethod(i3);
            CType type = this.topContext.lookupType((CScope)ownerType, m.retType);
            if (type == null) {
                ErrorMgr.report(0, m.retType.leftToken(), m.retType.rightToken(), m.retType.getFullName());
                type = this.topContext.badType;
            } else if (m.numBrackets() > 0) {
                type = type.getArrayType(this.topContext, m.numBrackets());
            }
            CMethod method = new CMethod(ownerType, m.getElementName(), type, 0, m);
            m.setSymbol(method);
            if (ownerType.isInterface()) {
                method.getAccess().processInterfaceMethodModifiers(m.modifiers);
            } else {
                method.getAccess().processMethodModifiers(m.modifiers);
            }
            this.processThrowsClause(m);
            this.currentContext.push(method);
            int j = 0;
            while (j < m.numFormalParameters()) {
                this.processParameterDeclaration(m.getFormalParameter(j));
                ++j;
            }
            ownerType.addMethod(method);
            this.currentContext.pop();
            ++i3;
        }
    }

    private void createDefaultInitializers(TypeDeclaration astType, CClassType ownerType) {
        CMethod ctor;
        MethodDeclaration ctorAst = new MethodDeclaration(null, null, "<init>", null, null, null, null, null, null, null, null, true, false);
        ctorAst.setParent(astType);
        ctorAst.symbol = ctor = new CMethod(ownerType, "<init>", this.topContext.voidType, 0, ctorAst);
        astType.setInstanceInitializer(ctorAst);
        ctorAst = new MethodDeclaration(null, null, "<clinit>", null, null, null, null, null, null, null, null, true, false);
        ctorAst.setParent(astType);
        ctorAst.symbol = ctor = new CMethod(ownerType, "<clinit>", this.topContext.voidType, 0, ctorAst);
        astType.setClassInitializer(ctorAst);
    }

    private void processParameterDeclaration(FormalParameter param) {
        CClassType ownerType = this.currentContext.currentType();
        CScope parentScope = this.currentContext.currentScope();
        CType type = this.topContext.lookupType(parentScope, param.typeSpec);
        if (type == null) {
            ErrorMgr.report(0, param.typeSpec.leftToken(), param.typeSpec.rightToken(), param.typeSpec.getFullName());
            type = this.topContext.badType;
        } else if (param.declarator.numBrackets() > 0) {
            type = type.getArrayType(this.topContext, param.declarator.numBrackets());
        }
        param.type = type;
        CVariable var = new CVariable(ownerType, parentScope, param.declarator.getElementName(), 0, param.declarator);
        var.setType(type);
        var.getAccess().processFormalModifiers(param.modifiers);
        param.declarator.setSymbol(var);
        parentScope.addVariable(var);
    }

    private void processThrowsClause(MethodDeclaration method) {
        int i = 0;
        while (i < method.numThrowSpecifiers()) {
            ThrowSpecifier spec = method.getThrowSpecifier(i);
            CType type = this.topContext.lookupType(this.currentContext.currentScope(), spec.getThrowType());
            if (type == null) {
                ErrorMgr.report(0, spec.getThrowType().leftToken(), spec.getThrowType().rightToken(), spec.getThrowType().getFullName());
                type = this.topContext.badType;
            } else if (!type.isClass()) {
                ErrorMgr.report(30, spec.getThrowType().leftToken(), spec.getThrowType().rightToken(), spec.getThrowType().getFullName());
                type = this.topContext.badType;
            } else if (!((CClassType)type).descendsFrom(this.topContext.throwableType)) {
                ErrorMgr.report(42, spec.getThrowType().leftToken(), spec.getThrowType().rightToken(), spec.getThrowType().getFullName());
                type = this.topContext.badType;
            }
            spec.setSymbol(type);
            ++i;
        }
    }

    private void processFields(TypeDeclaration astType) {
        int i = 0;
        while (i < astType.numFields()) {
            this.processVariableDeclaration(astType.getField(i), false);
            ++i;
        }
    }

    private void processVariableDeclaration(VariableDeclaration decl, boolean processInitializer) {
        CClassType ownerType = this.currentContext.currentType();
        CScope ownerScope = this.currentContext.currentScope();
        CType type = this.topContext.lookupType(ownerScope, decl.typeSpec);
        if (type == null) {
            ErrorMgr.report(0, decl.typeSpec.leftToken(), decl.typeSpec.rightToken(), decl.typeSpec.getFullName());
            type = this.topContext.badType;
        }
        int i = 0;
        while (i < decl.numDeclarators()) {
            VariableDeclarator v = decl.getDeclarator(i);
            CVariable var = new CVariable(ownerType, ownerScope, v.getElementName(), 0, v);
            CType varType = v.numBrackets() > 0 ? type.getArrayType(this.topContext, v.numBrackets()) : type;
            var.setType(varType);
            if (ownerScope != ownerType) {
                var.getAccess().processLocalModifiers(decl.modifiers);
            } else if (ownerType.isInterface()) {
                var.getAccess().processConstantModifiers(decl.modifiers);
            } else {
                var.getAccess().processFieldModifiers(decl.modifiers);
            }
            ownerScope.addVariable(var);
            v.setSymbol(var);
            if (processInitializer && v.initializer != null) {
                this.processVariableInitializer(var, v);
            }
            ++i;
        }
    }

    private void processVariableInitializer(CVariable var, VariableDeclarator v) {
        this.currentContext.currentVariable = var;
        v.initializer.exprType = this.topContext.badType;
        this.processExprOrStmt(v.initializer);
        v.getInitializerAssignment().leftExpr().exprType = var;
        this.processAssignExpr(v.getInitializerAssignment(), false);
        this.currentContext.currentVariable = null;
    }

    public void processBodies(CompilationUnit ast) {
        this.currentFile = ast.symbol;
        this.currentContext.push(ast.symbol.getPackage());
        int i = 0;
        while (i < ast.numTypeDeclarations()) {
            this.processBodies(ast.getTypeDeclaration(i), true);
            ++i;
        }
        this.currentContext.pop();
    }

    public void processInContext(Declaration scope, Ast tree) {
        CDefinition d = scope.getSymbol();
        if (d != null) {
            this.currentContext = new ContextStack(d);
            this.currentFile = d.getCompilationUnit();
            this.processExprOrStmt(tree);
        }
    }

    private void processBodies(TypeDeclaration astType, boolean processFields) {
        ArrayList<ExprStmt> instBody = new ArrayList<ExprStmt>();
        ArrayList<ExprStmt> classBody = new ArrayList<ExprStmt>();
        CClassType type = astType.symbol;
        this.currentContext.push(type);
        if (astType.numConstructors() == 0) {
            SuperCall call = new SuperCall(null, null, new SuperExpr(null), null, null, null);
            if (type.getSuperClass() != null) {
                call.exprType = type.getSuperClass().lookupDefaultConstructor(type);
                if (call.exprType == null) {
                    call.exprType = this.topContext.badType;
                }
            } else {
                call.exprType = this.topContext.badType;
            }
            instBody.add(new ExprStmt(call, null));
        }
        if (processFields) {
            int i = 0;
            while (i < astType.numFields()) {
                VariableDeclaration decl = astType.getField(i);
                int j = 0;
                while (j < decl.numDeclarators()) {
                    VariableDeclarator v = decl.getDeclarator(j);
                    if (v.initializer != null) {
                        this.processVariableInitializer(v.symbol, v);
                        if (v.isStatic()) {
                            classBody.add(new ExprStmt(v.getInitializerAssignment(), null));
                        } else {
                            instBody.add(new ExprStmt(v.getInitializerAssignment(), null));
                        }
                    }
                    ++j;
                }
                ++i;
            }
            Block body = new Block(null, classBody.toArray(new Stmt[classBody.size()]), null);
            astType.getClassInitializer().setBody(body);
            body = new Block(null, instBody.toArray(new Stmt[instBody.size()]), null);
            astType.getInstanceInitializer().setBody(body);
        }
        int i = 0;
        while (i < astType.numClassInitializers()) {
            ClassInitializer init = astType.getClassInitializer(i);
            this.processMethodDeclaration(init.symbol, init.getBlockBody());
            ++i;
        }
        int i2 = 0;
        while (i2 < astType.numConstructors()) {
            MethodDeclaration ctor = astType.getConstructor(i2);
            this.processMethodDeclaration(ctor.symbol, ctor.getBlockBody());
            ++i2;
        }
        int i3 = 0;
        while (i3 < astType.numMethods()) {
            MethodDeclaration mth = astType.getMethod(i3);
            this.processMethodDeclaration(mth.symbol, mth.getBlockBody());
            ++i3;
        }
        int i4 = 0;
        while (i4 < astType.numNestedTypes()) {
            this.processBodies(astType.getNestedType(i4), processFields);
            ++i4;
        }
        this.currentContext.pop();
    }

    private void processMethodDeclaration(CMethod method, Block body) {
        if (body != null) {
            this.currentContext.push(method);
            this.processBlock(body);
            this.currentContext.pop();
        }
    }

    private void processBlock(Block ast) {
        CBlock cblock = new CBlock(this.currentContext.currentType(), this.currentContext.currentScope(), null);
        this.currentContext.push(cblock);
        int i = 0;
        while (i < ast.numStatements()) {
            this.processExprOrStmt(ast.statement(i));
            ++i;
        }
        this.currentContext.pop();
    }

    void processExprOrStmt(Ast s) {
        boolean breakable = false;
        boolean continuable = false;
        if (s instanceof Stmt) {
            Stmt stmt = (Stmt)s;
            if (stmt.isBreakable() || stmt.isLabeled()) {
                breakable = true;
                this.currentContext.pushBreakable(stmt);
            }
            if (stmt.isContinuable()) {
                continuable = true;
                this.currentContext.pushContinuable(stmt);
            }
        }
        switch (s.astType()) {
            case 14: {
                this.processLiteral((Literal)s);
                break;
            }
            case 62: {
                this.processAssertStmt((AssertStmt)s);
                break;
            }
            case 1: {
                this.processAssignExpr((AssignExpr)s, true);
                break;
            }
            case 2: {
                this.processBinaryExpr((BinaryExpr)s);
                break;
            }
            case 3: {
                this.processBlock((Block)s);
                break;
            }
            case 4: {
                this.processCastExpr((CastExpr)s);
                break;
            }
            case 7: {
                this.processConditionalExpr((ConditionalExpr)s);
                break;
            }
            case 10: {
                this.processFieldAccess((FieldAccess)s);
                break;
            }
            case 36: {
                this.processArrayAccess((ArrayAccess)s);
                break;
            }
            case 11: {
                this.processParameterDeclaration((FormalParameter)s);
                break;
            }
            case 16: {
                this.processMethodCall((MethodCall)s);
                break;
            }
            case 20: {
                this.processNewExpr((NewExpr)s);
                break;
            }
            case 39: {
                this.processArrayCreationExpr((ArrayCreationExpr)s);
                break;
            }
            case 22: {
                this.processSimpleName((SimpleName)s);
                break;
            }
            case 24: {
                this.processSuperExpr((SuperExpr)s);
                break;
            }
            case 25: {
                this.processThisExpr((ThisExpr)s);
                break;
            }
            case 26: {
                this.processLocalClass((TypeDeclaration)s);
                break;
            }
            case 27: {
                this.processTypeExpr((TypeExpr)s);
                break;
            }
            case 28: {
                this.processVariableDeclaration((VariableDeclaration)s, true);
                break;
            }
            case 31: {
                this.processUnaryPlusMinusExpr((UnaryPlusMinusExpr)s);
                break;
            }
            case 32: {
                this.processIncDecExpr((IncDecExpr)s);
                break;
            }
            case 34: {
                this.processBinaryNotExpr((BinaryNotExpr)s);
                break;
            }
            case 35: {
                this.processLogicalNotExpr((LogicalNotExpr)s);
                break;
            }
            case 8: {
                this.processEmptyStmt((EmptyStmt)s);
                break;
            }
            case 9: {
                this.processExprStmt((ExprStmt)s);
                break;
            }
            case 41: {
                this.processIfStmt((IfStmt)s);
                break;
            }
            case 42: {
                this.processDoStmt((DoStmt)s);
                break;
            }
            case 43: {
                this.processWhileStmt((WhileStmt)s);
                break;
            }
            case 44: {
                this.processForStmt((ForStmt)s);
                break;
            }
            case 45: {
                this.processSynchronizedStmt((SynchronizedStmt)s);
                break;
            }
            case 46: {
                this.processParExpr((ParExpr)s);
                break;
            }
            case 47: {
                this.processFinallyClause((FinallyClause)s);
                break;
            }
            case 48: {
                this.processCatchClause((CatchClause)s);
                break;
            }
            case 51: {
                this.processTryStmt((TryStmt)s);
                break;
            }
            case 52: {
                this.processThrowStmt((ThrowStmt)s);
                break;
            }
            case 53: {
                this.processSwitchStmt((SwitchStmt)s);
                break;
            }
            case 55: {
                this.processReturnStmt((ReturnStmt)s);
                break;
            }
            case 56: {
                this.processContinueStmt((ContinueStmt)s);
                break;
            }
            case 57: {
                this.processBreakStmt((BreakStmt)s);
                break;
            }
            case 58: {
                this.processThisCall((ThisCall)s);
                break;
            }
            case 30: {
                this.processSuperCall((SuperCall)s);
                break;
            }
            case 59: {
                this.processDeclarationStmt((DeclarationStmt)s);
                break;
            }
            case 38: {
                this.processArrayInitializer((ArrayInitializer)s);
                break;
            }
            case 64: {
                this.processDbcResultExpr((DbcResultExpr)s);
                break;
            }
            default: {
                ErrorMgr.report(31, s.leftToken(), s.rightToken());
            }
        }
        if (breakable) {
            this.currentContext.popBreakable();
        }
        if (continuable) {
            this.currentContext.popContinuable();
        }
    }

    private void processDbcResultExpr(DbcResultExpr e) {
        CMethod m = this.currentContext.currentMethod();
        e.exprType = m != null ? m.getType() : this.topContext.badType;
    }

    private void processAssertStmt(AssertStmt s) {
        MethodSet set;
        AstVector args = new AstVector(1);
        this.processExprOrStmt(s.condition());
        this.checkBooleanExpr(s.condition());
        if (s.argument() != null) {
            this.processExprOrStmt(s.argument());
            args.add(s.argument());
        }
        if ((set = this.topContext.assertionErrorType.lookupConstructor(this.currentContext.currentType(), args)) == null || set.size() == 0) {
            ErrorMgr.report(27, s.leftToken(), s.rightToken(), "AssertionError");
        } else if (set.size() > 1) {
            ErrorMgr.report(28, s.leftToken(), s.rightToken(), "AssertionError");
        } else {
            CMethod method = set.get(0);
            method.addReference(s);
            s.ctor = method.getAST();
            if (s.argument() != null) {
                s.argument().runtype = method.getFormalParameter(0).getType();
            }
        }
    }

    private void processAssignExpr(AssignExpr s, boolean processOperands) {
        if (processOperands) {
            this.processExprOrStmt(s.leftExpr());
            this.processExprOrStmt(s.rightExpr());
        }
        CType leftType = s.leftExpr().type();
        CType rightType = s.rightExpr().type();
        s.rightExpr().runtype = leftType;
        if (leftType.isBad() || rightType.isBad() || !this.checkLvalue(s.leftExpr(), s.parent().astType() != 29)) {
            s.exprType = this.topContext.badType;
            s.leftExpr().runtype = this.topContext.badType;
            s.rightExpr().runtype = this.topContext.badType;
            return;
        }
        s.exprType = s.getExpressionKind() == 0 ? (rightType.isAssignableTo(leftType) ? s.leftExpr().getDef() : (leftType == this.topContext.byteType || leftType == this.topContext.shortType || leftType == this.topContext.charType ? (rightType.isIntegral() || rightType != this.topContext.longType ? s.leftExpr().getDef() : this.topContext.badType) : this.topContext.badType)) : (s.getExpressionKind() == 1 && leftType == this.topContext.stringType ? s.leftExpr().getDef() : (!leftType.isPrimitive() || !rightType.isPrimitive() ? this.topContext.badType : s.leftExpr().getDef()));
        if (s.type().isBad()) {
            ErrorMgr.report(6, s.leftToken(), s.rightToken(), leftType.getQualifiedName(), rightType.getQualifiedName());
        }
    }

    private void processBinaryExpr(BinaryExpr e) {
        this.processExprOrStmt(e.leftExpr());
        this.processExprOrStmt(e.rightExpr());
        CType leftType = e.leftExpr().type();
        CType rightType = e.rightExpr().type();
        if (leftType.isBad() || rightType.isBad()) {
            switch (e.getExpressionKind()) {
                case 9: 
                case 10: 
                case 11: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    e.exprType = this.topContext.booleanType;
                    return;
                }
            }
            e.exprType = this.topContext.badType;
            e.leftExpr().runtype = this.topContext.badType;
            e.rightExpr().runtype = this.topContext.badType;
            return;
        }
        switch (e.getExpressionKind()) {
            case 4: {
                if (leftType == this.topContext.stringType || rightType == this.topContext.stringType) {
                    e.exprType = this.topContext.stringType;
                    e.leftExpr().runtype = this.topContext.stringType;
                    e.rightExpr().runtype = this.topContext.stringType;
                    break;
                }
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                if (!leftType.isNumeric()) {
                    ErrorMgr.report(4, e.leftExpr().leftToken(), e.leftExpr().rightToken(), leftType.getQualifiedName());
                    e.exprType = this.topContext.badType;
                    break;
                }
                if (!rightType.isNumeric()) {
                    ErrorMgr.report(4, e.rightExpr().leftToken(), e.rightExpr().rightToken(), rightType.getQualifiedName());
                    e.exprType = this.topContext.badType;
                    break;
                }
                e.exprType = this.promoteBinaryExpr(e.leftExpr(), e.rightExpr());
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                if (!leftType.isIntegral()) {
                    ErrorMgr.report(5, e.leftExpr().leftToken(), e.leftExpr().rightToken(), leftType.getQualifiedName());
                    e.exprType = this.topContext.badType;
                    break;
                }
                if (!rightType.isIntegral()) {
                    ErrorMgr.report(5, e.rightExpr().leftToken(), e.rightExpr().rightToken(), rightType.getQualifiedName());
                    e.exprType = this.topContext.badType;
                    break;
                }
                this.promoteUnaryExpr(e.rightExpr());
                e.exprType = this.promoteUnaryExpr(e.leftExpr());
                break;
            }
            case 9: {
                if (!leftType.isReference() && !leftType.isNull()) {
                    ErrorMgr.report(24, e.leftExpr().leftToken(), e.leftExpr().rightToken(), leftType.getQualifiedName());
                } else if (!rightType.isReference() && !rightType.isNull()) {
                    ErrorMgr.report(24, e.rightExpr().leftToken(), e.rightExpr().rightToken(), rightType.getQualifiedName());
                }
                e.exprType = this.topContext.booleanType;
                break;
            }
            case 10: 
            case 11: 
            case 17: 
            case 18: {
                if (!leftType.isNumeric()) {
                    ErrorMgr.report(4, e.leftExpr().leftToken(), e.leftExpr().rightToken(), leftType.getQualifiedName());
                } else if (!rightType.isNumeric()) {
                    ErrorMgr.report(4, e.rightExpr().leftToken(), e.rightExpr().rightToken(), rightType.getQualifiedName());
                } else {
                    this.promoteBinaryExpr(e.leftExpr(), e.rightExpr());
                }
                e.exprType = this.topContext.booleanType;
                break;
            }
            case 19: 
            case 20: {
                if (leftType.isNumeric() && rightType.isNumeric()) {
                    this.promoteBinaryExpr(e.leftExpr(), e.rightExpr());
                } else if (!(leftType.isBoolean() && rightType.isBoolean() || (leftType.isReference() || leftType.isNull()) && (rightType.isReference() || rightType.isNull()))) {
                    ErrorMgr.report(6, e.leftToken(), e.rightToken(), leftType.getQualifiedName(), rightType.getQualifiedName());
                }
                e.exprType = this.topContext.booleanType;
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                if (leftType == this.topContext.booleanType && rightType == this.topContext.booleanType) {
                    e.exprType = this.topContext.booleanType;
                    break;
                }
                if (leftType.isIntegral() && rightType.isIntegral()) {
                    e.exprType = this.promoteBinaryExpr(e.leftExpr(), e.rightExpr());
                    break;
                }
                ErrorMgr.report(6, e.leftToken(), e.rightToken(), leftType.getQualifiedName(), rightType.getQualifiedName());
                e.exprType = this.topContext.badType;
                break;
            }
            case 15: 
            case 16: {
                if (!leftType.isBoolean()) {
                    ErrorMgr.report(35, e.leftExpr().leftToken(), e.leftExpr().rightToken(), leftType.getQualifiedName());
                } else if (!rightType.isBoolean()) {
                    ErrorMgr.report(35, e.rightExpr().leftToken(), e.rightExpr().rightToken(), rightType.getQualifiedName());
                }
                e.exprType = this.topContext.booleanType;
            }
        }
        if (e.leftExpr().isConstant() && e.rightExpr().isConstant && this.isConstantType(e.type()) && e.getExpressionKind() != 9) {
            e.isConstant = true;
        }
    }

    private void processCastExpr(CastExpr s) {
        this.processExprOrStmt(s.expression);
        this.processTypeExpr(s.typeSpec);
        s.exprType = s.typeSpec.exprType;
        s.exprType.addReference(s);
        if (s.expression.isConstant() && this.isConstantType(s.typeSpec.type())) {
            s.isConstant = true;
        }
    }

    private void processConditionalExpr(ConditionalExpr s) {
        this.processExprOrStmt(s.testExpr());
        this.processExprOrStmt(s.trueExpr());
        this.processExprOrStmt(s.falseExpr());
        CType trueType = s.trueExpr().type();
        CType falseType = s.falseExpr().type();
        if (trueType.isBad() || falseType.isBad()) {
            s.exprType = this.topContext.badType;
        } else if (trueType == falseType) {
            s.exprType = trueType;
        } else if (trueType.isNumeric()) {
            if (!falseType.isNumeric()) {
                ErrorMgr.report(6, s.leftToken(), s.rightToken(), trueType.getQualifiedName(), falseType.getQualifiedName());
                s.exprType = this.topContext.badType;
                return;
            }
            s.exprType = trueType == this.topContext.byteType && falseType == this.topContext.shortType ? this.topContext.shortType : (trueType == this.topContext.shortType && falseType == this.topContext.byteType ? this.topContext.shortType : this.promoteBinaryExpr(s.trueExpr(), s.falseExpr()));
        } else {
            if (falseType.isNumeric()) {
                ErrorMgr.report(6, s.leftToken(), s.rightToken(), trueType.getQualifiedName(), falseType.getQualifiedName());
                s.exprType = this.topContext.badType;
                return;
            }
            if (trueType == this.topContext.nullType) {
                s.exprType = falseType;
            } else if (falseType == this.topContext.nullType) {
                s.exprType = trueType;
            } else if (trueType.isAssignableTo(falseType)) {
                s.exprType = falseType;
            } else if (falseType.isAssignableTo(trueType)) {
                s.exprType = trueType;
            } else {
                ErrorMgr.report(6, s.leftToken(), s.rightToken(), trueType.getQualifiedName(), falseType.getQualifiedName());
                s.exprType = this.topContext.badType;
            }
        }
        if (s.testExpr().isConstant() && s.trueExpr().isConstant() && s.falseExpr().isConstant() && this.isConstantType(s.type())) {
            s.isConstant = true;
        }
    }

    private void processNewExpr(NewExpr s) {
        CType type;
        CClassType anonClass = null;
        int i = 0;
        while (i < s.numArguments()) {
            Expr expr = s.argument(i);
            this.processExprOrStmt(expr);
            ++i;
        }
        s.exprType = this.topContext.badType;
        if (s.base != null) {
            this.processExprOrStmt(s.base);
            if (!s.base.type().isReference()) {
                ErrorMgr.report(24, s.base.leftToken(), s.base.rightToken(), s.base.exprType.getQualifiedName());
            } else if (s.typeSpec.base() != null) {
                ErrorMgr.report(25, s.base.leftToken(), s.base.rightToken(), s.typeSpec.getFullName());
            }
        }
        if ((type = this.topContext.lookupType(this.currentContext.currentScope(), s.typeSpec)) == null) {
            ErrorMgr.report(0, s.leftToken(), s.rightToken(), s.typeSpec.getFullName());
        } else if (!type.isClass() && !type.isInterface()) {
            ErrorMgr.report(30, s.typeSpec.leftToken(), s.typeSpec.rightToken(), type.getQualifiedName());
            type = null;
        } else if (s.body() == null && (type.isAbstract() || type.isInterface())) {
            ErrorMgr.report(29, s.typeSpec.leftToken(), s.typeSpec.rightToken(), type.getQualifiedName());
            type = null;
        }
        if (s.getClassBody() != null) {
            anonClass = this.processAnonymousClass(s.classBody, type != null ? (CClassType)type : this.topContext.objectType);
        }
        if (type != null) {
            CClassType from;
            CClassType stype;
            if (s.body() != null) {
                stype = type.isInterface() ? this.topContext.objectType : (CClassType)type;
                from = anonClass;
            } else {
                stype = (CClassType)type;
                from = this.currentContext.currentType();
            }
            MethodSet set = stype.lookupConstructor(from, s.getArgumentsVector());
            if (set == null || set.size() == 0) {
                ErrorMgr.report(27, s.leftToken(), s.rightToken(), type.getQualifiedName());
            } else if (set.size() > 1) {
                ErrorMgr.report(28, s.leftToken(), s.rightToken(), type.getQualifiedName());
            } else {
                CMethod method = set.get(0);
                method.addReference(s);
                s.ctor = method.getAST();
                s.exprType = type.getThisObject();
                int i2 = 0;
                while (i2 < s.numArguments()) {
                    s.argument((int)i2).runtype = method.getFormalParameter(i2).getType();
                    ++i2;
                }
            }
        }
    }

    private CClassType processAnonymousClass(TypeDeclaration decl, CClassType superType) {
        CClassType ownerType = this.currentContext.currentType();
        CPackage ownerPackage = ownerType.getPackage();
        CClassType outermostType = ownerType.getOutermostType();
        String name = outermostType.getName() + "$" + outermostType.getAnonymousId();
        CScope parent = this.currentContext.currentScope();
        CClassType ctype = new CClassType(ownerPackage, outermostType, ownerType, parent, name, name, 16, decl);
        ctype.setSourceFile();
        decl.symbol = ctype;
        decl.typeName = name;
        if (superType.isClass()) {
            ctype.setSuperClass(superType);
        } else {
            ctype.setSuperClass(this.topContext.objectType);
            ctype.addInterface(superType);
        }
        int i = 0;
        while (i < decl.numNestedTypes()) {
            this.processTypes(ownerPackage, outermostType, ctype, ctype, decl.getNestedType(i));
            ++i;
        }
        this.processMembers(decl);
        this.processBodies(decl, true);
        return ctype;
    }

    private void processLocalClass(TypeDeclaration decl) {
        CClassType ownerType = this.currentContext.currentType();
        CPackage ownerPackage = ownerType.getPackage();
        CClassType outermostType = ownerType.getOutermostType();
        String scopedName = outermostType.getName() + "$" + outermostType.getAnonymousId() + "$" + decl.getElementName();
        CScope parent = this.currentContext.currentScope();
        CClassType ctype = new CClassType(ownerPackage, outermostType, ownerType, parent, decl.getElementName(), scopedName, 0, decl);
        ctype.setSourceFile();
        this.currentContext.currentScope().addType(ctype);
        decl.symbol = ctype;
        int i = 0;
        while (i < decl.numNestedTypes()) {
            this.processTypes(ownerPackage, outermostType, ctype, ctype, decl.getNestedType(i));
            ++i;
        }
        this.processSuperTypes(decl, true);
        this.processMembers(decl);
        this.processBodies(decl, true);
    }

    private void processArrayCreationExpr(ArrayCreationExpr s) {
        CType type;
        int i = 0;
        while (i < s.numDimensions()) {
            Brackets br = s.dimension(i);
            if (br.expr != null) {
                this.processExprOrStmt(br.expr);
                if (this.promoteUnaryExpr(br.expr) != this.topContext.intType) {
                    CType indexType = br.expr.type();
                    ErrorMgr.report(23, br.expr.leftToken(), br.expr.rightToken(), indexType != null ? indexType.getQualifiedName() : null);
                }
            }
            ++i;
        }
        if (s.initializer != null) {
            this.processExprOrStmt(s.initializer);
        }
        if ((type = this.topContext.lookupType(this.currentContext.currentScope(), s.arrayType)) == null) {
            ErrorMgr.report(0, s.leftToken(), s.rightToken(), s.arrayType.getFullName());
            s.exprType = this.topContext.badType;
        } else {
            type.addReference(s);
            type = type.getArrayType(this.topContext, s.numDimensions());
            s.exprType = type.getThisObject();
        }
    }

    private void processSimpleName(SimpleName s) {
        CVariable v = this.topContext.lookupSimpleExpression(this.currentContext.currentScope(), s);
        if (v == null) {
            ErrorMgr.report(2, s.leftToken(), s.rightToken(), s.getFullName());
            s.exprType = this.topContext.badType;
        } else {
            s.exprType = v;
            if (v.isFinal()) {
                VariableDeclarator var = (VariableDeclarator)v.getAST();
                if (var.initializer != null) {
                    this.resolveConstant(v, var);
                    if (var.initializer.isConstant()) {
                        s.isConstant = true;
                    }
                }
            }
        }
    }

    private void processFieldAccess(FieldAccess s) {
        this.topContext.lookupAmbiguousName(this.currentContext.currentScope(), s);
        if (s.exprType == this.topContext.badType) {
            return;
        }
        if (s.exprType instanceof CPackage) {
            ErrorMgr.report(2, s.leftToken(), s.rightToken(), s.getFullName());
            s.exprType = this.topContext.badType;
        } else if (s.exprType instanceof CType) {
            ErrorMgr.report(41, s.leftToken(), s.rightToken(), s.getFullName());
            s.exprType = this.topContext.badType;
        } else {
            CVariable v = (CVariable)s.exprType;
            if (v.isFinal() && s.base().exprType instanceof CType) {
                VariableDeclarator var = (VariableDeclarator)v.getAST();
                if (var.initializer != null) {
                    this.resolveConstant(v, var);
                    if (var.initializer.isConstant()) {
                        s.isConstant = true;
                    }
                }
            }
        }
    }

    private void resolveConstant(CVariable v, VariableDeclarator var) {
        if (var.initializer.exprType == null) {
            ContextStack saveContext = this.currentContext;
            this.currentContext = new ContextStack(v.getOwnerType());
            CCompilationUnit saveFile = this.currentFile;
            this.currentFile = v.getCompilationUnit();
            this.processVariableInitializer(v, var);
            this.currentFile = saveFile;
            this.currentContext = saveContext;
        }
    }

    private void processArrayAccess(ArrayAccess s) {
        this.processExprOrStmt(s.base);
        this.processExprOrStmt(s.index);
        CType baseType = s.base.type();
        CType indexType = s.index.type();
        if (baseType.isBad() || indexType.isBad()) {
            s.exprType = this.topContext.badType;
        } else if (!baseType.isArray()) {
            ErrorMgr.report(22, s.base.leftToken(), s.base.rightToken(), baseType.getQualifiedName());
            s.exprType = this.topContext.badType;
        } else if (this.promoteUnaryExpr(s.index) != this.topContext.intType) {
            ErrorMgr.report(23, s.index.leftToken(), s.index.rightToken(), indexType.getQualifiedName());
            s.exprType = this.topContext.badType;
        } else {
            s.exprType = ((CArrayType)baseType).getElementType().getThisObject();
        }
    }

    private void processMethodCall(MethodCall m) {
        int i = 0;
        while (i < m.numArguments()) {
            Expr expr = m.argument(i);
            this.processExprOrStmt(expr);
            ++i;
        }
        if (m.method instanceof Name) {
            Name methodName = (Name)m.method;
            MethodSet set = this.topContext.lookupMethod(this.currentContext.currentScope(), methodName, m.getArgumentsVector());
            if (set == null || set.size() == 0) {
                ErrorMgr.report(7, m.leftToken(), m.rightToken(), methodName.getName());
                methodName.exprType = m.exprType = this.topContext.badType;
            } else if (set.size() > 1) {
                ErrorMgr.report(9, m.leftToken(), m.rightToken(), methodName.getName());
                methodName.exprType = m.exprType = this.topContext.badType;
            } else {
                CMethod method = set.get(0);
                method.addReference(m);
                methodName.exprType = m.exprType = method;
                int i2 = 0;
                while (i2 < m.numArguments()) {
                    m.argument((int)i2).runtype = method.getFormalParameter(i2).getType();
                    ++i2;
                }
            }
        } else {
            ErrorMgr.report(10, m.leftToken(), m.rightToken(), null);
            m.exprType = this.topContext.badType;
        }
    }

    private CType promoteUnaryExpr(Expr expr) {
        CType type = expr.type();
        if (!type.isNumeric()) {
            ErrorMgr.report(4, expr.leftToken(), expr.rightToken(), type.getQualifiedName());
            return this.topContext.badType;
        }
        CType promotedType = type;
        if (type == this.topContext.byteType || type == this.topContext.charType || type == this.topContext.shortType) {
            promotedType = this.topContext.intType;
        }
        expr.runtype = promotedType;
        return promotedType;
    }

    private CType promoteBinaryExpr(Expr leftExpr, Expr rightExpr) {
        CType leftType = leftExpr.type();
        CType rightType = rightExpr.type();
        if (!leftType.isNumeric()) {
            ErrorMgr.report(4, leftExpr.leftToken(), leftExpr.rightToken(), leftType.getQualifiedName());
            return this.topContext.badType;
        }
        if (!rightType.isNumeric()) {
            ErrorMgr.report(4, rightExpr.leftToken(), rightExpr.rightToken(), rightType.getQualifiedName());
            return this.topContext.badType;
        }
        CPrimitiveType promotedType = leftType == this.topContext.doubleType ? this.topContext.doubleType : (rightType == this.topContext.doubleType ? this.topContext.doubleType : (leftType == this.topContext.floatType ? this.topContext.floatType : (rightType == this.topContext.floatType ? this.topContext.floatType : (leftType == this.topContext.longType ? this.topContext.longType : (rightType == this.topContext.longType ? this.topContext.longType : this.topContext.intType)))));
        leftExpr.runtype = promotedType;
        rightExpr.runtype = promotedType;
        return promotedType;
    }

    private void processLiteral(Literal s) {
        if (!s.eval()) {
            s.exprType = this.topContext.badType;
            return;
        }
        switch (s.getLiteralKind()) {
            case 0: {
                s.exprType = this.topContext.intType;
                break;
            }
            case 1: {
                s.exprType = this.topContext.longType;
                break;
            }
            case 2: {
                s.exprType = this.topContext.floatType;
                break;
            }
            case 3: {
                s.exprType = this.topContext.doubleType;
                break;
            }
            case 4: {
                s.exprType = this.topContext.booleanType;
                break;
            }
            case 5: {
                s.exprType = this.topContext.charType;
                break;
            }
            case 6: {
                s.exprType = this.topContext.stringType;
                break;
            }
            case 7: {
                s.exprType = this.topContext.nullType;
                break;
            }
            default: {
                s.exprType = this.topContext.badType;
            }
        }
        if (s.getLiteralKind() != 7) {
            s.isConstant = true;
        }
    }

    private void processUnaryPlusMinusExpr(UnaryPlusMinusExpr s) {
        this.processExprOrStmt(s.expression);
        s.exprType = this.promoteUnaryExpr(s.expression);
        if (s.expression.isConstant() && this.isConstantType(s.type())) {
            s.isConstant = true;
        }
    }

    private void processIncDecExpr(IncDecExpr s) {
        this.processExprOrStmt(s.expr());
        if (this.checkLvalue(s.expr(), true)) {
            CType type = s.expr().type();
            if (!type.isNumeric()) {
                ErrorMgr.report(4, s.expr().leftToken(), s.expr().rightToken(), type.getQualifiedName());
                s.exprType = this.topContext.badType;
            } else {
                s.exprType = s.expr().getDef();
            }
        } else {
            s.exprType = this.topContext.badType;
        }
    }

    private void processBinaryNotExpr(BinaryNotExpr s) {
        this.processExprOrStmt(s.expr());
        if (!s.expr().type().isIntegral()) {
            if (!s.type().isBad()) {
                ErrorMgr.report(5, s.expr().leftToken(), s.expr().rightToken(), s.expr().type().getQualifiedName());
            }
            s.exprType = this.topContext.badType;
        } else {
            s.exprType = this.promoteUnaryExpr(s.expr());
        }
        if (s.expr().isConstant() && this.isConstantType(s.type())) {
            s.isConstant = true;
        }
    }

    private void processLogicalNotExpr(LogicalNotExpr s) {
        this.processExprOrStmt(s.expr());
        this.checkBooleanExpr(s.expr());
        s.exprType = this.topContext.booleanType;
        if (s.expr().isConstant() && this.isConstantType(s.type())) {
            s.isConstant = true;
        }
    }

    private void processThisExpr(ThisExpr s) {
        if (this.currentContext.isStaticContext()) {
            ErrorMgr.report(19, s.leftToken(), s.rightToken());
            s.exprType = this.topContext.badType;
        } else {
            s.exprType = this.currentContext.currentType().getThisObject();
        }
    }

    private void processSuperExpr(SuperExpr s) {
        if (this.currentContext.isStaticContext()) {
            ErrorMgr.report(20, s.leftToken(), s.rightToken());
            s.exprType = this.topContext.badType;
        } else if (this.currentContext.currentType() == this.topContext.objectType) {
            ErrorMgr.report(21, s.leftToken(), s.rightToken());
            s.exprType = this.topContext.badType;
        } else {
            s.exprType = this.currentContext.currentType().getSuperClass();
        }
    }

    private void processEmptyStmt(EmptyStmt s) {
    }

    private void processExprStmt(ExprStmt s) {
        this.processExprOrStmt(s.expr());
    }

    private void processIfStmt(IfStmt s) {
        this.processExprOrStmt(s.condition());
        this.checkBooleanExpr(s.condition());
        this.processExprOrStmt(s.thenStmt());
        if (s.elseStmt() != null) {
            this.processExprOrStmt(s.elseStmt());
        }
    }

    private void processDoStmt(DoStmt s) {
        this.processExprOrStmt(s.condition());
        this.checkBooleanExpr(s.condition());
        this.processExprOrStmt(s.body());
    }

    private void processWhileStmt(WhileStmt s) {
        this.processExprOrStmt(s.condition());
        this.checkBooleanExpr(s.condition());
        this.processExprOrStmt(s.body());
    }

    private void processForStmt(ForStmt s) {
        CBlock scope = new CBlock(this.currentContext.currentType(), this.currentContext.currentScope(), null);
        this.currentContext.push(scope);
        int i = 0;
        while (i < s.numInitStatements()) {
            this.processExprOrStmt(s.initStatement(i));
            ++i;
        }
        if (s.condition() != null) {
            this.processExprOrStmt(s.condition());
            this.checkBooleanExpr(s.condition());
        }
        int i2 = 0;
        while (i2 < s.numUpdateStatements()) {
            this.processExprOrStmt(s.updateStatement(i2));
            ++i2;
        }
        this.processExprOrStmt(s.body());
        this.currentContext.pop();
    }

    private void processSynchronizedStmt(SynchronizedStmt s) {
        this.processExprOrStmt(s.condition());
        this.processExprOrStmt(s.body());
    }

    private void processParExpr(ParExpr s) {
        this.processExprOrStmt(s.expr());
        s.exprType = s.expr().exprType;
    }

    private void processFinallyClause(FinallyClause s) {
        this.processExprOrStmt(s.body());
    }

    private void processCatchClause(CatchClause s) {
        CBlock scope = new CBlock(this.currentContext.currentType(), this.currentContext.currentScope(), null);
        this.currentContext.push(scope);
        this.processExprOrStmt(s.param());
        this.processExprOrStmt(s.body());
        this.currentContext.pop();
    }

    private void processDefaultLabel(DefaultLabel s) {
    }

    private void processCaseLabel(CaseLabel s, Expr selectExpr) {
        this.processExprOrStmt(s.expr());
        s.expr().runtype = selectExpr.runtype;
    }

    private void processTryStmt(TryStmt s) {
        this.processExprOrStmt(s.body());
        int i = 0;
        while (i < s.numCatchClauses()) {
            this.processExprOrStmt(s.catchClause(i));
            ++i;
        }
        if (s.finallyClause() != null) {
            this.processExprOrStmt(s.finallyClause());
        }
    }

    private void processThrowStmt(ThrowStmt s) {
        this.processExprOrStmt(s.expr());
    }

    private void processSwitchStmt(SwitchStmt s) {
        Expr selectExpr = s.condition();
        this.processExprOrStmt(selectExpr);
        selectExpr.runtype = this.promoteUnaryExpr(selectExpr);
        int i = 0;
        while (i < s.numSwitchGroups()) {
            this.processSwitchGroup(s.getSwitchGroup(i), selectExpr);
            ++i;
        }
    }

    private void processSwitchGroup(SwitchGroup s, Expr selectExpr) {
        int i = 0;
        while (i < s.numCaseLabels()) {
            Ast label = s.getCaseLabel(i);
            if (label.astType() == 49) {
                this.processDefaultLabel((DefaultLabel)label);
            } else {
                this.processCaseLabel((CaseLabel)label, selectExpr);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < s.numStatements()) {
            this.processExprOrStmt(s.getStatement(i2));
            ++i2;
        }
    }

    private void processReturnStmt(ReturnStmt s) {
        if (s.expr() != null) {
            this.processExprOrStmt(s.expr());
            s.expr().runtype = this.currentContext.currentMethod().getType();
        }
    }

    private void processContinueStmt(ContinueStmt s) {
        s.target = this.currentContext.lookupContinueTarget(s.getLabelName());
        if (s.target == null) {
            ErrorMgr.report(37, s.leftToken(), s.rightToken(), s.getLabelName());
        }
    }

    private void processBreakStmt(BreakStmt s) {
        s.target = this.currentContext.lookupBreakTarget(s.getLabelName());
        if (s.target == null) {
            ErrorMgr.report(36, s.leftToken(), s.rightToken(), s.getLabelName());
        }
    }

    private void processThisCall(ThisCall s) {
        s.exprType = this.topContext.voidType;
        int i = 0;
        while (i < s.numArguments()) {
            Expr expr = s.argument(i);
            this.processExprOrStmt(expr);
            ++i;
        }
        CClassType thisType = this.currentContext.currentType();
        MethodSet set = thisType.lookupConstructor(thisType, s.getArgumentsVector());
        if (set == null || set.size() == 0) {
            ErrorMgr.report(27, s.leftToken(), s.rightToken(), thisType.getQualifiedName());
        } else if (set.size() > 1) {
            ErrorMgr.report(28, s.leftToken(), s.rightToken(), thisType.getQualifiedName());
        } else {
            CMethod method = set.get(0);
            method.addReference(s);
            s.ctor = method.getAST();
            int i2 = 0;
            while (i2 < s.numArguments()) {
                s.argument((int)i2).runtype = method.getFormalParameter(i2).getType();
                ++i2;
            }
        }
    }

    private void processSuperCall(SuperCall s) {
        MethodSet set;
        s.exprType = this.topContext.voidType;
        if (s.base() != null) {
            this.processExprOrStmt(s.base());
        }
        int i = 0;
        while (i < s.numArguments()) {
            Expr expr = s.argument(i);
            this.processExprOrStmt(expr);
            ++i;
        }
        CClassType thisType = this.currentContext.currentType();
        CClassType superType = thisType.getSuperClass();
        if (superType == null) {
            superType = this.topContext.objectType;
        }
        if ((set = superType.lookupConstructor(thisType, s.getArgumentsVector())) == null || set.size() == 0) {
            ErrorMgr.report(27, s.leftToken(), s.rightToken(), superType.getQualifiedName());
        } else if (set.size() > 1) {
            ErrorMgr.report(28, s.leftToken(), s.rightToken(), superType.getQualifiedName());
        } else {
            CMethod method = set.get(0);
            method.addReference(s);
            s.ctor = method.getAST();
            int i2 = 0;
            while (i2 < s.numArguments()) {
                s.argument((int)i2).runtype = method.getFormalParameter(i2).getType();
                ++i2;
            }
        }
    }

    private void processDeclarationStmt(DeclarationStmt s) {
        this.processExprOrStmt(s.decl());
    }

    private void processArrayInitializer(ArrayInitializer s) {
        int i = 0;
        while (i < s.numInitializers()) {
            this.processExprOrStmt(s.getInitializer(i));
            ++i;
        }
    }

    private void processTypeExpr(TypeExpr s) {
        CType type = this.topContext.lookupType(this.currentContext.currentScope(), s);
        if (type == null) {
            ErrorMgr.report(0, s.leftToken(), s.rightToken(), s.getFullName());
            s.exprType = this.topContext.badType;
        } else {
            s.exprType = type;
        }
    }

    private void checkBooleanExpr(Expr e) {
        if (!e.type().isBoolean() && !e.type().isBad()) {
            ErrorMgr.report(35, e.leftToken(), e.rightToken(), e.type().getQualifiedName());
        }
    }

    private boolean isConstantType(CType type) {
        return type.isPrimitive() || type == this.topContext.stringType;
    }

    private boolean checkLvalue(Expr e, boolean checkFinal) {
        CDefinition def = e.getDef();
        int kind = e.astType();
        if (kind != 22 && kind != 10 && kind != 36 || !(def instanceof CVariable)) {
            ErrorMgr.report(8, e.leftToken(), e.rightToken());
            e.runtype = this.topContext.badType;
            return false;
        }
        if (checkFinal && def.isFinal() && ((VariableDeclarator)def.getAST()).initializer != null) {
            ErrorMgr.report(44, e.leftToken(), e.rightToken());
            e.runtype = this.topContext.badType;
            return false;
        }
        return true;
    }
}

