/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.symbol;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;

public class IndentingPrintWriter
extends PrintWriter {
    private String indentString = "";
    private boolean lineInProgress = false;
    private boolean showBinaryTypes;

    public IndentingPrintWriter(OutputStream out) {
        super(out);
    }

    public IndentingPrintWriter(OutputStream out, boolean autoFlush, boolean showAllTypes) {
        super(out, autoFlush);
        this.showBinaryTypes = showAllTypes;
    }

    public IndentingPrintWriter(Writer out) {
        super(out);
    }

    public IndentingPrintWriter(Writer out, boolean autoFlush, boolean showAllTypes) {
        super(out, autoFlush);
        this.showBinaryTypes = showAllTypes;
    }

    public boolean showBinaryTypes() {
        return this.showBinaryTypes;
    }

    public void dedent() {
        if (this.indentString.length() >= 2) {
            this.indentString = this.indentString.substring(2);
        }
    }

    public void indent() {
        this.indentString = this.indentString + "  ";
    }

    public void print(char[] s) {
        if (!this.lineInProgress) {
            super.write(this.indentString);
            this.lineInProgress = true;
        }
        super.print(s);
    }

    public void print(char c) {
        if (!this.lineInProgress) {
            super.write(this.indentString);
            this.lineInProgress = true;
        }
        super.print(c);
    }

    public void print(double d) {
        if (!this.lineInProgress) {
            super.write(this.indentString);
            this.lineInProgress = true;
        }
        super.print(d);
    }

    public void print(float f) {
        if (!this.lineInProgress) {
            super.write(this.indentString);
            this.lineInProgress = true;
        }
        super.print(f);
    }

    public void print(int i) {
        if (!this.lineInProgress) {
            super.write(this.indentString);
            this.lineInProgress = true;
        }
        super.print(i);
    }

    public void print(long l) {
        if (!this.lineInProgress) {
            super.write(this.indentString);
            this.lineInProgress = true;
        }
        super.print(l);
    }

    public void print(Object obj) {
        if (!this.lineInProgress) {
            super.write(this.indentString);
            this.lineInProgress = true;
        }
        super.print(obj);
    }

    public void print(String s) {
        if (!this.lineInProgress) {
            super.write(this.indentString);
            this.lineInProgress = true;
        }
        super.print(s);
    }

    public void print(boolean b) {
        if (!this.lineInProgress) {
            super.write(this.indentString);
            this.lineInProgress = true;
        }
        super.print(b);
    }

    public void println() {
        if (!this.lineInProgress) {
            super.write(this.indentString);
            this.lineInProgress = true;
        }
        super.println();
        this.lineInProgress = false;
    }

    public void println(char[] x) {
        if (!this.lineInProgress) {
            super.write(this.indentString);
            this.lineInProgress = true;
        }
        super.println(x);
        this.lineInProgress = false;
    }

    public void println(char x) {
        if (!this.lineInProgress) {
            super.write(this.indentString);
            this.lineInProgress = true;
        }
        super.println(x);
        this.lineInProgress = false;
    }

    public void println(double x) {
        if (!this.lineInProgress) {
            super.write(this.indentString);
            this.lineInProgress = true;
        }
        super.println(x);
        this.lineInProgress = false;
    }

    public void println(float x) {
        if (!this.lineInProgress) {
            super.write(this.indentString);
            this.lineInProgress = true;
        }
        super.println(x);
        this.lineInProgress = false;
    }

    public void println(int x) {
        if (!this.lineInProgress) {
            super.write(this.indentString);
            this.lineInProgress = true;
        }
        super.println(x);
        this.lineInProgress = false;
    }

    public void println(long x) {
        if (!this.lineInProgress) {
            super.write(this.indentString);
            this.lineInProgress = true;
        }
        super.println(x);
        this.lineInProgress = false;
    }

    public void println(Object x) {
        if (!this.lineInProgress) {
            super.write(this.indentString);
            this.lineInProgress = true;
        }
        super.println(x);
        this.lineInProgress = false;
    }

    public void println(String x) {
        if (!this.lineInProgress) {
            super.write(this.indentString);
            this.lineInProgress = true;
        }
        super.println(x);
        this.lineInProgress = false;
    }

    public void println(boolean x) {
        if (!this.lineInProgress) {
            super.write(this.indentString);
            this.lineInProgress = true;
        }
        super.println(x);
        this.lineInProgress = false;
    }
}

