/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.symbol;

import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.Model;
import com.togethersoft.sca.internal.jparser.symbol.CMethod;
import com.togethersoft.sca.internal.jparser.symbol.Constants;
import java.util.ResourceBundle;

public class ErrorMgr
implements Constants {
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle("com.togethersoft.sca.core.Messages");
    private static Model model;

    public static void report(int msgCode) {
        ErrorMgr.report(msgCode, null, null, null, null);
    }

    public static void report(int msgCode, JavaToken leftToken, JavaToken rightToken) {
        ErrorMgr.report(msgCode, leftToken, rightToken, null, null);
    }

    public static void report(int msgCode, String insert) {
        ErrorMgr.report(msgCode, null, null, insert, null);
    }

    public static void report(int msgCode, JavaToken leftToken, JavaToken rightToken, String insert) {
        ErrorMgr.report(msgCode, leftToken, rightToken, insert, null);
    }

    public static void report(int msgCode, JavaToken leftToken, JavaToken rightToken, String insert1, String insert2) {
        if (msgCode >= 45 || msgCode < 0 || model == null) {
            return;
        }
        StringBuffer sbuf = new StringBuffer();
        if (leftToken != null && rightToken != null) {
            sbuf.append(ErrorMgr.model.getSemantic().currentFile.getName()).append(':');
            sbuf.append(leftToken.getLine()).append(':');
            sbuf.append(leftToken.getColumn()).append(':');
            sbuf.append(rightToken.getEndLine()).append(':');
            sbuf.append(rightToken.getEndColumn()).append(": ");
        }
        sbuf.append(resourceBundle.getString("ErrMgr." + (msgCode + 1)));
        if (insert1 != null) {
            sbuf.append(": ").append(insert1);
            if (insert2 != null) {
                sbuf.append(", ").append(insert2);
            }
        }
        model.getCompiler().logError(sbuf.toString());
        CMethod method = model.getSemantic().getContext().currentMethod();
        if (method != null) {
            method.resetErrorFree();
        }
    }

    public static void setModel(Model model_) {
        model = model_;
    }
}

