/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.symbol;

import com.togethersoft.sca.internal.jparser.ast.Stmt;
import com.togethersoft.sca.internal.jparser.symbol.CClassType;
import com.togethersoft.sca.internal.jparser.symbol.CDefinition;
import com.togethersoft.sca.internal.jparser.symbol.CMethod;
import com.togethersoft.sca.internal.jparser.symbol.CScope;
import com.togethersoft.sca.internal.jparser.symbol.CVariable;
import java.io.Serializable;
import java.util.Stack;

public class ContextStack
implements Serializable {
    Stack stack = new Stack();
    Stack typeStack = new Stack();
    Stack methodStack = new Stack();
    Stack stmtStack = new Stack();
    CVariable currentVariable;

    ContextStack() {
    }

    ContextStack(CDefinition symbol) {
        this.restoreContext(symbol);
    }

    private void restoreContext(CDefinition symbol) {
        if (symbol.getOwnerType() != null) {
            this.restoreContext(symbol.getOwnerType());
        } else {
            this.push(symbol.getPackage());
        }
        this.push(symbol);
    }

    void pop() {
        CDefinition context = (CDefinition)this.stack.pop();
        if (context instanceof CClassType) {
            this.typeStack.pop();
        } else if (context instanceof CMethod) {
            this.methodStack.pop();
            this.stmtStack.pop();
        }
    }

    void push(CDefinition context) {
        this.stack.push(context);
        if (context instanceof CClassType) {
            this.typeStack.push(context);
            this.currentVariable = null;
        } else if (context instanceof CMethod) {
            this.methodStack.push(context);
            this.stmtStack.push(new MethodContext());
        }
    }

    CClassType currentType() {
        if (!this.typeStack.empty()) {
            return (CClassType)this.typeStack.peek();
        }
        return null;
    }

    CMethod currentMethod() {
        if (!this.methodStack.empty()) {
            return (CMethod)this.methodStack.peek();
        }
        return null;
    }

    CScope currentScope() {
        int i = this.stack.size() - 1;
        while (i >= 0) {
            if (this.stack.get(i) instanceof CScope) {
                return (CScope)this.stack.get(i);
            }
            --i;
        }
        return null;
    }

    boolean isStaticContext() {
        return this.currentVariable != null && this.currentVariable.isStatic() || this.currentMethod() != null && this.currentMethod().isStatic() || this.currentType().isInterface();
    }

    void pushBreakable(Stmt stmt) {
        this.getMethodContext().pushBreakable(stmt);
    }

    void popBreakable() {
        this.getMethodContext().popBreakable();
    }

    void pushContinuable(Stmt stmt) {
        this.getMethodContext().pushContinuable(stmt);
    }

    void popContinuable() {
        this.getMethodContext().popContinuable();
    }

    Stmt lookupContinueTarget(String label) {
        return this.getMethodContext().lookupContinueTarget(label);
    }

    Stmt lookupBreakTarget(String label) {
        return this.getMethodContext().lookupBreakTarget(label);
    }

    private MethodContext getMethodContext() {
        return (MethodContext)this.stmtStack.peek();
    }

    private class MethodContext {
        Stack breakable = new Stack();
        Stack continuable = new Stack();

        private MethodContext() {
        }

        void pushBreakable(Stmt stmt) {
            this.breakable.push(stmt);
        }

        void popBreakable() {
            this.breakable.pop();
        }

        void pushContinuable(Stmt stmt) {
            this.continuable.push(stmt);
        }

        void popContinuable() {
            this.continuable.pop();
        }

        Stmt lookupContinueTarget(String label) {
            int i = this.continuable.size() - 1;
            while (i >= 0) {
                Stmt s = (Stmt)this.continuable.get(i);
                if (label != null) {
                    if (s.lookupLabel(label) != null) {
                        return s;
                    }
                } else {
                    return s;
                }
                --i;
            }
            return null;
        }

        Stmt lookupBreakTarget(String label) {
            int i = this.breakable.size() - 1;
            while (i >= 0) {
                Stmt s = (Stmt)this.breakable.get(i);
                if (label != null ? s.lookupLabel(label) != null : s.isBreakable()) {
                    return s;
                }
                --i;
            }
            return null;
        }
    }
}

