/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.symbol;

import com.togethersoft.sca.internal.jparser.ast.VariableDeclarator;
import com.togethersoft.sca.internal.jparser.symbol.CBadType;
import com.togethersoft.sca.internal.jparser.symbol.CClassType;
import com.togethersoft.sca.internal.jparser.symbol.CDefinition;
import com.togethersoft.sca.internal.jparser.symbol.CScope;
import com.togethersoft.sca.internal.jparser.symbol.CType;
import com.togethersoft.sca.internal.jparser.symbol.CVisitor;
import com.togethersoft.sca.internal.jparser.symbol.Constants;
import com.togethersoft.sca.internal.jparser.symbol.ErrorMgr;
import com.togethersoft.sca.internal.jparser.symbol.IndentingPrintWriter;
import com.togethersoft.sca.internal.jparser.symbol.Reportable;

public class CVariable
extends CDefinition
implements Reportable,
Constants {
    transient CType type;
    private String descriptor;

    CVariable(CClassType ownerType, CScope parent, String name, int modifiers, VariableDeclarator astNode) {
        super(ownerType, parent, name, modifiers);
        this.astNode = astNode;
    }

    protected String buildSignature() {
        return this.getType().getSignature();
    }

    public void setType(CType type) {
        this.type = type;
    }

    public CType getType() {
        if (this.isPending()) {
            this.process();
        }
        return this.type;
    }

    void setDescriptor(String descriptor) {
        this.descriptor = descriptor;
    }

    public boolean isPending() {
        return this.descriptor != null;
    }

    public void process() {
        this.type = this.getTopScope().loadTypeFromDescriptor(this.descriptor);
        this.descriptor = null;
        if (this.type == null || this.type.getKind() == 1) {
            ErrorMgr.report(17, "for field: " + this.getQualifiedName() + ", field descriptor: " + this.descriptor);
            this.type = CBadType.getInstance();
        }
    }

    public void report(IndentingPrintWriter out) {
        out.println(this.getQualifiedName() + " (Variable) #" + this.getAST().id());
        out.indent();
        out.print("Type: ");
        if (this.type != null) {
            out.println(this.type.getQualifiedName());
        } else {
            out.println("~unknown~");
        }
        this.listReferences(out);
        out.dedent();
    }

    public void accept(CVisitor visitor) {
        visitor.visitVariable(this);
    }

    public void traverse(CVisitor visitor) {
    }
}

