/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.symbol;

import com.togethersoft.sca.internal.jparser.ast.AstVector;
import com.togethersoft.sca.internal.jparser.ast.BooleanLiteral;
import com.togethersoft.sca.internal.jparser.ast.BuiltInType;
import com.togethersoft.sca.internal.jparser.ast.ClassFile;
import com.togethersoft.sca.internal.jparser.ast.DoubleLiteral;
import com.togethersoft.sca.internal.jparser.ast.Expr;
import com.togethersoft.sca.internal.jparser.ast.FieldAccess;
import com.togethersoft.sca.internal.jparser.ast.FloatLiteral;
import com.togethersoft.sca.internal.jparser.ast.IntLiteral;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.Literal;
import com.togethersoft.sca.internal.jparser.ast.LongLiteral;
import com.togethersoft.sca.internal.jparser.ast.MethodDeclaration;
import com.togethersoft.sca.internal.jparser.ast.Model;
import com.togethersoft.sca.internal.jparser.ast.Modifiers;
import com.togethersoft.sca.internal.jparser.ast.Name;
import com.togethersoft.sca.internal.jparser.ast.PackageDeclaration;
import com.togethersoft.sca.internal.jparser.ast.SimpleName;
import com.togethersoft.sca.internal.jparser.ast.TypeDeclaration;
import com.togethersoft.sca.internal.jparser.ast.TypeExpr;
import com.togethersoft.sca.internal.jparser.ast.VariableDeclaration;
import com.togethersoft.sca.internal.jparser.ast.VariableDeclarator;
import com.togethersoft.sca.internal.jparser.classfile.ClassConstants;
import com.togethersoft.sca.internal.jparser.classfile.ClassDesc;
import com.togethersoft.sca.internal.jparser.classfile.Constant;
import com.togethersoft.sca.internal.jparser.classfile.DoubleConstant;
import com.togethersoft.sca.internal.jparser.classfile.FieldDesc;
import com.togethersoft.sca.internal.jparser.classfile.FloatConstant;
import com.togethersoft.sca.internal.jparser.classfile.IntConstant;
import com.togethersoft.sca.internal.jparser.classfile.LongConstant;
import com.togethersoft.sca.internal.jparser.classfile.MethodDesc;
import com.togethersoft.sca.internal.jparser.symbol.CBadType;
import com.togethersoft.sca.internal.jparser.symbol.CClassType;
import com.togethersoft.sca.internal.jparser.symbol.CCompilationUnit;
import com.togethersoft.sca.internal.jparser.symbol.CDefinition;
import com.togethersoft.sca.internal.jparser.symbol.CMethod;
import com.togethersoft.sca.internal.jparser.symbol.CPackage;
import com.togethersoft.sca.internal.jparser.symbol.CPrimitiveType;
import com.togethersoft.sca.internal.jparser.symbol.CScope;
import com.togethersoft.sca.internal.jparser.symbol.CType;
import com.togethersoft.sca.internal.jparser.symbol.CVariable;
import com.togethersoft.sca.internal.jparser.symbol.CVisitor;
import com.togethersoft.sca.internal.jparser.symbol.Constants;
import com.togethersoft.sca.internal.jparser.symbol.ErrorMgr;
import com.togethersoft.sca.internal.jparser.symbol.IndentingPrintWriter;
import com.togethersoft.sca.internal.jparser.symbol.MethodSet;
import com.togethersoft.sca.internal.jparser.symbol.Reportable;
import com.togethersoft.sca.internal.jparser.symbol.Semantic;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;

public class CTopLevel
extends CScope
implements Reportable,
Constants,
ClassConstants {
    private ArrayList packages;
    private CPackage defaultPackage;
    private CPackage javaLangPackage;
    private CPackage javaIoPackage;
    transient Semantic sem;
    transient Model model;
    HashMap hits = new HashMap(4096);
    HashSet misses = new HashSet(4096);
    CPrimitiveType byteType;
    CPrimitiveType shortType;
    CPrimitiveType charType;
    CPrimitiveType intType;
    CPrimitiveType longType;
    CPrimitiveType floatType;
    CPrimitiveType doubleType;
    CPrimitiveType booleanType;
    CPrimitiveType voidType;
    CPrimitiveType nullType;
    CBadType badType;
    CClassType objectType;
    CClassType stringType;
    CClassType cloneableType;
    CClassType serializableType;
    CClassType classType;
    CClassType throwableType;
    CClassType assertionErrorType;
    private transient boolean stdTypesLoaded = false;

    CTopLevel(Semantic sem) {
        super(null, null, null, 0);
        this.sem = sem;
        this.packages = new ArrayList();
        this.defaultPackage = new CPackage(this, "", null);
    }

    public void initialize() {
        this.initBuiltInTypes();
        this.initLibraryPackages();
    }

    private int numPackages() {
        return this.packages.size();
    }

    private CPackage getPackage(int i) {
        return (CPackage)this.packages.get(i);
    }

    public CPackage getDefaultPackage() {
        return this.defaultPackage;
    }

    public CPackage getJavaLangPackage() {
        return this.javaLangPackage;
    }

    public CPackage lookupPackage(String name) {
        int i = 0;
        while (i < this.numPackages()) {
            CPackage pkg = this.getPackage(i);
            if (pkg.getName().equals(name)) {
                return pkg;
            }
            ++i;
        }
        return null;
    }

    public CPackage insertPackage(String name) {
        CPackage pkg = new CPackage(this, name, null);
        this.packages.add(pkg);
        return pkg;
    }

    public CScope lookupPackageOrType(String qualifiedName) {
        CScope parent = null;
        StringTokenizer st = new StringTokenizer(qualifiedName, "/");
        while (st.hasMoreTokens()) {
            String name = st.nextToken();
            if (parent == null) {
                parent = this.defaultPackage.lookupType(name);
                if (parent == null) {
                    parent = this.lookupPackage(name);
                }
            } else {
                CScope symbol = parent.lookupType(name);
                if (symbol == null) {
                    symbol = parent.lookupPackage(name);
                }
                parent = symbol;
            }
            if (parent == null) break;
        }
        return parent;
    }

    private boolean checkTypeAccess(CClassType type, CScope from) {
        if (type == null) {
            return false;
        }
        return type.isAccessible(from.getPackage());
    }

    private boolean checkMemberAccess(Name id, CDefinition symbol, CScope from, CType base) {
        if (symbol == null) {
            return false;
        }
        if (symbol.isAccessible(from.getInnermostType(), base)) {
            return true;
        }
        ErrorMgr.report(26, id.leftToken(), id.rightToken(), symbol.getQualifiedName());
        return false;
    }

    CType loadTypeFromDescriptor(String descriptor) {
        CType clazz;
        int src = 0;
        int indirect = 0;
        int length = descriptor.length();
        while (src < length && descriptor.charAt(src) == '[') {
            ++indirect;
            ++src;
        }
        if (src >= length) {
            return null;
        }
        switch (descriptor.charAt(src)) {
            case 'V': {
                clazz = this.voidType;
                break;
            }
            case 'I': {
                clazz = this.intType;
                break;
            }
            case 'S': {
                clazz = this.shortType;
                break;
            }
            case 'D': {
                clazz = this.doubleType;
                break;
            }
            case 'J': {
                clazz = this.longType;
                break;
            }
            case 'F': {
                clazz = this.floatType;
                break;
            }
            case 'B': {
                clazz = this.byteType;
                break;
            }
            case 'C': {
                clazz = this.charType;
                break;
            }
            case 'Z': {
                clazz = this.booleanType;
                break;
            }
            case 'L': {
                int start = ++src;
                while (src < length && descriptor.charAt(src) != ';') {
                    ++src;
                }
                clazz = this.loadReferenceType(descriptor.substring(start, src));
                break;
            }
            default: {
                clazz = null;
            }
        }
        if (clazz != null && indirect > 0) {
            clazz = clazz.getArrayType(this, indirect);
        }
        return clazz;
    }

    CClassType loadReferenceType(String qualifiedName) {
        CClassType clazz = (CClassType)this.hits.get(qualifiedName);
        if (clazz != null) {
            return clazz;
        }
        if (this.misses.contains(qualifiedName)) {
            return null;
        }
        int lastDollar = qualifiedName.lastIndexOf(36);
        if (lastDollar != -1) {
            String simpleName;
            CClassType cls = this.loadReferenceType(qualifiedName.substring(0, lastDollar));
            if (cls != null && (clazz = cls.lookupType(simpleName = qualifiedName.substring(lastDollar + 1))) == null) {
                clazz = cls.loadType(simpleName);
            }
        } else {
            String simpleName;
            CPackage pkg;
            int lastSlash = qualifiedName.lastIndexOf(47);
            if (lastSlash != -1) {
                pkg = this.processPackage(qualifiedName.substring(0, lastSlash));
                simpleName = qualifiedName.substring(lastSlash + 1);
            } else {
                pkg = this.getDefaultPackage();
                simpleName = qualifiedName;
            }
            clazz = pkg.lookupType(simpleName);
            if (clazz == null) {
                clazz = pkg.loadType(simpleName);
            }
        }
        if (clazz != null) {
            this.hits.put(qualifiedName, clazz);
        } else {
            this.misses.add(qualifiedName);
        }
        return clazz;
    }

    CClassType loadTypeFromClassFile(PackageDeclaration ownerPackage, CClassType ownerType, String simpleName) {
        String externalName;
        CScope owner;
        if (ownerType != null) {
            owner = ownerType;
            externalName = ownerType.getExternalName() + "$" + simpleName;
        } else {
            owner = ownerPackage.symbol;
            externalName = ownerPackage.getQualifiedName() + "/" + simpleName;
        }
        ClassDesc clazz = this.sem.classpath.getClassDesc(externalName);
        if (clazz == null) {
            return null;
        }
        boolean isInterface = (clazz.getAccess().getFlags() & 0x200) != 0;
        TypeDeclaration clAst = new TypeDeclaration(isInterface ? 2 : 1, simpleName, new Modifiers(clazz.getAccess().getFlags()));
        CClassType clSymbol = new CClassType(ownerPackage.symbol, null, ownerType, owner, simpleName, null, clazz.getAccess().getFlags(), clAst);
        if (ownerType == null) {
            clSymbol.setOutermostType(clSymbol);
        } else {
            clSymbol.setOutermostType(ownerType.getOutermostType());
        }
        clAst.symbol = clSymbol;
        if (ownerType == null) {
            ClassFile classFile = new ClassFile(clazz.getFilename(), clAst);
            ownerPackage.addClassFile(classFile);
            ownerPackage.symbol.addType(clSymbol);
        } else {
            ((TypeDeclaration)ownerType.astNode).addNestedType(clAst);
            ownerType.addType(clSymbol);
        }
        this.processLoadedType(clazz, clSymbol, clAst);
        this.loadInnerTypes(clazz, ownerPackage.symbol, clSymbol.getOutermostType(), clSymbol, clAst, externalName);
        return clSymbol;
    }

    private void loadInnerTypes(ClassDesc desc, CPackage parentPackage, CClassType outermostType, CClassType parentType, TypeDeclaration parentAst, String parentExternalName) {
        if (desc.innerClasses == null) {
            return;
        }
        int i = 0;
        while (i < desc.innerClasses.length) {
            if (desc.innerClasses[i].isNamedInnerClass()) {
                String simpleName = desc.innerClasses[i].getName();
                String externalName = parentExternalName + "$" + simpleName;
                ClassDesc clazz = this.sem.classpath.getClassDesc(externalName);
                if (clazz == null) {
                    ErrorMgr.report(16, externalName);
                    return;
                }
                if (parentType.lookupTypeWithoutInheritance(simpleName) == null) {
                    CClassType clSymbol;
                    boolean isInterface = (clazz.getAccess().getFlags() & 0x200) != 0;
                    TypeDeclaration clAst = new TypeDeclaration(isInterface ? 2 : 1, simpleName, new Modifiers(clazz.getAccess().getFlags()));
                    clAst.symbol = clSymbol = new CClassType(parentPackage, outermostType, parentType, parentType, simpleName, null, clazz.getAccess().getFlags(), clAst);
                    parentAst.addNestedType(clAst);
                    parentType.addType(clSymbol);
                    this.processLoadedType(clazz, clSymbol, clAst);
                    this.loadInnerTypes(clazz, parentPackage, outermostType, clSymbol, clAst, externalName);
                }
            }
            ++i;
        }
    }

    private void processLoadedType(ClassDesc clazz, CClassType clSymbol, TypeDeclaration clAst) {
        int i = 0;
        while (i < clazz.fields.length) {
            CVariable field;
            FieldDesc fd = clazz.fields[i];
            VariableDeclaration decl = new VariableDeclaration(new Modifiers(fd.getAccess().getFlags()), null);
            VariableDeclarator fieldAst = new VariableDeclarator(decl, new JavaToken(fd.getName()), null, null, null);
            decl.setDeclarators(fieldAst);
            fieldAst.symbol = field = new CVariable(clSymbol, clSymbol, fd.getName(), fd.getAccess().getFlags(), fieldAst);
            field.setDescriptor(fd.getDescriptor());
            this.createFieldInitializer(fieldAst, fd);
            clAst.addField(decl);
            clSymbol.addVariable(field);
            ++i;
        }
        int i2 = 0;
        while (i2 < clazz.methods.length) {
            CMethod method;
            MethodDesc md = clazz.methods[i2];
            boolean isConstructor = md.getName().equals("<init>");
            String name = isConstructor ? clSymbol.getName() : md.getName();
            MethodDeclaration methodAst = new MethodDeclaration(new Modifiers(md.getAccess().getFlags()), null, name, null, null, null, null, null, null, null, null, isConstructor, false);
            methodAst.symbol = method = new CMethod(clSymbol, name, null, md.getAccess().getFlags(), methodAst);
            method.setDescriptor(md.getDescriptor(), md.exceptions);
            if (isConstructor) {
                clAst.addConstructor(methodAst);
                clSymbol.addConstructor(method);
            } else {
                clAst.addMethod(methodAst);
                clSymbol.addMethod(method);
            }
            ++i2;
        }
        clSymbol.markSuperProcessing();
        if (clazz.getSuperClass() != null) {
            CClassType superClass = this.loadReferenceType(clazz.getSuperClass());
            if (superClass == null) {
                ErrorMgr.report(17, clazz.getSuperClass());
            } else if (superClass.isSuperProcessing()) {
                ErrorMgr.report(1, "in super class " + superClass.getQualifiedName() + " of " + clSymbol.getQualifiedName());
            } else {
                clSymbol.setSuperClass(superClass);
            }
        }
        int i3 = 0;
        while (i3 < clazz.numSuperInterfaces()) {
            CClassType superIface = this.loadReferenceType(clazz.getSuperInterface(i3));
            if (superIface == null) {
                ErrorMgr.report(17, clazz.getSuperInterface(i3));
            } else if (superIface.isSuperProcessing()) {
                ErrorMgr.report(1, "in super interface " + superIface.getQualifiedName() + " of " + clSymbol.getQualifiedName());
            } else {
                clSymbol.addInterface(superIface);
            }
            ++i3;
        }
        clSymbol.unmarkSuperProcessing();
        clSymbol.markSuperResolved();
    }

    private void createFieldInitializer(VariableDeclarator decl, FieldDesc fd) {
        Literal init = null;
        Constant c = fd.getInitializer();
        if (c != null) {
            switch (c.getConstantType()) {
                case 3: {
                    IntConstant ic = (IntConstant)c;
                    if (fd.getDescriptor().length() == 1 && fd.getDescriptor().charAt(0) == 'Z') {
                        init = new BooleanLiteral(null, ic.getValue() != 0);
                        init.exprType = this.booleanType;
                        break;
                    }
                    init = new IntLiteral(ic.getValue());
                    init.exprType = this.intType;
                    break;
                }
                case 5: {
                    LongConstant lc = (LongConstant)c;
                    init = new LongLiteral(lc.getValue());
                    init.exprType = this.longType;
                    break;
                }
                case 4: {
                    FloatConstant fc = (FloatConstant)c;
                    init = new FloatLiteral(fc.getValue());
                    init.exprType = this.floatType;
                    break;
                }
                case 6: {
                    DoubleConstant dc = (DoubleConstant)c;
                    init = new DoubleLiteral(dc.getValue());
                    init.exprType = this.doubleType;
                }
            }
        }
        if (init != null) {
            init.isConstant = true;
            decl.setInitializer(init);
        }
    }

    private MethodSet lookupSimpleMethod(CClassType scope, String name, AstVector parms) {
        CClassType from = scope;
        while (scope != null) {
            MethodSet m = scope.lookupMethod(from, null, name, parms);
            if (m != null) {
                return m;
            }
            scope = scope.getOwnerType();
        }
        return null;
    }

    MethodSet lookupMethod(CScope sc, Name id, AstVector parms) {
        if (id.base() == null) {
            return this.lookupSimpleMethod(sc.getInnermostType(), id.getName(), parms);
        }
        if (id.base() instanceof Name) {
            this.lookupAmbiguousName(sc, (Name)id.base());
        } else {
            this.sem.processExprOrStmt(id.base());
        }
        CDefinition def = id.base().exprType;
        if (id.base().type().isBad()) {
            return null;
        }
        if (def instanceof CPackage) {
            return null;
        }
        if (def instanceof CType) {
            CType t = (CType)def;
            return t.lookupMethod(sc.getInnermostType(), null, id.getName(), parms);
        }
        CType base = id.base().type();
        if (base == null || !base.isReference()) {
            return null;
        }
        return base.lookupMethod(sc.getInnermostType(), base, id.getName(), parms);
    }

    private void lookupSimpleAmbiguousName(CScope sc, SimpleName id) {
        CDefinition d = this.lookupSimpleExpression(sc, id);
        if (d == null) {
            d = this.lookupType(sc, id);
        }
        if (d == null) {
            d = this.model.lookupInsertPackage((String)id.getName()).symbol;
        }
        id.exprType = d;
    }

    void lookupAmbiguousName(CScope sc, Name id) {
        Expr baseAst = id.base();
        if (baseAst == null) {
            this.lookupSimpleAmbiguousName(sc, (SimpleName)id);
        } else {
            id.exprType = this.badType;
            if (id instanceof FieldAccess && ((FieldAccess)id).isClassAccess()) {
                FieldAccess fa = (FieldAccess)id;
                CType type = null;
                if (baseAst instanceof Name) {
                    Name spec = (Name)baseAst;
                    type = this.lookupType(sc, spec);
                    if (type == null) {
                        ErrorMgr.report(0, spec.leftToken(), spec.rightToken(), spec.getFullName());
                    }
                } else if (baseAst instanceof TypeExpr) {
                    TypeExpr spec = (TypeExpr)baseAst;
                    type = this.lookupType(sc, spec);
                    if (type == null) {
                        ErrorMgr.report(0, spec.leftToken(), spec.rightToken(), spec.getFullName());
                    }
                } else {
                    ErrorMgr.report(40, fa.leftToken(), fa.rightToken());
                }
                if (type != null) {
                    id.exprType = this.classType.getThisObject();
                }
            } else {
                if (baseAst instanceof Name) {
                    this.lookupAmbiguousName(sc, (Name)baseAst);
                } else {
                    this.sem.processExprOrStmt(baseAst);
                }
                CDefinition base = baseAst.exprType;
                if (baseAst.exprType == this.badType) {
                    return;
                }
                FieldAccess fa = (FieldAccess)id;
                if (fa.isThisAccess() || fa.isSuperAccess()) {
                    if (base instanceof CClassType) {
                        if (fa.isThisAccess()) {
                            fa.exprType = ((CClassType)base).getThisObject();
                        } else {
                            CClassType supertype = ((CClassType)base).getSuperClass();
                            if (supertype == null) {
                                ErrorMgr.report(21, fa.leftToken(), fa.rightToken());
                            } else {
                                fa.exprType = supertype;
                            }
                        }
                    } else if (base instanceof CPackage) {
                        ErrorMgr.report(0, baseAst.leftToken(), baseAst.rightToken(), base.getQualifiedName());
                    } else if (base instanceof CType) {
                        ErrorMgr.report(30, baseAst.leftToken(), baseAst.rightToken(), base.getQualifiedName());
                    } else if (fa.isThisAccess()) {
                        ErrorMgr.report(38, fa.leftToken(), fa.rightToken());
                    } else {
                        ErrorMgr.report(39, fa.leftToken(), fa.rightToken());
                    }
                } else if (base instanceof CPackage) {
                    CPackage pkg = (CPackage)base;
                    CClassType t = pkg.lookupType(id.getName());
                    if (t == null) {
                        t = pkg.loadType(id.getName());
                    }
                    if (t != null) {
                        if (this.checkMemberAccess(id, t, sc, null)) {
                            t.addReference(id);
                            t.addDependence(sc.getInnermostType());
                            id.exprType = t;
                        }
                    } else {
                        id.exprType = this.model.lookupInsertPackage((PackageDeclaration)((PackageDeclaration)pkg.getAST()), (String)id.getName()).symbol;
                    }
                } else if (base instanceof CType) {
                    CType type = (CType)base;
                    CVariable v = type.lookupVariable(id.getName());
                    if (v != null) {
                        if (this.checkMemberAccess(id, v, sc, null)) {
                            v.addReference(id);
                            v.getType().addDependence(sc.getInnermostType());
                            id.exprType = v;
                        }
                    } else {
                        CClassType t = type.lookupType(id.getName());
                        if (t != null) {
                            if (this.checkMemberAccess(id, t, sc, null)) {
                                t.addReference(id);
                                t.addDependence(sc.getInnermostType());
                                id.exprType = t;
                            }
                        } else {
                            ErrorMgr.report(3, id.leftToken(), id.rightToken(), id.getFullName());
                        }
                    }
                } else {
                    CType baseType = baseAst.type();
                    if (baseType != null) {
                        CVariable v = baseType.lookupVariable(id.getName());
                        if (v != null) {
                            if (this.checkMemberAccess(id, v, sc, baseType)) {
                                v.addReference(id);
                                v.getType().addDependence(sc.getInnermostType());
                                id.exprType = v;
                            }
                        } else {
                            CClassType t = baseType.lookupType(id.getName());
                            if (t != null) {
                                if (this.checkMemberAccess(id, t, sc, baseType)) {
                                    t.addReference(id);
                                    t.addDependence(sc.getInnermostType());
                                    id.exprType = t;
                                }
                            } else {
                                ErrorMgr.report(3, id.leftToken(), id.rightToken(), id.getFullName());
                            }
                        }
                    }
                }
            }
        }
    }

    private CScope lookupPackageOrType(CScope sc, Name id) {
        CType clazz = null;
        if (id.base() == null) {
            clazz = this.lookupSimpleType(sc, (SimpleName)id);
            if (clazz == null) {
                return this.model.lookupInsertPackage((String)id.getName()).symbol;
            }
        } else {
            if (!(id.base() instanceof Name)) {
                return null;
            }
            CScope base = this.lookupPackageOrType(sc, (Name)id.base());
            if (base == null) {
                return null;
            }
            if (base instanceof CType) {
                clazz = base.lookupType(id.getName());
            } else {
                CPackage basePkg = (CPackage)base;
                clazz = basePkg.lookupType(id.getName());
                if (clazz == null) {
                    return this.model.lookupInsertPackage((PackageDeclaration)((PackageDeclaration)basePkg.astNode), (String)id.getName()).symbol;
                }
            }
        }
        if (this.checkMemberAccess(id, clazz, sc, null)) {
            clazz.addReference(id);
            clazz.addDependence(sc.getInnermostType());
            return clazz;
        }
        return null;
    }

    private CScope loadPackageOrType(CScope from, Name id) {
        CClassType clazz = null;
        if (id.base() == null) {
            clazz = this.sem.currentFile.loadType(id.getName());
            if (clazz == null) {
                return this.model.lookupInsertPackage((String)id.getName()).symbol;
            }
        } else {
            if (!(id.base() instanceof Name)) {
                return null;
            }
            CScope base = this.loadPackageOrType(from, (Name)id.base());
            if (base == null) {
                return null;
            }
            if (base instanceof CPackage) {
                CPackage basePkg = (CPackage)base;
                clazz = basePkg.lookupType(id.getName());
                if (clazz == null) {
                    clazz = basePkg.loadType(id.getName());
                }
                if (clazz == null) {
                    return this.model.lookupInsertPackage((PackageDeclaration)((PackageDeclaration)basePkg.astNode), (String)id.getName()).symbol;
                }
            } else {
                clazz = base.lookupType(id.getName());
            }
        }
        if (this.checkMemberAccess(id, clazz, from, null)) {
            clazz.addReference(id);
            clazz.addDependence(from.getInnermostType());
            return clazz;
        }
        return null;
    }

    private CType lookupSimpleType(CScope from, SimpleName type) {
        if (type instanceof BuiltInType) {
            return this.lookupBuiltInType(((BuiltInType)type).kind());
        }
        CScope sc = from;
        while (sc != null) {
            CClassType clazz = sc.lookupType(type.getName());
            if (clazz != null) {
                return clazz;
            }
            if (sc instanceof CCompilationUnit) break;
            sc = sc.getParent();
        }
        return null;
    }

    CType lookupType(CScope from, Name id) {
        CType clazz = null;
        if (id.base() == null) {
            clazz = this.lookupSimpleType(from, (SimpleName)id);
            if (clazz == null) {
                clazz = this.sem.currentFile.loadType(id.getName());
            }
        } else {
            if (!(id.base() instanceof Name)) {
                return null;
            }
            CScope q = this.lookupPackageOrType(from, (Name)id.base());
            if (q == null) {
                return null;
            }
            clazz = q.lookupType(id.getName());
            if (clazz == null) {
                CScope sc = this.loadPackageOrType(from, id);
                return sc instanceof CType ? (CType)sc : null;
            }
        }
        if (this.checkMemberAccess(id, clazz, from, null)) {
            clazz.addDependence(from.getInnermostType());
            id.exprType = clazz;
            return clazz;
        }
        return null;
    }

    CType lookupType(CScope from, TypeExpr typeSpec) {
        CType type = this.lookupType(from, typeSpec.type);
        typeSpec.exprType = type;
        if (type != null && typeSpec.numBrackets() > 0) {
            type = type.getArrayType(this, typeSpec.numBrackets());
        }
        return type;
    }

    CVariable lookupSimpleExpression(CScope from, SimpleName id) {
        CScope sc = from;
        while (sc != null) {
            if (sc instanceof CCompilationUnit || sc instanceof CPackage) break;
            CVariable v = sc.lookupVariable(id.getName());
            if (this.checkMemberAccess(id, v, from, null)) {
                v.addReference(id);
                v.getType().addDependence(from.getInnermostType());
                return v;
            }
            sc = sc.getParent();
        }
        return null;
    }

    CScope lookupImportedType(CPackage from, Name id) {
        if (id.base() == null) {
            CClassType type;
            if (from != null) {
                type = from.lookupType(id.getName());
                if (type == null) {
                    type = this.getDefaultPackage().lookupType(id.getName());
                }
            } else {
                type = this.getDefaultPackage().lookupType(id.getName());
            }
            if (type == null) {
                if (from != null) {
                    type = from.loadType(id.getName());
                    if (type == null) {
                        type = this.getDefaultPackage().loadType(id.getName());
                    }
                } else {
                    type = this.getDefaultPackage().loadType(id.getName());
                }
            }
            if (type != null) {
                return this.checkTypeAccess(type, from) ? type : null;
            }
            return this.model.lookupInsertPackage((String)id.getName()).symbol;
        }
        CScope base = this.lookupImportedType(from, (Name)id.base());
        if (base instanceof CClassType) {
            CClassType clazz = ((CClassType)base).lookupTypeWithoutInheritance(id.getName());
            return this.checkTypeAccess(clazz, from) ? clazz : null;
        }
        if (base instanceof CPackage) {
            CPackage ownerPkg = (CPackage)base;
            CClassType type = ownerPkg.lookupType(id.getName());
            if (type == null) {
                type = this.loadReferenceType(id.getFullName());
            }
            if (type != null) {
                return this.checkTypeAccess(type, from) ? type : null;
            }
            return this.model.lookupInsertPackage((PackageDeclaration)((PackageDeclaration)ownerPkg.astNode), (String)id.getName()).symbol;
        }
        return null;
    }

    private CPackage processPackage(String qualifiedName) {
        return this.model.lookupInsertPackageQualified((String)qualifiedName).symbol;
    }

    private void initBuiltInTypes() {
        this.nullType = new CPrimitiveType(10);
        this.voidType = new CPrimitiveType(1);
        this.booleanType = new CPrimitiveType(9);
        this.badType = CBadType.getInstance();
        this.doubleType = new CPrimitiveType(8);
        this.floatType = new CPrimitiveType(7);
        this.longType = new CPrimitiveType(6);
        this.intType = new CPrimitiveType(5);
        this.charType = new CPrimitiveType(4);
        this.shortType = new CPrimitiveType(3);
        this.byteType = new CPrimitiveType(2);
    }

    private void initLibraryPackages() {
        this.javaLangPackage = this.processPackage("java/lang");
        this.javaIoPackage = this.processPackage("java/io");
    }

    private CClassType loadType(CPackage parent, String name) {
        CClassType type = parent.lookupType(name);
        if (type == null && (type = this.loadTypeFromClassFile((PackageDeclaration)parent.astNode, null, name)) == null) {
            ErrorMgr.report(16, name);
            System.exit(1);
        }
        return type;
    }

    public void initLibraryTypes(boolean assertEnabled) {
        if (this.stdTypesLoaded) {
            return;
        }
        this.objectType = this.loadType(this.javaLangPackage, "Object");
        this.stringType = this.loadType(this.javaLangPackage, "String");
        this.cloneableType = this.loadType(this.javaLangPackage, "Cloneable");
        this.classType = this.loadType(this.javaLangPackage, "Class");
        this.serializableType = this.loadType(this.javaIoPackage, "Serializable");
        this.throwableType = this.loadType(this.javaLangPackage, "Throwable");
        if (assertEnabled) {
            this.assertionErrorType = this.loadType(this.javaLangPackage, "AssertionError");
        }
        this.stdTypesLoaded = true;
    }

    public CType lookupBuiltInType(int kind) {
        switch (kind) {
            case 10: {
                return this.nullType;
            }
            case 1: {
                return this.voidType;
            }
            case 2: {
                return this.byteType;
            }
            case 3: {
                return this.shortType;
            }
            case 4: {
                return this.charType;
            }
            case 5: {
                return this.intType;
            }
            case 6: {
                return this.longType;
            }
            case 7: {
                return this.floatType;
            }
            case 8: {
                return this.doubleType;
            }
            case 9: {
                return this.booleanType;
            }
            case 0: {
                return this.badType;
            }
        }
        return this.badType;
    }

    public void report(IndentingPrintWriter out) {
        this.reportIndentedElements(out, null, this.packages);
        this.getDefaultPackage().report(out);
    }

    public void accept(CVisitor visitor) {
    }

    public void traverse(CVisitor visitor) {
        int i = 0;
        while (i < this.numPackages()) {
            this.getPackage(i).action(visitor);
            ++i;
        }
        this.defaultPackage.action(visitor);
        this.byteType.action(visitor);
        this.shortType.action(visitor);
        this.charType.action(visitor);
        this.intType.action(visitor);
        this.longType.action(visitor);
        this.floatType.action(visitor);
        this.doubleType.action(visitor);
        this.booleanType.action(visitor);
        this.voidType.action(visitor);
        this.nullType.action(visitor);
        this.badType.action(visitor);
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.stdTypesLoaded = true;
    }
}

