/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.symbol;

import com.togethersoft.sca.ast.AstTypeReference;
import com.togethersoft.sca.internal.jparser.ast.AstVector;
import com.togethersoft.sca.internal.jparser.ast.Expr;
import com.togethersoft.sca.internal.jparser.ast.TypeDeclaration;
import com.togethersoft.sca.internal.jparser.symbol.CClassType;
import com.togethersoft.sca.internal.jparser.symbol.CMethod;
import com.togethersoft.sca.internal.jparser.symbol.CScope;
import com.togethersoft.sca.internal.jparser.symbol.CType;
import com.togethersoft.sca.internal.jparser.symbol.CVariable;
import com.togethersoft.sca.internal.jparser.symbol.CVisitor;
import com.togethersoft.sca.internal.jparser.symbol.MethodSet;
import com.togethersoft.sca.internal.jparser.symbol.SymbolTable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public abstract class CReferenceType
extends CType {
    private transient CClassType superClass;
    transient ArrayList superIfaces;
    transient ArrayList subclasses;
    SymbolTable stable = new SymbolTable();
    ArrayList methods = new ArrayList();
    private transient HashMap inheritedFields;
    private transient ArrayList inheritedMethods;

    CReferenceType(CClassType ownerType, CScope parent, String name, int modifiers) {
        super(ownerType, parent, name, modifiers);
    }

    public boolean isReference() {
        return true;
    }

    public boolean isDerivedFrom(AstTypeReference type) {
        if (type instanceof TypeDeclaration) {
            return this.descendsFrom(((TypeDeclaration)type).symbol);
        }
        if (type instanceof CClassType) {
            return this.descendsFrom((CClassType)type);
        }
        return false;
    }

    public void setSuperClass(CClassType t) {
        this.superClass = t;
    }

    public CClassType getSuperClass() {
        return this.superClass;
    }

    public int numInterfaces() {
        if (this.superIfaces == null) {
            return 0;
        }
        return this.superIfaces.size();
    }

    public void addInterface(CClassType ifc) {
        if (this.superIfaces == null) {
            this.superIfaces = new ArrayList();
        }
        this.superIfaces.add(ifc);
    }

    public void removeInterface(CClassType ifc) {
        this.removeElement(this.superIfaces, ifc);
    }

    public CClassType getInterface(int i) {
        return (CClassType)this.superIfaces.get(i);
    }

    public Collection getAllFields() {
        if (this.inheritedFields == null) {
            this.buildFieldsClosure();
        }
        return this.inheritedFields.values();
    }

    public Collection getAllMethods() {
        if (this.inheritedMethods == null) {
            this.buildMethodsClosure();
        }
        return this.inheritedMethods;
    }

    int numMethods() {
        return this.methods.size();
    }

    void addMethod(CMethod m) {
        this.methods.add(m);
    }

    CMethod getMethod(int i) {
        return (CMethod)this.methods.get(i);
    }

    int numInheritedMethods() {
        return this.inheritedMethods.size();
    }

    CMethod getInheritedMethod(int i) {
        return (CMethod)this.inheritedMethods.get(i);
    }

    protected void buildMethodsClosure(CReferenceType derived) {
        if ("java/lang/Object".equals(this.getQualifiedName()) && derived.isInterface()) {
            int i = 0;
            while (i < this.numMethods()) {
                CMethod m1 = this.getMethod(i);
                if (m1.isPublic() && !m1.isStatic() && derived.lookupMethod(m1.getName(), m1.getSignature()) == null) {
                    derived.inheritedMethods.add(m1);
                }
                ++i;
            }
        } else {
            if (this.inheritedMethods == null) {
                this.buildMethodsClosure();
            }
            int i = 0;
            while (i < this.numInheritedMethods()) {
                CMethod m1 = this.getInheritedMethod(i);
                if ((m1.isPublic() || m1.isProtected() || !m1.isPrivate() && this.getPackage() == derived.getPackage()) && derived.lookupMethod(m1.getName(), m1.getSignature()) == null) {
                    derived.inheritedMethods.add(m1);
                }
                ++i;
            }
        }
    }

    void buildMethodsClosure() {
        if (this.inheritedMethods != null) {
            return;
        }
        this.inheritedMethods = new ArrayList();
        this.inheritedMethods.addAll(this.methods);
        if (this.getSuperClass() != null) {
            this.getSuperClass().buildMethodsClosure(this);
        }
        int i = 0;
        while (i < this.numInterfaces()) {
            this.getInterface(i).buildMethodsClosure(this);
            ++i;
        }
    }

    protected void buildFieldsClosure(CReferenceType derived) {
        if (this.inheritedFields == null) {
            this.buildFieldsClosure();
        }
        Iterator i = this.inheritedFields.values().iterator();
        while (i.hasNext()) {
            CVariable field = (CVariable)i.next();
            if (!field.isPublic() && !field.isProtected() && (field.isPrivate() || this.getPackage() != derived.getPackage()) || derived.inheritedFields.get(field.getName()) != null) continue;
            derived.inheritedFields.put(field.getName(), field);
        }
    }

    private void buildFieldsClosure() {
        this.inheritedFields = new HashMap();
        if (this.stable.getVariables() != null) {
            Iterator i = this.stable.getVariables().iterator();
            while (i.hasNext()) {
                CVariable field = (CVariable)i.next();
                this.inheritedFields.put(field.getName(), field);
            }
        }
        if (this.getSuperClass() != null) {
            this.getSuperClass().buildFieldsClosure(this);
        }
        int i = 0;
        while (i < this.numInterfaces()) {
            this.getInterface(i).buildFieldsClosure(this);
            ++i;
        }
    }

    void addVariable(CVariable v) {
        this.stable.addVariable(v);
    }

    public CVariable lookupVariable(String name) {
        if (this.inheritedFields == null) {
            this.buildFieldsClosure();
        }
        return (CVariable)this.inheritedFields.get(name);
    }

    public CVariable lookupVariableWithoutInheritance(String name) {
        return this.stable.lookupVariable(name);
    }

    public CMethod lookupMethod(String name, String signature) {
        if (this.inheritedMethods == null) {
            this.buildMethodsClosure();
        }
        int i = 0;
        while (i < this.numInheritedMethods()) {
            CMethod method = this.getInheritedMethod(i);
            if (method.getName().equals(name) && method.getSignature().equals(signature)) {
                return method;
            }
            ++i;
        }
        return null;
    }

    MethodSet lookupMethod(CClassType from, CType base, String name, AstVector parms) {
        int numParms;
        MethodSet set = new MethodSet();
        boolean methodFound = false;
        int n = numParms = parms != null ? parms.size() : 0;
        if (this.inheritedMethods == null) {
            this.buildMethodsClosure();
        }
        int i = 0;
        while (i < this.numInheritedMethods()) {
            CMethod method = this.getInheritedMethod(i);
            if (method.isPending()) {
                method.process();
            }
            if (method.getName().equals(name)) {
                methodFound = true;
                if (method.numFormalParameters() == numParms) {
                    boolean applicable;
                    if (!method.isAccessible(from, base)) {
                        applicable = false;
                    } else {
                        applicable = true;
                        int j = 0;
                        while (j < numParms) {
                            CType formalType = method.getFormalParameter(j).getType();
                            CType actualType = ((Expr)parms.at(j)).type();
                            if (!actualType.isAssignableToMethodParam(formalType)) {
                                applicable = false;
                                break;
                            }
                            ++j;
                        }
                    }
                    if (applicable) {
                        set.put(method);
                    }
                }
            }
            ++i;
        }
        return methodFound ? set : null;
    }

    boolean isSubclass(CClassType superClass) {
        if (this == superClass) {
            return true;
        }
        return this.getSuperClass() == null ? false : this.getSuperClass().isSubclass(superClass);
    }

    boolean isSubinterface(CClassType superIface) {
        if (this == superIface) {
            return true;
        }
        int i = 0;
        while (i < this.numInterfaces()) {
            if (this.getInterface(i).isSubinterface(superIface)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean implementsIface(CClassType iface) {
        int i = 0;
        while (i < this.numInterfaces()) {
            if (this.getInterface(i).isSubinterface(iface)) {
                return true;
            }
            ++i;
        }
        return this.getSuperClass() == null ? false : this.getSuperClass().implementsIface(iface);
    }

    public boolean descendsFrom(CClassType from) {
        if (this.isInterface()) {
            if (from.isInterface()) {
                return this.isSubinterface(from);
            }
            return false;
        }
        if (from.isInterface()) {
            return this.implementsIface(from);
        }
        return this.isSubclass(from);
    }

    public boolean enclosingClassDescendsFrom(CClassType from) {
        CReferenceType cls = this;
        while (cls != null) {
            if (cls.descendsFrom(from)) {
                return true;
            }
            cls = cls.getOwnerType();
        }
        return false;
    }

    public boolean descendsFromEnclosingClass(CClassType from) {
        CClassType cls = from;
        while (cls != null) {
            if (this.descendsFrom(cls)) {
                return true;
            }
            cls = cls.getOwnerType();
        }
        return false;
    }

    public boolean descendsFrom(String typeName) {
        if (this.getQualifiedName().equals(typeName)) {
            return true;
        }
        if (this.getSuperClass() != null && this.getSuperClass().descendsFrom(typeName)) {
            return true;
        }
        int i = 0;
        while (i < this.numInterfaces()) {
            if (this.getInterface(i).descendsFrom(typeName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void traverse(CVisitor visitor) {
        super.traverse(visitor);
        this.stable.traverse(visitor);
        int i = 0;
        while (i < this.numMethods()) {
            this.getMethod(i).action(visitor);
            ++i;
        }
    }

    public void addSubclass(CClassType subcls) {
        if (this.subclasses == null) {
            this.subclasses = new ArrayList();
        }
        this.subclasses.add(subcls);
    }

    public void removeSubclass(CClassType cls) {
        if (this.subclasses != null) {
            Iterator i = ((AbstractList)this.subclasses).iterator();
            while (i.hasNext()) {
                if (i.next() != cls) continue;
                i.remove();
                break;
            }
        }
    }

    public int numSubclasses() {
        return this.subclasses != null ? this.subclasses.size() : 0;
    }

    public CClassType getSubclass(int i) {
        return (CClassType)this.subclasses.get(i);
    }

    public void getOverridden(CMethod m, HashSet methods) {
        CClassType superClass = this.getSuperClass();
        if (superClass != null) {
            CMethod ov = superClass.findMethod(m.getName(), m.getSignature());
            if (ov != null) {
                methods.add(ov);
            }
            superClass.getOverridden(m, methods);
        }
        int i = 0;
        while (i < this.numInterfaces()) {
            CClassType superIface = this.getInterface(i);
            CMethod ov = superIface.findMethod(m.getName(), m.getSignature());
            if (ov != null) {
                methods.add(ov);
            }
            superIface.getOverridden(m, methods);
            ++i;
        }
    }

    public void overriddenBy(CMethod m, HashSet methods) {
        if (this.subclasses != null) {
            Iterator i = ((AbstractList)this.subclasses).iterator();
            while (i.hasNext()) {
                CClassType subcls = (CClassType)i.next();
                CMethod ov = subcls.findMethod(m.getName(), m.getSignature());
                if (ov != null) {
                    methods.add(ov);
                }
                subcls.overriddenBy(m, methods);
            }
        }
    }

    public CMethod findMethod(String name, String signature) {
        int i = 0;
        while (i < this.numMethods()) {
            CMethod m = this.getMethod(i);
            if (m.getName().equals(name) && m.getSignature().equals(signature)) {
                return m;
            }
            ++i;
        }
        return null;
    }
}

