/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.symbol;

import com.togethersoft.sca.internal.jparser.ast.Ast;
import com.togethersoft.sca.internal.jparser.symbol.CClassType;
import com.togethersoft.sca.internal.jparser.symbol.CType;
import com.togethersoft.sca.internal.jparser.symbol.CVisitor;
import com.togethersoft.sca.internal.jparser.symbol.Constants;
import com.togethersoft.sca.internal.jparser.symbol.IndentingPrintWriter;

public class CPrimitiveType
extends CType
implements Constants {
    private int kind;

    CPrimitiveType(int kind) {
        super(null, null, null, 0);
        this.kind = kind;
    }

    public boolean isPrimitive() {
        return true;
    }

    public int getKind() {
        return this.kind;
    }

    public boolean isIntegral() {
        return this.kind == 2 || this.kind == 3 || this.kind == 4 || this.kind == 5 || this.kind == 6;
    }

    boolean isFloatingPoint() {
        return this.kind == 7 || this.kind == 8;
    }

    public boolean isNumeric() {
        return this.isIntegral() || this.isFloatingPoint();
    }

    public boolean isBoolean() {
        return this.kind == 9;
    }

    public boolean isNull() {
        return this.kind == 10;
    }

    boolean isAccessible(CClassType from, CType base) {
        return true;
    }

    boolean isAssignableTo(CType t) {
        if (this == t) {
            return true;
        }
        if (t.isReference()) {
            return this.kind == 10;
        }
        if (!t.isPrimitive()) {
            return false;
        }
        CPrimitiveType type = (CPrimitiveType)t;
        switch (this.kind) {
            case 2: {
                return type.kind == 3 || type.kind == 5 || type.kind == 6 || type.kind == 7 || type.kind == 8;
            }
            case 3: {
                return type.kind == 5 || type.kind == 6 || type.kind == 7 || type.kind == 8;
            }
            case 4: {
                return type.kind == 5 || type.kind == 6 || type.kind == 7 || type.kind == 8;
            }
            case 5: {
                return type.kind == 6 || type.kind == 7 || type.kind == 8;
            }
            case 6: {
                return type.kind == 7 || type.kind == 8;
            }
            case 7: {
                return type.kind == 8;
            }
        }
        return false;
    }

    public void addReference(Ast from) {
    }

    protected String buildSignature() {
        switch (this.kind) {
            case 1: {
                return "V";
            }
            case 2: {
                return "B";
            }
            case 3: {
                return "S";
            }
            case 4: {
                return "C";
            }
            case 5: {
                return "I";
            }
            case 6: {
                return "J";
            }
            case 7: {
                return "F";
            }
            case 8: {
                return "D";
            }
            case 9: {
                return "Z";
            }
        }
        return "#";
    }

    public String getQualifiedName() {
        switch (this.kind) {
            case 1: {
                return "void";
            }
            case 2: {
                return "byte";
            }
            case 3: {
                return "short";
            }
            case 4: {
                return "char";
            }
            case 5: {
                return "int";
            }
            case 6: {
                return "long";
            }
            case 7: {
                return "float";
            }
            case 8: {
                return "double";
            }
            case 9: {
                return "boolean";
            }
            case 10: {
                return "null";
            }
        }
        return null;
    }

    public String getName() {
        return this.getQualifiedName();
    }

    public void report(IndentingPrintWriter out) {
    }

    public void accept(CVisitor visitor) {
        visitor.visitPrimitiveType(this);
    }

    public void traverse(CVisitor visitor) {
        super.traverse(visitor);
    }
}

