/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.symbol;

import com.togethersoft.sca.internal.jparser.ast.PackageDeclaration;
import com.togethersoft.sca.internal.jparser.symbol.CClassType;
import com.togethersoft.sca.internal.jparser.symbol.CCompilationUnit;
import com.togethersoft.sca.internal.jparser.symbol.CScope;
import com.togethersoft.sca.internal.jparser.symbol.CType;
import com.togethersoft.sca.internal.jparser.symbol.CVisitor;
import com.togethersoft.sca.internal.jparser.symbol.Constants;
import com.togethersoft.sca.internal.jparser.symbol.IndentingPrintWriter;
import com.togethersoft.sca.internal.jparser.symbol.Reportable;
import java.util.ArrayList;

public class CPackage
extends CScope
implements Reportable,
Constants {
    private ArrayList packages = new ArrayList();
    private ArrayList types = new ArrayList();
    private ArrayList cunits = new ArrayList();

    CPackage(CScope parent, String name, PackageDeclaration astNode) {
        super(null, parent, name, 0);
        this.astNode = astNode;
    }

    public int numTypes() {
        return this.types.size();
    }

    public CClassType getType(int i) {
        return (CClassType)this.types.get(i);
    }

    public void addType(CClassType type) {
        this.types.add(type);
    }

    public int numCUnits() {
        return this.cunits.size();
    }

    public CCompilationUnit getCUnit(int i) {
        return (CCompilationUnit)this.cunits.get(i);
    }

    public void addCUnit(CCompilationUnit cu) {
        this.cunits.add(cu);
    }

    public void removeCUnit(CCompilationUnit cu) {
        int index = this.cunits.indexOf(cu);
        if (index >= 0) {
            this.cunits.remove(index);
        }
    }

    public int numSubpackages() {
        return this.packages.size();
    }

    public CPackage getSubpackage(int i) {
        return (CPackage)this.packages.get(i);
    }

    public CPackage lookupPackage(String name) {
        return (CPackage)this.lookupElement(this.packages, name);
    }

    public CPackage insertPackage(String name) {
        CPackage pkg = new CPackage(this, name, null);
        this.packages.add(pkg);
        return pkg;
    }

    public CPackage getPackage() {
        return this;
    }

    public CClassType lookupType(String name) {
        CClassType t = (CClassType)this.lookupElement(this.types, name);
        if (t != null) {
            return t;
        }
        int i = 0;
        while (i < this.cunits.size()) {
            CCompilationUnit cu = (CCompilationUnit)this.cunits.get(i);
            t = cu.lookupDeclaredType(name);
            if (t != null) {
                return t;
            }
            ++i;
        }
        return t;
    }

    public CClassType loadType(String name) {
        return this.getTopScope().loadTypeFromClassFile((PackageDeclaration)this.astNode, null, name);
    }

    boolean isAccessible(CClassType from, CType base) {
        return true;
    }

    public void report(IndentingPrintWriter out) {
        if (this.cunits.size() > 0 || this.types.size() > 0) {
            out.print("\nPackage: " + (this.getQualifiedName() == null ? "default" : this.getQualifiedName()));
            out.println(" #" + this.getAST().id());
            out.println("-----------------------------------------");
            out.indent();
            this.reportElements(out, this.types);
            this.reportElements(out, this.cunits);
            out.dedent();
        }
        this.reportElements(out, this.packages);
    }

    public void accept(CVisitor visitor) {
        visitor.visitPackage(this);
    }

    public void traverse(CVisitor visitor) {
        int i = 0;
        while (i < this.numSubpackages()) {
            this.getSubpackage(i).action(visitor);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.numTypes()) {
            this.getType(i2).action(visitor);
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.numCUnits()) {
            this.getCUnit(i3).action(visitor);
            ++i3;
        }
    }
}

