/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.symbol;

import com.togethersoft.sca.internal.jparser.ast.Declaration;
import com.togethersoft.sca.internal.jparser.ast.FormalParameter;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.MethodDeclaration;
import com.togethersoft.sca.internal.jparser.ast.Modifiers;
import com.togethersoft.sca.internal.jparser.ast.ThrowSpecifier;
import com.togethersoft.sca.internal.jparser.ast.VariableDeclarator;
import com.togethersoft.sca.internal.jparser.classfile.ClassConstants;
import com.togethersoft.sca.internal.jparser.symbol.CBadType;
import com.togethersoft.sca.internal.jparser.symbol.CClassType;
import com.togethersoft.sca.internal.jparser.symbol.CScope;
import com.togethersoft.sca.internal.jparser.symbol.CType;
import com.togethersoft.sca.internal.jparser.symbol.CVariable;
import com.togethersoft.sca.internal.jparser.symbol.CVisitor;
import com.togethersoft.sca.internal.jparser.symbol.Constants;
import com.togethersoft.sca.internal.jparser.symbol.ErrorMgr;
import com.togethersoft.sca.internal.jparser.symbol.IndentingPrintWriter;
import com.togethersoft.sca.internal.jparser.symbol.Reportable;
import java.util.ArrayList;

public class CMethod
extends CScope
implements Reportable,
Constants,
ClassConstants {
    transient CType type;
    private String descriptor;
    private String[] exceptions;
    private ArrayList formalParameters = null;
    private boolean isErrorFree = true;
    private static final String paramName = "<formal param>";
    private static final JavaToken paramToken = new JavaToken("<formal param>");

    CMethod(CClassType ownerType, String name, CType type, int modifiers, Declaration astNode) {
        super(ownerType, ownerType, name, modifiers);
        this.type = type;
        this.astNode = astNode;
    }

    public boolean isErrorFree() {
        return this.isErrorFree;
    }

    public void resetErrorFree() {
        this.isErrorFree = false;
    }

    protected String buildSignature() {
        if (this.isPending()) {
            this.process();
        }
        String signature = "(";
        int i = 0;
        while (i < this.numFormalParameters()) {
            signature = signature + this.getFormalParameter(i).getType().getSignature();
            ++i;
        }
        signature = signature + ")" + this.getType().getSignature();
        return signature;
    }

    int numFormalParameters() {
        return this.formalParameters == null ? 0 : this.formalParameters.size();
    }

    CVariable getFormalParameter(int i) {
        return (CVariable)this.formalParameters.get(i);
    }

    void addVariable(CVariable p) {
        if (this.formalParameters == null) {
            this.formalParameters = new ArrayList();
        }
        this.formalParameters.add(p);
    }

    public CType getType() {
        if (this.isPending()) {
            this.process();
        }
        return this.type;
    }

    public void setType(CType type) {
        this.type = type;
    }

    void setDescriptor(String descriptor, String[] exceptions) {
        this.descriptor = descriptor;
        this.exceptions = exceptions;
    }

    public boolean isPending() {
        return this.descriptor != null;
    }

    public void process() {
        if (this.exceptions != null) {
            int i = 0;
            while (i < this.exceptions.length) {
                CClassType exc = this.getTopScope().loadReferenceType(this.exceptions[i]);
                if (exc != null) {
                    ThrowSpecifier thr = new ThrowSpecifier(null);
                    thr.type = exc;
                    ((MethodDeclaration)this.astNode).addThrowSpecifier(thr);
                } else {
                    ErrorMgr.report(17, "for method: " + this.getQualifiedName() + ", throw specifier type descriptor: " + this.exceptions[i]);
                }
                ++i;
            }
        }
        this.exceptions = null;
        int src = 0;
        int length = this.descriptor.length();
        if (length > 0 && this.descriptor.charAt(src++) == '(') {
            while (src < length && this.descriptor.charAt(src) != ')') {
                CType paramType = this.getTopScope().loadTypeFromDescriptor(this.descriptor.substring(src));
                if (paramType == null) {
                    ErrorMgr.report(17, "for method: " + this.getQualifiedName() + ", formal parameter type descriptor: " + this.descriptor.substring(src));
                    paramType = CBadType.getInstance();
                }
                if (!((MethodDeclaration)this.getAST()).isConstructor() || src != 1 || this.getOwnerType().hasSourceFile() || !this.getOwnerType().isMemberInnerClass() || paramType != this.getOwnerType().getOwnerType()) {
                    CVariable param;
                    VariableDeclarator paramAst;
                    FormalParameter paramDecl = new FormalParameter(new Modifiers(0), null);
                    paramDecl.declarator = paramAst = new VariableDeclarator(paramDecl, paramToken, null, null, null);
                    ((MethodDeclaration)this.astNode).addFormalParameter(paramDecl);
                    paramAst.symbol = param = new CVariable(this.getOwnerType(), this, paramName, 0, paramAst);
                    param.setType(paramType);
                    this.addVariable(param);
                }
                while (src < length && this.descriptor.charAt(src) == '[') {
                    ++src;
                }
                if (src >= length) continue;
                if (this.descriptor.charAt(src) == 'L') {
                    while (src < length && this.descriptor.charAt(src) != ';') {
                        ++src;
                    }
                    ++src;
                    continue;
                }
                ++src;
            }
            if (src < length - 1 && this.descriptor.charAt(src) == ')') {
                this.type = this.getTopScope().loadTypeFromDescriptor(this.descriptor.substring(++src));
                if (this.type == null) {
                    ErrorMgr.report(17, "for method: " + this.getQualifiedName() + ", return type descriptor: " + this.descriptor.substring(src));
                    this.type = CBadType.getInstance();
                }
                this.descriptor = null;
                return;
            }
        }
        ErrorMgr.report(18, "for method: " + this.getQualifiedName() + ", method descriptor: " + this.descriptor);
        this.type = CBadType.getInstance();
        this.descriptor = null;
    }

    CVariable lookupVariable(String name) {
        if (this.isPending()) {
            this.process();
        }
        return (CVariable)this.lookupElement(this.formalParameters, name);
    }

    boolean isAccessible(CClassType from, CType base) {
        if (base != null && base.isArray()) {
            return true;
        }
        return super.isAccessible(from, base);
    }

    boolean isMoreSpecific(CMethod m) {
        if (this.isPending()) {
            this.process();
        }
        if (m.isPending()) {
            m.process();
        }
        int i = 0;
        while (i < this.numFormalParameters()) {
            CType uParam;
            CType tParam = this.getFormalParameter(i).getType();
            if (tParam != (uParam = m.getFormalParameter(i).getType()) && !tParam.isAssignableToMethodParam(uParam)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void report(IndentingPrintWriter out) {
        out.print(this.getQualifiedName() + " (Method)");
        out.println(" #" + this.getAST().id());
        out.indent();
        this.listReferences(out);
        this.reportIndentedElements(out, "Parameters:", this.formalParameters);
        out.dedent();
    }

    public void accept(CVisitor visitor) {
        visitor.visitMethod(this);
    }

    public void traverse(CVisitor visitor) {
        int i = 0;
        while (i < this.numFormalParameters()) {
            this.getFormalParameter(i).action(visitor);
            ++i;
        }
    }
}

