/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.symbol;

import com.togethersoft.sca.internal.jparser.ast.Ast;
import com.togethersoft.sca.internal.jparser.ast.Declaration;
import com.togethersoft.sca.internal.jparser.symbol.CAccessMods;
import com.togethersoft.sca.internal.jparser.symbol.CClassType;
import com.togethersoft.sca.internal.jparser.symbol.CCompilationUnit;
import com.togethersoft.sca.internal.jparser.symbol.CPackage;
import com.togethersoft.sca.internal.jparser.symbol.CScope;
import com.togethersoft.sca.internal.jparser.symbol.CTopLevel;
import com.togethersoft.sca.internal.jparser.symbol.CType;
import com.togethersoft.sca.internal.jparser.symbol.CVisitor;
import com.togethersoft.sca.internal.jparser.symbol.Constants;
import com.togethersoft.sca.internal.jparser.symbol.IndentingPrintWriter;
import com.togethersoft.sca.internal.jparser.symbol.Reportable;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

public abstract class CDefinition
implements Serializable,
Constants {
    protected String name;
    protected CAccessMods modifiers;
    protected CClassType ownerType;
    protected transient String qualifiedName;
    protected CScope parent;
    public transient Declaration astNode;
    private transient String signature;

    CDefinition(CClassType ownerType, CScope parent, String name, int modifiers) {
        this.ownerType = ownerType;
        this.parent = parent;
        this.name = name;
        this.modifiers = new CAccessMods(modifiers);
    }

    public Declaration getAST() {
        return this.astNode;
    }

    public String getSignature() {
        if (this.signature == null) {
            this.signature = this.buildSignature();
        }
        return this.signature;
    }

    protected String buildSignature() {
        return "";
    }

    public CScope getParent() {
        return this.parent;
    }

    public CCompilationUnit getCompilationUnit() {
        CScope parent = this.getParent();
        while (parent != null) {
            if (parent instanceof CCompilationUnit) {
                return (CCompilationUnit)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public CClassType getOwnerType() {
        return this.ownerType;
    }

    public CClassType getInnermostType() {
        return this.getOwnerType();
    }

    CPackage getPackage() {
        CClassType containingType = this.getInnermostType();
        return containingType == null ? null : containingType.getPackage();
    }

    protected CTopLevel getTopScope() {
        CScope scope = this.parent;
        while (!(scope instanceof CTopLevel)) {
            scope = scope.parent;
        }
        return (CTopLevel)scope;
    }

    public CAccessMods getAccess() {
        return this.modifiers;
    }

    public boolean isPublic() {
        return this.getAccess().ACC_PUBLIC();
    }

    public boolean isProtected() {
        return this.getAccess().ACC_PROTECTED();
    }

    public boolean isPrivate() {
        return this.getAccess().ACC_PRIVATE();
    }

    public boolean isFinal() {
        return this.getAccess().ACC_FINAL();
    }

    public boolean isAbstract() {
        return this.getAccess().ACC_ABSTRACT();
    }

    public boolean isStatic() {
        return this.getAccess().ACC_STATIC();
    }

    boolean isAccessible(CClassType from, CType base) {
        if (from.getInnermostType() == null) {
            return false;
        }
        if (this.isPublic()) {
            return true;
        }
        if (this.isProtected()) {
            if (this.getPackage() == from.getPackage()) {
                return true;
            }
            if (from.enclosingClassDescendsFrom(this.getOwnerType())) {
                if (base != null) {
                    return base.descendsFromEnclosingClass(from);
                }
                return true;
            }
            return false;
        }
        if (this.isPrivate()) {
            return this.getInnermostType().getOutermostType() == from.getOutermostType();
        }
        return this.getPackage() == from.getPackage();
    }

    String getDef() {
        return this.astNode.getLocation();
    }

    public String getName() {
        return this.name == null ? "~noname~" : this.name;
    }

    public String getQualifiedName() {
        if (this.qualifiedName == null) {
            String parentName;
            if (this.parent != null && (parentName = this.parent.getQualifiedName()) != null && parentName.length() > 0) {
                this.qualifiedName = this.name == null ? parentName : parentName + "/" + this.name;
                return this.qualifiedName;
            }
            this.qualifiedName = this.name != null ? this.name : "";
        }
        return this.qualifiedName;
    }

    public String getScopedClassName() {
        CScope d = this.getParent();
        if (!(d instanceof CClassType)) {
            return this.getName();
        }
        String name = d.getScopedClassName() + "$" + this.getName();
        return name;
    }

    public void addReference(Ast from) {
        if (this.astNode != null) {
            this.astNode.addReference(from);
        }
    }

    void listReferences(IndentingPrintWriter out) {
        Collection refs = this.astNode.getReferenceList();
        if (refs != null) {
            out.println("Referenced:");
            out.indent();
            Iterator i = refs.iterator();
            while (i.hasNext()) {
                out.println(((Ast)i.next()).getLocation());
            }
            out.dedent();
        }
    }

    void listElements(IndentingPrintWriter out, Collection v) {
        if (v != null) {
            Iterator iter = v.iterator();
            while (iter.hasNext()) {
                out.println(((CDefinition)iter.next()).getQualifiedName());
            }
        }
    }

    void listIndentedElements(IndentingPrintWriter out, String title, Collection v) {
        if (v != null) {
            if (title != null) {
                out.println(title);
            }
            out.indent();
            this.listElements(out, v);
            out.dedent();
        }
    }

    void reportElements(IndentingPrintWriter out, Collection v) {
        if (v != null) {
            Iterator iter = v.iterator();
            while (iter.hasNext()) {
                ((Reportable)iter.next()).report(out);
            }
        }
    }

    void reportIndentedElements(IndentingPrintWriter out, String title, Collection v) {
        if (v != null) {
            if (title != null) {
                out.println(title);
            }
            out.indent();
            this.reportElements(out, v);
            out.dedent();
        }
    }

    public String toString() {
        return this.getQualifiedName();
    }

    public abstract void accept(CVisitor var1);

    public abstract void traverse(CVisitor var1);

    public void action(CVisitor visitor) {
        if ((visitor.getAction() & 1) != 0) {
            this.accept(visitor);
        }
        this.traverse(visitor);
        if ((visitor.getAction() & 2) != 0) {
            this.accept(visitor);
        }
    }
}

