/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.symbol;

import com.togethersoft.sca.internal.jparser.ast.CompilationUnit;
import com.togethersoft.sca.internal.jparser.symbol.CClassType;
import com.togethersoft.sca.internal.jparser.symbol.CPackage;
import com.togethersoft.sca.internal.jparser.symbol.CScope;
import com.togethersoft.sca.internal.jparser.symbol.CVisitor;
import com.togethersoft.sca.internal.jparser.symbol.IndentingPrintWriter;
import com.togethersoft.sca.internal.jparser.symbol.Reportable;
import java.util.ArrayList;

public class CCompilationUnit
extends CScope
implements Reportable {
    ArrayList types = new ArrayList();
    transient ArrayList importedPackages;
    transient ArrayList importedTypes;

    CCompilationUnit(CPackage parent, String file, CompilationUnit astNode) {
        super(null, parent, file, 0);
        this.astNode = astNode;
    }

    public String getQualifiedName() {
        return this.getParent().getQualifiedName();
    }

    public CPackage getPackage() {
        return (CPackage)this.getParent();
    }

    public int numTypes() {
        return this.types.size();
    }

    public CClassType getType(int i) {
        return (CClassType)this.types.get(i);
    }

    void addType(CClassType type) {
        this.types.add(type);
    }

    public void addImportedPackage(CScope type) {
        if (this.importedPackages == null) {
            this.importedPackages = new ArrayList();
        }
        this.importedPackages.add(type);
    }

    public void addImportedType(CClassType type) {
        if (this.importedTypes == null) {
            this.importedTypes = new ArrayList();
        }
        this.importedTypes.add(type);
    }

    public void removeImportedType(CClassType type) {
        this.removeElement(this.importedTypes, type);
    }

    CClassType lookupDeclaredType(String name) {
        return (CClassType)this.lookupElement(this.types, name);
    }

    CClassType lookupType(String name) {
        CPackage pkg;
        CClassType cl;
        int i = 0;
        while (i < this.types.size()) {
            cl = (CClassType)this.types.get(i);
            if (cl.getName().equals(name)) {
                return cl;
            }
            ++i;
        }
        if (this.importedTypes != null) {
            int i2 = 0;
            while (i2 < this.importedTypes.size()) {
                cl = (CClassType)this.importedTypes.get(i2);
                if (cl.getName().equals(name)) {
                    return cl;
                }
                ++i2;
            }
        }
        if ((cl = (pkg = (CPackage)this.getParent()).lookupType(name)) != null) {
            return cl;
        }
        if (this.importedPackages != null) {
            int i3 = 0;
            while (i3 < this.importedPackages.size()) {
                CScope sc = (CScope)this.importedPackages.get(i3);
                cl = sc.lookupType(name);
                if (cl != null) {
                    return cl;
                }
                ++i3;
            }
        }
        return null;
    }

    public CClassType loadType(String name) {
        CClassType cl = ((CPackage)this.getParent()).loadType(name);
        if (cl != null) {
            return cl;
        }
        if (this.importedPackages != null) {
            int i = 0;
            while (i < this.importedPackages.size()) {
                Object imp = this.importedPackages.get(i);
                if (imp instanceof CPackage && (cl = ((CPackage)imp).loadType(name)) != null) {
                    return cl;
                }
                ++i;
            }
        }
        return null;
    }

    public void report(IndentingPrintWriter out) {
        out.println("CompilationUnit: " + this.getName() + " #" + this.getAST().id());
        this.listIndentedElements(out, "Import on demand:", this.importedPackages);
        this.listIndentedElements(out, "Import single type:", this.importedTypes);
        this.reportIndentedElements(out, "Defined types:", this.types);
    }

    public void accept(CVisitor visitor) {
        visitor.visitCompilationUnit(this);
    }

    public void traverse(CVisitor visitor) {
        int i = 0;
        while (i < this.numTypes()) {
            this.getType(i).action(visitor);
            ++i;
        }
    }
}

