/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.symbol;

import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.ast.AstTypeReference;
import com.togethersoft.sca.internal.jparser.ast.AstVector;
import com.togethersoft.sca.internal.jparser.ast.Expr;
import com.togethersoft.sca.internal.jparser.ast.PackageDeclaration;
import com.togethersoft.sca.internal.jparser.ast.TypeDeclaration;
import com.togethersoft.sca.internal.jparser.symbol.CMethod;
import com.togethersoft.sca.internal.jparser.symbol.CPackage;
import com.togethersoft.sca.internal.jparser.symbol.CReferenceType;
import com.togethersoft.sca.internal.jparser.symbol.CScope;
import com.togethersoft.sca.internal.jparser.symbol.CType;
import com.togethersoft.sca.internal.jparser.symbol.CVisitor;
import com.togethersoft.sca.internal.jparser.symbol.IndentingPrintWriter;
import com.togethersoft.sca.internal.jparser.symbol.MethodSet;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class CClassType
extends CReferenceType {
    private CPackage ownerPackage;
    private CClassType outermostType;
    private String scopedName;
    private String externalName;
    private ArrayList ctors = new ArrayList();
    private int processing = 0;
    private static final int ST_PROCESSING = 1;
    private static final int ST_RESOLVED = 2;
    private static final int ST_COMPLETE = 4;
    private static final int ST_NESTED = 8;
    private boolean loadedFromSourceFile = false;
    private int anonymousId = 0;
    transient HashSet dependents = new HashSet();
    transient HashSet dependsOn = new HashSet();

    CClassType(CPackage ownerPackage, CClassType outermostType, CClassType ownerType, CScope parent, String name, String scopedName, int modifiers, TypeDeclaration astNode) {
        super(ownerType, parent, name, modifiers);
        this.ownerPackage = ownerPackage;
        this.outermostType = outermostType;
        this.astNode = astNode;
    }

    public int getKind() {
        return this.isInterface() ? 12 : 11;
    }

    public boolean hasSourceFile() {
        return this.loadedFromSourceFile;
    }

    public AstType getBaseType() {
        return (AstType)((Object)this.astNode);
    }

    public AstTypeReference getExternalType() {
        return (AstTypeReference)((Object)this.getAST());
    }

    void setSourceFile() {
        this.loadedFromSourceFile = true;
    }

    public String getScopedClassName() {
        if (this.scopedName == null) {
            this.scopedName = super.getScopedClassName();
        }
        return this.scopedName;
    }

    public String getQualifiedName() {
        if (this.qualifiedName == null) {
            if (this.scopedName != null) {
                String pkgName = this.ownerPackage.getQualifiedName();
                this.qualifiedName = pkgName != null && pkgName.length() > 0 ? pkgName + "/" + this.scopedName : this.scopedName;
            } else {
                return super.getQualifiedName();
            }
        }
        return this.qualifiedName;
    }

    String getExternalName() {
        if (this.externalName == null) {
            String parentName;
            if (this.parent != null && (parentName = this.parent.getQualifiedName()) != null && parentName.length() > 0) {
                this.externalName = this.parent instanceof CPackage ? parentName + "/" + this.name : parentName + "$" + this.name;
                return this.externalName;
            }
            this.externalName = this.name;
        }
        return this.externalName;
    }

    public void addDependence(CClassType cls) {
        CClassType server = this.getOutermostType();
        CClassType client = cls.getOutermostType();
        if (client != server) {
            server.dependents.add(client);
            client.dependsOn.add(server);
        }
    }

    public Collection getExportCouplings() {
        return this.dependents;
    }

    public Collection getImportCouplings() {
        return this.dependsOn;
    }

    public void removeDependencies() {
        Iterator i = this.dependsOn.iterator();
        while (i.hasNext()) {
            CClassType server = (CClassType)i.next();
            server.dependents.remove(this);
        }
        i = this.dependents.iterator();
        while (i.hasNext()) {
            CClassType client = (CClassType)i.next();
            client.dependsOn.remove(this);
        }
        if (this.getSuperClass() != null) {
            this.getSuperClass().removeSubclass(this);
        }
        if (this.superIfaces != null) {
            i = ((AbstractList)this.superIfaces).iterator();
            while (i.hasNext()) {
                ((CClassType)i.next()).removeSubclass(this);
            }
        }
    }

    public void updateDependencies(CClassType oldType) {
        this.dependents = oldType.dependents;
        Iterator i = oldType.dependents.iterator();
        while (i.hasNext()) {
            CClassType client = (CClassType)i.next();
            client.dependsOn.add(this);
        }
    }

    public CPackage getPackage() {
        return this.ownerPackage;
    }

    CClassType getOutermostType() {
        return this.outermostType;
    }

    void setOutermostType(CClassType outermostType) {
        this.outermostType = outermostType;
    }

    public CClassType getInnermostType() {
        return this;
    }

    private boolean isNested() {
        return this.getOutermostType() != this;
    }

    public boolean isClass() {
        return !this.isInterface();
    }

    public boolean isInterface() {
        return this.getAccess().ACC_INTERFACE();
    }

    protected String buildSignature() {
        return "L" + this.getQualifiedName() + ";";
    }

    private int numConstructors() {
        return this.ctors.size();
    }

    private CMethod getConstructor(int i) {
        return (CMethod)this.ctors.get(i);
    }

    void addConstructor(CMethod ctor) {
        this.ctors.add(ctor);
    }

    CMethod lookupDefaultConstructor(CClassType from) {
        int i = 0;
        while (i < this.numConstructors()) {
            CMethod ctor = this.getConstructor(i);
            if (ctor.numFormalParameters() == 0) {
                return ctor.isAccessible(from, null) ? ctor : null;
            }
            ++i;
        }
        return null;
    }

    MethodSet lookupConstructor(CClassType from, AstVector parms) {
        MethodSet set = new MethodSet();
        int numParms = parms != null ? parms.size() : 0;
        int i = 0;
        while (i < this.numConstructors()) {
            CMethod ctor = this.getConstructor(i);
            if (ctor.isPending()) {
                ctor.process();
            }
            if (ctor.numFormalParameters() == numParms) {
                boolean applicable;
                if (!ctor.isAccessible(from, null)) {
                    applicable = false;
                } else {
                    applicable = true;
                    int j = 0;
                    while (j < numParms) {
                        CType formalType = ctor.getFormalParameter(j).getType();
                        CType actualType = ((Expr)parms.at(j)).type();
                        if (!actualType.isAssignableToMethodParam(formalType)) {
                            applicable = false;
                            break;
                        }
                        ++j;
                    }
                }
                if (applicable) {
                    set.put(ctor);
                }
            }
            ++i;
        }
        return set;
    }

    void addType(CClassType type) {
        this.stable.addType(type);
    }

    public Collection getTypes() {
        return this.stable.getTypes();
    }

    public CClassType lookupTypeWithoutInheritance(String name) {
        return this.stable.lookupType(name);
    }

    public CClassType lookupType(String name) {
        CClassType clazz = this.stable.lookupType(name);
        if (clazz != null) {
            return clazz;
        }
        if (this.getSuperClass() != null && (clazz = this.getSuperClass().lookupType(name)) != null) {
            return clazz;
        }
        int i = 0;
        while (i < this.numInterfaces()) {
            clazz = this.getInterface(i).lookupType(name);
            if (clazz != null) {
                return clazz;
            }
            ++i;
        }
        return null;
    }

    CClassType loadType(String name) {
        return this.getTopScope().loadTypeFromClassFile((PackageDeclaration)this.ownerPackage.astNode, this, name);
    }

    void markSuperProcessing() {
        this.processing |= 1;
    }

    void unmarkSuperProcessing() {
        this.processing &= 0xFFFFFFFE;
    }

    boolean isSuperProcessing() {
        return (this.processing & 1) != 0;
    }

    void markSuperResolved() {
        this.processing |= 2;
    }

    boolean isSuperResolved() {
        return (this.processing & 2) != 0;
    }

    void markSuperComplete() {
        this.processing |= 4;
    }

    boolean isSuperComplete() {
        return (this.processing & 4) != 0;
    }

    void markNestedPending() {
        this.processing |= 8;
    }

    boolean isNestedPending() {
        return (this.processing & 8) != 0;
    }

    int getAnonymousId() {
        return ++this.anonymousId;
    }

    boolean isMemberInnerClass() {
        return this.getParent() instanceof CClassType && !this.isStatic() && this.isClass();
    }

    boolean isAccessible(CPackage from) {
        if (this.isPublic()) {
            return true;
        }
        if (!this.isNested()) {
            return this.getPackage() == from;
        }
        if (this.isPrivate()) {
            return false;
        }
        return this.getPackage() == from;
    }

    boolean isAssignableTo(CType type) {
        if (type.isBad()) {
            return false;
        }
        if (this == type) {
            return true;
        }
        if (type.isPrimitive()) {
            return false;
        }
        if ("java/lang/Object".equals(type.getQualifiedName())) {
            return true;
        }
        if (type.isClass() || type.isInterface()) {
            return this.descendsFrom((CClassType)type);
        }
        return false;
    }

    public void report(IndentingPrintWriter out) {
        if (!out.showBinaryTypes() && !this.hasSourceFile()) {
            return;
        }
        out.print(this.getQualifiedName());
        if (this.isInterface()) {
            out.print(" (Interface)");
        } else {
            out.print(" (Class)");
        }
        out.println(" #" + this.getAST().id());
        out.println(this.getDef());
        out.indent();
        this.listReferences(out);
        if (this.getSuperClass() != null) {
            out.println("Superclass: " + this.getSuperClass().getQualifiedName());
        }
        if (this.numInterfaces() > 0) {
            if (this.isInterface()) {
                out.print("Superinterfaces: ");
            } else {
                out.println("Implemented interfaces: ");
            }
            int i = 0;
            while (i < this.numInterfaces()) {
                out.print(this.getInterface(i).getQualifiedName() + " ");
                ++i;
            }
            out.println();
        }
        this.listIndentedElements(out, "Dependent types:", this.dependents);
        this.reportIndentedElements(out, "Nested types:", this.stable.getTypes());
        this.reportIndentedElements(out, "Constructors:", this.ctors);
        this.reportIndentedElements(out, "Fields:", this.stable.getVariables());
        this.reportIndentedElements(out, "Methods:", this.methods);
        out.dedent();
    }

    public void accept(CVisitor visitor) {
        visitor.visitClassType(this);
    }

    public void traverse(CVisitor visitor) {
        super.traverse(visitor);
        int i = 0;
        while (i < this.numConstructors()) {
            this.getConstructor(i).action(visitor);
            ++i;
        }
    }
}

