/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.symbol;

import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.internal.jparser.ast.Ast;
import com.togethersoft.sca.internal.jparser.ast.Declaration;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.Modifiers;
import com.togethersoft.sca.internal.jparser.ast.VariableDeclaration;
import com.togethersoft.sca.internal.jparser.ast.VariableDeclarator;
import com.togethersoft.sca.internal.jparser.symbol.CClassType;
import com.togethersoft.sca.internal.jparser.symbol.CReferenceType;
import com.togethersoft.sca.internal.jparser.symbol.CTopLevel;
import com.togethersoft.sca.internal.jparser.symbol.CType;
import com.togethersoft.sca.internal.jparser.symbol.CVariable;
import com.togethersoft.sca.internal.jparser.symbol.CVisitor;
import com.togethersoft.sca.internal.jparser.symbol.IndentingPrintWriter;

public class CArrayType
extends CReferenceType {
    CType elementType;
    private static final JavaToken lengthToken = new JavaToken("length");

    CArrayType(CTopLevel context, CType elementType) {
        super(null, null, null, 17);
        this.elementType = elementType;
        CVariable length = new CVariable(null, this, "length", 17, null);
        length.setType(context.intType);
        this.addVariable(length);
        VariableDeclaration decl = new VariableDeclaration(new Modifiers(17), null);
        VariableDeclarator lengthAst = new VariableDeclarator(decl, lengthToken, null, null, null);
        decl.setDeclarators(lengthAst);
        lengthAst.symbol = length;
        length.astNode = lengthAst;
        this.setSuperClass(context.objectType);
        this.addInterface(context.cloneableType);
        this.addInterface(context.serializableType);
    }

    public int getKind() {
        return this.elementType.getKind();
    }

    public boolean isArray() {
        return true;
    }

    public int numDimensions() {
        return this.elementType.numDimensions() + 1;
    }

    public CType getElementType() {
        return this.elementType;
    }

    public String getQualifiedName() {
        if (this.qualifiedName == null) {
            this.qualifiedName = this.elementType.getQualifiedName() + "[]";
        }
        return this.qualifiedName;
    }

    protected String buildSignature() {
        return "[" + this.getElementType().getSignature();
    }

    public AstType getBaseType() {
        return this.getElementType().getBaseType();
    }

    public void addReference(Ast from) {
        this.getElementType().addReference(from);
    }

    public Declaration getAST() {
        return this.getElementType().getAST();
    }

    boolean isAccessible(CClassType from, CType base) {
        return this.elementType.isAccessible(from, base);
    }

    boolean isAssignableTo(CType type) {
        if (type.isClass() || type.isInterface()) {
            return this.descendsFrom((CClassType)type);
        }
        if (type.isArray()) {
            if (this.getElementType().isPrimitive()) {
                return this.getElementType() == ((CArrayType)type).getElementType();
            }
            return this.getElementType().isAssignableTo(((CArrayType)type).getElementType());
        }
        return false;
    }

    public void report(IndentingPrintWriter out) {
    }

    public void accept(CVisitor visitor) {
        visitor.visitArrayType(this);
    }

    public void traverse(CVisitor visitor) {
        super.traverse(visitor);
    }
}

