/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.symbol;

import com.togethersoft.sca.internal.jparser.ast.Modifier;
import com.togethersoft.sca.internal.jparser.ast.Modifiers;
import com.togethersoft.sca.internal.jparser.symbol.Constants;
import com.togethersoft.sca.internal.jparser.symbol.ErrorMgr;
import java.io.Serializable;

public class CAccessMods
implements Constants,
Serializable {
    private int mods;

    CAccessMods() {
        this.mods = 0;
    }

    CAccessMods(int mods) {
        this.mods = mods;
    }

    void processClassModifiers(Modifiers mods) {
        if (mods != null) {
            int i = 0;
            while (i < mods.numModifiers()) {
                Modifier m = mods.modifier(i);
                switch (m.kind()) {
                    case 1024: {
                        if (this.ACC_ABSTRACT()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                        } else {
                            this.setACC_ABSTRACT();
                        }
                        if (!this.ACC_FINAL()) break;
                        ErrorMgr.report(13, m.leftToken(), m.rightToken(), m.leftToken().getText());
                        break;
                    }
                    case 16: {
                        if (this.ACC_FINAL()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                        } else {
                            this.setACC_FINAL();
                        }
                        if (!this.ACC_ABSTRACT()) break;
                        ErrorMgr.report(13, m.leftToken(), m.rightToken(), m.leftToken().getText());
                        break;
                    }
                    case 1: {
                        if (this.ACC_PUBLIC()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                            break;
                        }
                        this.setACC_PUBLIC();
                        break;
                    }
                    case 2048: {
                        if (this.ACC_STRICTFP()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                            break;
                        }
                        this.setACC_STRICTFP();
                        break;
                    }
                    default: {
                        ErrorMgr.report(12, m.leftToken(), m.rightToken(), m.leftToken().getText());
                    }
                }
                ++i;
            }
        }
    }

    void processLocalClassModifiers(Modifiers mods) {
        if (mods != null) {
            int i = 0;
            while (i < mods.numModifiers()) {
                Modifier m = mods.modifier(i);
                switch (m.kind()) {
                    case 1024: {
                        if (this.ACC_ABSTRACT()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                        } else {
                            this.setACC_ABSTRACT();
                        }
                        if (!this.ACC_FINAL()) break;
                        ErrorMgr.report(13, m.leftToken(), m.rightToken(), m.leftToken().getText());
                        break;
                    }
                    case 16: {
                        if (this.ACC_FINAL()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                        } else {
                            this.setACC_FINAL();
                        }
                        if (!this.ACC_ABSTRACT()) break;
                        ErrorMgr.report(13, m.leftToken(), m.rightToken(), m.leftToken().getText());
                        break;
                    }
                    case 2048: {
                        if (this.ACC_STRICTFP()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                            break;
                        }
                        this.setACC_STRICTFP();
                        break;
                    }
                    default: {
                        ErrorMgr.report(12, m.leftToken(), m.rightToken(), m.leftToken().getText());
                    }
                }
                ++i;
            }
        }
    }

    void processNestedClassModifiers(Modifiers mods) {
        if (mods != null) {
            int i = 0;
            while (i < mods.numModifiers()) {
                Modifier m = mods.modifier(i);
                switch (m.kind()) {
                    case 1024: {
                        if (this.ACC_ABSTRACT()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                        } else {
                            this.setACC_ABSTRACT();
                        }
                        if (!this.ACC_FINAL()) break;
                        ErrorMgr.report(13, m.leftToken(), m.rightToken(), m.leftToken().getText());
                        break;
                    }
                    case 16: {
                        if (this.ACC_FINAL()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                        } else {
                            this.setACC_FINAL();
                        }
                        if (!this.ACC_ABSTRACT()) break;
                        ErrorMgr.report(13, m.leftToken(), m.rightToken(), m.leftToken().getText());
                        break;
                    }
                    case 1: {
                        if (this.ACC_PUBLIC() || this.ACC_PROTECTED() || this.ACC_PRIVATE()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                            break;
                        }
                        this.setACC_PUBLIC();
                        break;
                    }
                    case 4: {
                        if (this.ACC_PUBLIC() || this.ACC_PROTECTED() || this.ACC_PRIVATE()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                            break;
                        }
                        this.setACC_PROTECTED();
                        break;
                    }
                    case 2: {
                        if (this.ACC_PUBLIC() || this.ACC_PROTECTED() || this.ACC_PRIVATE()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                            break;
                        }
                        this.setACC_PRIVATE();
                        break;
                    }
                    case 8: {
                        if (this.ACC_STATIC()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                            break;
                        }
                        this.setACC_STATIC();
                        break;
                    }
                    case 2048: {
                        if (this.ACC_STRICTFP()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                            break;
                        }
                        this.setACC_STRICTFP();
                        break;
                    }
                    default: {
                        ErrorMgr.report(12, m.leftToken(), m.rightToken(), m.leftToken().getText());
                    }
                }
                ++i;
            }
        }
    }

    void processStaticNestedClassModifiers(Modifiers mods) {
        if (mods != null) {
            int i = 0;
            while (i < mods.numModifiers()) {
                Modifier m = mods.modifier(i);
                switch (m.kind()) {
                    case 1024: {
                        if (this.ACC_ABSTRACT()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                        } else {
                            this.setACC_ABSTRACT();
                        }
                        if (!this.ACC_FINAL()) break;
                        ErrorMgr.report(13, m.leftToken(), m.rightToken(), m.leftToken().getText());
                        break;
                    }
                    case 16: {
                        if (this.ACC_FINAL()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                        } else {
                            this.setACC_FINAL();
                        }
                        if (!this.ACC_ABSTRACT()) break;
                        ErrorMgr.report(13, m.leftToken(), m.rightToken(), m.leftToken().getText());
                        break;
                    }
                    case 1: {
                        if (this.ACC_PUBLIC()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                            break;
                        }
                        this.setACC_PUBLIC();
                        break;
                    }
                    case 8: {
                        if (this.ACC_STATIC()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                            break;
                        }
                        this.setACC_STATIC();
                        break;
                    }
                    case 2048: {
                        if (this.ACC_STRICTFP()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                            break;
                        }
                        this.setACC_STRICTFP();
                        break;
                    }
                    default: {
                        ErrorMgr.report(12, m.leftToken(), m.rightToken(), m.leftToken().getText());
                    }
                }
                ++i;
            }
        }
        this.setACC_STATIC();
        this.setACC_PUBLIC();
    }

    void processInterfaceModifiers(Modifiers mods) {
        if (mods != null) {
            int i = 0;
            while (i < mods.numModifiers()) {
                Modifier m = mods.modifier(i);
                switch (m.kind()) {
                    case 1024: {
                        if (this.ACC_ABSTRACT()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                        } else {
                            this.setACC_ABSTRACT();
                        }
                        if (!this.ACC_FINAL()) break;
                        ErrorMgr.report(13, m.leftToken(), m.rightToken(), m.leftToken().getText());
                        break;
                    }
                    case 1: {
                        if (this.ACC_PUBLIC()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                            break;
                        }
                        this.setACC_PUBLIC();
                        break;
                    }
                    case 2048: {
                        if (this.ACC_STRICTFP()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                            break;
                        }
                        this.setACC_STRICTFP();
                        break;
                    }
                    default: {
                        ErrorMgr.report(12, m.leftToken(), m.rightToken(), m.leftToken().getText());
                    }
                }
                ++i;
            }
        }
        this.setACC_INTERFACE();
        this.setACC_ABSTRACT();
    }

    void processStaticInterfaceModifiers(Modifiers mods) {
        if (mods != null) {
            int i = 0;
            while (i < mods.numModifiers()) {
                Modifier m = mods.modifier(i);
                switch (m.kind()) {
                    case 1024: {
                        if (this.ACC_ABSTRACT()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                        } else {
                            this.setACC_ABSTRACT();
                        }
                        if (!this.ACC_FINAL()) break;
                        ErrorMgr.report(13, m.leftToken(), m.rightToken(), m.leftToken().getText());
                        break;
                    }
                    case 1: {
                        if (this.ACC_PUBLIC()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                            break;
                        }
                        this.setACC_PUBLIC();
                        break;
                    }
                    case 8: {
                        if (this.ACC_STATIC()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                            break;
                        }
                        this.setACC_STATIC();
                        break;
                    }
                    case 2048: {
                        if (this.ACC_STRICTFP()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                            break;
                        }
                        this.setACC_STRICTFP();
                        break;
                    }
                    default: {
                        ErrorMgr.report(12, m.leftToken(), m.rightToken(), m.leftToken().getText());
                    }
                }
                ++i;
            }
        }
        this.setACC_INTERFACE();
        this.setACC_ABSTRACT();
        this.setACC_STATIC();
        this.setACC_PUBLIC();
    }

    void processNestedInterfaceModifiers(Modifiers mods) {
        if (mods != null) {
            int i = 0;
            while (i < mods.numModifiers()) {
                Modifier m = mods.modifier(i);
                switch (m.kind()) {
                    case 1024: {
                        if (this.ACC_ABSTRACT()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                        } else {
                            this.setACC_ABSTRACT();
                        }
                        if (!this.ACC_FINAL()) break;
                        ErrorMgr.report(13, m.leftToken(), m.rightToken(), m.leftToken().getText());
                        break;
                    }
                    case 1: {
                        if (this.ACC_PUBLIC() || this.ACC_PROTECTED() || this.ACC_PRIVATE()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                            break;
                        }
                        this.setACC_PUBLIC();
                        break;
                    }
                    case 4: {
                        if (this.ACC_PUBLIC() || this.ACC_PROTECTED() || this.ACC_PRIVATE()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                            break;
                        }
                        this.setACC_PROTECTED();
                        break;
                    }
                    case 2: {
                        if (this.ACC_PUBLIC() || this.ACC_PROTECTED() || this.ACC_PRIVATE()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                            break;
                        }
                        this.setACC_PRIVATE();
                        break;
                    }
                    case 8: {
                        if (this.ACC_STATIC()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                            break;
                        }
                        this.setACC_STATIC();
                        break;
                    }
                    case 2048: {
                        if (this.ACC_STRICTFP()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                            break;
                        }
                        this.setACC_STRICTFP();
                        break;
                    }
                    default: {
                        ErrorMgr.report(12, m.leftToken(), m.rightToken(), m.leftToken().getText());
                    }
                }
                ++i;
            }
        }
        this.setACC_INTERFACE();
        this.setACC_ABSTRACT();
        this.setACC_STATIC();
    }

    void processFieldModifiers(Modifiers mods) {
        if (mods != null) {
            int i = 0;
            while (i < mods.numModifiers()) {
                Modifier m = mods.modifier(i);
                switch (m.kind()) {
                    case 1: {
                        if (this.ACC_PUBLIC() || this.ACC_PROTECTED() || this.ACC_PRIVATE()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                            break;
                        }
                        this.setACC_PUBLIC();
                        break;
                    }
                    case 4: {
                        if (this.ACC_PUBLIC() || this.ACC_PROTECTED() || this.ACC_PRIVATE()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                            break;
                        }
                        this.setACC_PROTECTED();
                        break;
                    }
                    case 2: {
                        if (this.ACC_PUBLIC() || this.ACC_PROTECTED() || this.ACC_PRIVATE()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                            break;
                        }
                        this.setACC_PRIVATE();
                        break;
                    }
                    case 8: {
                        if (this.ACC_STATIC()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                            break;
                        }
                        this.setACC_STATIC();
                        break;
                    }
                    case 16: {
                        if (this.ACC_FINAL()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                        } else {
                            this.setACC_FINAL();
                        }
                        if (!this.ACC_VOLATILE()) break;
                        ErrorMgr.report(14, m.leftToken(), m.rightToken(), m.leftToken().getText());
                        break;
                    }
                    case 128: {
                        if (this.ACC_TRANSIENT()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                            break;
                        }
                        this.setACC_TRANSIENT();
                        break;
                    }
                    case 64: {
                        if (this.ACC_VOLATILE()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                        } else {
                            this.setACC_VOLATILE();
                        }
                        if (!this.ACC_FINAL()) break;
                        ErrorMgr.report(14, m.leftToken(), m.rightToken(), m.leftToken().getText());
                        break;
                    }
                    default: {
                        ErrorMgr.report(12, m.leftToken(), m.rightToken(), m.leftToken().getText());
                    }
                }
                ++i;
            }
        }
    }

    void processLocalModifiers(Modifiers mods) {
        if (mods != null) {
            int i = 0;
            while (i < mods.numModifiers()) {
                Modifier m = mods.modifier(i);
                if (m.kind() == 16) {
                    if (this.ACC_FINAL()) {
                        ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                    } else {
                        this.setACC_FINAL();
                    }
                } else {
                    ErrorMgr.report(12, m.leftToken(), m.rightToken(), m.leftToken().getText());
                }
                ++i;
            }
        }
    }

    void processFormalModifiers(Modifiers mods) {
        if (mods != null) {
            int i = 0;
            while (i < mods.numModifiers()) {
                Modifier m = mods.modifier(i);
                if (m.kind() == 16) {
                    if (this.ACC_FINAL()) {
                        ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                    } else {
                        this.setACC_STRICTFP();
                    }
                } else {
                    ErrorMgr.report(12, m.leftToken(), m.rightToken(), m.leftToken().getText());
                }
                ++i;
            }
        }
    }

    void processMethodModifiers(Modifiers mods) {
        if (mods != null) {
            int i = 0;
            while (i < mods.numModifiers()) {
                Modifier m = mods.modifier(i);
                switch (m.kind()) {
                    case 1: {
                        if (this.ACC_PUBLIC() || this.ACC_PROTECTED() || this.ACC_PRIVATE()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                            break;
                        }
                        this.setACC_PUBLIC();
                        break;
                    }
                    case 4: {
                        if (this.ACC_PUBLIC() || this.ACC_PROTECTED() || this.ACC_PRIVATE()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                            break;
                        }
                        this.setACC_PROTECTED();
                        break;
                    }
                    case 2: {
                        if (this.ACC_PUBLIC() || this.ACC_PROTECTED() || this.ACC_PRIVATE()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                        } else {
                            this.setACC_PRIVATE();
                        }
                        if (!this.ACC_ABSTRACT()) break;
                        ErrorMgr.report(15, m.leftToken(), m.rightToken(), m.leftToken().getText());
                        break;
                    }
                    case 8: {
                        if (this.ACC_STATIC()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                        } else {
                            this.setACC_STATIC();
                        }
                        if (!this.ACC_ABSTRACT()) break;
                        ErrorMgr.report(15, m.leftToken(), m.rightToken(), m.leftToken().getText());
                        break;
                    }
                    case 2048: {
                        if (this.ACC_STRICTFP()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                            break;
                        }
                        this.setACC_STRICTFP();
                        break;
                    }
                    case 1024: {
                        if (this.ACC_ABSTRACT()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                        } else {
                            this.setACC_ABSTRACT();
                        }
                        if (!this.ACC_PRIVATE() && !this.ACC_STATIC() && !this.ACC_FINAL() && !this.ACC_NATIVE() && !this.ACC_SYNCHRONIZED()) break;
                        ErrorMgr.report(15, m.leftToken(), m.rightToken(), null);
                        break;
                    }
                    case 16: {
                        if (this.ACC_FINAL()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                        } else {
                            this.setACC_FINAL();
                        }
                        if (!this.ACC_ABSTRACT()) break;
                        ErrorMgr.report(15, m.leftToken(), m.rightToken(), m.leftToken().getText());
                        break;
                    }
                    case 256: {
                        if (this.ACC_NATIVE()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                        } else {
                            this.setACC_NATIVE();
                        }
                        if (!this.ACC_ABSTRACT()) break;
                        ErrorMgr.report(15, m.leftToken(), m.rightToken(), m.leftToken().getText());
                        break;
                    }
                    case 32: {
                        if (this.ACC_SYNCHRONIZED()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                        } else {
                            this.setACC_SYNCHRONIZED();
                        }
                        if (!this.ACC_ABSTRACT()) break;
                        ErrorMgr.report(15, m.leftToken(), m.rightToken(), m.leftToken().getText());
                        break;
                    }
                    default: {
                        ErrorMgr.report(12, m.leftToken(), m.rightToken(), m.leftToken().getText());
                    }
                }
                ++i;
            }
        }
    }

    void processInterfaceMethodModifiers(Modifiers mods) {
        if (mods != null) {
            int i = 0;
            while (i < mods.numModifiers()) {
                Modifier m = mods.modifier(i);
                switch (m.kind()) {
                    case 1: {
                        if (this.ACC_PUBLIC()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                            break;
                        }
                        this.setACC_PUBLIC();
                        break;
                    }
                    case 1024: {
                        if (this.ACC_ABSTRACT()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                            break;
                        }
                        this.setACC_ABSTRACT();
                        break;
                    }
                    default: {
                        ErrorMgr.report(12, m.leftToken(), m.rightToken(), m.leftToken().getText());
                    }
                }
                ++i;
            }
        }
        this.setACC_PUBLIC();
        this.setACC_ABSTRACT();
    }

    void processConstructorModifiers(Modifiers mods) {
        if (mods != null) {
            int i = 0;
            while (i < mods.numModifiers()) {
                Modifier m = mods.modifier(i);
                switch (m.kind()) {
                    case 1: {
                        if (this.ACC_PUBLIC() || this.ACC_PROTECTED() || this.ACC_PRIVATE()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                            break;
                        }
                        this.setACC_PUBLIC();
                        break;
                    }
                    case 4: {
                        if (this.ACC_PUBLIC() || this.ACC_PROTECTED() || this.ACC_PRIVATE()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                            break;
                        }
                        this.setACC_PROTECTED();
                        break;
                    }
                    case 2: {
                        if (this.ACC_PUBLIC() || this.ACC_PROTECTED() || this.ACC_PRIVATE()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                            break;
                        }
                        this.setACC_PRIVATE();
                        break;
                    }
                    default: {
                        ErrorMgr.report(12, m.leftToken(), m.rightToken(), m.leftToken().getText());
                    }
                }
                ++i;
            }
        }
    }

    void processConstantModifiers(Modifiers mods) {
        if (mods != null) {
            int i = 0;
            while (i < mods.numModifiers()) {
                Modifier m = mods.modifier(i);
                switch (m.kind()) {
                    case 1: {
                        if (this.ACC_PUBLIC()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                            break;
                        }
                        this.setACC_PUBLIC();
                        break;
                    }
                    case 8: {
                        if (this.ACC_STATIC()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                            break;
                        }
                        this.setACC_STATIC();
                        break;
                    }
                    case 16: {
                        if (this.ACC_FINAL()) {
                            ErrorMgr.report(11, m.leftToken(), m.rightToken(), m.leftToken().getText());
                            break;
                        }
                        this.setACC_FINAL();
                        break;
                    }
                    default: {
                        ErrorMgr.report(12, m.leftToken(), m.rightToken(), m.leftToken().getText());
                    }
                }
                ++i;
            }
        }
        this.setACC_PUBLIC();
        this.setACC_STATIC();
        this.setACC_FINAL();
    }

    public int getModifiers() {
        return this.mods;
    }

    boolean ACC_PUBLIC() {
        return (this.mods & 1) == 1;
    }

    boolean ACC_PROTECTED() {
        return (this.mods & 4) == 4;
    }

    boolean ACC_PRIVATE() {
        return (this.mods & 2) == 2;
    }

    boolean ACC_INTERFACE() {
        return (this.mods & 0x200) == 512;
    }

    boolean ACC_ABSTRACT() {
        return (this.mods & 0x400) == 1024;
    }

    boolean ACC_STATIC() {
        return (this.mods & 8) == 8;
    }

    boolean ACC_FINAL() {
        return (this.mods & 0x10) == 16;
    }

    boolean ACC_SYNCHRONIZED() {
        return (this.mods & 0x20) == 32;
    }

    boolean ACC_TRANSIENT() {
        return (this.mods & 0x80) == 128;
    }

    boolean ACC_VOLATILE() {
        return (this.mods & 0x40) == 64;
    }

    boolean ACC_NATIVE() {
        return (this.mods & 0x100) == 256;
    }

    boolean ACC_STRICTFP() {
        return (this.mods & 0x800) == 2048;
    }

    void setACC_PUBLIC() {
        this.mods |= 1;
    }

    void setACC_PROTECTED() {
        this.mods |= 4;
    }

    void setACC_PRIVATE() {
        this.mods |= 2;
    }

    void setACC_INTERFACE() {
        this.mods |= 0x200;
    }

    void setACC_ABSTRACT() {
        this.mods |= 0x400;
    }

    void setACC_STATIC() {
        this.mods |= 8;
    }

    void setACC_FINAL() {
        this.mods |= 0x10;
    }

    void setACC_SYNCHRONIZED() {
        this.mods |= 0x20;
    }

    void setACC_TRANSIENT() {
        this.mods |= 0x80;
    }

    void setACC_VOLATILE() {
        this.mods |= 0x40;
    }

    void setACC_NATIVE() {
        this.mods |= 0x100;
    }

    void setACC_STRICTFP() {
        this.mods |= 0x800;
    }

    void clearACC_PUBLIC() {
        this.mods &= 0xFFFFFFFE;
    }

    void clearACC_PROTECTED() {
        this.mods &= 0xFFFFFFFB;
    }

    void clearACC_PRIVATE() {
        this.mods &= 0xFFFFFFFD;
    }

    void clearACC_INTERFACE() {
        this.mods &= 0xFFFFFDFF;
    }

    void clearACC_ABSTRACT() {
        this.mods &= 0xFFFFFBFF;
    }

    void clearACC_STATIC() {
        this.mods &= 0xFFFFFFF7;
    }

    void clearACC_FINAL() {
        this.mods &= 0xFFFFFFEF;
    }

    void clearACC_SYNCHRONIZED() {
        this.mods &= 0xFFFFFFDF;
    }

    void clearACC_TRANSIENT() {
        this.mods &= 0xFFFFFF7F;
    }

    void clearACC_VOLATILE() {
        this.mods &= 0xFFFFFFBF;
    }

    void clearACC_NATIVE() {
        this.mods &= 0xFFFFFEFF;
    }

    void clearACC_STRICTFP() {
        this.mods &= 0xFFFFF7FF;
    }

    public String toString() {
        String str = "";
        if ((this.mods & 1) == 1) {
            str = str + "public ";
        }
        if ((this.mods & 4) == 4) {
            str = str + "protected ";
        }
        if ((this.mods & 2) == 2) {
            str = str + "private ";
        }
        if ((this.mods & 0x400) == 1024) {
            str = str + "abstract ";
        }
        if ((this.mods & 8) == 8) {
            str = str + "static ";
        }
        if ((this.mods & 0x10) == 16) {
            str = str + "final ";
        }
        if ((this.mods & 0x20) == 32) {
            str = str + "synchronized ";
        }
        if ((this.mods & 0x100) == 256) {
            str = str + "native ";
        }
        if ((this.mods & 0x800) == 2048) {
            str = str + "strictfp ";
        }
        if ((this.mods & 0x80) == 128) {
            str = str + "transient ";
        }
        if ((this.mods & 0x40) == 64) {
            str = str + "volatile ";
        }
        return str;
    }
}

