/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.parser;

import antlr.CharStreamException;
import antlr.NoViableAltForCharException;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.TokenStreamRecognitionException;
import com.togethersoft.sca.internal.jparser.ast.Comment;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.parser.JavaInputStream;
import com.togethersoft.sca.internal.jparser.parser.JavaTokenTypes;
import com.togethersoft.sca.internal.jparser.parser.Keyword;
import java.io.Reader;
import java.util.ArrayList;

public class JavaLexer
implements JavaTokenTypes,
TokenStream {
    private JavaInputStream input;
    private int tabSize;
    private ArrayList comments = new ArrayList();
    private static final String strLCURLY = new String("{");
    private static final String strRCURLY = new String("}");
    private static final String strLPAREN = new String("(");
    private static final String strRPAREN = new String(")");
    private static final String strCOMMA = new String(",");
    private static final String strSEMI = new String(";");
    private static final String strQUESTION = new String("?");
    private static final String strLBRACK = new String("[");
    private static final String strRBRACK = new String("]");
    private static final String strCOLON = new String(":");
    private static final String strBNOT = new String("~");
    private static final String strDOT = new String(".");
    private static final String strEQUAL = new String("==");
    private static final String strASSIGN = new String("=");
    private static final String strINC = new String("++");
    private static final String strPLUS_ASSIGN = new String("+=");
    private static final String strPLUS = new String("+");
    private static final String strDEC = new String("--");
    private static final String strMINUS_ASSIGN = new String("-=");
    private static final String strMINUS = new String("-");
    private static final String strBSR = new String(">>>");
    private static final String strBSR_ASSIGN = new String(">>>=");
    private static final String strSR = new String(">>");
    private static final String strSR_ASSIGN = new String(">>=");
    private static final String strGE = new String(">=");
    private static final String strGT = new String(">");
    private static final String strSL = new String("<<");
    private static final String strSL_ASSIGN = new String("<<=");
    private static final String strLE = new String("<=");
    private static final String strLT = new String("<");
    private static final String strNOT_EQUAL = new String("!=");
    private static final String strLNOT = new String("!");
    private static final String strSTAR_ASSIGN = new String("*=");
    private static final String strSTAR = new String("*");
    private static final String strMOD_ASSIGN = new String("%=");
    private static final String strMOD = new String("%");
    private static final String strBXOR_ASSIGN = new String("^=");
    private static final String strBXOR = new String("^");
    private static final String strBOR_ASSIGN = new String("|=");
    private static final String strLOR = new String("||");
    private static final String strBOR = new String("|");
    private static final String strBAND_ASSIGN = new String("&=");
    private static final String strLAND = new String("&&");
    private static final String strBAND = new String("&");
    private static final String strDIV_ASSIGN = new String("/=");
    private static final String strDIV = new String("/");

    public JavaLexer(String filename, Reader stream, int tabSize, boolean assertEnabled, boolean dbcEnabled) throws CharStreamException {
        this.input = new JavaInputStream(filename, stream, 1);
        this.tabSize = tabSize;
        Keyword.loadTable(assertEnabled, dbcEnabled);
    }

    public String getFilename() {
        return this.input.getFilename();
    }

    private Comment[] getComments() {
        if (this.comments.size() > 0) {
            Comment[] cs = this.comments.toArray(new Comment[this.comments.size()]);
            this.comments.clear();
            return cs;
        }
        return null;
    }

    private JavaToken makeToken(int type) {
        JavaToken token = this.input.makeToken(type);
        token.setComments(this.getComments());
        return token;
    }

    public JavaToken makeToken(int type, String text) {
        JavaToken token = this.input.makeToken(type, text);
        token.setComments(this.getComments());
        return token;
    }

    public void skipBody() throws TokenStreamException {
        int depth = 1;
        do {
            Token token;
            if ((token = this.nextToken()).getType() == 74) {
                ++depth;
                continue;
            }
            if (token.getType() != 75) continue;
            --depth;
        } while (depth != 0);
    }

    private void processSingleComment() throws CharStreamException {
        while (true) {
            switch (this.input.LA(0)) {
                case '\r': {
                    this.comments.add(new Comment(this.input.makeToken(0), false, true));
                    this.input.consume();
                    if (this.input.LA(0) == '\n') {
                        this.input.consume();
                    }
                    this.input.newline();
                    return;
                }
                case '\n': {
                    this.comments.add(new Comment(this.input.makeToken(0), false, true));
                    this.input.consume();
                    this.input.newline();
                    return;
                }
                case '\uffff': {
                    this.comments.add(new Comment(this.input.makeToken(0), false, true));
                    return;
                }
            }
            this.input.consume();
        }
    }

    private void processMultiComment(boolean isJavadoc) throws RecognitionException, CharStreamException {
        block6: while (true) {
            switch (this.input.LA(0)) {
                case '*': {
                    if (this.input.LA(1) == '/') {
                        this.input.consume();
                        this.input.consume();
                        this.comments.add(new Comment(this.input.makeToken(0), isJavadoc, false));
                        return;
                    }
                    this.input.consume();
                    continue block6;
                }
                case '\r': {
                    this.input.consume();
                    if (this.input.LA(0) == '\n') {
                        this.input.consume();
                    }
                    this.input.newline();
                    continue block6;
                }
                case '\n': {
                    this.input.consume();
                    this.input.newline();
                    continue block6;
                }
                case '\uffff': {
                    throw new NoViableAltForCharException('\uffff', this.input.getFilename(), this.input.getLine());
                }
            }
            this.input.consume();
        }
    }

    private void match(char c) throws RecognitionException, CharStreamException {
        if (this.input.LA(0) != c) {
            throw new NoViableAltForCharException(this.input.LA(0), this.input.getFilename(), this.input.getLine());
        }
        this.input.consume();
    }

    private void matchNot(char c) throws RecognitionException, CharStreamException {
        if (this.input.LA(0) == c) {
            throw new NoViableAltForCharException(this.input.LA(0), this.input.getFilename(), this.input.getLine());
        }
        this.input.consume();
    }

    public Token nextToken() throws TokenStreamException {
        try {
            block34: while (true) {
                this.input.resetToken();
                switch (this.input.LA(0)) {
                    case '\uffff': {
                        return this.makeToken(1);
                    }
                    case '?': {
                        this.input.consume();
                        return this.makeToken(112, strQUESTION);
                    }
                    case '(': {
                        this.input.consume();
                        return this.makeToken(78, strLPAREN);
                    }
                    case ')': {
                        this.input.consume();
                        return this.makeToken(79, strRPAREN);
                    }
                    case '[': {
                        this.input.consume();
                        return this.makeToken(48, strLBRACK);
                    }
                    case ']': {
                        this.input.consume();
                        return this.makeToken(49, strRBRACK);
                    }
                    case '{': {
                        this.input.consume();
                        return this.makeToken(74, strLCURLY);
                    }
                    case '}': {
                        this.input.consume();
                        return this.makeToken(75, strRCURLY);
                    }
                    case ':': {
                        this.input.consume();
                        return this.makeToken(84, strCOLON);
                    }
                    case ',': {
                        this.input.consume();
                        return this.makeToken(76, strCOMMA);
                    }
                    case '~': {
                        this.input.consume();
                        return this.makeToken(134, strBNOT);
                    }
                    case ';': {
                        this.input.consume();
                        return this.makeToken(46, strSEMI);
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        this.processWhiteSpace();
                        continue block34;
                    }
                    case '\'': {
                        return this.processCharLiteral();
                    }
                    case '\"': {
                        return this.processStringLiteral();
                    }
                    case '$': 
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'G': 
                    case 'H': 
                    case 'I': 
                    case 'J': 
                    case 'K': 
                    case 'L': 
                    case 'M': 
                    case 'N': 
                    case 'O': 
                    case 'P': 
                    case 'Q': 
                    case 'R': 
                    case 'S': 
                    case 'T': 
                    case 'U': 
                    case 'V': 
                    case 'W': 
                    case 'X': 
                    case 'Y': 
                    case 'Z': 
                    case '_': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': 
                    case 'g': 
                    case 'h': 
                    case 'i': 
                    case 'j': 
                    case 'k': 
                    case 'l': 
                    case 'm': 
                    case 'n': 
                    case 'o': 
                    case 'p': 
                    case 'q': 
                    case 'r': 
                    case 's': 
                    case 't': 
                    case 'u': 
                    case 'v': 
                    case 'w': 
                    case 'x': 
                    case 'y': 
                    case 'z': {
                        return this.processIdentifier();
                    }
                    case '.': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        return this.processNumLiteral();
                    }
                    case '>': {
                        this.input.consume();
                        if (this.input.LA(0) == '>') {
                            this.input.consume();
                            if (this.input.LA(0) == '>') {
                                this.input.consume();
                                if (this.input.LA(0) == '=') {
                                    this.input.consume();
                                    return this.makeToken(107, strBSR_ASSIGN);
                                }
                                return this.makeToken(127, strBSR);
                            }
                            if (this.input.LA(0) == '=') {
                                this.input.consume();
                                return this.makeToken(106, strSR_ASSIGN);
                            }
                            return this.makeToken(126, strSR);
                        }
                        if (this.input.LA(0) == '=') {
                            this.input.consume();
                            return this.makeToken(123, strGE);
                        }
                        return this.makeToken(121, strGT);
                    }
                    case '<': {
                        this.input.consume();
                        if (this.input.LA(0) == '<') {
                            this.input.consume();
                            if (this.input.LA(0) == '=') {
                                this.input.consume();
                                return this.makeToken(108, strSL_ASSIGN);
                            }
                            return this.makeToken(125, strSL);
                        }
                        if (this.input.LA(0) == '=') {
                            this.input.consume();
                            return this.makeToken(122, strLE);
                        }
                        return this.makeToken(120, strLT);
                    }
                    case '=': {
                        this.input.consume();
                        if (this.input.LA(0) == '=') {
                            this.input.consume();
                            return this.makeToken(119, strEQUAL);
                        }
                        return this.makeToken(81, strASSIGN);
                    }
                    case '!': {
                        this.input.consume();
                        if (this.input.LA(0) == '=') {
                            this.input.consume();
                            return this.makeToken(118, strNOT_EQUAL);
                        }
                        return this.makeToken(135, strLNOT);
                    }
                    case '+': {
                        this.input.consume();
                        if (this.input.LA(0) == '+') {
                            this.input.consume();
                            return this.makeToken(132, strINC);
                        }
                        if (this.input.LA(0) == '=') {
                            this.input.consume();
                            return this.makeToken(101, strPLUS_ASSIGN);
                        }
                        return this.makeToken(128, strPLUS);
                    }
                    case '-': {
                        this.input.consume();
                        if (this.input.LA(0) == '-') {
                            this.input.consume();
                            return this.makeToken(133, strDEC);
                        }
                        if (this.input.LA(0) == '=') {
                            this.input.consume();
                            return this.makeToken(102, strMINUS_ASSIGN);
                        }
                        return this.makeToken(129, strMINUS);
                    }
                    case '*': {
                        this.input.consume();
                        if (this.input.LA(0) == '=') {
                            this.input.consume();
                            return this.makeToken(103, strSTAR_ASSIGN);
                        }
                        return this.makeToken(61, strSTAR);
                    }
                    case '%': {
                        this.input.consume();
                        if (this.input.LA(0) == '=') {
                            this.input.consume();
                            return this.makeToken(105, strMOD_ASSIGN);
                        }
                        return this.makeToken(131, strMOD);
                    }
                    case '^': {
                        this.input.consume();
                        if (this.input.LA(0) == '=') {
                            this.input.consume();
                            return this.makeToken(110, strBXOR_ASSIGN);
                        }
                        return this.makeToken(116, strBXOR);
                    }
                    case '|': {
                        this.input.consume();
                        if (this.input.LA(0) == '=') {
                            this.input.consume();
                            return this.makeToken(111, strBOR_ASSIGN);
                        }
                        if (this.input.LA(0) == '|') {
                            this.input.consume();
                            return this.makeToken(113, strLOR);
                        }
                        return this.makeToken(115, strBOR);
                    }
                    case '&': {
                        this.input.consume();
                        if (this.input.LA(0) == '=') {
                            this.input.consume();
                            return this.makeToken(109, strBAND_ASSIGN);
                        }
                        if (this.input.LA(0) == '&') {
                            this.input.consume();
                            return this.makeToken(114, strLAND);
                        }
                        return this.makeToken(117, strBAND);
                    }
                    case '/': {
                        this.input.consume();
                        if (this.input.LA(0) == '=') {
                            this.input.consume();
                            return this.makeToken(104, strDIV_ASSIGN);
                        }
                        if (this.input.LA(0) == '/') {
                            this.input.consume();
                            this.processSingleComment();
                            continue block34;
                        }
                        if (this.input.LA(0) == '*') {
                            this.input.consume();
                            if (this.input.LA(0) == '*') {
                                this.input.consume();
                                if (this.input.LA(0) == '/') {
                                    this.input.consume();
                                    continue block34;
                                }
                                this.processMultiComment(true);
                                continue block34;
                            }
                            this.processMultiComment(false);
                            continue block34;
                        }
                        return this.makeToken(130, strDIV);
                    }
                }
                break;
            }
            throw new NoViableAltForCharException(this.input.LA(0), this.input.getFilename(), this.input.getLine());
        }
        catch (RecognitionException e) {
            throw new TokenStreamRecognitionException(e);
        }
        catch (CharStreamException e) {
            throw new TokenStreamException(e.getMessage());
        }
    }

    private void processWhiteSpace() throws CharStreamException {
        block6: while (true) {
            switch (this.input.LA(0)) {
                case '\t': {
                    this.input.consume();
                    this.input.column += this.tabSize - 1;
                    this.input.column -= (this.input.column - 1) % this.tabSize;
                    continue block6;
                }
                case '\f': 
                case ' ': {
                    this.input.consume();
                    continue block6;
                }
                case '\r': {
                    this.input.consume();
                    if (this.input.LA(0) == '\n') {
                        this.input.consume();
                    }
                    this.input.newline();
                    continue block6;
                }
                case '\n': {
                    this.input.consume();
                    this.input.newline();
                    continue block6;
                }
            }
            break;
        }
    }

    private JavaToken processCharLiteral() throws RecognitionException, CharStreamException {
        this.match('\'');
        if (this.input.LA(0) == '\\') {
            this.processEscape();
        } else {
            this.matchNot('\'');
        }
        this.match('\'');
        return this.makeToken(143);
    }

    private void processEscape() throws RecognitionException, CharStreamException {
        this.match('\\');
        switch (this.input.LA(0)) {
            case '\"': 
            case '\'': 
            case '\\': 
            case 'b': 
            case 'f': 
            case 'n': 
            case 'r': 
            case 't': {
                this.input.consume();
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': {
                this.input.consume();
                if (this.input.LA(0) < '0' || this.input.LA(0) > '7') break;
                this.input.consume();
                if (this.input.LA(0) < '0' || this.input.LA(0) > '7') break;
                this.input.consume();
                break;
            }
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                this.input.consume();
                if (this.input.LA(0) < '0' || this.input.LA(0) > '7') break;
                this.input.consume();
                break;
            }
            default: {
                throw new NoViableAltForCharException(this.input.LA(0), this.input.getFilename(), this.input.getLine());
            }
        }
    }

    private JavaToken processStringLiteral() throws RecognitionException, CharStreamException {
        this.match('\"');
        block5: while (true) {
            switch (this.input.LA(0)) {
                case '\"': {
                    this.input.consume();
                    return this.makeToken(144);
                }
                case '\\': {
                    this.processEscape();
                    continue block5;
                }
                case '\uffff': {
                    throw new NoViableAltForCharException('\uffff', this.input.getFilename(), this.input.getLine());
                }
            }
            this.input.consume();
        }
    }

    private JavaToken processIdentifier() throws CharStreamException {
        char c;
        this.input.consume();
        while ((c = this.input.LA(0)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '$') {
            this.input.consume();
        }
        JavaToken token = this.makeToken(59);
        token.setType(Keyword.findKeyword(token.getText()));
        return token;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JavaToken processNumLiteral() throws RecognitionException, CharStreamException {
        boolean isDecimal = true;
        char c = this.input.LA(0);
        if (c == '.') {
            this.input.consume();
            c = this.input.LA(0);
            if (c < '0' || c > '9') return this.makeToken(60, strDOT);
            do {
                this.input.consume();
            } while ((c = this.input.LA(0)) >= '0' && c <= '9');
            if (c == 'e' || c == 'E') {
                this.processExponent();
            }
            if ((c = this.input.LA(0)) == 'f' || c == 'F') {
                this.input.consume();
                return this.makeToken(145);
            }
            if (c != 'd' && c != 'D') return this.makeToken(146);
            this.input.consume();
            return this.makeToken(146);
        }
        if (c == '0') {
            this.input.consume();
            c = this.input.LA(0);
            if (c == 'x' || c == 'X') {
                isDecimal = false;
                this.input.consume();
                c = this.input.LA(0);
                if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'f') && (c < 'A' || c > 'F')) throw new NoViableAltForCharException(c, this.input.getFilename(), this.input.getLine());
                do {
                    this.input.consume();
                } while ((c = this.input.LA(0)) >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F');
            } else if (c >= '0' && c <= '7') {
                isDecimal = false;
                do {
                    this.input.consume();
                } while ((c = this.input.LA(0)) >= '0' && c <= '7');
            }
        } else {
            do {
                this.input.consume();
            } while ((c = this.input.LA(0)) >= '0' && c <= '9');
        }
        if (c == 'l' || c == 'L') {
            this.input.consume();
            return this.makeToken(142);
        }
        if (!isDecimal) return this.makeToken(141);
        boolean isFloating = false;
        if (c == '.') {
            isFloating = true;
            do {
                this.input.consume();
            } while ((c = this.input.LA(0)) >= '0' && c <= '9');
        }
        if (c == 'e' || c == 'E') {
            isFloating = true;
            this.processExponent();
            c = this.input.LA(0);
        }
        if (c == 'f' || c == 'F') {
            this.input.consume();
            return this.makeToken(145);
        }
        if (c == 'd' || c == 'D') {
            isFloating = true;
            this.input.consume();
        }
        if (!isFloating) return this.makeToken(141);
        return this.makeToken(146);
    }

    private void processExponent() throws RecognitionException, CharStreamException {
        char c = this.input.read();
        if (c != 'e' && c != 'E') {
            throw new NoViableAltForCharException(c, this.input.getFilename(), this.input.getLine());
        }
        c = this.input.LA(0);
        if (c == '+' || c == '-') {
            this.input.consume();
            c = this.input.LA(0);
        }
        if (c < '0' || c > '9') {
            throw new NoViableAltForCharException(c, this.input.getFilename(), this.input.getLine());
        }
        do {
            this.input.consume();
        } while ((c = this.input.LA(0)) >= '0' && c <= '9');
    }
}

