/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.parser;

import antlr.CharStreamException;
import antlr.CharStreamIOException;
import com.togethersoft.sca.internal.jparser.ast.JavaMLToken;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class JavaInputStream {
    public static final char EOF_CHAR = '\uffff';
    int line = 1;
    int column = 1;
    private int offset = 0;
    private int startLine;
    private int startColumn;
    private int startOffset;
    private String filename;
    private Reader input;
    private static final int BUF_SIZE = 65536;
    private int lookahead;
    private char[] buffer;
    private int secondPageStart;
    private int secondPageEnd;
    private boolean hasNextPage;
    private int forward = 0;
    private int beginning = 0;
    private StringBuffer token;
    private int pushback = -1;
    private int state = 0;
    private static final int RAW = 0;
    private static final int BSL = 1;
    private static final int UESC = 2;
    private static final int UESCHD1 = 3;
    private static final int UESCHD2 = 4;
    private static final int UESCHD3 = 5;

    public JavaInputStream(String filename, Reader input, int lookahead) throws CharStreamException {
        this.filename = filename;
        this.input = new BufferedReader(input);
        lookahead = lookahead < 2 ? 2 : ++lookahead;
        this.lookahead = lookahead;
        this.secondPageStart = 65536 + lookahead;
        this.secondPageEnd = this.secondPageStart + 65536;
        this.buffer = new char[this.secondPageEnd + lookahead];
        this.fillPage(0);
    }

    public String getFilename() {
        return this.filename;
    }

    public void resetToken() {
        this.startLine = this.line;
        this.startColumn = this.column;
        this.startOffset = this.offset;
        this.beginning = this.forward;
        this.token = null;
    }

    public JavaToken makeToken(int type) {
        String text;
        if (this.token == null) {
            text = new String(this.buffer, this.beginning, this.forward - this.beginning).intern();
        } else {
            this.token.append(this.buffer, this.beginning, this.forward - this.beginning);
            text = this.token.toString().intern();
        }
        if (this.startLine == this.line) {
            return new JavaToken(type, text, this.startLine, this.startColumn, this.startOffset, this.column);
        }
        return new JavaMLToken(type, text, this.startLine, this.startColumn, this.startOffset, this.line, this.column, this.offset);
    }

    public JavaToken makeToken(int type, String text) {
        if (this.startLine == this.line) {
            return new JavaToken(type, text, this.startLine, this.startColumn, this.startOffset, this.column);
        }
        return new JavaMLToken(type, text, this.startLine, this.startColumn, this.startOffset, this.line, this.column, this.offset);
    }

    public char LA(int i) throws CharStreamException {
        int index = this.forward + i;
        char c = this.buffer[index];
        if (c == '\uffff') {
            if (index >= 65536 && index < this.secondPageStart) {
                if (!this.hasNextPage) {
                    this.fillPage(this.secondPageStart);
                    this.hasNextPage = true;
                }
                c = this.buffer[index + this.lookahead];
            } else if (index >= this.secondPageEnd) {
                if (!this.hasNextPage) {
                    this.fillPage(0);
                    this.hasNextPage = true;
                }
                c = this.buffer[index - this.secondPageEnd];
            }
        }
        return c;
    }

    public void consume() throws CharStreamException {
        if (this.buffer[this.forward] != '\uffff') {
            ++this.forward;
        } else if (this.forward == 65536 || this.forward == this.secondPageEnd) {
            int index;
            if (this.token == null) {
                this.token = new StringBuffer(this.forward - this.beginning);
            }
            this.token.append(this.buffer, this.beginning, this.forward - this.beginning);
            int n = index = this.forward == 65536 ? this.secondPageStart : 0;
            if (this.hasNextPage) {
                this.hasNextPage = false;
            } else {
                this.fillPage(index);
            }
            this.beginning = index;
            this.forward = index + 1;
        } else {
            return;
        }
        ++this.offset;
        ++this.column;
    }

    public char read() throws CharStreamException {
        char c = this.LA(0);
        this.consume();
        return c;
    }

    public void newline() {
        ++this.line;
        this.column = 1;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    /*
     * WARNING - void declaration
     */
    private void fillPage(int index) throws CharStreamException {
        try {
            int c;
            int u = 0;
            int end = index + 65536;
            if (this.pushback != -1) {
                this.buffer[index++] = (char)this.pushback;
                this.pushback = -1;
            }
            while (index < end && (c = this.input.read()) != -1) {
                switch (this.state) {
                    case 0: {
                        void var2_4;
                        if (var2_4 == 92) {
                            this.state = 1;
                            break;
                        }
                        this.buffer[index++] = (char)var2_4;
                        break;
                    }
                    case 1: {
                        void var2_4;
                        if (var2_4 == 117) {
                            this.state = 2;
                            break;
                        }
                        this.state = 0;
                        this.buffer[index++] = 92;
                        if (index < end) {
                            this.buffer[index++] = (char)var2_4;
                            break;
                        }
                        this.pushback = var2_4;
                        break;
                    }
                    case 2: {
                        void var2_4;
                        if (var2_4 == 117) break;
                        int val = Character.digit((char)var2_4, 16);
                        if (val != -1) {
                            u = val;
                            this.state = 3;
                            break;
                        }
                        throw new CharStreamException(this.filename + ": Invalid Unicode escape");
                    }
                    case 3: {
                        void var2_4;
                        int val = Character.digit((char)var2_4, 16);
                        if (val != -1) {
                            u = u * 16 + val;
                            this.state = 4;
                            break;
                        }
                        throw new CharStreamException(this.filename + ": Invalid Unicode escape");
                    }
                    case 4: {
                        void var2_4;
                        int val = Character.digit((char)var2_4, 16);
                        if (val != -1) {
                            u = u * 16 + val;
                            this.state = 5;
                            break;
                        }
                        throw new CharStreamException(this.filename + ": Invalid Unicode escape");
                    }
                    case 5: {
                        void var2_4;
                        int val = Character.digit((char)var2_4, 16);
                        if (val != -1) {
                            if ((u = u * 16 + val) == 65535) {
                                u = 65534;
                            }
                            this.buffer[index++] = (char)u;
                            this.state = 0;
                            break;
                        }
                        throw new CharStreamException(this.filename + ": Invalid Unicode escape");
                    }
                }
            }
            if (this.state == 1 && index < end) {
                this.buffer[index++] = 92;
                this.state = 0;
            }
        }
        catch (IOException e) {
            throw new CharStreamIOException(e);
        }
        int nc = this.lookahead;
        while (nc > 0) {
            this.buffer[index++] = 65535;
            --nc;
        }
    }
}

