/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.dbc;

import com.togethersoft.sca.ast.AstComment;
import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstJavadocTag;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.internal.jparser.ast.Declaration;
import com.togethersoft.sca.internal.jparser.ast.Expr;
import com.togethersoft.sca.internal.jparser.ast.ExprStmt;
import com.togethersoft.sca.internal.jparser.ast.PackageDeclaration;
import com.togethersoft.sca.internal.jparser.parser.JavaLexer;
import com.togethersoft.sca.internal.jparser.parser.JavaRecognizer;
import java.io.StringReader;
import java.util.ArrayList;

public class CommentParser {
    private static final AstExpression[] EMPTY_SET = new AstExpression[0];

    public static AstExpression[] getPreconditions(AstMethod method) {
        return CommentParser.extractExpressions(method, "@pre");
    }

    public static AstExpression[] getPostconditions(AstMethod method) {
        return CommentParser.extractExpressions(method, "@post");
    }

    public static AstExpression[] getInvariants(AstType type) {
        return CommentParser.extractExpressions(type, "@invariant");
    }

    private static AstExpression[] extractExpressions(AstDeclaration ast, String tag) {
        ArrayList<AstExpression> expressions = null;
        AstComment[] comments = ast.getComments();
        int i = 0;
        while (i < comments.length) {
            if (comments[i].isJavadoc()) {
                AstJavadocTag[] tags = comments[i].getJavadocTags();
                int j = 0;
                while (j < tags.length) {
                    AstExpression e;
                    String arg;
                    if (tag.equals(tags[j].getTag()) && (arg = tags[j].getArgument()) != null && (e = CommentParser.parserExpression((Declaration)ast, arg)) != null) {
                        if (expressions == null) {
                            expressions = new ArrayList<AstExpression>();
                        }
                        expressions.add(e);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return expressions != null ? expressions.toArray(new AstExpression[expressions.size()]) : EMPTY_SET;
    }

    private static AstExpression parserExpression(Declaration scope, String arg) {
        try {
            JavaLexer lexer = new JavaLexer("<dbc comment>", new StringReader(arg + " :"), 4, true, true);
            JavaRecognizer parser = new JavaRecognizer(lexer);
            parser.setLexer(lexer);
            parser.setFilename("<dbc comment>");
            Expr e = parser.expression();
            ExprStmt s = new ExprStmt(e, null);
            s.setParent(scope);
            ((PackageDeclaration)s.getPackage()).getModel().getSemantic().processInContext(scope, s);
            return e;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

