/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.classfile;

import com.togethersoft.sca.internal.jparser.classfile.AccessFlags;
import com.togethersoft.sca.internal.jparser.classfile.ClassConstants;
import com.togethersoft.sca.internal.jparser.classfile.ConstantPool;
import com.togethersoft.sca.internal.jparser.classfile.MemberDesc;
import java.io.DataInput;
import java.io.PrintStream;

public class MethodDesc
extends MemberDesc
implements ClassConstants {
    String type;
    public String[] exceptions;

    MethodDesc(ConstantPool cp, DataInput fp) throws Exception {
        int access_flags = fp.readUnsignedShort();
        int name_index = fp.readUnsignedShort();
        int descriptor_index = fp.readUnsignedShort();
        this.setName(cp.getUtf8(name_index));
        this.setAccess(new AccessFlags(access_flags));
        this.type = cp.getUtf8(descriptor_index);
        int attr_count = fp.readUnsignedShort();
        while (--attr_count >= 0) {
            int attr_name = fp.readUnsignedShort();
            int attr_len = fp.readInt();
            String attrStr = cp.getUtf8(attr_name);
            if (attrStr.equals("Deprecated")) {
                this.setDeprecated(true);
                continue;
            }
            if (attrStr.equals("Exceptions")) {
                int numExceptions = fp.readUnsignedShort();
                this.exceptions = new String[numExceptions];
                int i = 0;
                while (i < numExceptions) {
                    this.exceptions[i] = cp.getClass(fp.readUnsignedShort());
                    ++i;
                }
                continue;
            }
            fp.skipBytes(attr_len);
        }
    }

    public String getDescriptor() {
        return this.type;
    }

    void print(PrintStream out) {
        try {
            out.println("\t" + this.getAccess() + this.getRetType() + " " + this.getName() + this.getArgsType());
        }
        catch (Exception e) {
            out.println(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private String getArgsType() throws Exception {
        dst = new String("(");
        src = 0;
        if (this.type.length() == 0 || this.type.charAt(src++) != '(') {
            throw new Exception("Invalid method descriptor: " + this.type);
        }
        firstParameter = true;
        while (src < this.type.length() && this.type.charAt(src) != ')') {
            if (!firstParameter) {
                dst = dst + ", ";
            }
            firstParameter = false;
            indirect = 0;
            while (src < this.type.length() && this.type.charAt(src) == '[') {
                ++indirect;
                ++src;
            }
            if (src >= this.type.length()) continue;
            ch = this.type.charAt(src++);
            switch (ch) {
                case 'I': {
                    dst = dst + "int";
                    ** GOTO lbl52
                }
                case 'S': {
                    dst = dst + "short";
                    ** GOTO lbl52
                }
                case 'D': {
                    dst = dst + "double";
                    ** GOTO lbl52
                }
                case 'J': {
                    dst = dst + "long";
                    ** GOTO lbl52
                }
                case 'F': {
                    dst = dst + "float";
                    ** GOTO lbl52
                }
                case 'B': {
                    dst = dst + "byte";
                    ** GOTO lbl52
                }
                case 'C': {
                    dst = dst + "char";
                    ** GOTO lbl52
                }
                case 'Z': {
                    dst = dst + "boolean";
                    ** GOTO lbl52
                }
                case 'L': {
                    while (src < this.type.length() && this.type.charAt(src) != ';') {
                        dst = dst + this.type.charAt(src++);
                    }
                    ++src;
                    if (true) ** GOTO lbl52
                }
                default: {
                    throw new Exception("Invalid character in method descriptor " + this.type + ": " + ch);
                }
            }
            do {
                dst = dst + "[]";
lbl52:
                // 10 sources

            } while (indirect-- > 0);
        }
        dst = dst + ")";
        return dst;
    }

    /*
     * Unable to fully structure code
     */
    private String getRetType() throws Exception {
        block17: {
            dst = new String();
            src = 0;
            if (this.type.length() == 0 || this.type.charAt(src++) != '(') {
                return null;
            }
            while (src < this.type.length() && this.type.charAt(src++) != ')') {
            }
            indirect = 0;
            while (src < this.type.length() && this.type.charAt(src) == '[') {
                ++indirect;
                ++src;
            }
            if (src >= this.type.length()) break block17;
            ch = this.type.charAt(src++);
            switch (ch) {
                case 'V': {
                    dst = dst + "void";
                    ** GOTO lbl52
                }
                case 'I': {
                    dst = dst + "int";
                    ** GOTO lbl52
                }
                case 'S': {
                    dst = dst + "short";
                    ** GOTO lbl52
                }
                case 'D': {
                    dst = dst + "double";
                    ** GOTO lbl52
                }
                case 'J': {
                    dst = dst + "long";
                    ** GOTO lbl52
                }
                case 'F': {
                    dst = dst + "float";
                    ** GOTO lbl52
                }
                case 'B': {
                    dst = dst + "byte";
                    ** GOTO lbl52
                }
                case 'C': {
                    dst = dst + "char";
                    ** GOTO lbl52
                }
                case 'Z': {
                    dst = dst + "boolean";
                    ** GOTO lbl52
                }
                case 'L': {
                    while (src < this.type.length() && this.type.charAt(src) != ';') {
                        dst = dst + this.type.charAt(src);
                        ++src;
                    }
                    if (true) ** GOTO lbl52
                }
                default: {
                    throw new Exception("Invalid character in method descriptor " + this.type + ": " + ch);
                }
            }
            do {
                dst = dst + "[]";
lbl52:
                // 11 sources

            } while (indirect-- > 0);
        }
        return dst;
    }
}

