/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.classfile;

import com.togethersoft.sca.internal.jparser.classfile.AccessFlags;
import com.togethersoft.sca.internal.jparser.classfile.ClassDesc;
import com.togethersoft.sca.internal.jparser.classfile.ConstantPool;
import com.togethersoft.sca.internal.jparser.classfile.MemberDesc;
import java.io.DataInput;

public class InnerClassDesc
extends MemberDesc {
    String innerClass;
    String outerClass;
    ClassDesc containingClass;

    InnerClassDesc(DataInput fp, ConstantPool cp, ClassDesc containingClass) throws Exception {
        this.containingClass = containingClass;
        int inner_class_info_index = fp.readUnsignedShort();
        int outer_class_info_index = fp.readUnsignedShort();
        int inner_name_index = fp.readUnsignedShort();
        int inner_class_access_flags = fp.readUnsignedShort();
        if (inner_class_info_index != 0) {
            this.innerClass = cp.getClass(inner_class_info_index);
        }
        if (outer_class_info_index != 0) {
            this.outerClass = cp.getClass(outer_class_info_index);
        }
        if (inner_name_index != 0) {
            this.setName(cp.getUtf8(inner_name_index));
        }
        this.setAccess(new AccessFlags(inner_class_access_flags));
    }

    public boolean isNamedInnerClass() {
        return this.outerClass == this.containingClass.getName() && this.innerClass != null && this.getName() != null;
    }
}

