/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.classfile;

import com.togethersoft.sca.internal.jparser.classfile.AccessFlags;
import com.togethersoft.sca.internal.jparser.classfile.ClassConstants;
import com.togethersoft.sca.internal.jparser.classfile.Constant;
import com.togethersoft.sca.internal.jparser.classfile.ConstantPool;
import com.togethersoft.sca.internal.jparser.classfile.MemberDesc;
import java.io.DataInput;
import java.io.PrintStream;

public class FieldDesc
extends MemberDesc
implements ClassConstants {
    private String type;
    private Constant value;

    FieldDesc(ConstantPool cp, DataInput fp) throws Exception {
        int accessFlags = fp.readUnsignedShort();
        int nameIndex = fp.readUnsignedShort();
        int descriptorIndex = fp.readUnsignedShort();
        this.setAccess(new AccessFlags(accessFlags));
        this.setName(cp.getUtf8(nameIndex));
        this.type = cp.getUtf8(descriptorIndex);
        int attrCount = fp.readUnsignedShort();
        while (--attrCount >= 0) {
            int attrIndex = fp.readUnsignedShort();
            int attrLength = fp.readInt();
            String attrName = cp.getUtf8(attrIndex);
            if (attrName.equals("Deprecated")) {
                this.setDeprecated(true);
                continue;
            }
            if (attrName.equals("ConstantValue")) {
                int index = fp.readUnsignedShort();
                this.value = cp.getConstant(index);
                continue;
            }
            fp.skipBytes(attrLength);
        }
    }

    public String getDescriptor() {
        return this.type;
    }

    public Constant getInitializer() {
        return this.value;
    }

    void print(PrintStream out) {
        try {
            out.println("\t" + this.getAccess() + this.getFieldType() + " " + this.getName());
        }
        catch (Exception e) {
            out.println(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private String getFieldType() throws Exception {
        dst = new String();
        src = 0;
        indirect = 0;
        while (src < this.type.length() && this.type.charAt(src) == '[') {
            ++indirect;
            ++src;
        }
        if (src >= this.type.length()) {
            throw new Exception("Invalid field descriptor " + this.type);
        }
        ch = this.type.charAt(src++);
        switch (ch) {
            case 'I': {
                dst = dst + "int";
                ** GOTO lbl46
            }
            case 'S': {
                dst = dst + "short";
                ** GOTO lbl46
            }
            case 'D': {
                dst = dst + "double";
                ** GOTO lbl46
            }
            case 'J': {
                dst = dst + "long";
                ** GOTO lbl46
            }
            case 'F': {
                dst = dst + "float";
                ** GOTO lbl46
            }
            case 'B': {
                dst = dst + "byte";
                ** GOTO lbl46
            }
            case 'C': {
                dst = dst + "char";
                ** GOTO lbl46
            }
            case 'Z': {
                dst = dst + "boolean";
                ** GOTO lbl46
            }
            case 'L': {
                while (src < this.type.length() && this.type.charAt(src) != ';') {
                    dst = dst + this.type.charAt(src);
                    ++src;
                }
                if (true) ** GOTO lbl46
            }
            default: {
                throw new Exception("Invalid character in field descriptor " + this.type + ": " + ch);
            }
        }
        do {
            dst = dst + "[]";
lbl46:
            // 10 sources

        } while (indirect-- > 0);
        return dst;
    }
}

