/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.classfile;

import com.togethersoft.sca.internal.jparser.classfile.ClassDescription;
import com.togethersoft.sca.internal.jparser.classfile.ClassDirectory;
import com.togethersoft.sca.internal.jparser.classfile.Data;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

class DirClassDirectory
extends ClassDirectory {
    private File dir;

    public DirClassDirectory(File dir) {
        this.dir = dir;
    }

    public ClassDescription getClassFile(String name) {
        name = name.replace('/', File.separatorChar) + ".class";
        final File file = new File(this.dir.getPath(), name);
        try {
            if (!file.canRead() || !file.getCanonicalPath().endsWith(name)) {
                return null;
            }
            return new ClassDescription(){

                public Data getData() {
                    try {
                        return new Data(new FileInputStream(file));
                    }
                    catch (FileNotFoundException e) {
                        return null;
                    }
                }

                public String getFilename() {
                    return file.getPath();
                }
            };
        }
        catch (IOException e1) {
            return null;
        }
    }
}

